/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.physstorage;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.physstorage.DirectAccessDeviceAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.physstorage.StorageSpace;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceComparator;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceImpl;
import com.sanrad.nms.server.logic.physstorage.StorageSpaceManager;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDevice;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceCreateValidator;
import com.sanrad.nms.server.logic.physstorage.SubDirectAccessDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ConfigOperation;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.BlockSizeConstant;
import com.sanrad.nms.server.util.types.constants.DirectAccessDeviceWCEStateConstants;
import com.sanrad.nms.server.util.types.constants.DirectAccessDeviceWPStateConstants;
import com.sanrad.nms.server.util.types.constants.PhysStorTransportTypeConstant;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import com.sanrad.util.virtualization.Allocable;
import com.sanrad.util.virtualization.AllocationUtil;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DirectAccessDeviceImpl
extends GeneralSCSIDeviceImpl
implements DirectAccessDevice,
Allocable {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private final ArrayList<SubDirectAccessDeviceImpl> mySubDirectAccessDevices = new ArrayList();
    private final ArrayList allocatedSpace = new ArrayList();
    private StorageSpaceManager myStorageSpaceManager = null;
    private Integer blockSize = null;
    private BigInteger numberOfBlocks = null;
    private final ArrayList<StorageSpace> m_storageSpaceStatus = new ArrayList();
    private AllocationTool myAllocationTool = new AllocationTool();
    private static SrLogger theLogger;

    public DirectAccessDeviceImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.DIRECT_ACCESS_DEVICE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public Boolean isWriteProtected() throws RemoteException {
        return this.isWriteProtected(null);
    }

    private Boolean isWriteProtected(VSwitchImpl vSwitch) {
        DirectAccessDeviceWPStateConstants state = (DirectAccessDeviceWPStateConstants)this.getSrValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_WP, vSwitch == null);
        if (state != null) {
            if (state.equals((Object)DirectAccessDeviceWPStateConstants.DIRECT_ACCESS_DEVICE_WP_STATE_ENABLE)) {
                return Boolean.TRUE;
            }
            if (state.equals((Object)DirectAccessDeviceWPStateConstants.DIRECT_ACCESS_DEVICE_WP_STATE_DISABLE)) {
                return Boolean.FALSE;
            }
            if (state.equals((Object)DirectAccessDeviceWPStateConstants.DIRECT_ACCESS_DEVICE_WP_STATE_UNKOWN)) {
                return null;
            }
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Undefined WP state for ", this.getClassId(), " ", this});
        return null;
    }

    @Override
    public Boolean isWriteCacheEnabled() throws RemoteException {
        return this.isWriteCacheEnabled(null);
    }

    private Boolean isWriteCacheEnabled(VSwitchImpl vSwitch) {
        DirectAccessDeviceWCEStateConstants state = (DirectAccessDeviceWCEStateConstants)this.getSrValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE, vSwitch == null);
        if (state != null) {
            if (state.equals((Object)DirectAccessDeviceWCEStateConstants.DIRECT_ACCESS_DEVICE_WCE_STATE_ENABLE)) {
                return Boolean.TRUE;
            }
            if (state.equals((Object)DirectAccessDeviceWCEStateConstants.DIRECT_ACCESS_DEVICE_WCE_STATE_DISABLE)) {
                return Boolean.FALSE;
            }
            if (state.equals((Object)DirectAccessDeviceWCEStateConstants.DIRECT_ACCESS_DEVICE_WCE_STATE_UNKOWN)) {
                return null;
            }
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Undefined WCE state for ", this.getClassId(), " ", this});
        return null;
    }

    @Override
    public void updateElementWithCreationParameters(ConfigElementData element, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        super.updateElementWithCreationParameters(element, remoteCluster);
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE, (Object)this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE)));
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, (Object)this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME)));
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_LUN, (Object)this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_LUN)));
        element.addParameter(new Parameter(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER, (Object)this.getSrValueOf(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER)));
        element.addParameter(new Parameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, (Object)this.getSrValueOf(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE)));
        element.addParameter(new Parameter(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, (Object)this.getSrValueOf(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM)));
    }

    @Override
    public boolean isDeviceSuitableForLocalCopy(HashSet set, VolumeNodeImpl volume, ClusterImpl remoteCluster) throws IllegalValueException {
        if (!set.contains(this)) {
            List<VolumeNodeImpl> devices = volume.getDevicesOfVolume();
            for (VolumeNodeImpl device : devices) {
                if (device.getRootVolume().isPreventLocalCopy(set, remoteCluster)) continue;
                return false;
            }
            set.add(this);
        }
        return true;
    }

    @Override
    public ConfigElementDataList buildCedListForRemoveVolumeTree(Vector subdisks, ConfigElementDataList elementList) throws RemoteException {
        for (int i = 0; i < this.mySubDirectAccessDevices.size(); ++i) {
            if (subdisks.contains(this.mySubDirectAccessDevices.get(i))) continue;
            return elementList;
        }
        return super.buildCedListForRemoveVolumeTree(subdisks, elementList);
    }

    @Override
    protected LogicObjectImpl findEquivelentElement(ClusterImpl cluster, LogicObjectImpl childVol) throws RemoteException, IllegalValueException {
        List devices = cluster.getStorage().getStorageDevices();
        for (GeneralSCSIDeviceImpl device : devices) {
            if (!this.equals(device)) continue;
            return device;
        }
        return null;
    }

    @Override
    protected void setExsistentElementIfNeeded(LogicObjectImpl source) throws RemoteException, IllegalValueException {
        HashMap<ClientParameterCode, Number> changeValues = new HashMap<ClientParameterCode, Number>();
        if (this.getBlockSize() == BlockSizeConstant.BLOCK_SIZE_ONE.getBlockSize()) {
            changeValues.put(ClientParameterCode.SCSI_DEVICE_BLOCK_SIZE, new Integer(((DirectAccessDeviceImpl)source).getBlockSize()));
        }
        if (this.getNumberOfBlocks().intValue() == 0) {
            changeValues.put(ClientParameterCode.SCSI_DEVICE_BLOCK_NUMBER, ((DirectAccessDeviceImpl)source).getNumberOfBlocks());
        }
        ErrorAssertingListener.listenTo(this.changeElement(changeValues));
    }

    public BigInteger getNumberOfBlocks() {
        return this.getNumberOfBlocks(null);
    }

    protected void createIscsiDisk(ConfigElementData element, Cluster remoteCluster) throws RemoteException, IllegalAccessException, IllegalValueException {
        if (this.mySubDirectAccessDevices != null && !this.mySubDirectAccessDevices.isEmpty()) {
            throw new IllegalValueException("The disk already has sub disk on it you cannot create volume on it");
        }
    }

    @Override
    public BigInteger getNumberOfBlocks(VSwitchImpl vSwitch) {
        return (BigInteger)this.getValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, vSwitch == null);
    }

    @Override
    public BigInteger getTotalSpace() {
        return this.getTotalSpace(null);
    }

    public BigInteger getTotalSpace(VSwitchImpl vSwitch) {
        int blkSize = this.getBlockSize(vSwitch);
        if (blkSize != -1) {
            BigInteger blockSize = new BigInteger(Integer.toString(blkSize));
            return this.getNumberOfBlocks(vSwitch).multiply(blockSize);
        }
        return null;
    }

    @Override
    public BigInteger getNonAllocatedSpace() throws RemoteException {
        BigInteger totalSpace = this.getTotalSpace();
        return totalSpace == null ? null : this.getTotalSpace().subtract(this.getAllocatedSpace());
    }

    @Override
    public int getBlockSize(VSwitchImpl vSwitch) {
        SrType value = this.getSrValueOf(vSwitch, ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, vSwitch == null);
        if (value == null) {
            return -1;
        }
        return ((SrInteger)value).intValue();
    }

    public BigInteger getBlockSizeBigInteger(VSwitchImpl vSwitch) {
        int bs = this.getBlockSize(vSwitch);
        return new BigInteger(Integer.toString(bs));
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.numberOfBlocks = this.getNumberOfBlocks();
        this.blockSize = new Integer(this.getBlockSize());
        if (this.myStorageSpaceManager == null) {
            this.myStorageSpaceManager = new StorageSpaceManager(this.getTotalSpace(), this.getBlockSize(), this.isProvisioned());
        } else if (PhysStorTransportTypeConstant.PHYS_STOR_TRANS_TYPE_ISCSI.equals((Object)this.getTransportType())) {
            BigInteger totalSpace = this.getTotalSpace();
            int blockSize = this.getBlockSize();
            boolean isProv = this.isProvisioned();
            if (totalSpace != null) {
                this.myStorageSpaceManager.setTotalSize(totalSpace);
            }
            if (blockSize > -1) {
                this.myStorageSpaceManager.setBlockSize(blockSize);
            }
            this.myStorageSpaceManager.setProvisioned(isProv);
        }
        return changedValues;
    }

    public void addSubDirectAccessDevice(SubDirectAccessDeviceImpl subDirectAccessDevice) throws RemoteException {
        if (!this.mySubDirectAccessDevices.contains(subDirectAccessDevice)) {
            this.mySubDirectAccessDevices.add(subDirectAccessDevice);
            this.myStorageSpaceManager.addOccupiedSpace(subDirectAccessDevice.getStartAddress(), subDirectAccessDevice.getSize());
            this.setFree(false);
        }
    }

    public void removeSubDirectAccessDevice(SubDirectAccessDevice subDirectAccessDevice) throws RemoteException {
        this.mySubDirectAccessDevices.remove(subDirectAccessDevice);
        this.myStorageSpaceManager.removeOccupiedSpace(subDirectAccessDevice.getStartAddress(), subDirectAccessDevice.getSize());
        if (this.mySubDirectAccessDevices.isEmpty()) {
            this.setFree(true);
        }
    }

    @Override
    public BigInteger getEndAddress() throws RemoteException {
        return this.getEndAddress(null);
    }

    public BigInteger getEndAddress(VSwitchImpl vSwitch) {
        return this.getTotalSpace(vSwitch).subtract(this.getBlockSizeBigInteger(vSwitch));
    }

    @Override
    public Vector<SubDirectAccessDeviceImpl> getSubDirectAccessDevices() {
        return new Vector<SubDirectAccessDeviceImpl>(this.mySubDirectAccessDevices);
    }

    private List<SubDirectAccessDeviceImpl> getNotRedundantSubDirectAccessDevices(VSwitchImpl vSwitch) {
        ArrayList<SubDirectAccessDeviceImpl> notRedundantVector = new ArrayList<SubDirectAccessDeviceImpl>();
        for (SubDirectAccessDeviceImpl sd : this.getSubDirectAccessDevices()) {
            if (sd.isRedundant() || !sd.isKnownByVSwitch(vSwitch)) continue;
            notRedundantVector.add(sd);
        }
        return notRedundantVector;
    }

    @Override
    public Vector<StorageSpace> getStorageSpaceStatus() {
        List<StorageSpaceImpl> freeSpace;
        ArrayList<RemoteObjectImpl> tempStatus = new ArrayList<RemoteObjectImpl>();
        if (this.mySubDirectAccessDevices.size() > 0) {
            tempStatus.addAll(this.mySubDirectAccessDevices);
        }
        if ((freeSpace = this.myStorageSpaceManager.getFreeSpaceList()).size() > 0) {
            tempStatus.addAll(freeSpace);
        }
        this.m_storageSpaceStatus.retainAll(tempStatus);
        tempStatus.removeAll(this.m_storageSpaceStatus);
        this.m_storageSpaceStatus.addAll(tempStatus);
        if (this.m_storageSpaceStatus.size() > 0) {
            Collections.sort(this.m_storageSpaceStatus, new StorageSpaceComparator());
        }
        return new Vector<StorageSpace>(this.m_storageSpaceStatus);
    }

    public List<StorageSpaceImpl> getFreeSpaceFragments() {
        return this.myStorageSpaceManager.getFreeSpaceList();
    }

    public List<VSwitchImpl> getExposedOnVswitches() {
        HashSet<VSwitchImpl> vswitchesSet = new HashSet<VSwitchImpl>();
        if (this.mySubDirectAccessDevices.size() == 0 && this.isExposed()) {
            vswitchesSet.add(this.getExposedOnVSwitch());
        } else {
            for (SubDirectAccessDeviceImpl device : this.mySubDirectAccessDevices) {
                VSwitchImpl vs;
                if (!device.isExposed() || (vs = device.getDominantVswitch()) == null) continue;
                vswitchesSet.add(vs);
            }
        }
        return new ArrayList<VSwitchImpl>(vswitchesSet);
    }

    public boolean isExposedOnVswitch(VSwitchImpl aVswitch) {
        List<VSwitchImpl> exposedOnVswitches = this.getExposedOnVswitches();
        return exposedOnVswitches.isEmpty() || exposedOnVswitches.size() == 1 && exposedOnVswitches.contains(aVswitch);
    }

    @Override
    public double getBlockNum() {
        return this.getNumberOfBlocks(null).doubleValue();
    }

    @Override
    public double getBlockNum(VSwitchImpl vswitch) {
        return this.getNumberOfBlocks(vswitch).doubleValue();
    }

    public int getSubDirectAccessDevicesCount() {
        return this.mySubDirectAccessDevices.size();
    }

    @Override
    public Boolean isAllocable() throws RemoteException {
        Integer allocable = (Integer)this.getValueOf(this.getActiveVswitch(), ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE);
        if (allocable != null) {
            return allocable == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public boolean isDiskFull() throws RemoteException {
        return this.getNonAllocatedSpace().longValue() == 0L;
    }

    public boolean isSubDirectAccessDeviceAliasExist(String alias) {
        for (SubDirectAccessDeviceImpl device : this.mySubDirectAccessDevices) {
            if (!device.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    public SubDirectAccessDeviceImpl getSubDirectAccessDevice(String alias) {
        for (SubDirectAccessDeviceImpl device : this.mySubDirectAccessDevices) {
            if (!device.getAlias().equals(alias)) continue;
            return device;
        }
        return null;
    }

    public SubDirectAccessDevice isStartAddressOccupied(BigInteger startAddr) throws RemoteException {
        Enumeration<SubDirectAccessDeviceImpl> e = this.getSubDirectAccessDevices().elements();
        while (e.hasMoreElements()) {
            SubDirectAccessDevice device = e.nextElement();
            BigInteger min = device.getStartAddress();
            BigInteger max = device.getEndAddress();
            if (startAddr.compareTo(min) == -1 || startAddr.compareTo(max) == 1) continue;
            return device;
        }
        return null;
    }

    public boolean isStartAddressCompatible(BigInteger startAddr, BigInteger size) throws RemoteException {
        if (this.isStartAddressOccupied(startAddr) != null) {
            return false;
        }
        if (this.isProvisioned()) {
            return true;
        }
        return this.myStorageSpaceManager.isStartAddressCompatible(startAddr, size);
    }

    public SubDirectAccessDeviceImpl getSubDirectAccessDevice(BigInteger endAddr) throws RemoteException {
        for (SubDirectAccessDeviceImpl subDirectAccessDevice : this.mySubDirectAccessDevices) {
            BigInteger endBlocks;
            BigInteger endBytes = subDirectAccessDevice.getEndAddress();
            if (this.getBlockSize() == 0 || (endBlocks = Util.bytesToBlocks((BigInteger)endBytes, (int)this.getBlockSize())).compareTo(endAddr) != 0) continue;
            return subDirectAccessDevice;
        }
        return null;
    }

    private ConfigElementData getSubdiskCreationCed(String alias, BigInteger startAddr, BigInteger size, List<VSwitchImpl> vSwitches, CommKeyClassId operationInvoker) throws IllegalValueException {
        int blockSize = this.getBlockSize();
        if (this.getBlockSize() == 0) {
            throw new IllegalValueException("The block size of " + this.getClassId() + " " + this.getAlias() + " is 0");
        }
        if (alias == null || alias.isEmpty()) {
            alias = SubDirectAccessDeviceCreateValidator.getDefaultAlias();
        }
        SubDirectAccessDeviceCreateValidator validator = new SubDirectAccessDeviceCreateValidator(this, alias, startAddr, size, this.cluster);
        CommKeyClassId[] vSwitchesToSetData = null;
        vSwitchesToSetData = vSwitches != null ? validator.getLegalVSwitchesForOperation(vSwitches) : validator.getLegalVSwitchesForOperation(this.cluster.getConnectedVSwitches());
        ConfigElementData element = new ConfigElementData(ClassID.SUB_DIRECT_ACCESS_DEVICE, ConfigOperation.CREATE);
        Parameter aliasName = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_ALIAS, (Object)new SrString(alias));
        element.addParameter(aliasName);
        BigInteger numberOfBlocks = Util.bytesToBlocks((BigInteger)size, (int)blockSize);
        BigInteger endAddress = startAddr.add(size);
        BigInteger endAddrBlocks = Util.bytesToBlocks((BigInteger)endAddress, (int)blockSize);
        endAddrBlocks = endAddrBlocks.subtract(BigInteger.ONE);
        Parameter endAddr = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_END_ADDR, (Object)new SrLunFormat(endAddrBlocks));
        element.addParameter(endAddr);
        Parameter len = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_LENGTH, (Object)new SrLunFormat(numberOfBlocks));
        element.addParameter(len);
        CommKeyClassId parentCommKeyClassId = new CommKeyClassId(this.getCommKeys(), this.getClassId());
        Parameter parent = new Parameter(ParameterCode.SUB_DIRECT_ACCESS_DEVICE_DISK_ID, (Object)parentCommKeyClassId);
        element.addParameter(parent);
        element.setOperationInvoker(operationInvoker);
        element.setValues(ParameterCode.VSWITCH_ID, (SrType[])vSwitchesToSetData);
        return element;
    }

    public ConfigElementData getTotalSpaceSubdiskCed() throws IllegalValueException {
        if (this.getTotalSpace().compareTo(this.getAllocationSpace()) > 0) {
            throw new IllegalValueException("Some of the disk's space is occupied, cannot allocate entire disk");
        }
        return this.getVolumeAllocationCed(this.getAlias(), this.getAllocationSpace(), BigInteger.ZERO);
    }

    public boolean isTotalSpaceSubdisk() {
        return this.mySubDirectAccessDevices.size() == 1 && BigInteger.ZERO.equals(this.getAllocationSpace());
    }

    public boolean isTotalSpaceAvailableForAllocation() {
        return this.getTotalSpace().equals(this.getAllocationSpace());
    }

    public SubDirectAccessDeviceImpl getTotalSpaceSubdisk() {
        if (this.isTotalSpaceSubdisk()) {
            return this.mySubDirectAccessDevices.get(0);
        }
        return null;
    }

    public ConfigElementData getVolumeAllocationCed(String aAlias, BigInteger aSize, BigInteger aStartAddr) throws IllegalValueException {
        boolean isValidSize;
        boolean bl = isValidSize = aSize != null && BigInteger.ZERO.compareTo(aSize) < 0;
        if (!isValidSize) {
            throw new IllegalArgumentException("Allocation size " + aSize + " is not valid. Subdisk alias: " + aAlias);
        }
        if (aSize.compareTo(this.getAllocationSpace()) > 0) {
            String msg = ErrorMessage.CAPACITY_IS_TOO_HIGH.getMessage(Util.bytesToLargerUnits((BigInteger)aSize));
            throw new IllegalValueException(msg);
        }
        return this.myAllocationTool.getVolumeAllcationCed(aAlias, aSize, aStartAddr);
    }

    public SrFuture<Void> createSubDirectAccessDevice(String alias, BigInteger startAddr, BigInteger size, List<VSwitchImpl> vSwitches, CommKeyClassId operationInvoker) throws IllegalValueException {
        ConfigElementData element = this.getSubdiskCreationCed(alias, startAddr, size, vSwitches, operationInvoker);
        return this.cluster.createElement(element, ClassID.SUB_DIRECT_ACCESS_DEVICE, alias + " for " + this.getAlias(), vSwitches);
    }

    @Override
    public SrFuture<Void> createSubDirectAccessDevice(String alias, BigInteger startAddr, BigInteger size) throws RemoteException, IllegalValueException {
        SubDirectAccessDeviceCreateValidator validator = new SubDirectAccessDeviceCreateValidator(this, alias, startAddr, size, this.cluster);
        if (!validator.isValid()) {
            throw new IllegalValueException(validator.getErrorMsg());
        }
        return this.createSubDirectAccessDevice(alias, startAddr, size, null, null);
    }

    @Override
    public SrFuture<Void> createSubDirectAccessDevice(String alias, BigInteger size) throws RemoteException, IllegalValueException {
        BigInteger startAddr = null;
        startAddr = this.myStorageSpaceManager.getBestFitStartAddress(size);
        if (startAddr != null) {
            return this.createSubDirectAccessDevice(alias, startAddr, size);
        }
        String msg = ErrorMessage.CAPACITY_IS_TOO_HIGH.getMessage(Util.bytesToLargerUnits((BigInteger)size));
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{msg});
        throw new IllegalValueException(msg);
    }

    @Override
    public SrFuture<Void> createSubDirectAccessDevice(String alias) throws RemoteException, IllegalValueException {
        BigInteger size = this.myStorageSpaceManager.getLastAvailableSpaceSize();
        return this.createSubDirectAccessDevice(alias, size);
    }

    @Override
    public BigInteger getAccessibleSpace() {
        if (this.mySubDirectAccessDevices.size() > 0) {
            BigInteger accessibleSpace = BigInteger.ZERO;
            for (SubDirectAccessDeviceImpl subDirectAccessDevice : this.mySubDirectAccessDevices) {
                accessibleSpace = accessibleSpace.add(subDirectAccessDevice.getAccessibleSpace());
            }
            return accessibleSpace;
        }
        return this.getTotalSpace();
    }

    @Override
    public BigInteger getAllocatedSpace() throws RemoteException {
        if (this.mySubDirectAccessDevices.size() > 0) {
            BigInteger allocatedSpace = BigInteger.ZERO;
            for (SubDirectAccessDevice subDirectAccessDevice : this.mySubDirectAccessDevices) {
                allocatedSpace = allocatedSpace.add(subDirectAccessDevice.getAllocatedSpace());
            }
            return allocatedSpace;
        }
        if (this.getParentVolume() == null && this.getParentLU() == null) {
            return BigInteger.ZERO;
        }
        return this.getTotalSpace();
    }

    @Override
    protected String canBeDeleted() {
        CopyOperationImpl oper;
        String msg = super.canBeDeleted();
        if (msg == null && !this.mySubDirectAccessDevices.isEmpty()) {
            return "You cannot remove " + this.getClassId() + " " + this.getAlias() + ", because it has sub-disks";
        }
        if (this.getParentVolume() == null && (oper = this.cluster.getCopyOperManager().getCopyForNode(this.getCommKeyClassId())) != null) {
            String[] msgBody = new String[]{this.toString(), "a copy operation", "copy"};
            VolumeOperationType copyOpType = oper.getCopyType();
            if (copyOpType != null) {
                msgBody[1] = "a " + copyOpType.toString();
                msgBody[2] = copyOpType.toString();
            }
            return ErrorMessage.CANNOT_DELETE_PHYS_STOR_IN_COPY.getMessage(msgBody);
        }
        return msg;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        BigInteger blockNum;
        Integer blockSize;
        Boolean allocable;
        String msg = super.isValid(parameterList);
        if (msg != null) {
            return msg;
        }
        Object wce = parameterList.get(ClientParameterCode.DIRECT_ACCESS_DEVICE_WCE_ENABLE_STATE);
        if (wce != null) {
            parameterList.put(ClientParameterCode.DIRECT_ACCESS_DEVICE_WCE_ENABLE_STATE, new SrBoolean((Boolean)wce));
        }
        if ((allocable = (Boolean)parameterList.get(ClientParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE)) != null) {
            parameterList.put(ClientParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE, new SrBoolean(allocable.booleanValue()));
        }
        if ((blockSize = (Integer)parameterList.get(ClientParameterCode.SCSI_DEVICE_BLOCK_SIZE)) != null) {
            parameterList.put(ClientParameterCode.SCSI_DEVICE_BLOCK_SIZE, new SrInteger(blockSize));
        }
        if ((blockNum = (BigInteger)parameterList.get(ClientParameterCode.SCSI_DEVICE_BLOCK_NUMBER)) != null) {
            parameterList.put(ClientParameterCode.SCSI_DEVICE_BLOCK_NUMBER, new SrLunFormat(blockNum));
        }
        return null;
    }

    @Override
    public void clear() throws RemoteException {
        this.mySubDirectAccessDevices.clear();
        this.allocatedSpace.clear();
        this.myStorageSpaceManager = null;
        this.m_storageSpaceStatus.clear();
        super.clear();
    }

    private int synchronizeSubdisks() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        int syncRetVal = 0;
        Iterator<SubDirectAccessDeviceImpl> iter = this.mySubDirectAccessDevices.iterator();
        while (iter.hasNext()) {
            try {
                SubDirectAccessDevice subDirectAccessDevice = iter.next();
                int sdRetVal = subDirectAccessDevice.synchronize();
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of Disk ", this.getAlias(), "Subdisk ", subDirectAccessDevice.getAlias(), " Sync status ", sdRetVal});
                if (sdRetVal <= syncRetVal) continue;
                syncRetVal = sdRetVal;
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
                errMsg.append(" \n");
                errMsg.append(ive.getMessage());
                errOccured = true;
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        if (syncRetVal == 1) {
            syncRetVal = 2;
        }
        return syncRetVal;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Start to synchronize ", this.getClassId(), " ", this.toString()});
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"Start Sync of Disk ", this.getAlias()});
        int retVal = 0;
        retVal = super.synchronize();
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of target ", this.getAlias(), " After Super completion status ", retVal});
        if (retVal == 0) {
            retVal = this.synchronizeSubdisks();
            switch (retVal) {
                case 3: {
                    this.setSynchronizePending(false);
                    break;
                }
                case 1: {
                    retVal = 2;
                }
            }
        }
        return retVal;
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            this.synchronizeSubdisks();
            return;
        }
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.cluster.addPropagationStateDependentObjectAndListener(this);
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return DirectAccessDeviceAlarmGenerator.getThisInstance();
    }

    public SubDirectAccessDevice getSubDirectAccessDevice(BigInteger startAddr, BigInteger endAddr, VSwitchImpl vSwitch) {
        Enumeration<SubDirectAccessDeviceImpl> e = this.getSubDirectAccessDevices().elements();
        while (e.hasMoreElements()) {
            SubDirectAccessDeviceImpl sd = e.nextElement();
            if (!sd.isKnownByVSwitch(vSwitch)) continue;
            BigInteger start = sd.getStartAddress(vSwitch);
            BigInteger end = sd.getEndAddress(vSwitch);
            if (end.compareTo(startAddr) < 0 || start.compareTo(endAddr) > 0) continue;
            return sd;
        }
        return null;
    }

    public HashMap getInconsistentSubDirectAccessDevice() {
        if (this.isRedundant()) {
            VSwitchImpl firstVSwitch = this.getFirstVSwitch();
            Vector<SubDirectAccessDeviceImpl> notRedundantVector = new Vector<SubDirectAccessDeviceImpl>(this.getNotRedundantSubDirectAccessDevices(firstVSwitch));
            VSwitchImpl otherVSwitch = this.cluster.getOtherVSwitch(firstVSwitch);
            HashMap<SubDirectAccessDeviceImpl, SubDirectAccessDevice> inconsistentSDs = null;
            Enumeration<SubDirectAccessDeviceImpl> e = notRedundantVector.elements();
            while (e.hasMoreElements()) {
                BigInteger endAddr;
                SubDirectAccessDeviceImpl notRedundantSD = e.nextElement();
                BigInteger startAddr = notRedundantSD.getStartAddress(firstVSwitch);
                SubDirectAccessDevice inconsistent = this.getSubDirectAccessDevice(startAddr, endAddr = notRedundantSD.getEndAddress(firstVSwitch), otherVSwitch);
                if (inconsistent == null) continue;
                if (inconsistentSDs == null) {
                    inconsistentSDs = new HashMap<SubDirectAccessDeviceImpl, SubDirectAccessDevice>();
                }
                inconsistentSDs.put(notRedundantSD, inconsistent);
            }
            return inconsistentSDs;
        }
        return null;
    }

    public boolean hasIllegalSubDirectAccessDevice() {
        return this.getParentVolume() != null && !this.getSubDirectAccessDevices().isEmpty();
    }

    public boolean hasSubdisks() {
        return !this.getSubDirectAccessDevices().isEmpty();
    }

    @Override
    protected boolean compareNoAffectOnVirtualizationWith(GeneralSCSIDeviceImpl device) {
        boolean result = super.compareNoAffectOnVirtualizationWith(device);
        if (result) {
            if (this.numberOfBlocks != null && ((DirectAccessDeviceImpl)device).numberOfBlocks == null || this.numberOfBlocks == null && ((DirectAccessDeviceImpl)device).numberOfBlocks != null) {
                return false;
            }
            if (this.blockSize.compareTo(((DirectAccessDeviceImpl)device).blockSize) == 0 && (this.numberOfBlocks == null && ((DirectAccessDeviceImpl)device).numberOfBlocks == null || this.numberOfBlocks.compareTo(((DirectAccessDeviceImpl)device).numberOfBlocks) == 0) || this.numberOfBlocks.intValue() == 0 || ((DirectAccessDeviceImpl)device).numberOfBlocks.intValue() == 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isIllegalDownHierarchy() {
        return this.getInconsistentSubDirectAccessDevice() != null || this.hasIllegalSubDirectAccessDevice();
    }

    @Override
    public boolean isIllegalUpHierarchy() {
        VolumeImpl parentVol = this.getParentVolume();
        LUImpl parentLu = this.getParentLU();
        boolean isOk = true;
        if (parentVol != null) {
            isOk = !parentVol.isIllegalUpHierarchy();
        } else if (parentLu != null) {
            isOk = this.getHeadLU().isLegitimateForVolumeOperation();
        }
        if (isOk) {
            isOk = this.getInconsistentSubDirectAccessDevice() == null && !this.hasIllegalSubDirectAccessDevice();
        }
        return !isOk;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME);
        params.add(ParameterCode.PHYSICAL_STORAGE_LUN);
        params.add(ParameterCode.PHYSICAL_STORAGE_SERIAL_NUMBER);
        params.add(ParameterCode.PHYSICAL_STORAGE_TRANSPORT_TYPE);
        params.add(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM);
        return params;
    }

    public BigInteger getAllocationSpace() {
        try {
            return this.getNonAllocatedSpace();
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[0]);
            return BigInteger.ZERO;
        }
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_WCE_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_WP, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DIRECT_ACCESS_DEVICE_ALLOCABLE, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
    }

    private class AllocationTool {
        private AllocationTool() {
        }

        ConfigElementData getVolumeAllcationCed(String aAlias, BigInteger aSize, BigInteger aStartAddr) throws IllegalValueException {
            List<StorageSpaceImpl> allFreeSpaces = DirectAccessDeviceImpl.this.myStorageSpaceManager.getFreeSpaceList();
            StorageSpaceImpl firstFragmentInAllocation = this.getFragment(aStartAddr, allFreeSpaces);
            if (firstFragmentInAllocation == null) {
                throw new IllegalStateException("First disk free-size fragment not found");
            }
            if (aStartAddr == null) {
                aStartAddr = firstFragmentInAllocation.getStartAddress();
            }
            Allocable fakeFirstAllocable = this.createAllocable(firstFragmentInAllocation, aStartAddr);
            List<StorageSpaceImpl> fragmentsInUse = allFreeSpaces.subList(allFreeSpaces.indexOf(firstFragmentInAllocation), allFreeSpaces.size());
            List spacesForAllocation = Util.convertListType(fragmentsInUse);
            spacesForAllocation.set(0, fakeFirstAllocable);
            Map allocaMap = AllocationUtil.getSimpleAllocation((BigInteger)aSize, (List)spacesForAllocation);
            if (allocaMap == null) {
                throw new IllegalStateException("Allocation map is null although there is enough allocation space");
            }
            allocaMap.put(firstFragmentInAllocation, allocaMap.remove(fakeFirstAllocable));
            BigInteger blockSize = new BigInteger(String.valueOf(DirectAccessDeviceImpl.this.getBlockSize()));
            allocaMap = AllocationUtil.filterAllocationBySize((Map)allocaMap, (BigInteger)blockSize);
            if (allocaMap.size() == 1) {
                StorageSpaceImpl storageSpace = (StorageSpaceImpl)allocaMap.keySet().iterator().next();
                BigInteger subdiskStart = storageSpace.getStartAddress().max(aStartAddr);
                return DirectAccessDeviceImpl.this.getSubdiskCreationCed(aAlias, subdiskStart, (BigInteger)allocaMap.get(storageSpace), null, null);
            }
            ConfigElementDataList subdisksCedList = new ConfigElementDataList(ConfigOperation.CREATE);
            int aliasIndex = DirectAccessDeviceImpl.this.cluster.getStoragePoolMgr().getLastAliasIndex(aAlias);
            for (Allocable allocable : allocaMap.keySet()) {
                StorageSpaceImpl storageSpace = (StorageSpaceImpl)allocable;
                String subdiskChildAlias = aAlias + '.' + ++aliasIndex;
                BigInteger startAddr = storageSpace.getStartAddress().max(aStartAddr);
                ConfigElementData subdiskCed = DirectAccessDeviceImpl.this.getSubdiskCreationCed(subdiskChildAlias, startAddr, (BigInteger)allocaMap.get(storageSpace), null, null);
                subdisksCedList.add((ElementData)subdiskCed);
            }
            ConfigElementData concatCed = new ConfigElementData(ClassID.CONCAT_VOLUME, ConfigOperation.CREATE);
            concatCed.setValue(ParameterCode.VOLUME_ALIAS, (SrType)new SrString(aAlias));
            concatCed.setValue(ParameterCode.VOLUME_CHILDREN, subdisksCedList);
            return concatCed;
        }

        private StorageSpaceImpl getFragment(BigInteger aStartAddr, List<StorageSpaceImpl> aFreeSpaceFragments) {
            StorageSpaceImpl firstFragmentInAllocation = null;
            if (aStartAddr == null) {
                firstFragmentInAllocation = aFreeSpaceFragments.get(0);
            } else {
                for (StorageSpaceImpl fragment : aFreeSpaceFragments) {
                    BigInteger fragmentStart = fragment.getStartAddress();
                    BigInteger fragmentEnd = fragmentStart.add(fragment.getSize());
                    if (fragmentStart.compareTo(aStartAddr) > 0 || fragmentEnd.compareTo(aStartAddr) <= 0) continue;
                    firstFragmentInAllocation = fragment;
                    break;
                }
            }
            return firstFragmentInAllocation;
        }

        private Allocable createAllocable(final StorageSpaceImpl aFragment, final BigInteger aStartAddr) {
            if (aStartAddr == null) {
                return aFragment;
            }
            Allocable allocable = new Allocable(){

                public BigInteger getAllocationSpace() {
                    return aFragment.getAllocationSpace().subtract(aStartAddr.subtract(aFragment.getStartAddress()));
                }
            };
            return allocable;
        }
    }
}

