/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.lu;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.lu.LUAlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.VirtualizationHierarchyObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.lu.LUSyncValidator;
import com.sanrad.nms.server.logic.lu.SCSILunImpl;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeParentable;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.LUOperStatusConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStateConstant;
import com.sanrad.nms.server.util.types.constants.SCSILunStatusConstant;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.SrFuture;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LUImpl
extends SynchronizeableImpl
implements LU,
SynchronizeListener,
VolumeParentable,
VirtualizationHierarchyObject {
    public static final int MAX_LUN_VALUE = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.MAX_LUN_VALUE));
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private TargetImpl parentTaregt = null;
    private VolumeNodeImpl volumeChild = null;
    private Integer lun = null;
    private SCSILunImpl scsiLun = null;

    public LUImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.LUN, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        VolumeNodeImpl volume = this.getVolumeChild();
        Parameter childVolume = new Parameter(ParameterCode.LU_VOLUME_ID, (Object)new CommKeyClassId(volume.getCommKeys(), volume.getClassId()));
        ced.addParameter(childVolume);
        if (volume.getClassId().equals((Object)ClassID.TRANSPARENT_VOLUME)) {
            return this.deleteLuAndTransparent(volume, ced);
        }
        return this.deleteElement(ced);
    }

    private SrFuture<Void> deleteLuAndTransparent(VolumeNode volume, ConfigElementData ced) throws RemoteException {
        ConfigElementDataList list = new ConfigElementDataList();
        list.add((ElementData)ced);
        list.add((ElementData)new ConfigElementData(volume.getCommKeyClassId()));
        return DataMgrAdapter.getInstance().removeElement(list);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        BigInteger luNumber = (BigInteger)this.getSrValueOf(null, ParameterCode.LU_LUN_NUMBER, true).value();
        this.lun = new Integer(luNumber.intValue());
        this.toStringValue = this.getLUN().toString();
        boolean newElement = this.parentTaregt == null;
        VSwitchImpl vSwitch = this.getVSwitch(aCED);
        if (this.parentTaregt == null) {
            this.parentTaregt = this.getParentTarget(vSwitch);
            if (this.parentTaregt == null) {
                throw new IllegalValueException(ClassID.VSWITCH + " " + vSwitch + ".  Target of LU " + this.lun + " is null");
            }
        }
        VolumeNodeImpl oldVolume = null;
        if (aCED.getParametersList().containsKey(ParameterCode.LU_VOLUME_ID)) {
            oldVolume = this.volumeChild;
            this.volumeChild = this.getVolumeChild(vSwitch);
        }
        if (this.volumeChild == null) {
            throw new IllegalValueException(ClassID.VSWITCH + " " + vSwitch + ".  Volume of LU " + this.lun + " on target " + this.parentTaregt + " is null");
        }
        this.toStringValue = this.parentTaregt.toString() + "/" + this.getLUN().toString();
        if (oldVolume != null && !this.volumeChild.equals(oldVolume)) {
            ((SynchronizeableImpl)oldVolume).removeSynchronizeListener(this);
            if (oldVolume.getParentLU() != null && oldVolume.getParentLU().equals(this)) {
                this.cluster.getStorage().returnVolumeToForest(oldVolume);
            } else {
                this.removePropagationStateDependentObjectAndListener(oldVolume);
            }
            this.setVol(this.volumeChild);
        }
        if (newElement) {
            this.parentTaregt.addSynchronizeListener(this);
            this.setVol(this.volumeChild);
        }
        ErrorAssertingListener.listenTo(this.synchronizeSerialNumber());
        return changedValues;
    }

    public SrFuture<Void> synchronizeSerialNumber() throws RemoteException, IllegalValueException {
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            SrType luSerialNumberOnNotExposed;
            SrType luSerialNumberOnExposed;
            VSwitchImpl exposedOnVSwitch = this.getExposedOnVSwitch();
            VSwitchImpl notExposedOnVSwitch = this.getNotExposedOnVSwitch();
            CommKey exposedKey = CommKeyUtil.getSpecificCommKey((CommKeyClassId)this.getCommKeyClassId(), (char)exposedOnVSwitch.getCommKeyClassId().getMyFirstSnmpAgentIndex());
            CommKey notExposedKey = CommKeyUtil.getSpecificCommKey((CommKeyClassId)this.getCommKeyClassId(), (char)notExposedOnVSwitch.getCommKeyClassId().getMyFirstSnmpAgentIndex());
            if (exposedKey != null && notExposedKey != null && !(luSerialNumberOnExposed = this.getLUSerialNumber(exposedOnVSwitch)).equals((Object)(luSerialNumberOnNotExposed = this.getLUSerialNumber(notExposedOnVSwitch))) && this.isNullSerialNumberValue((SrString)luSerialNumberOnNotExposed)) {
                ConfigElementData element = new ConfigElementData(this.getCommKeyClassId());
                element.setValue(ParameterCode.LU_SERIAL_NUMBER, luSerialNumberOnExposed);
                element.setValue(ParameterCode.VSWITCH_ID, (SrType)notExposedOnVSwitch.getCommKeyClassId());
                return DataMgrAdapter.getInstance().changeElement(element);
            }
        }
        return new CompleteFuture("LUImpl.synchronizeSerialNumber");
    }

    private boolean isNullSerialNumberValue(SrString value) {
        if (value.toString().length() == 0) {
            return true;
        }
        if (this.isMonfoxHexaString(value.toString())) {
            String strval = value.toString();
            BigInteger bigint = new BigInteger(strval.substring(1, strval.length() - 2), 16);
            return bigint.compareTo(BigInteger.ZERO) == 0;
        }
        return false;
    }

    private boolean isMonfoxHexaString(String str) {
        if (str == null || str.length() < 5) {
            return false;
        }
        int len = str.length();
        if (str.charAt(0) == '\'' && str.charAt(len - 2) == '\'' && (str.charAt(len - 1) == 'H' || str.charAt(len - 1) == 'h') && (len - 1) % 2 == 0) {
            char c;
            String hexStr = str.substring(1, len - 2).toLowerCase();
            int i = hexStr.length();
            while (i-- > 0 && (Character.isDigit(c = hexStr.charAt(i)) || c >= 'a' && c <= 'f')) {
            }
            return i == -1;
        }
        return false;
    }

    private VSwitchImpl getExposedOnVSwitch() {
        TargetImpl parent = this.getParentTarget();
        String vSwitchName = parent.getExposedOnVSwitch();
        return this.getCluster().getVSwitchByName(vSwitchName);
    }

    private VSwitchImpl getNotExposedOnVSwitch() {
        VSwitchImpl exposedOnVSwitch = this.getExposedOnVSwitch();
        return this.getCluster().getOtherVSwitch(exposedOnVSwitch);
    }

    @Override
    public String getSerialNumber() {
        VSwitchImpl vs = this.getExposedOnVSwitch();
        if (vs == null) {
            vs = this.getFirstVSwitch();
        }
        return this.getSerialNumber(vs);
    }

    public String getSerialNumber(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(this.getExposedOnVSwitch(), ParameterCode.LU_SERIAL_NUMBER);
    }

    public SrType getLUSerialNumber() {
        return this.getLUSerialNumber(this.getExposedOnVSwitch());
    }

    private SrType getLUSerialNumber(VSwitchImpl vSwitch) {
        SrType luSerialNumber = this.getSrValueOf(vSwitch, ParameterCode.LU_SERIAL_NUMBER, vSwitch == null);
        return luSerialNumber;
    }

    private void setVolumeExposed() {
        if (this.volumeChild != null) {
            this.volumeChild.setExposed(true);
            this.volumeChild.setParentLU(this);
            this.volumeChild.setParent(null, 0);
        }
    }

    @Override
    public Integer getLUN() {
        return this.lun;
    }

    public Integer getLUN(VSwitchImpl vSwitch) {
        SrGauge lun = (SrGauge)this.getSrValueOf(vSwitch, ParameterCode.LU_LUN_NUMBER, vSwitch == null);
        if (lun != null) {
            return new Integer(((BigInteger)lun.value()).intValue());
        }
        return null;
    }

    public TargetImpl getParentTarget(VSwitchImpl vSwitch) {
        CommKeyClassId targetCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.LU_PARENT, vSwitch == null);
        TargetImpl taregt = (TargetImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(targetCommKeyClassId);
        return taregt;
    }

    @Override
    public TargetImpl getParentTarget() {
        return this.parentTaregt;
    }

    public VolumeNodeImpl getVolumeChild(VSwitchImpl vSwitch) {
        CommKeyClassId volumeCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.LU_VOLUME_ID, vSwitch == null);
        VolumeNodeImpl volume = (VolumeNodeImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(volumeCommKeyClassId);
        return volume;
    }

    @Override
    public VolumeNodeImpl getVolumeChild() {
        return this.volumeChild;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException();
    }

    public BigInteger getAccessibleSpace() {
        VolumeNodeImpl volume = this.getVolumeChild();
        return volume.getAccessibleSpace();
    }

    public int getTotalVolumeCount() {
        int totalVolumeCount = 0;
        VolumeNodeImpl volume = this.getVolumeChild();
        if (volume instanceof VolumeImpl) {
            ++totalVolumeCount;
        }
        return totalVolumeCount += volume.getChildrenOfVirtualVolumeTypeCount();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LU) {
            try {
                if (((LU)obj).getLUN().equals(this.getLUN()) && ((LU)obj).getParentTarget().equals(this.getParentTarget())) {
                    VolumeNode volumeNode = ((LU)obj).getVolumeChild();
                    if (volumeNode != null && this.getVolumeChild() != null) {
                        return ((LU)obj).getVolumeChild().equals(this.getVolumeChild());
                    }
                    return volumeNode == null && this.getVolumeChild() == null;
                }
            }
            catch (RemoteException re) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)re, new Object[]{"got a remote exception in the server."});
            }
        }
        return false;
    }

    private LUOperStatusConstant getState(VSwitchImpl vSwitch) {
        return (LUOperStatusConstant)this.getSrValueOf(vSwitch, ParameterCode.LU_OPER_STATUS, vSwitch == null);
    }

    private boolean isInState(VSwitchImpl vSwitch, LUOperStatusConstant state) {
        return state.equals((Object)this.getState(vSwitch));
    }

    public boolean isWaitingForTarget(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, LUOperStatusConstant.LU_OPER_STATUS_WAITING_FOR_TARGET);
    }

    public boolean isInitializing(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, LUOperStatusConstant.LU_OPER_STATUS_INITIALIZING);
    }

    public boolean isActive(VSwitchImpl vSwitch) {
        return this.isInState(vSwitch, LUOperStatusConstant.LU_OPER_STATUS_ACTIVE);
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.addPropagationStateDependentObjectAndListener(this.getVolumeChild());
        this.getParentTarget().addPropagationStateDependentObjectAndListener(this);
        VolumeNodeImpl volume = this.getVolumeChild();
        if (volume instanceof VolumeImpl) {
            ((VolumeImpl)volume).unRegisterToPropagatedStateListenerForAllLeafs(this.cluster);
        } else {
            this.cluster.removePropagationStateDependentObjectAndListener(volume);
        }
    }

    @Override
    public void unregisterToPropagatedStateChange() {
        this.getParentTarget().removePropagationStateDependentObjectAndListener(this);
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return LUAlarmGenerator.getInstance();
    }

    public boolean isLU0() {
        return this.lun != null && this.lun == 0;
    }

    @Override
    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        TargetImpl target = this.getParentTarget();
        if (target.isNeedToSynchronize()) {
            if (!target.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("LU ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(target.getClassId());
                msg.append(" ");
                msg.append(target);
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Target " + target.getAlias() + " is not synchronized.";
            return msg;
        }
        VolumeNodeImpl volume = this.getVolumeChild();
        if (volume.isNeedToSynchronize()) {
            if (!volume.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("LU ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(volume.getClassId());
                msg.append(" ");
                msg.append(volume);
                msg.append("is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Volume " + volume.getAlias() + " is not synchronized.";
            return msg;
        }
        return null;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Start Sync of Lu ", this.toString()});
        if (this.isSynchronizePending()) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Already synchronizing ", this.getClassId(), " ", this.toString()});
            return 1;
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Start to synchronize ", this.getClassId(), " ", this.toString()});
        this.setSynchronizePending(true);
        int retVal = 0;
        try {
            retVal = this.getVolumeChild().synchronize();
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of Lu ", this.toString(), " Vol ", this.getVolumeChild().getAlias(), " Vol Sync status ", retVal});
            switch (retVal) {
                case 1: 
                case 2: {
                    return 2;
                }
                case 3: {
                    this.setSynchronizePending(false);
                    return 3;
                }
            }
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizePending(false);
                return retVal;
            }
            retVal = this.synchronizeMe();
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of Lu ", this.toString(), " SyncMe status ", retVal});
            return retVal;
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
            this.setSynchronizePending(false);
            throw ive;
        }
    }

    @Override
    public int synchronizeMe() throws RemoteException, IllegalValueException {
        String msg = this.canBeSynchronized();
        if (msg != null) {
            return 2;
        }
        if (!this.isInSynchronizingMode()) {
            theLogger.info(SrLogCategories.LEGACY, new Object[]{"Sync Me for Lu ", this.toString()});
            StorageImpl storage = this.cluster.getStorage();
            LUSyncValidator validator = new LUSyncValidator(this.cluster, this.getLUN(), this.getVolumeChild(), this.getParentTarget(), this.cluster.getOtherVSwitches(this.getVSwitches()));
            if (!validator.isValid()) {
                throw new IllegalValueException(validator.getErrorMsg());
            }
            String serialNumber = null;
            if (!this.getVolumeChild().getClassId().equals((Object)ClassID.TRANSPARENT_VOLUME)) {
                serialNumber = this.getSerialNumber(this.getActiveVswitch());
            }
            ErrorAssertingListener.listenTo(storage.exposeVolume(this.getLUN(), this.getVolumeChild(), this.getParentTarget(), this.cluster.getOtherVSwitches(this.getVSwitches()), this.getCommKeyClassId(), serialNumber));
            theLogger.info(SrLogCategories.LEGACY, new Object[]{"After send SNMP in Sync Me for Lu ", this.toString()});
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    @Override
    public void synchronizingCompleted(SynchronizeEvent event) {
        try {
            this.syncDataWasChanged();
        }
        catch (RemoteException re) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{re});
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
        }
    }

    @Override
    public void doneSynchronizing() throws RemoteException {
        super.doneSynchronizing();
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"syncDataWasChanged called  ", this.toString()});
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
        }
        catch (IllegalValueException ive) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)((Object)ive), new Object[0]);
            this.errorInSynchronizing();
            return;
        }
        this.doneSynchronizing();
    }

    @Override
    public String getAlias() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        throw new UnsupportedOperationException();
    }

    private void setVol(VolumeNodeImpl newVol) {
        if (newVol.getParentLU() == null && newVol.getParentVolume() == null) {
            this.cluster.getVolumeMgr().removeVolumeFromForest(newVol);
        }
        this.volumeChild = newVol;
        newVol.addSynchronizeListener(this);
        this.addPropagationStateDependentObjectAndListener(newVol);
        this.setVolumeExposed();
    }

    public void removeVol(VolumeNodeImpl vol) {
        vol.removeSynchronizeListener(this);
        vol.removePropagatedStateEventListener(this);
        if (this.volumeChild.equals(vol)) {
            this.volumeChild = null;
        }
    }

    @Override
    public void childVolumeStateWasChanged() {
    }

    @Override
    public void childCapacityWasChanged() {
    }

    @Override
    public boolean isLegitimateForVolumeOperation() {
        return this.parentTaregt.isLegitimateForVolumeOperation();
    }

    public SCSILunImpl getScsiLun() {
        return this.scsiLun;
    }

    public void setScsiLun(SCSILunImpl scsiLun) {
        this.scsiLun = scsiLun;
    }

    @Override
    public String getDeviceRevisionID() throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getRevisionID() : null;
    }

    public String getDeviceRevisionID(VSwitchImpl vSwitch) {
        return this.scsiLun != null ? this.scsiLun.getRevisionID(vSwitch) : null;
    }

    @Override
    public SCSILunStateConstant getDeviceState() {
        return this.scsiLun != null ? this.scsiLun.getState() : null;
    }

    public SCSILunStateConstant getDeviceState(VSwitchImpl vSwitch) {
        return this.scsiLun != null ? this.scsiLun.getState(vSwitch) : null;
    }

    @Override
    public SCSILunStatusConstant getDeviceStatus() {
        return this.scsiLun != null ? this.scsiLun.getStatus() : null;
    }

    public SCSILunStatusConstant getDeviceStatus(VSwitchImpl vSwitch) throws RemoteException {
        return this.scsiLun != null ? this.scsiLun.getStatus(vSwitch) : null;
    }

    public SrFuture<Void> readSCSILunElement() throws RemoteException {
        if (this.cluster.isDiscoverCompleted()) {
            VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
            CommKeyClassId[] vSwitchesData = new CommKeyClassId[vSwitches.length];
            CommKeyClassId targetID = this.getParentTarget().getCommKeyClassId();
            CommKey[] scsiKeys = null;
            int vsCount = vSwitches.length;
            for (int i = 0; i < vsCount; ++i) {
                CommKeyClassId vsKey;
                vSwitchesData[i] = vsKey = vSwitches[i].getCommKeyClassId();
                CommKeyClassId targetSpecific = CommKeyUtil.getSpecificCommKeyClassId((CommKeyClassId)targetID, (CommKeyClassId)vsKey);
                if (i == 0) {
                    CommKeyClassId ckcid = this.cluster.getSCSIId(targetSpecific);
                    if (ckcid == null) {
                        String errMsg = "The returned ckcid must not be null. myID: " + this.getCommKeyClassId() + "; targetID: " + targetID + "; vsKey: " + vsKey + "; targetSpecific: " + targetSpecific + "; cluster's SCSI/iSCSI mapping: " + this.cluster.getPrintableSCSIISCSIDeviceMap();
                        theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{errMsg});
                        throw new IllegalStateException(errMsg);
                    }
                    scsiKeys = ckcid.getCommKeys();
                    continue;
                }
                scsiKeys = CommKeyUtil.mergerCommKeyLists(scsiKeys, (CommKey[])this.cluster.getSCSIId(targetSpecific).getCommKeys());
            }
            ConfigElementData element = new ConfigElementData(ClassID.SCSI_LUN);
            CommKeyClassId scsiDeviceID = new CommKeyClassId(scsiKeys, ClassID.SCSI_TARGET);
            element.setValue(ParameterCode.SCSI_DEVICE_ID, (SrType)scsiDeviceID);
            element.setValue(ParameterCode.LU_LUN_NUMBER, this.getSrValueOf(ParameterCode.LU_LUN_NUMBER));
            element.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)vSwitchesData));
            return this.cluster.createElement(element, "read SCSI LUN after LU creation", null);
        }
        return new CompleteFuture("LUImpl.readSCSILunElement");
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap list = super.getClientParameterList();
        list.put(ClientParameterCode.LU_DEVICE_REVISION_ID, this.getDeviceRevisionID());
        list.put(ClientParameterCode.LU_DEVICE_STATE, this.getDeviceState());
        list.put(ClientParameterCode.LU_DEVICE_STATUS, this.getDeviceStatus());
        list.put(ClientParameterCode.LU_VOLUME_CHILD, this.volumeChild);
        return list;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.LU_LUN_NUMBER);
        params.add(ParameterCode.LU_SERIAL_NUMBER);
        params.add(ParameterCode.LU_PARENT);
        params.add(ParameterCode.LU_VOLUME_ID);
        return params;
    }

    @Override
    protected List<LogicObjectImpl> getChildElementsForDeletion() {
        ArrayList<LogicObjectImpl> children = new ArrayList<LogicObjectImpl>();
        VolumeNodeImpl luChild = this.getVolumeChild();
        if (!ClassID.DIRECT_ACCESS_DEVICE.equals((Object)luChild.getClassId())) {
            children.add(luChild);
        }
        return children;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.LU_LUN_NUMBER, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.LU_PARENT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.LU_VOLUME_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.LU_OPER_STATUS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.LU_SERIAL_NUMBER, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

