/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.iscsi;

import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSIConnection;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionImpl;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.constants.ConnectionStateConstant;
import com.sanrad.nms.server.util.types.constants.SessionDirectionConstant;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ISCSIConnectionImpl
extends TableRowImpl
implements ISCSIConnection {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private ISCSISessionImpl mySessionParent;

    public ISCSIConnectionImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.mySessionParent = this.getConnectionSessionParent();
        return changedValues;
    }

    @Override
    public void clear() throws RemoteException {
        this.setSessionParent(null);
        super.clear();
    }

    public ISCSISessionImpl getConnectionSessionParent() {
        CommKeyClassId sessionCommKeyClassId = (CommKeyClassId)this.getSrValueOf(ParameterCode.ISCSI_SESSION_ID);
        ISCSISessionImpl iscsiSessionImpl = (ISCSISessionImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(sessionCommKeyClassId);
        return iscsiSessionImpl;
    }

    @Override
    public ISCSISessionImpl getSessionParent() {
        return this.mySessionParent;
    }

    public void setSessionParent(ISCSISessionImpl session) {
        this.mySessionParent = session;
    }

    @Override
    public Integer getCid() {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_CID);
    }

    @Override
    public ConnectionStateConstant getState() {
        return (ConnectionStateConstant)this.getSrValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_STATE);
    }

    @Override
    public String getInitiatorIP() {
        if (this.mySessionParent == null) {
            this.mySessionParent = this.getConnectionSessionParent();
        }
        if (this.mySessionParent != null) {
            SessionDirectionConstant sessionDirection = this.mySessionParent.getDirection();
            ParameterCode code = SessionDirectionConstant.IN_BOUND.equals((Object)sessionDirection) ? ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS : ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS;
            String ip = this.getDisplayStringOf(this.getParentVSwitch(), code);
            return ip;
        }
        return null;
    }

    @Override
    public BigInteger getInitiatorPort() {
        SessionDirectionConstant sessionDirection = this.mySessionParent.getDirection();
        ParameterCode code = sessionDirection.equals((Object)SessionDirectionConstant.IN_BOUND) ? ParameterCode.ISCSI_CONNECTION_REMOTE_PORT : ParameterCode.ISCSI_CONNECTION_LOCAL_PORT;
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), code);
    }

    @Override
    public String getTargetIP() {
        SessionDirectionConstant sessionDirection = this.mySessionParent.getDirection();
        ParameterCode code = sessionDirection.equals((Object)SessionDirectionConstant.IN_BOUND) ? ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS : ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS;
        String ip = this.getDisplayStringOf(this.getParentVSwitch(), code);
        return ip;
    }

    @Override
    public BigInteger getTargetPort() {
        SessionDirectionConstant sessionDirection = this.mySessionParent.getDirection();
        ParameterCode code = sessionDirection.equals((Object)SessionDirectionConstant.IN_BOUND) ? ParameterCode.ISCSI_CONNECTION_LOCAL_PORT : ParameterCode.ISCSI_CONNECTION_REMOTE_PORT;
        return (BigInteger)this.getValueOf(this.getParentVSwitch(), code);
    }

    @Override
    public Integer getMaxReceivedPDULength() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH);
    }

    @Override
    public Integer getMaxTransmittedPDULength() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH);
    }

    @Override
    public Integer getHeaderIntegrity() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY);
    }

    @Override
    public Integer getDataIntegrity() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY);
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public String toString() {
        return "TODO";
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_SESSION_ID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_CID, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_LOCAL_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_LOCAL_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_REMOTE_ADDRESS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_REMOTE_PORT, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_MAX_RECEIVED_PDU_LENGTH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_MAX_TRANSMIT_PDU_LENGTH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_HEADER_INTEGRITY, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ISCSI_CONNECTION_DATA_INTEGRITY, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

