/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.identity.IdentityName;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IdentityNameImpl
extends SynchronizeableImpl
implements IdentityName {
    private IdentityImpl identityParent;
    private String name;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public IdentityNameImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        this.identityParent = this.getIdentityParent(null);
        this.name = this.getName(null);
        return changedValues;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getName(VSwitchImpl vSwitch) {
        return (String)this.getValueOf(vSwitch, ParameterCode.IDENTITY_NAME_VALUE, vSwitch == null);
    }

    @Override
    public IdentityImpl getIdentityParent() throws RemoteException {
        return this.identityParent;
    }

    public IdentityImpl getIdentityParent(VSwitchImpl vSwitch) {
        CommKeyClassId identCommKeyClassId = (CommKeyClassId)this.getSrValueOf(vSwitch, ParameterCode.IDENTITY_NAME_PARENT, vSwitch == null);
        IdentityImpl identity = (IdentityImpl)this.cluster.getCommKeyRefMap().getRefByCommKeyClassID(identCommKeyClassId);
        return identity;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Checking synchronizing for ", this.getClassId(), " ", this.toString()});
        this.setSynchronizePending(true);
        if (!this.isRedundant()) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Begin synchronizing for ", this.getClassId(), " ", this.toString()});
            this.synchronizeMe();
        }
        return 2;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            ErrorAssertingListener.listenTo(this.getIdentityParent().synchronizeIdentityName(this.getName(), this.cluster.getOtherVSwitches(this.getVSwitches())));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            this.doneSynchronizing();
        }
        IdentityImpl identityParent = this.getIdentityParent();
        identityParent.syncDataWasChanged();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return "";
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        return "";
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.IDENTITY_NAME_PARENT);
        params.add(ParameterCode.IDENTITY_NAME_VALUE);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.IDENTITY_NAME_VALUE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.IDENTITY_NAME_PARENT, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

