/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.srv.radius.RadiusServerImpl;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class IdentitiesList {
    private Hashtable<String, IdentityImpl> list = new Hashtable();
    public static final String TARGET_IDENTITY_DESCRIPTION = "#forTarget#";
    public static final String DEF_ALL_IDENTITY_ALIAS = "DEF_ALL";
    public static final String DR_DEF_ALL_IDENTITY_ALIAS = "DR_IDENTITY_ALL";
    private HashMap<String, ArrayList<String>> m_pendingDrIdentityCreate = new HashMap();
    private static SrLogger theLogger = SrLogger.getLogger();

    public void addIdentity(IdentityImpl identity) throws RemoteException {
        this.list.put(identity.getAlias(), identity);
    }

    public void addIdentity(IdentityImpl identity, String vswitchName) throws RemoteException {
        String key = this.createIdentityKey(identity.getAlias(), vswitchName);
        this.list.put(key, identity);
    }

    public IdentityImpl removeIdentity(IdentityImpl identity) {
        boolean isLocalInitiatorIdentity = identity.isOfLocalInitiator();
        String identityKey = identity.getAlias();
        if (isLocalInitiatorIdentity) {
            Enumeration<String> keys = this.list.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (!this.list.get(key).equals(identity)) continue;
                identityKey = key;
            }
        }
        if (identity.getConnectedVSwitchCounter() < 2) {
            identity.removeAllCredentials();
            identity.removeAllNames();
            this.list.remove(identityKey);
        }
        return identity;
    }

    public void changeEntryKey(IdentityImpl identity) throws RemoteException {
        Enumeration<String> keys = this.list.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!this.list.get(key).equals(identity)) continue;
            String alias = identity.getAlias();
            if (!alias.equals(key)) {
                this.list.remove(key);
                this.list.put(alias, identity);
            }
            return;
        }
    }

    public void changeEntryKey(IdentityImpl identity, String vswitchName) throws RemoteException {
        String newKey = this.createIdentityKey(identity.getAlias(), vswitchName);
        Enumeration<String> keys = this.list.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!this.list.get(key).equals(identity)) continue;
            this.list.remove(key);
            this.list.put(newKey, identity);
            return;
        }
    }

    public void removeAll() {
        this.list.clear();
        this.clearAllPendingCreatingDrIdentities();
    }

    public IdentityImpl getIdentityByAlias(String alias) {
        return this.list.get(alias);
    }

    public IdentityImpl getDRIdentityByRemoteInitiatorNames(ArrayList existedRemoteInitiatorNames) throws RemoteException {
        Enumeration<String> keys = this.list.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            IdentityImpl identity = this.list.get(key);
            if (!identity.isOfRemoteInitiatorDR() && (!identity.isPurposeUnknown() || !identity.getAlias().startsWith(IdentityPurposeConstant.REMOTE_INITIATOR_DR.getDescriptionName())) || !identity.atLeastOneNameIncluded(existedRemoteInitiatorNames)) continue;
            return identity;
        }
        return null;
    }

    public boolean isAliasExist(String alias) {
        return this.list.containsKey(alias);
    }

    public Vector<IdentityImpl> getAllIdentities() throws RemoteException {
        Vector<IdentityImpl> identities = new Vector<IdentityImpl>();
        for (IdentityImpl identity : this.list.values()) {
            if (identity.getAlias().equals(TARGET_IDENTITY_DESCRIPTION)) continue;
            identities.addElement(identity);
        }
        return identities;
    }

    public boolean synchronize() throws RemoteException, IllegalValueException {
        StringBuffer errMsg = new StringBuffer();
        boolean errOccured = false;
        Enumeration<IdentityImpl> e = this.list.elements();
        while (e.hasMoreElements()) {
            Identity identity = e.nextElement();
            try {
                if (((IdentityImpl)identity).isOfLocalInitiator() || ((IdentityImpl)identity).isOfRemoteTarget() || ((IdentityImpl)identity).isOfLocalTarget() && ((IdentityImpl)identity).getDescription().equals(TARGET_IDENTITY_DESCRIPTION) || identity.getAlias().equals(DEF_ALL_IDENTITY_ALIAS)) continue;
                identity.synchronize();
            }
            catch (IllegalValueException ive) {
                errMsg.append("\n");
                errMsg.append(ive.getMessage());
                errOccured = true;
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive.getMessage(), " when trying to synchronize ", identity.getClassId(), " ", identity});
            }
        }
        if (errOccured) {
            throw new IllegalValueException(errMsg.toString());
        }
        return false;
    }

    public IdentityImpl getIdentityUsingRADIUS(RadiusServerImpl radSrv) {
        Enumeration<String> e = this.list.keys();
        while (e.hasMoreElements()) {
            IdentityImpl identity = this.list.get(e.nextElement());
            if (!identity.isRADIUSServerInUse(radSrv)) continue;
            return identity;
        }
        return null;
    }

    private String createIdentityKey(String identityAlias, String vswitchName) {
        StringBuffer key = new StringBuffer();
        key.append(identityAlias);
        key.append(vswitchName);
        return key.toString();
    }

    public void removeDrIdentityPendingCreateForInitiatorNames(String identityAlias, String identityName) {
        ArrayList<String> nameOfIdentityAlias = this.m_pendingDrIdentityCreate.get(identityAlias);
        if (nameOfIdentityAlias != null && nameOfIdentityAlias.contains(identityName)) {
            ArrayList<String> ret;
            nameOfIdentityAlias.remove(identityName);
            if (nameOfIdentityAlias.size() == 0 && (ret = this.m_pendingDrIdentityCreate.remove(identityAlias)) == null) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Couldn't remove pending created dr identity: ", identityAlias});
            }
        }
    }

    public void addDrIdentityPendingCreateForInitiatorNames(String identityAlias, ArrayList<String> existedRemoteInitiatorNames) {
        this.m_pendingDrIdentityCreate.put(identityAlias, existedRemoteInitiatorNames);
    }

    public boolean isDrIdentityOnPendingCreateForInitiatorNames(ArrayList existedRemoteInitiatorNames) {
        Set<String> keys = this.m_pendingDrIdentityCreate.keySet();
        for (String currentKey : keys) {
            ArrayList<String> identityNames = this.m_pendingDrIdentityCreate.get(currentKey);
            if (!identityNames.containsAll(existedRemoteInitiatorNames)) continue;
            return true;
        }
        return false;
    }

    private void clearAllPendingCreatingDrIdentities() {
        this.m_pendingDrIdentityCreate.clear();
    }
}

