/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.identity;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.CHAPCredentials;
import com.sanrad.nms.server.logic.identity.CredentialsImpl;
import com.sanrad.nms.server.logic.identity.CredentialsValidator;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CHAPCredentialsImpl
extends CredentialsImpl
implements CHAPCredentials {
    public static final int RADIUS_DISABLED = 1;
    public static final int RADIUS_ENABLED = 2;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public CHAPCredentialsImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    protected void initUserNameParameterCode() {
        this.userNameParameterCode = ParameterCode.CHAP_CREDENTIALS_USER_NAME;
    }

    @Override
    public String getPassword(VSwitch vSwitch) throws RemoteException {
        return (String)this.getValueOf(vSwitch, ParameterCode.CHAP_CREDENTIALS_PASSWORD, vSwitch == null);
    }

    @Override
    public boolean isRadiusEnabled() {
        int enabled = (Integer)this.getValueOf(null, ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, true);
        return enabled == 2;
    }

    @Override
    public String getPassword() throws RemoteException {
        return this.password;
    }

    @Override
    protected int synchronizeMe() throws RemoteException, IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            ErrorAssertingListener.listenTo(this.getIdentityParent().createCHAPCredentials(this.getUserName(), this.getPassword(), this.isRadiusEnabled(), this.cluster.getOtherVSwitches(this.getVSwitches())));
            this.setSynchronizingMode(true);
        }
        return 2;
    }

    @Override
    protected void synchronizeMe(HashMap parameterList) throws IllegalValueException {
        if (!this.isInSynchronizingMode()) {
            String userName = this.getUserName();
            Object userNameParam = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME);
            if (userNameParam != null) {
                userName = (String)((SrString)userNameParam).value();
            }
            String password = null;
            Object passwordParam = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD);
            if (passwordParam != null) {
                password = (String)((SrString)passwordParam).value();
            }
            Boolean isRadiusEnabled = new Boolean(this.isRadiusEnabled());
            Object radiusEnabledParam = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED);
            if (radiusEnabledParam != null) {
                isRadiusEnabled = (Boolean)((SrBoolean)radiusEnabledParam).value();
            }
            ErrorAssertingListener.listenTo(this.getIdentityParent().createCHAPCredentials(userName, password, isRadiusEnabled, this.cluster.getOtherVSwitches(this.getVSwitches())));
            this.setSynchronizingMode(true);
        }
    }

    @Override
    public synchronized void syncDataWasChanged() throws RemoteException, IllegalValueException {
        if (!this.isNeedToSynchronize()) {
            this.doneSynchronizing();
        }
        IdentityImpl identityParent = this.getIdentityParent();
        identityParent.syncDataWasChanged();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String result = super.isValid(parameterList);
        if (result == null) {
            Object radiusEnabled = parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED);
            if (radiusEnabled != null) {
                int value = (Boolean)radiusEnabled != false ? 2 : 1;
                parameterList.put(ClientParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, new SrInteger(value));
            }
            String userName = (String)parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME);
            String password = (String)parameterList.get(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD);
            IdentityImpl chapCredParentIdentity = this.getIdentityParent();
            CredentialsValidator chapCredValidator = new CredentialsValidator(chapCredParentIdentity, ClassID.CHAP_CREDENTIALS, userName, password, false);
            if (userName != null) {
                result = chapCredValidator.isUserNameValid(userName);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.CHAP_CREDENTIALS_USER_NAME, new SrString(userName));
            }
            if (password != null) {
                result = chapCredValidator.isPasswordValid(password);
                if (result != null) {
                    return result;
                }
                parameterList.put(ClientParameterCode.CHAP_CREDENTIALS_PASSWORD, new SrString(password));
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return ClassID.CHAP_CREDENTIALS + " " + this.getUserName();
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.CHAP_CREDENTIALS_USER_NAME);
        params.add(ParameterCode.CHAP_CREDENTIALS_PASSWORD);
        params.add(ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED);
        params.add(ParameterCode.CREDENTIALS_PARENT);
        return params;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.CHAP_CREDENTIALS_USER_NAME, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CHAP_CREDENTIALS_PASSWORD, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CHAP_CREDENTIALS_RADIUS_ENABLED, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

