/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.hardware;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.vswitch.VSwitchAlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.hardware.Hardware;
import com.sanrad.nms.server.logic.vswitch.TableRowImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HardwareImpl
extends TableRowImpl
implements Hardware {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static final String STATUS_OK = "OK";
    private static final String STATUS_FAULTY = "FAULTY";
    private static final String STATUS_WARNING = "WARNING";

    public HardwareImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.HARDWARE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(ClassID.HARDWARE.toString());
        sb.append(" of ");
        sb.append(ClassID.VSWITCH.toString());
        sb.append(" ");
        sb.append(this.getParentVSwitch().getName());
        return sb.toString();
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return VSwitchAlarmGenerator.getInstance();
    }

    @Override
    protected String canBeDeleted() {
        throw new UnsupportedOperationException("The client cannot delete hardware element");
    }

    @Override
    protected String isValid(HashMap parameterList) {
        throw new UnsupportedOperationException("The client cannot change hardware parameters");
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public Integer getMaxNumOfPowerSuppliers() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS);
    }

    @Override
    public Integer getCurrentNumOfWorkingPowerSuppliers() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS);
    }

    @Override
    public Integer getMaxNumOfFans() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.MAX_NUM_OF_FANS);
    }

    @Override
    public Integer getCurrentNumOfWorkingFans() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CURR_NUM_OF_WORKING_FANS);
    }

    @Override
    public Integer getOnBoardTemp() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ON_BOARD_TEMP);
    }

    @Override
    public Integer getCPUTemp() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CPU_TEMP);
    }

    @Override
    public Integer getOnBoardFactoryTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH);
    }

    @Override
    public Integer getCPUFactoryTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CPU_FACTORY_TEMP_TRESH);
    }

    @Override
    public Integer getOnBoardWarningTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.ON_BOARD_WARNING_TEMP_TRESH);
    }

    @Override
    public Integer getCPUWarningTempThresh() throws RemoteException {
        return (Integer)this.getValueOf(this.getParentVSwitch(), ParameterCode.CPU_WARNING_TEMP_TRESH);
    }

    @Override
    public String getOnBoardTempStatus() throws RemoteException {
        if (this.isOnBoardTempWarning()) {
            return STATUS_WARNING;
        }
        if (this.isOnBoardTempCritical()) {
            return STATUS_FAULTY;
        }
        return STATUS_OK;
    }

    @Override
    public String getCPUTempStatus() throws RemoteException {
        if (this.isCPUTempWarning()) {
            return STATUS_WARNING;
        }
        if (this.isCPUTempCritical()) {
            return STATUS_FAULTY;
        }
        return STATUS_OK;
    }

    public boolean isFanFaulty() throws RemoteException {
        Integer currNumOfFans = this.getCurrentNumOfWorkingFans();
        if (currNumOfFans > 1) {
            Integer maxNumOfFans = this.getMaxNumOfFans();
            return maxNumOfFans - currNumOfFans > 0;
        }
        return false;
    }

    public boolean isFanCritical() throws RemoteException {
        Integer currNumOfFans = this.getCurrentNumOfWorkingFans();
        return currNumOfFans == 1;
    }

    public boolean isPowerSupplyFaulty() throws RemoteException {
        Integer maxNumOfPowerSuppliers = this.getMaxNumOfPowerSuppliers();
        Integer CurrNumOfPowerSuppliers = this.getCurrentNumOfWorkingPowerSuppliers();
        return maxNumOfPowerSuppliers - CurrNumOfPowerSuppliers > 0;
    }

    public boolean isCPUTempWarning() throws RemoteException {
        Integer cpuTemp = this.getCPUTemp();
        Integer cpuWarningTempTresh = this.getCPUWarningTempThresh();
        if (cpuTemp - cpuWarningTempTresh >= 0) {
            Integer cpuFactoryTempTresh = this.getCPUFactoryTempThresh();
            return cpuTemp - cpuFactoryTempTresh < 0;
        }
        return false;
    }

    public boolean isOnBoardTempWarning() throws RemoteException {
        Integer onBoardTemp = this.getOnBoardTemp();
        Integer onBoardWarningTempTresh = this.getOnBoardWarningTempThresh();
        if (onBoardTemp - onBoardWarningTempTresh >= 0) {
            Integer onBoardFactoryTempTresh = this.getOnBoardFactoryTempThresh();
            return onBoardTemp - onBoardFactoryTempTresh < 0;
        }
        return false;
    }

    public boolean isCPUTempCritical() throws RemoteException {
        Integer cpuTemp = this.getCPUTemp();
        Integer cpuFactoryTempTresh = this.getCPUFactoryTempThresh();
        return cpuTemp - cpuFactoryTempTresh >= 0;
    }

    public boolean isOnBoardTempCritical() throws RemoteException {
        Integer onBoardTemp = this.getOnBoardTemp();
        Integer onBoardFactoryTempTresh = this.getOnBoardFactoryTempThresh();
        return onBoardTemp - onBoardFactoryTempTresh >= 0;
    }

    public boolean isNoFan() throws RemoteException {
        Integer CurrNumOfFans = this.getCurrentNumOfWorkingFans();
        return CurrNumOfFans == 0;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.ON_BOARD_WARNING_TEMP_TRESH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CPU_WARNING_TEMP_TRESH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ON_BOARD_FACTORY_TEMP_TRESH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CPU_FACTORY_TEMP_TRESH, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CPU_TEMP, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.ON_BOARD_TEMP, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CURR_NUM_OF_WORKING_FANS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.MAX_NUM_OF_FANS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.CURR_NUM_OF_WORKING_POWER_SUPPLIERS, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.MAX_NUM_OF_POWER_SUPPLIERS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

