/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRPrimaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.dr.DRSecondaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRVolume;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DRVolumeImpl
extends GeneralLogicObjectImpl
implements DRVolume {
    private VolumeNodeImpl m_localVolume = null;
    private VolumeNodeImpl m_remoteVolume = null;
    private static SrLogger theLogger = SrLogger.getLogger();

    protected DRVolumeImpl(VolumeNodeImpl localVol, VolumeNodeImpl remoteVol) throws RemoteException {
        this.updateDRVolume(localVol, DRRoleConstant.LOCAL);
        this.updateDRVolume(remoteVol, DRRoleConstant.REMOTE);
    }

    protected DRVolumeImpl(VolumeNodeImpl vol, DRRoleConstant role) throws RemoteException {
        this.updateDRVolume(vol, role);
    }

    public void updateDRVolume(VolumeNodeImpl volume, DRRoleConstant role) {
        if (role.equals((Object)DRRoleConstant.LOCAL)) {
            if (this.m_localVolume == null) {
                this.m_localVolume = volume;
            }
        } else if (role.equals((Object)DRRoleConstant.REMOTE)) {
            if (this.m_remoteVolume == null) {
                this.m_remoteVolume = volume;
            }
        } else {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"attempt to set a DR volume with illegal role ", role});
        }
    }

    public void clearLocalVolume() {
        this.m_localVolume = null;
    }

    public void clearRemoteVolume() {
        this.m_remoteVolume = null;
    }

    @Override
    public VolumeNodeImpl getLocalVolume() {
        return this.m_localVolume;
    }

    @Override
    public VolumeNodeImpl getRemoteVolume() {
        return this.m_remoteVolume;
    }

    public boolean isEmpty() {
        return this.m_localVolume == null && this.m_remoteVolume == null;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        return null;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public HashMap checkConsistencyBetweenVSwitches() {
        return null;
    }

    @Override
    public VSwitchImpl[] getConnectedVSwitches() {
        return null;
    }

    public CommKeyClassId getCommKeyClassId() throws RemoteException {
        return null;
    }

    public CommKey[] getCommKeys() throws RemoteException {
        return null;
    }

    @Override
    public Cluster[] getAllClusters() throws RemoteException {
        return null;
    }

    @Override
    public VSwitchImpl getActiveVswitch() {
        VSwitchImpl[] vswitches = this.getConnectedVSwitches();
        if (vswitches.length == 1) {
            return vswitches[0];
        }
        String result = new String(this.getReleventVolume().getParentLU().getParentTarget().getExposedOnVSwitch());
        for (int i = 0; i < vswitches.length; ++i) {
            if (!vswitches[i].toString().equals(result)) continue;
            return vswitches[i];
        }
        return null;
    }

    @Override
    public VSwitch getInactiveVSwitch() throws RemoteException {
        throw new UnsupportedOperationException("getInactiveVSwitch() not supported");
    }

    @Override
    public ClusterImpl getCluster() throws RemoteException {
        return null;
    }

    public boolean isInconsistentWithTheVSwitch() {
        return false;
    }

    @Override
    public boolean isRedundant() {
        return false;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException("deleteElement unsupported for class " + this.getClass());
    }

    @Override
    public List<SrFuture<Void>> deleteElementTree() throws IllegalValueException {
        throw new UnsupportedOperationException("deleteElementTree unsupported for class " + this.getClass());
    }

    @Override
    public SrFuture<Void> changeElement(ClientParameterCode code, Object value) throws RemoteException, IllegalValueException {
        throw new UnsupportedOperationException("changeElement unsupported for class " + this.getClass());
    }

    @Override
    public SrFuture<Void> changeElement(HashMap parameterList) throws IllegalValueException {
        throw new UnsupportedOperationException("changeElement unsupported for class " + this.getClass());
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public boolean isParameterCodeExsist(ParameterCode code) {
        return false;
    }

    @Override
    public boolean isParameterEqual(Parameters param, VSwitchImpl vswitch) {
        return false;
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.addPropagationStateDependentObjectAndListener(this.getReleventVolume());
    }

    public boolean equals(Object obj) {
        return obj instanceof DRVolumeImpl && ((DRVolumeImpl)obj).getLocalVolume() != null && ((DRVolumeImpl)obj).getLocalVolume().equals(this.getLocalVolume()) && ((DRVolumeImpl)obj).getRemoteVolume() != null && ((DRVolumeImpl)obj).getRemoteVolume().equals(this.getRemoteVolume());
    }

    public void validAndActivateForChildren(DRActivateConstant state) throws RemoteException, IllegalValueException {
    }

    @Override
    public boolean validAndActivate(DRActivateConstant state, boolean isSnapshotNeeded) throws IllegalValueException {
        if (state.equals((Object)DRActivateConstant.DISASTER_FAILOVER) || state.equals((Object)DRActivateConstant.ABORT_REPLICATE)) {
            return true;
        }
        if (this.m_localVolume != null && this.m_remoteVolume != null) {
            VolumeNodeImpl nonFunc;
            if (this.m_localVolume.isProvisioned() || this.m_remoteVolume.isProvisioned()) {
                nonFunc = this.m_localVolume;
                if (this.m_remoteVolume.isProvisioned()) {
                    nonFunc = this.m_remoteVolume;
                }
                DRPairImpl pair = DRRootImpl.getInstance().getPairUsingVolume(nonFunc);
                if (nonFunc.equals(this.getRemoteVolume()) && nonFunc.isExposed() && pair != null && ((DRAsyncPairImpl)pair).getVolumeLocalCopySize() != null) {
                    theLogger.info(SrLogCategories.LEGACY, new Object[]{"Do not prevent start replicate on local copy"});
                } else {
                    throw new IllegalValueException("Can't activate " + state + " command since the " + nonFunc + " is non functional ");
                }
            }
            if (this.m_localVolume.isInvolvedInActiveCopy(this.m_localVolume.getActiveVswitch()) || this.m_remoteVolume.isInvolvedInActiveCopy(this.m_remoteVolume.getActiveVswitch())) {
                nonFunc = this.m_localVolume;
                if (this.m_remoteVolume.isNonFunctional()) {
                    nonFunc = this.m_remoteVolume;
                }
                throw new IllegalValueException("Can't activate " + state + " command since the " + nonFunc + " is in copy operation ");
            }
        } else {
            throw new IllegalValueException("one of the volumes is missing!!!");
        }
        if (isSnapshotNeeded) {
            this.checkExsistentOfSnapshot(state);
        }
        if (this.m_localVolume.isInvolvedInActiveCopy(this.m_localVolume.getActiveVswitch()) || this.m_remoteVolume.isInvolvedInActiveCopy(this.m_remoteVolume.getActiveVswitch())) {
            throw new IllegalValueException("one of the volumes is synchronizing!!!");
        }
        return true;
    }

    private void checkExsistentOfSnapshot(DRActivateConstant state) throws IllegalValueException {
        VolumeNodeImpl volume = this.getVolumeAccordingToAction(state);
        if (volume == null) {
            return;
        }
        if (!volume.isSnapshotSource()) {
            throw new IllegalValueException("Can't activate " + state + " command since the " + volume + " doesn't have snapshot ");
        }
    }

    private VolumeNodeImpl getVolumeAccordingToAction(DRActivateConstant state) {
        if (state.equals((Object)DRActivateConstant.FALLBACK) && this instanceof DRSecondaryVolumeImpl) {
            return this.m_remoteVolume;
        }
        if (state.equals((Object)DRActivateConstant.PLANNED_FAILOVER) && this instanceof DRPrimaryVolumeImpl) {
            return this.m_localVolume;
        }
        return null;
    }

    public boolean isVolumeComplete() {
        return this.m_localVolume != null && this.m_remoteVolume != null;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    protected abstract VolumeNodeImpl getReleventVolume();

    public boolean equalsForPendingAlarmsCheck(Object obj) {
        return this.equals(obj);
    }

    @Override
    public boolean equalsByCommKey(Object obj) {
        return false;
    }

    @Override
    public String validateChange(Map<ClientParameterCode, Object> aParams) {
        throw new UnsupportedOperationException("validateChange unsupported for class " + this.getClass());
    }

    @Override
    public String validateDeletion() {
        throw new UnsupportedOperationException("validateDeletion unsupported for class " + this.getClass());
    }
}

