/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterManager;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRBlockingEvent;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroupImpl;
import com.sanrad.nms.server.logic.dr.DREvent;
import com.sanrad.nms.server.logic.dr.DRExtendedPair;
import com.sanrad.nms.server.logic.dr.DRExtendedPairImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObject;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.dr.DRPairImpl;
import com.sanrad.nms.server.logic.dr.DRPiT;
import com.sanrad.nms.server.logic.dr.DRPiTContainer;
import com.sanrad.nms.server.logic.dr.DRPiTImpl;
import com.sanrad.nms.server.logic.dr.DRPrimaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRSecondaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.dr.DRSyncPairImpl;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.policies.PoliciesManager;
import com.sanrad.nms.server.logic.storage.StorageImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.JournalVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.PortalTableRowImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrDateAndTime;
import com.sanrad.nms.server.util.types.SrEntityNameFormat;
import com.sanrad.nms.server.util.types.SrGauge;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrLunFormat;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRModeConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRReplicationStateConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.PolicyTypeConstant;
import com.sanrad.nms.server.util.types.constants.SDTakeOverStateConstant;
import com.sanrad.nms.server.util.types.constants.SrBITSConstant;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DRRootImpl
extends RemoteObjectImpl
implements DRRoot {
    private static DRRootImpl m_theInstance = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    private DRArrayList m_syncPairs = new DRArrayList();
    private DRArrayList m_consistencyGroups = new DRArrayList();
    private DRArrayList m_extendedPairs = new DRArrayList();
    private HashMap m_stubToRefMap = new HashMap();
    private int m_isDRDiscoveryCompletedCounter = 0;
    private boolean m_isDRDiscoveryCompleted = false;
    private HashSet m_clustersDiscoveredInDR = new HashSet();
    private Object m_replacingVolumeLock = new Object();

    private DRRootImpl() throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStubToRefMapping(String hashKey, DRLogicObjectImpl object) {
        HashMap hashMap = this.m_stubToRefMap;
        synchronized (hashMap) {
            this.m_stubToRefMap.put(hashKey, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStubToRefMapping(String hashKey) {
        HashMap hashMap = this.m_stubToRefMap;
        synchronized (hashMap) {
            this.m_stubToRefMap.remove(hashKey);
        }
    }

    public DRPairImpl getPairUsingVolume(VolumeNodeImpl vol) {
        if (vol.getClassId().equals((Object)ClassID.SNAPSHOT_VOLUME)) {
            return this.getPairUsingVolume((SnapshotVolumeImpl)vol);
        }
        ArrayList pairs = this.getAllPairs();
        for (int i = 0; i < pairs.size(); ++i) {
            DRPairImpl pair = (DRPairImpl)pairs.get(i);
            if ((pair.getLocalElement() == null || !vol.equals(((DRClusterPairImpl)pair.getLocalElement()).getPrimaryVolume()) && !vol.equals(((DRClusterPairImpl)pair.getLocalElement()).getSecondaryVolume())) && (pair.getRemoteElement() == null || !vol.equals(((DRClusterPairImpl)pair.getRemoteElement()).getPrimaryVolume()) && !vol.equals(((DRClusterPairImpl)pair.getRemoteElement()).getSecondaryVolume()))) continue;
            return pair;
        }
        return null;
    }

    public boolean isUsedByPair(VolumeNodeImpl vol) {
        return this.getPairUsingVolume(vol) != null;
    }

    public DRPairImpl getPairUsingVolume(SnapshotVolumeImpl sn) {
        VolumeNodeImpl vol = sn.getSourceVolume();
        DRPairImpl pair = this.getPairUsingVolume(vol);
        if (pair != null && pair instanceof DRAsyncPairImpl) {
            DRAsyncPairImpl asyncPair = (DRAsyncPairImpl)pair;
            if (sn.equals(asyncPair.getLocalSnapshot()) || sn.equals(asyncPair.getRemoteSnapshot())) {
                return pair;
            }
            return null;
        }
        return null;
    }

    public DRPairImpl getPairUsingLocalCopy(VolumeNodeImpl vol) {
        ArrayList pairs = this.getAsyncPairList();
        for (int i = 0; i < pairs.size(); ++i) {
            if (!vol.equals(((DRAsyncPairImpl)pairs.get(i)).findLocalCopyToPair())) continue;
            return (DRPairImpl)pairs.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DRLogicObjectImpl getRefByStub(String hashKey) {
        HashMap hashMap = this.m_stubToRefMap;
        synchronized (hashMap) {
            return (DRLogicObjectImpl)this.m_stubToRefMap.get(hashKey);
        }
    }

    private void clearClusterFromElements(ArrayList list, ClusterImpl cluster, boolean fireEvent) throws RemoteException {
        if (list != null && cluster != null) {
            for (DRLogicObjectImpl currObject : list) {
                DRClusterLogicObjectImpl clusterObject = currObject.getClusterElement(cluster);
                if (clusterObject == null) continue;
                this.elementRemoved(clusterObject);
            }
        } else if (cluster == null) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"attempt to clear ", list, " list from ", cluster, " cluster elements"});
        }
    }

    private void clearClusterFromConsistencyGroup(DRAbstractConsistencyGroupImpl cg, ClusterImpl cluster, boolean fireEvent) throws RemoteException {
        DRClusterAbstractConsistencyGroupImpl clusterGroup = (DRClusterAbstractConsistencyGroupImpl)cg.getClusterElement(cluster);
        if (clusterGroup != null) {
            if (!cg.isPartial()) {
                cg.removeElement(clusterGroup);
            }
            if (cg.getPairsCount() > 0) {
                DRAsyncPair[] pairs = cg.getPairs();
                int i = pairs.length;
                while (i-- > 0) {
                    DRClusterAsyncPairImpl clusterPair = (DRClusterAsyncPairImpl)((DRAsyncPairImpl)pairs[i]).getClusterElement(cluster);
                    if (clusterPair == null) continue;
                    this.elementRemoved(clusterPair);
                }
            }
            if (!cg.isPartial()) {
                cg.setElement(clusterGroup);
            }
            this.elementRemoved(clusterGroup);
        }
    }

    private void clearCluster(ClusterImpl cluster, boolean fireEvent) throws RemoteException {
        ArrayList drObjectList = new ArrayList(this.m_consistencyGroups);
        int i = drObjectList.size();
        while (i-- > 0) {
            this.clearClusterFromConsistencyGroup((DRConsistencyGroupImpl)drObjectList.get(i), cluster, fireEvent);
        }
        drObjectList = new ArrayList(this.m_extendedPairs);
        i = drObjectList.size();
        while (i-- > 0) {
            this.clearClusterFromConsistencyGroup((DRExtendedPairImpl)drObjectList.get(i), cluster, fireEvent);
        }
        drObjectList = new ArrayList(this.m_syncPairs);
        this.clearClusterFromElements(drObjectList, cluster, fireEvent);
    }

    private void readCluster(ClusterImpl cluster) throws RemoteException {
        DRClusterManager drClusterManager = cluster.getDRManager();
        DRClusterAbstractConsistencyGroup[] consistencyGroups = drClusterManager.getConsistencyGroups();
        DRClusterAbstractConsistencyGroup[] extendedPairs = drClusterManager.getExtendedPairs();
        DRClusterPair[] syncPairs = drClusterManager.getSyncPairs();
        this.readGroups(consistencyGroups);
        this.readGroups(extendedPairs);
        this.readPairs(syncPairs);
    }

    private void checkAlarms() throws RemoteException {
        if (this.isDiscoverCompleted()) {
            ArrayList list = this.getDRObjects();
            for (int i = 0; i < list.size(); ++i) {
                this.checkAlarms((DRLogicObjectImpl)list.get(i), 1);
            }
        }
    }

    private void readGroups(DRClusterAbstractConsistencyGroup[] groups) throws RemoteException {
        if (groups != null) {
            for (int i = 0; i < groups.length; ++i) {
                this.elementCreated((DRClusterAbstractConsistencyGroupImpl)groups[i]);
                DRClusterPair[] pairs = ((DRClusterAbstractConsistencyGroupImpl)groups[i]).getPairs();
                this.readPairs(pairs);
            }
        }
    }

    private void readPairs(DRClusterPair[] pairs) throws RemoteException {
        try {
            if (pairs != null) {
                for (int i = 0; i < pairs.length; ++i) {
                    this.elementCreated((DRClusterPairImpl)pairs[i]);
                }
            }
        }
        catch (IllegalStateException ise) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)ise);
        }
    }

    private void elementCreated(LogicObjectImpl element) throws RemoteException {
        try {
            ClassID classId = element.getClassId();
            Object drObject = null;
            if (classId.isDRGroup()) {
                this.newConsistencyGroup((DRClusterAbstractConsistencyGroupImpl)element);
            } else if (classId.equals((Object)ClassID.ASYNC_PAIR)) {
                this.newAsyncPair((DRClusterAsyncPairImpl)element);
            } else if (classId.equals((Object)ClassID.SYNC_PAIR)) {
                this.newSyncPair((DRClusterSyncPairImpl)element);
            } else if (classId.equals((Object)ClassID.DR_ASYNC_PAIR_PIT) || classId.equals((Object)ClassID.DR_CONSISTENCY_GROUP_PIT)) {
                this.newDRPiT((DRPiTImpl)element);
            }
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)ive));
        }
        catch (IllegalStateException ise) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)ise);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void elementChanged(DREvent drEvent) throws RemoteException, IllegalValueException {
        HashMap changedElements = drEvent.getParameterList();
        LogicObjectImpl element = drEvent.getElement();
        if (changedElements == null || changedElements.isEmpty()) return;
        if (element instanceof DRClusterLogicObjectImpl) {
            DRClusterLogicObjectImpl clusterDRObject = (DRClusterLogicObjectImpl)element;
            DRLogicObjectImpl matchingDRObject = this.findDRObjectWithIdenticalElement(clusterDRObject);
            if (matchingDRObject == null) return;
            this.drElementChanged(matchingDRObject, clusterDRObject, changedElements);
            boolean isActivateChanged = changedElements.containsKey(matchingDRObject.getParameterCode((ParameterCodes)MasterParameterCode.DR_ACTIVATE));
            if (DRRoleConstant.REMOTE.equals((Object)clusterDRObject.getRole()) && !isActivateChanged) return;
        }
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, element);
        elementEvent.setParameterList(drEvent.getParameterList());
        LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
    }

    private void checkAlarms(DRLogicObjectImpl element, VSwitchImpl vswitch, int eventType) throws RemoteException {
        if (!this.isDiscoverCompleted()) {
            return;
        }
        if (3 == eventType) {
            element.setDeletionProcessCompleted();
        }
        if (!element.isInDeletionProcess() || 3 == eventType) {
            DrAlarmMgrImpl.getInstance().generateAlarms(eventType, element, vswitch);
        }
    }

    private void checkAlarms(DRLogicObjectImpl element, int eventType) throws RemoteException {
        VSwitchImpl[] vswitches = element.getConnectedVSwitches();
        for (int i = 0; i < vswitches.length; ++i) {
            this.checkAlarms(element, vswitches[i], eventType);
        }
    }

    private void elementRemoved(LogicObjectImpl element) throws RemoteException {
        try {
            ClassID classId = element.getClassId();
            if (element instanceof DRClusterLogicObjectImpl) {
                if (this.findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element) == null) {
                    return;
                }
                VSwitchImpl[] vSwitches = element.getConnectedVSwitches();
                int i = vSwitches.length;
                while (i-- > 0) {
                    this.checkAlarms(this.findDRObjectWithIdenticalElement((DRClusterLogicObjectImpl)element), vSwitches[i], 3);
                }
            }
            if (classId.isDRGroup()) {
                this.removeDRClusterConsistencyGroup((DRClusterAbstractConsistencyGroupImpl)element);
            } else if (classId.equals((Object)ClassID.ASYNC_PAIR)) {
                this.removeDRClusterAsyncPair((DRClusterAsyncPairImpl)element, false);
            } else if (classId.equals((Object)ClassID.SYNC_PAIR)) {
                this.removeDRClusterSyncPair((DRClusterSyncPairImpl)element);
            } else if (classId.equals((Object)ClassID.VSWITCH)) {
                VSwitch vswitch = (VSwitch)((Object)element);
                ErrorAssertingListener.listenTo(this.removeInitiatorNameFromTargetsACL(vswitch));
            } else if (classId.equals((Object)ClassID.CLUSTER)) {
                this.clearCluster((ClusterImpl)element, true);
                this.m_clustersDiscoveredInDR.remove(element);
            } else if (classId.equals((Object)ClassID.SITE)) {
                SiteImpl site = (SiteImpl)element;
                ArrayList<ClusterImpl> clusters = site.getClusters();
                int i = clusters.size();
                while (i-- > 0) {
                    this.clearCluster(clusters.get(i), true);
                    this.m_clustersDiscoveredInDR.remove(clusters.get(i));
                }
            } else if (classId.equals((Object)ClassID.DR_ASYNC_PAIR_PIT) || classId.equals((Object)ClassID.DR_CONSISTENCY_GROUP_PIT)) {
                this.removeDRPiT((DRPiTImpl)element);
            }
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)ive));
        }
        catch (IllegalStateException ise) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)ise);
        }
    }

    @Override
    public ArrayList getVSwitches() throws RemoteException {
        ArrayList<VSwitchImpl> vSwitches = new ArrayList<VSwitchImpl>();
        Cluster[] clusters = SystemRootImpl.getInstance().getAllClusters();
        if (clusters != null) {
            for (int i = 0; i < clusters.length; ++i) {
                ClusterImpl currCluster = (ClusterImpl)clusters[i];
                if (!currCluster.isDRInvolved()) continue;
                VSwitchImpl[] currVSwitches = currCluster.getConnectedVSwitches();
                for (int j = 0; j < currVSwitches.length; ++j) {
                    if (vSwitches.contains(currVSwitches[j])) continue;
                    vSwitches.add(currVSwitches[j]);
                }
            }
        }
        return vSwitches;
    }

    private void runEvent(DREvent drEvent) throws RemoteException {
        LogicObjectImpl tmpElem = drEvent.getElement();
        if (!(tmpElem instanceof LogicObjectImpl)) {
            theLogger.fatal(SrLogCategories.ERROR, new Object[]{"The object inside the dr event " + drEvent + " should be an instance of LogicObjectImpl but it is an instance of " + tmpElem.getClass().toString()});
            throw new IllegalArgumentException("The object inside the dr event " + drEvent + " should be an instance of LogicObjectImpl but it is an instance of " + tmpElem.getClass().toString());
        }
        LogicObjectImpl element = tmpElem;
        int eventType = drEvent.getType();
        switch (eventType) {
            case 1: {
                this.elementCreated(element);
                break;
            }
            case 2: {
                try {
                    this.elementChanged(drEvent);
                }
                catch (IllegalValueException e) {
                    theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)e));
                }
                break;
            }
            case 3: {
                this.elementRemoved(element);
                break;
            }
            case 21: {
                this.handleClusterDiscoveryStartEvent((ClusterImpl)element);
                break;
            }
            case 5: {
                this.handleClusterDiscoveryCompleteEvent((ClusterImpl)element);
            }
        }
    }

    private void handleClusterDiscoveryStartEvent(ClusterImpl cluster) throws RemoteException {
        try {
            if (this.isDiscoverCompleted()) {
                DrAlarmMgrImpl.getInstance().takePendingAlarms();
            }
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)ive));
        }
        this.m_isDRDiscoveryCompleted = false;
        ++this.m_isDRDiscoveryCompletedCounter;
        this.m_clustersDiscoveredInDR.remove(cluster);
        LogicMgrAOImpl.getInstance().__drDiscoveryStarted(new ElementEventImpl((Object)this, this));
        this.clearCluster(cluster, false);
    }

    private void handleClusterDiscoveryCompleteEvent(ClusterImpl cluster) throws RemoteException {
        this.readCluster(cluster);
        Iterator i = this.getDRObjects().iterator();
        while (i.hasNext()) {
            ((DRLogicObjectImpl)i.next()).updateCommKeyClassIDs();
        }
        --this.m_isDRDiscoveryCompletedCounter;
        this.m_clustersDiscoveredInDR.add(cluster);
        LogicMgrAOImpl.getInstance().__drDiscoveryCompleted(new ElementEventImpl((Object)this, this));
        if (SystemRootImpl.getInstance().isDiscoverCompleted() && this.m_clustersDiscoveredInDR.containsAll(SystemRootImpl.getInstance().getClustersRecursively())) {
            DrAlarmMgrImpl.getInstance().generateAlarms(null);
            DrAlarmMgrImpl.getInstance().clearPendingAlarms(null);
            SystemRootImpl.getInstance().notifyDRDiscoveryCompleted();
            this.m_isDRDiscoveryCompleted = true;
            try {
                ErrorAssertingListener.listenTo(this.updateTargetsACLWithRemoteInitiatorIdentities());
            }
            catch (IllegalValueException ive) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)ive));
            }
        }
    }

    public static synchronized DRRootImpl getInstance() {
        if (m_theInstance == null) {
            try {
                m_theInstance = new DRRootImpl();
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)re, new Object[]{"Couldn't initialize DRRootImpl because ", re.getMessage()});
            }
        }
        return m_theInstance;
    }

    @Override
    public DRConsistencyGroup[] getConsistencyGroups() {
        DRConsistencyGroup[] groups = new DRConsistencyGroup[this.m_consistencyGroups.size()];
        return this.m_consistencyGroups.toArray(groups);
    }

    @Override
    public DRExtendedPair[] getExtendedPairs() throws RemoteException {
        DRExtendedPair[] pairs = new DRExtendedPair[this.m_extendedPairs.size()];
        return this.m_extendedPairs.toArray(pairs);
    }

    private DRAbstractConsistencyGroupImpl newConsistencyGroup(DRClusterAbstractConsistencyGroup group) throws RemoteException {
        DRAbstractConsistencyGroupImpl newGroup;
        ClassID classId = group.getClassId();
        if (this.findDRObjectContainingElement(this.getDRLogicObjectList(group.getClassId()), (DRClusterLogicObjectImpl)((Object)group)) != null) {
            return null;
        }
        if (classId.equals((Object)ClassID.CONSISTENCY_GROUP)) {
            newGroup = new DRConsistencyGroupImpl((DRClusterConsistencyGroupImpl)group);
        } else if (classId.equals((Object)ClassID.EXTENDED_PAIR)) {
            newGroup = new DRExtendedPairImpl((DRClusterExtendedPairImpl)group);
        } else {
            throw new IllegalArgumentException();
        }
        this.drElementCreated(newGroup);
        return newGroup;
    }

    private DRAbstractConsistencyGroupImpl removeDRClusterConsistencyGroup(DRClusterAbstractConsistencyGroupImpl group) throws RemoteException, IllegalValueException {
        DRAbstractConsistencyGroupImpl removedElement = null;
        ArrayList groupList = this.getDRLogicObjectList(group.getClassId());
        DRAbstractConsistencyGroupImpl matchingGroup = (DRAbstractConsistencyGroupImpl)this.findDRObjectContainingElement(groupList, group);
        if (matchingGroup != null && matchingGroup.hasElement(group)) {
            DRPiT[] removedPits = matchingGroup.clearClusterPiTs(group.getCluster());
            int i = removedPits.length;
            while (i-- > 0) {
                ElementEventImpl elementEvent = new ElementEventImpl((Object)this, (DRPiTImpl)removedPits[i]);
                LogicMgrAOImpl.getInstance().__elementRemoved(elementEvent);
            }
            if (matchingGroup.isPartial()) {
                DRAsyncPairImpl matchingPair;
                removedElement = matchingGroup;
                this.drElementRemoved(matchingGroup);
                if (matchingGroup.getClassId().equals((Object)ClassID.EXTENDED_PAIR) && (matchingPair = (DRAsyncPairImpl)((DRExtendedPairImpl)matchingGroup).getPair()) != null) {
                    this.drElementRemoved(matchingPair);
                }
            } else {
                DRAsyncPairImpl matchingPair;
                if (matchingGroup.getClassId().equals((Object)ClassID.EXTENDED_PAIR) && (matchingPair = (DRAsyncPairImpl)((DRExtendedPairImpl)matchingGroup).getPair()) != null) {
                    matchingPair.removeElement(group.getRole());
                    this.drElementChanged(matchingPair);
                }
                matchingGroup.removeElement(group);
                this.drElementChanged(matchingGroup);
            }
        } else {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"attempt to remove non existing ", group.getClassId(), ": ", group});
        }
        return removedElement;
    }

    private DRAsyncPairImpl removeDRClusterAsyncPair(DRClusterAsyncPairImpl clusterPair, boolean isMergeDeletion) throws RemoteException {
        DRAsyncPairImpl removeElement = null;
        ArrayList groupList = this.getDRLogicObjectList(clusterPair.getGroupId().getClassID());
        DRAsyncPairImpl matchingPair = this.findPairContainingClusterPair(groupList, clusterPair);
        DRPiT[] removedPits = matchingPair.clearClusterPiTs(clusterPair.getCluster());
        int i = removedPits.length;
        while (i-- > 0) {
            ElementEventImpl elementEvent = new ElementEventImpl((Object)this, (DRPiTImpl)removedPits[i]);
            LogicMgrAOImpl.getInstance().__elementRemoved(elementEvent);
        }
        DRAbstractConsistencyGroupImpl matchingGroup = matchingPair.getParentGroup();
        if (matchingPair == null || !matchingPair.hasElement(clusterPair)) {
            return null;
        }
        JournalVolume journalVolume = matchingPair.getJournalVolume(clusterPair.getRole());
        if (journalVolume != null) {
            ((JournalVolumeImpl)journalVolume).removeConnectedPair(matchingPair);
        }
        theLogger.logAndAssert(SrLogCategories.ERROR, matchingGroup != null, new Object[]{"The pair " + matchingPair + " has no CG."});
        if (matchingPair.isPartial()) {
            this.drElementRemoved(matchingPair);
            removeElement = matchingPair;
            matchingGroup.removePair(matchingPair);
            if (!(matchingGroup.getPairs() != null && matchingGroup.getPairs().length != 0 || isMergeDeletion)) {
                this.drElementRemoved(matchingGroup);
            } else {
                this.drElementChanged(matchingGroup);
            }
        } else {
            matchingPair.removeElement(clusterPair);
            this.drElementChanged(matchingPair);
            ClassID classId = matchingGroup.getClassId();
            if (classId.equals((Object)ClassID.CONSISTENCY_GROUP) || isMergeDeletion) {
                if (matchingGroup.getPairsCount() == 1) {
                    this.splitGroup(matchingGroup, clusterPair.getRole().equals((Object)DRRoleConstant.LOCAL));
                }
            } else if (classId.equals((Object)ClassID.EXTENDED_PAIR)) {
                matchingGroup.removeElement(clusterPair.getRole());
                this.drElementChanged(matchingGroup);
            }
        }
        return removeElement;
    }

    private DRSyncPairImpl removeDRClusterSyncPair(DRClusterSyncPairImpl pair) throws RemoteException {
        DRSyncPairImpl removeElement = null;
        DRSyncPairImpl matchingPair = (DRSyncPairImpl)this.findDRObjectContainingElement(this.m_syncPairs, pair);
        if (matchingPair != null && matchingPair.hasElement(pair)) {
            if (matchingPair.isPartial()) {
                removeElement = matchingPair;
                this.drElementRemoved(matchingPair);
            } else {
                matchingPair.removeElement(pair);
                this.drElementChanged(matchingPair);
            }
        } else {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"attempt to remove a non-existing Sync pair element ", pair, " from DR"});
        }
        return removeElement;
    }

    private void removeDRPiT(DRPiTImpl pit) throws RemoteException {
        DRClusterLogicObjectImpl clusterParent = pit.getClusterObjectParent();
        ArrayList drObjectList = this.getDRLogicObjectList(clusterParent.getClassId());
        DRLogicObjectImpl parent = this.findDRObjectContainingElement(drObjectList, clusterParent);
        ((DRPiTContainer)((Object)parent)).removePiT(pit);
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, pit);
        LogicMgrAOImpl.getInstance().__elementRemoved(elementEvent);
    }

    private void splitGroup(DRAbstractConsistencyGroupImpl group, boolean isLocal) throws RemoteException {
    }

    private DRAsyncPairImpl newAsyncPair(DRClusterAsyncPair clusterPair) throws IllegalStateException, RemoteException, IllegalValueException {
        DRClusterAsyncPairImpl pair = (DRClusterAsyncPairImpl)clusterPair;
        if (this.findDRObjectContainingElement(this.getDRLogicObjectList(pair.getClassId()), pair) != null) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{pair.getClassId(), " ", pair, " has already exist in DR pair"});
            return null;
        }
        DRAbstractConsistencyGroupImpl groupIDMatchingGroup = null;
        DRAbstractConsistencyGroupImpl pairMatchingGroup = null;
        DRAsyncPairImpl matchingPair = null;
        ArrayList allGroups = this.getDRLogicObjectList(pair.getGroupId().getClassID());
        CommKeyClassId clusterGroupKey = pair.getGroupId();
        int i = allGroups.size();
        while (i-- > 0) {
            DRAbstractConsistencyGroupImpl group = (DRAbstractConsistencyGroupImpl)allGroups.get(i);
            if (group.containsDRClusterGroup(clusterGroupKey)) {
                groupIDMatchingGroup = group;
            }
            if (matchingPair != null || (matchingPair = (DRAsyncPairImpl)this.findEquivalentMatchingPair(group.getPairs(), pair)) == null) continue;
            pairMatchingGroup = group;
        }
        if (groupIDMatchingGroup != null) {
            DRAbstractConsistencyGroupImpl pairParentGroup = groupIDMatchingGroup;
            boolean parentGroupChanged = false;
            if (pairMatchingGroup != null && groupIDMatchingGroup != pairMatchingGroup) {
                this.drElementRemoved(groupIDMatchingGroup);
                this.mergeGroups(pairMatchingGroup, groupIDMatchingGroup);
                parentGroupChanged = true;
                DRAsyncPair[] pairsOfDepracatedGroups = groupIDMatchingGroup.getPairs();
                if (pairsOfDepracatedGroups != null) {
                    int i2 = pairsOfDepracatedGroups.length;
                    while (i2-- > 0) {
                        this.drElementChanged((DRAsyncPairImpl)pairsOfDepracatedGroups[i2]);
                    }
                }
                pairParentGroup = pairMatchingGroup;
            }
            DRRoleConstant role = pairParentGroup.getDRClusterGroup(clusterGroupKey).getRole();
            if (matchingPair != null) {
                matchingPair.setElement(pair, role);
                JournalVolume journalVolume = matchingPair.getJournalVolume(role);
                ((JournalVolumeImpl)journalVolume).addConnectedPair(matchingPair);
                this.drElementChanged(matchingPair);
                return matchingPair;
            }
            DRAsyncPairImpl newPair = new DRAsyncPairImpl(pair, role, pairParentGroup);
            pairParentGroup.addPair(newPair);
            parentGroupChanged = true;
            JournalVolume journalVolume = newPair.getJournalVolume(role);
            ((JournalVolumeImpl)journalVolume).addConnectedPair(newPair);
            this.drElementCreated(newPair);
            if (parentGroupChanged) {
                this.drElementChanged(pairParentGroup);
            }
        } else {
            throw new IllegalStateException("DR Async pair " + pair + " has no group in DRRootImpl!");
        }
        return null;
    }

    private DRSyncPairImpl newSyncPair(DRClusterSyncPairImpl pair) throws RemoteException {
        if (this.findDRObjectContainingElement(this.getDRLogicObjectList(pair.getClassId()), pair) != null) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{pair.getClassId(), " ", pair, " has already exist in DR pair"});
            return null;
        }
        DRPair[] syncPairs = new DRSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        DRSyncPairImpl matchingPair = (DRSyncPairImpl)this.findEquivalentMatchingPair(syncPairs, pair);
        if (matchingPair != null) {
            matchingPair.setElement(pair);
            this.drElementChanged(matchingPair);
            return null;
        }
        matchingPair = new DRSyncPairImpl(pair);
        this.drElementCreated(matchingPair);
        return matchingPair;
    }

    private void newDRPiT(DRPiTImpl pit) throws RemoteException {
        DRClusterLogicObjectImpl clusterParent = pit.getClusterObjectParent();
        ArrayList drObjectList = this.getDRLogicObjectList(clusterParent.getClassId());
        DRLogicObjectImpl parent = this.findDRObjectContainingElement(drObjectList, clusterParent);
        ((DRPiTContainer)((Object)parent)).addPiT(pit);
        pit.setDRObjectParent(parent);
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, pit);
        elementEvent.setParameterList(pit.getClientParameterList());
        LogicMgrAOImpl.getInstance().__elementCreated(elementEvent);
    }

    public SrFuture<Void> createInCluster(ConfigElementData ced, VolumeNodeImpl volume) throws RemoteException {
        ArrayList<VSwitchImpl> vSwitches = new ArrayList<VSwitchImpl>(Arrays.asList(volume.getConnectedVSwitches()));
        ClusterImpl cluster = volume.getCluster();
        return cluster.createElement(ced, "", vSwitches);
    }

    public SrFuture<Void> createInCluster(ConfigElementData ced, ClusterImpl cluster) throws RemoteException {
        if (cluster == null) {
            throw new IllegalArgumentException("The given cluster should not be null");
        }
        ClusterImpl clusterImpl = cluster;
        ArrayList<VSwitchImpl> vSwitches = new ArrayList<VSwitchImpl>(clusterImpl.getVSwitches());
        return this.createInCluster(ced, vSwitches, cluster);
    }

    public SrFuture<Void> createInCluster(ConfigElementData ced, List<VSwitchImpl> aVswitches, Cluster aCluster) throws RemoteException {
        if (aCluster == null) {
            throw new IllegalArgumentException("The given cluster should not be null");
        }
        return ((ClusterImpl)aCluster).createElement(ced, "", aVswitches);
    }

    public SrFuture<Void> createInCluster(ConfigElementDataList cedList, Cluster cluster) throws RemoteException {
        if (cluster == null) {
            throw new IllegalArgumentException("The given cluster should not be null");
        }
        List vs = Util.convertListType(cluster.getVSwitches());
        return ((ClusterImpl)cluster).createElement(cedList, "", new ArrayList<VSwitchImpl>(vs));
    }

    private GeneralSCSIDeviceImpl getISCSIDisk(Cluster remoteCluster, String targetName, LU lun) throws RemoteException {
        GeneralSCSIDeviceImpl iSCSIDisk = (GeneralSCSIDeviceImpl)((ClusterImpl)remoteCluster).getStoragePool().getSCSIDeviceByEntityNameLunAndSerialNumber(targetName, lun.getLUN().toString(), lun.getSerialNumber(), PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"The ISCSI disk that was found for the parameters: targetName=", targetName, "; lun = ", lun.getLUN().toString(), "; serial number = ", lun.getSerialNumber(), "; type = ", PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE, " is: ", iSCSIDisk});
        if (iSCSIDisk != null) {
            return iSCSIDisk;
        }
        iSCSIDisk = (GeneralSCSIDeviceImpl)((ClusterImpl)remoteCluster).getStoragePool().getSCSIDeviceByEntityNameLunAndSerialNumber(targetName, lun.getLUN().toString(), null, PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"The ISCSI disk that was found for the parameters: targetName=", targetName, "; lun = ", lun.getLUN().toString(), "; serial number = null; type = ", PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE, " is: ", iSCSIDisk});
        return iSCSIDisk;
    }

    @Override
    public SrFuture<Void> createAsyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, DRConsistencyGroup cg) throws RemoteException, IllegalValueException {
        return this.createAsyncPair(ClassID.ASYNC_PAIR, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, null, cg, null, null, null);
    }

    @Override
    public SrFuture<Void> createAsyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, String cgAlias, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        return this.createAsyncPair(ClassID.CONSISTENCY_GROUP, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, cgAlias, null, pitPolicy, transferPolicy, mergePolicy);
    }

    @Override
    public SrFuture<Void> createAsyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        return this.createAsyncPair(ClassID.EXTENDED_PAIR, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primarySnapshotId, secondarySnapshotId, secondarySnapshotParams, primaryJournalId, secondaryJournalId, null, null, pitPolicy, transferPolicy, mergePolicy);
    }

    private SrFuture<Void> createAsyncPair(ClassID classId, DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId primaryJournalId, CommKeyClassId secondaryJournalId, String cgAlias, DRConsistencyGroup cg, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        List<? extends VolumeNodeImpl> journals;
        ClusterImpl cluster;
        String exposedOnVSwitch;
        LUImpl lu;
        final SrFuture retFuture = new SrFuture("DRRootImpl.createAsyncPair");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        this.validatePairCreation(primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, primaryJournalId, secondaryJournalId);
        VolumeNodeImpl primaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        if (primarySnapshotId != null && primaryVolume.getCluster().getConnectedVSwitchCounter() > primarySnapshotId.getCommKeys().length) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Primary Snapshot ID for pair <", primaryVolume, ",", secondaryVolume, "> creation is not redundant:", primarySnapshotId});
        }
        if (secondarySnapshotId != null && secondaryVolume.getCluster().getConnectedVSwitchCounter() > secondarySnapshotId.getCommKeys().length) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Secondary Snapshot ID for pair <", primaryVolume, ",", secondaryVolume, "> creation is not redundant:", secondarySnapshotId});
        }
        if (localTarget == null) {
            lu = primaryVolume.getParentLU();
            localLun = lu.getLUN();
            localTarget = lu.getParentTarget().getName();
        }
        if (remoteTarget == null) {
            lu = secondaryVolume.getParentLU();
            remoteLun = lu.getLUN();
            remoteTarget = lu.getParentTarget().getName();
        }
        if (primaryJournalId == null) {
            lu = primaryVolume.getParentLU();
            exposedOnVSwitch = lu.getParentTarget().getExposedOnVSwitch();
            cluster = primaryVolume.getCluster();
            journals = cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
            for (JournalVolumeImpl journalVolumeImpl : journals) {
                if (!journalVolumeImpl.getActiveOnVSwitch().getName().equals(exposedOnVSwitch)) continue;
                primaryJournalId = journalVolumeImpl.getCommKeyClassId();
                break;
            }
        }
        if (secondaryJournalId == null) {
            lu = secondaryVolume.getParentLU();
            exposedOnVSwitch = lu.getParentTarget().getExposedOnVSwitch();
            cluster = secondaryVolume.getCluster();
            journals = cluster.getStorage().getInteranlVolumesByType(ClassID.JOURNAL_VOLUME);
            for (JournalVolume journalVolume : journals) {
                if (!journalVolume.getActiveOnVSwitch().getName().equals(exposedOnVSwitch)) continue;
                secondaryJournalId = journalVolume.getCommKeyClassId();
                break;
            }
        }
        midFutures.add(this.createLocalAsyncPair(classId, initialSyncType, primaryId, secondaryId, remoteTarget, remoteLun, primarySnapshotId, primaryJournalId, cgAlias, cg, pitPolicy, transferPolicy, mergePolicy));
        midFutures.add(this.createRemoteAsyncPair(classId, initialSyncType, primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, secondarySnapshotId, secondarySnapshotParams, secondaryJournalId, cgAlias, cg, pitPolicy, transferPolicy, mergePolicy));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private void createRemoteSnapshot(ConfigElementData element, HashMap params, ClusterImpl remoteCluster) throws RemoteException, IllegalValueException {
        CommKeyClassId[] commKeyArray = (CommKeyClassId[])params.get(ClientParameterCode.VOLUME_CHILDREN);
        VolumeNodeImpl snapshotChild = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(commKeyArray[0]);
        if (snapshotChild.getParentVolume() != null) {
            throw new IllegalValueException("Snapshot volume child " + snapshotChild + " is already used by " + snapshotChild.getParentVolume());
        }
        ConfigElementData snapshotElement = new ConfigElementData(ClassID.SNAPSHOT_VOLUME);
        params = ClientParameterCode.transformToParameterCode(params);
        params.put(ParameterCode.VOLUME_ALIAS, new SrString((String)params.get(ParameterCode.VOLUME_ALIAS)));
        params.put(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH, new SrInteger((Integer)params.get(ParameterCode.SNAPSHOT_VOLUME_PERCENT_THRESH)));
        snapshotElement.addParameter(params);
        remoteCluster.prepareVSwitchIDs((ElementData)snapshotElement, "", remoteCluster.getVSwitches());
        snapshotElement.addParameter(new Parameter(ParameterCode.SNAPSHOT_VOLUME_SOURCE, element.getValue((ParameterCodes)ParameterCode.DR_PAIR_SECONDARY_ID)));
        element.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, (ElementData)snapshotElement);
    }

    public SrFuture<Void> createLocalAsyncPair(ClassID classId, DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String remoteTarget, Integer remoteLun, CommKeyClassId primarySnapshotId, CommKeyClassId primaryJournalId, String cgAlias, DRConsistencyGroup cg, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        this.isCGAliasExsist(cgAlias);
        this.isCGInReplicationState(cg);
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        this.isVolumeAndClusterValidForPair(localPrimary);
        if (!DRPairInitialSyncTypeConstant.NONE.equals((Object)initialSyncType) && primarySnapshotId == null) {
            throw new IllegalValueException("cannot create pair, there is no snapshot on the primary volume");
        }
        ConfigElementData localCED = new ConfigElementData(classId);
        localCED.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, (SrType)primaryJournalId);
        localCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, (SrType)initialSyncType);
        this.preparePrimaryElementVolumes(localCED, localPrimary, remoteSecondary, remoteTarget, remoteLun);
        if (primarySnapshotId != null) {
            localCED.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, (SrType)primarySnapshotId);
        }
        localCED.setValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, (SrType)DRRoleConstant.LOCAL);
        if (cgAlias != null) {
            return this.createAsyncPairAndCG(cgAlias, DRRoleConstant.LOCAL, pitPolicy, transferPolicy, mergePolicy, localCED, localPrimary);
        }
        this.prepareAsyncOrExtendedPair(cg, pitPolicy, transferPolicy, mergePolicy, localCED, localPrimary, DRRoleConstant.LOCAL);
        return this.createInCluster(localCED, localPrimary);
    }

    private void prepareAsyncOrExtendedPair(DRConsistencyGroup aCg, HashMap aPitPolicy, HashMap aTransferPolicy, HashMap aMergePolicy, ConfigElementData aCreatePairCed, VolumeNodeImpl aPairVolume, DRRoleConstant aRole) throws RemoteException {
        if (aCg != null) {
            CommKeyClassId groupId = null;
            if (DRRoleConstant.REMOTE.equals((Object)aRole)) {
                groupId = ((DRAbstractConsistencyGroupImpl)this.getRefByStub(aCg.hashKey())).getRemoteElement().getCommKeyClassId();
            } else if (DRRoleConstant.LOCAL.equals((Object)aRole)) {
                groupId = ((DRAbstractConsistencyGroupImpl)this.getRefByStub(aCg.hashKey())).getLocalElement().getCommKeyClassId();
            } else {
                throw new IllegalArgumentException("The given role is " + aRole + " but it either should be remote or local");
            }
            aCreatePairCed.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, (SrType)groupId);
        } else {
            this.prepareElementPolicies(aCreatePairCed, aPitPolicy, aTransferPolicy, aMergePolicy, aPairVolume.getCluster());
        }
    }

    private SrFuture<Void> createAsyncPairAndCG(String aCgAlias, DRRoleConstant aRole, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy, ConfigElementData aCreatePairCed, final VolumeNodeImpl pairVolume) throws RemoteException, IllegalValueException {
        VSwitchImpl[] vswitches;
        if (aRole == null || aCreatePairCed == null || pairVolume == null) {
            throw new IllegalArgumentException("The following parameters should not be null. aRole = " + aRole + "; aCreatePairCed = " + aCreatePairCed + "; pairVolume = " + pairVolume);
        }
        ClusterImpl cluster = pairVolume.getCluster();
        DRClusterConsistencyGroupImpl existCG = cluster.getDRManager().getEmptyCG(aCgAlias);
        if (existCG == null || !aRole.equals((Object)existCG.getRole())) {
            aCreatePairCed.setValue(ParameterCode.DR_VIRT_GROUP_ALIAS, (SrType)new SrString(aCgAlias));
            this.prepareElementPolicies(aCreatePairCed, pitPolicy, transferPolicy, mergePolicy, pairVolume.getCluster());
            return this.createInCluster(aCreatePairCed, pairVolume);
        }
        CommKeyClassId existCGId = existCG.getCommKeyClassId();
        final ArrayList<Object> midFutures = new ArrayList<Object>();
        final SrFuture retFuture = new SrFuture("DRRootImpl.createAsyncPairAndCG");
        for (VSwitchImpl vs : vswitches = pairVolume.getConnectedVSwitches()) {
            final ConfigElementData clonedCed = new ConfigElementData(aCreatePairCed);
            if (!existCG.isKnownByVSwitch(vs)) {
                clonedCed.setValue(ParameterCode.DR_VIRT_GROUP_ALIAS, (SrType)new SrString(aCgAlias));
                this.prepareElementPolicies(clonedCed, pitPolicy, transferPolicy, mergePolicy, pairVolume.getCluster());
                ArrayList<VSwitchImpl> vsVec = new ArrayList<VSwitchImpl>();
                vsVec.add(vs);
                SrFuture<Void> createFuture = this.createInCluster(clonedCed, vsVec, cluster);
                midFutures.add(createFuture);
                continue;
            }
            HashMap<ClientParameterCode, HashMap> changeParameters = new HashMap<ClientParameterCode, HashMap>();
            changeParameters.put(ClientParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_POLICY, pitPolicy);
            changeParameters.put(ClientParameterCode.DR_CONSISTENCY_GROUP_TRANSFER_POLICY, transferPolicy);
            changeParameters.put(ClientParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY, mergePolicy);
            SrFuture<Void> changeFuture = existCG.changeElement(changeParameters);
            final SrFuture createPairFuture = new SrFuture("DRRootImpl.createAsyncPairOnExistingEmptyCG");
            midFutures.add(createPairFuture);
            clonedCed.setValue(ParameterCode.DR_ASYNC_PAIR_GROUP_ID, (SrType)existCGId);
            clonedCed.setClassId(ClassID.ASYNC_PAIR);
            DefaultFutureListener.listenTo((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        SrFuture<Void> future = DRRootImpl.this.createInCluster(clonedCed, pairVolume);
                        final ArrayList<SrFuture<Void>> createFuturesList = new ArrayList<SrFuture<Void>>();
                        createFuturesList.add(future);
                        Runnable runUpdateCreateFuture = new Runnable(){

                            @Override
                            public void run() {
                                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(createFuturesList, (SrFuture<Void>)createPairFuture);
                            }
                        };
                        DefaultFutureListener.listenTo((Runnable)runUpdateCreateFuture, (IFuture[])new IFuture[]{future});
                    }
                    catch (RemoteException e) {
                        theLogger.error(SrLogCategories.EXCEPTION, new Object[]{"A remote exception has been thrown inside a server context.", e});
                    }
                }
            }, (IFuture[])new IFuture[]{changeFuture});
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private void isVolumeAndClusterValidForPair(VolumeNodeImpl volume) throws IllegalValueException {
        SDTakeOverStateConstant takeOverState = volume.getCluster().getTakeoverState();
        if (takeOverState == null) {
            throw new IllegalValueException("The cluster " + volume.getCluster().getAlias() + "is not reachable. Connect its " + VSwitch.VSWITCHES_DISPLAY_STRING + " and try again");
        }
        if (takeOverState.equals((Object)SDTakeOverStateConstant.SD_TAKE_OVER_STATE_UNDER_TAKE_OVER)) {
            throw new IllegalValueException("The cluster is under take over, you cannot create pair");
        }
        if (!volume.getClassId().equals((Object)ClassID.JOURNAL_VOLUME)) {
            this.isVolumeValidForPair(volume);
        }
    }

    private void isVolumeValidForPair(VolumeNodeImpl volume) throws IllegalValueException {
        if (volume.isInvolvedInActiveCopy(volume.getActiveVswitch())) {
            throw new IllegalValueException("The volume is under copy operation, you cannot create pair");
        }
        if (volume.getParentVolume() != null) {
            throw new IllegalValueException("The volume has father, you cannot create pair");
        }
        if (!volume.getExposedOnVSwitch().hasJournal()) {
            throw new IllegalValueException("The volume is not exposed on the active " + ClassID.VSWITCH + ", you cannot create pair");
        }
    }

    private void validatePairCreation(CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId inPrimaryJournalId, CommKeyClassId inSecondaryJournalId) throws RemoteException, IllegalValueException {
        ISCSITargetImpl ltarget;
        String msg;
        VolumeNodeImpl primaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        ClusterImpl localCluster = primaryVolume.getCluster();
        ClusterImpl remoteCluster = secondaryVolume.getCluster();
        LUImpl localLU = primaryVolume.getParentLU();
        LUImpl remoteLU = secondaryVolume.getParentLU();
        String localISCSIDiskMsg = this.validateISCSIDisk(localCluster, remoteTarget, remoteLU);
        if (localISCSIDiskMsg != null) {
            throw new IllegalValueException(localISCSIDiskMsg);
        }
        String remoteISCSIDiskMsg = this.validateISCSIDisk(remoteCluster, localTarget, localLU);
        if (remoteISCSIDiskMsg != null) {
            throw new IllegalValueException(remoteISCSIDiskMsg);
        }
        GeneralSCSIDeviceImpl localSecondaryDisk = this.getISCSIDisk(localCluster, remoteTarget, remoteLU);
        GeneralSCSIDeviceImpl remotePrimaryDisk = this.getISCSIDisk(remoteCluster, localTarget, localLU);
        if (primaryVolume.equals(localSecondaryDisk)) {
            StringBuffer msg2 = new StringBuffer();
            msg2.append("The pair cannot be created: the iSCSI ");
            msg2.append(primaryVolume.getClassId());
            msg2.append(' ');
            msg2.append(primaryVolume);
            msg2.append(" in the local site is connected to ");
            msg2.append(secondaryVolume.getClassId());
            msg2.append(' ');
            msg2.append(secondaryVolume);
            msg2.append(" in the remote site");
            throw new IllegalValueException(msg2.toString());
        }
        if (secondaryVolume.equals(remotePrimaryDisk)) {
            StringBuffer msg3 = new StringBuffer();
            msg3.append("The pair cannot be created: the iSCSI ");
            msg3.append(secondaryVolume.getClassId());
            msg3.append(' ');
            msg3.append(secondaryVolume);
            msg3.append(" in the remote site is connected to ");
            msg3.append(primaryVolume.getClassId());
            msg3.append(' ');
            msg3.append(primaryVolume);
            msg3.append(" in the local site");
            throw new IllegalValueException(msg3.toString());
        }
        if (localSecondaryDisk != null && localSecondaryDisk.isExposed()) {
            StringBuffer msg4 = new StringBuffer();
            msg4.append("The pair cannot be created: the secondary ");
            msg4.append(localSecondaryDisk.getClassId());
            msg4.append(' ');
            msg4.append(localSecondaryDisk);
            msg4.append(" in the local site is exposed on target ");
            msg4.append(localSecondaryDisk.getParentLU());
            throw new IllegalValueException(msg4.toString());
        }
        if (remotePrimaryDisk != null && remotePrimaryDisk.isExposed()) {
            StringBuffer msg5 = new StringBuffer();
            msg5.append("The pair cannot be created: the primary ");
            msg5.append(remotePrimaryDisk.getClassId());
            msg5.append(' ');
            msg5.append(remotePrimaryDisk);
            msg5.append(" in the remote site is exposed on target ");
            msg5.append(remotePrimaryDisk.getParentLU());
            throw new IllegalValueException(msg5.toString());
        }
        if (localSecondaryDisk != null && !localSecondaryDisk.getRootVolume().equals(localSecondaryDisk)) {
            StringBuffer msg6 = new StringBuffer();
            msg6.append("The pair cannot be created: the primary ");
            msg6.append(localSecondaryDisk);
            msg6.append(" is not root volume ");
            throw new IllegalValueException(msg6.toString());
        }
        if (remotePrimaryDisk != null && !remotePrimaryDisk.getRootVolume().equals(remotePrimaryDisk)) {
            StringBuffer msg7 = new StringBuffer();
            msg7.append("The pair cannot be created: the secondary ");
            msg7.append(remotePrimaryDisk);
            msg7.append(" is part of the hierarchy of " + remotePrimaryDisk.getRootVolume().getClassId() + " " + remotePrimaryDisk.getRootVolume());
            throw new IllegalValueException(msg7.toString());
        }
        if (inPrimaryJournalId != null && (msg = this.checkIfJournalAndTargetAreExposedOnTheSameVswitch(inPrimaryJournalId, ltarget = primaryVolume.getCluster().getTargetListMgr().getTargetByName(localTarget))) != null) {
            throw new IllegalValueException(msg);
        }
        if (inSecondaryJournalId != null && (msg = this.checkIfJournalAndTargetAreExposedOnTheSameVswitch(inSecondaryJournalId, ltarget = secondaryVolume.getCluster().getTargetListMgr().getTargetByName(remoteTarget))) != null) {
            throw new IllegalValueException(msg);
        }
    }

    private String checkIfJournalAndTargetAreExposedOnTheSameVswitch(CommKeyClassId inJournalId, TargetImpl target) throws RemoteException {
        String msg = null;
        JournalVolumeImpl journal = (JournalVolumeImpl)SystemRootImpl.getInstance().getRefByStub(inJournalId);
        String vswitchName = target.getExposedOnVSwitch();
        if (!vswitchName.equals(journal.getActiveOnVSwitch().getName())) {
            msg = ClassID.JOURNAL_VOLUME + " " + journal + " is  active on  " + ClassID.VSWITCH + " " + journal.getActiveOnVSwitch().getName() + " and " + target.getClassId() + " " + target + " exposed on " + ClassID.VSWITCH + " " + vswitchName;
        }
        return msg;
    }

    private String validateISCSIDisk(ClusterImpl localCluster, String remoteTarget, LU remoteLun) throws RemoteException, IllegalValueException {
        String lunStr = remoteLun.getLUN().toString();
        GeneralSCSIDeviceImpl matchingDisk = this.getISCSIDisk(localCluster, remoteTarget, remoteLun);
        GeneralSCSIDevice anyDisk = localCluster.getStoragePool().getSCSIDeviceByEntityNameAndLun(remoteTarget, lunStr, PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE);
        if (matchingDisk == null && anyDisk != null) {
            StringBuffer msg = new StringBuffer();
            msg.append("Cannot create the element since it uses the target name ");
            msg.append(remoteTarget);
            msg.append(" and lun ");
            msg.append(lunStr);
            msg.append(" but diffrent serial number with the ");
            msg.append(anyDisk.getClassId());
            msg.append(' ');
            msg.append(anyDisk);
            msg.append(", please remove ");
            msg.append(anyDisk);
            msg.append(" in order to create the GDR pair.");
            return msg.toString();
        }
        return null;
    }

    private void isCGAliasExsist(String cgAlias) throws RemoteException, IllegalValueException {
        if (cgAlias == null) {
            return;
        }
        for (int i = 0; i < this.m_consistencyGroups.size(); ++i) {
            if (!cgAlias.equals(((DRConsistencyGroupImpl)this.m_consistencyGroups.get(i)).getAlias())) continue;
            throw new IllegalValueException("There is another cg with the same group name");
        }
    }

    private void isCGInReplicationState(DRConsistencyGroup cg) throws RemoteException, IllegalValueException {
        if (cg == null) {
            return;
        }
        DRConsistencyGroupImpl cgImpl = (DRConsistencyGroupImpl)this.getRefByStub(cg.hashKey());
        if (!cgImpl.getActiveElement().isParameterEqual((Parameters)new Parameter(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, (Object)DRReplicationStateConstant.INACTIVE), cgImpl.getActiveElement().getActiveVswitch()) || !cgImpl.getInactiveElement().isParameterEqual((Parameters)new Parameter(ParameterCode.DR_CONSISTENCY_GROUP_REPLICATION_STATE, (Object)DRReplicationStateConstant.INACTIVE), cgImpl.getInactiveElement().getActiveVswitch())) {
            throw new IllegalValueException("The cg is in replication state you cannot add pair to it");
        }
    }

    public SrFuture<Void> createRemoteAsyncPair(ClassID classId, DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun, CommKeyClassId secondarySnapshotId, HashMap secondarySnapshotParams, CommKeyClassId secondaryJournalId, String cgAlias, DRConsistencyGroup cg, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy) throws RemoteException, IllegalValueException {
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl journal = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryJournalId);
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        ClusterImpl remoteCluster = journal.getCluster();
        if (remoteSecondary.getCluster().equals(remoteCluster)) {
            this.isVolumeAndClusterValidForPair(remoteSecondary);
        } else {
            this.isVolumeAndClusterValidForPair(journal);
        }
        ConfigElementData remoteCED = new ConfigElementData(classId);
        remoteCED.setValue(ParameterCode.DR_ASYNC_PAIR_JOURNAL_ID, (SrType)secondaryJournalId);
        ConfigElementData elementVolume = null;
        this.prepareSecondaryElementVolumes(remoteCED, localTarget, localLun, remoteCluster, localPrimary);
        remoteCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, (SrType)initialSyncType);
        remoteCED.setValue(ParameterCode.DR_CONSISTENCY_GROUP_ROLE, (SrType)DRRoleConstant.REMOTE);
        if (!remoteCluster.equals(remoteSecondary.getCluster())) {
            this.localCopyAllowed(new HashSet(), remoteSecondary, remoteCluster);
            elementVolume = remoteSecondary.getDuplicationConfigElementData(new HashMap(), remoteCluster);
            remoteCED.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, (ElementData)elementVolume);
            if (secondarySnapshotParams != null && !secondarySnapshotParams.isEmpty()) {
                this.createRemoteSnapshot(remoteCED, secondarySnapshotParams, remoteCluster);
            }
            ConfigElementDataList list = new ConfigElementDataList();
            ConfigElementData luElement = this.createLunElement(remoteTarget, remoteLun, elementVolume, remoteCluster);
            if (luElement != null) {
                list.add((ElementData)luElement);
            }
            list.add((ElementData)remoteCED);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"ready to send package ", list});
            if (cgAlias != null) {
                return this.createAsyncPairAndCG(cgAlias, DRRoleConstant.REMOTE, pitPolicy, transferPolicy, mergePolicy, remoteCED, remoteSecondary);
            }
            this.prepareAsyncOrExtendedPair(cg, pitPolicy, transferPolicy, mergePolicy, remoteCED, remoteSecondary, DRRoleConstant.REMOTE);
            return this.createInCluster(list, (Cluster)remoteCluster);
        }
        remoteCED.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, (SrType)secondaryId);
        if (secondarySnapshotId != null) {
            remoteCED.setValue(ParameterCode.DR_ASYNC_PAIR_SNAPSHOT_ID, (SrType)secondarySnapshotId);
        }
        if (cgAlias != null) {
            return this.createAsyncPairAndCG(cgAlias, DRRoleConstant.REMOTE, pitPolicy, transferPolicy, mergePolicy, remoteCED, remoteSecondary);
        }
        this.prepareAsyncOrExtendedPair(cg, pitPolicy, transferPolicy, mergePolicy, remoteCED, remoteSecondary, DRRoleConstant.REMOTE);
        return this.createInCluster(remoteCED, remoteSecondary);
    }

    private ConfigElementData createLunElement(String remoteTarget, Integer remoteLun, ConfigElementData elementVolume, Cluster cluster) throws RemoteException, IllegalValueException {
        VolumeNode vol;
        LU parentLU;
        if (elementVolume.getCommKey() != null && (parentLU = (vol = (VolumeNode)cluster.getCommKeyRefMap().getRefByCommKeyClassID(elementVolume.getCommKeyClassId())).getParentLU()) != null) {
            if (parentLU.getLUN().equals(remoteLun)) {
                return null;
            }
            throw new IllegalValueException("Volume " + vol + " is already exposed on LUN " + parentLU);
        }
        ConfigElementData elementLu = new ConfigElementData(ClassID.LUN);
        elementLu.setValue(ParameterCode.LU_LUN_NUMBER, (SrType)new SrGauge(remoteLun));
        elementLu.setValue(ParameterCode.LU_PARENT, (SrType)((StorageImpl)cluster.getStorage()).getTargetListMgr().getTargetByName(remoteTarget).getCommKeyClassId());
        elementLu.setValue(ParameterCode.LU_VOLUME_ID, (ElementData)elementVolume);
        return elementLu;
    }

    public void prepareElementPolicies(ConfigElementData element, HashMap pitPolicy, HashMap transferPolicy, HashMap mergePolicy, ClusterImpl cluster) {
        if (pitPolicy != null) {
            PolicyTypeConstant pitType = (PolicyTypeConstant)pitPolicy.get(ClientParameterCode.DR_POLICY_METHOD);
            Long pitStartat = (Long)pitPolicy.get(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME);
            Long pitRunEvery = (Long)pitPolicy.get(ClientParameterCode.DR_POLICY_RUN_EVERY);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_TYPE, (SrType)pitType);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_START_AT, (SrType)new SrDateAndTime(pitStartat));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_RUN_EVERY, (SrType)new SrInteger(pitRunEvery.intValue()));
            HashMap pitIndicesParams = PoliciesManager.getInstance().getPolicyKeysParameterList(cluster, pitStartat, pitType, pitRunEvery);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_ID, (SrType)((CommKeyClassId)pitIndicesParams.get(ParameterCode.POLICY_ID)));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PIT_POLICY_PARAM_ID, (SrType)((CommKeyClassId)pitIndicesParams.get(ParameterCode.POLICY_PARAM_ID)));
        }
        if (transferPolicy != null) {
            PolicyTypeConstant transType = (PolicyTypeConstant)transferPolicy.get(ClientParameterCode.DR_POLICY_METHOD);
            Long transStartat = (Long)transferPolicy.get(ClientParameterCode.DR_POLICY_START_AT_DATE_AND_TIME);
            Long transRunevery = (Long)transferPolicy.get(ClientParameterCode.DR_POLICY_RUN_EVERY);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_TYPE, (SrType)transType);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_START_AT, (SrType)new SrDateAndTime(transStartat));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_RUN_EVERY, (SrType)new SrInteger(transRunevery.intValue()));
            HashMap transIndicesParams = PoliciesManager.getInstance().getPolicyKeysParameterList(cluster, transStartat, transType, transRunevery);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_ID, (SrType)((CommKeyClassId)transIndicesParams.get(ParameterCode.POLICY_ID)));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_TRANS_POLICY_PARAM_ID, (SrType)((CommKeyClassId)transIndicesParams.get(ParameterCode.POLICY_PARAM_ID)));
        }
        if (mergePolicy != null) {
            PolicyTypeConstant mergeType = (PolicyTypeConstant)mergePolicy.get(ClientParameterCode.DR_POLICY_METHOD);
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_TYPE, (SrType)mergeType);
            HashMap mergeIndicesParams = PoliciesManager.getInstance().getPolicyKeysParameterList(cluster, new Long(0L), mergeType, new Long(0L));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_ID, (SrType)((CommKeyClassId)mergeIndicesParams.get(ParameterCode.POLICY_ID)));
            element.setValue(ParameterCode.DR_CONSISTENCY_GROUP_MERGE_POLICY_PARAM_ID, (SrType)((CommKeyClassId)mergeIndicesParams.get(ParameterCode.POLICY_PARAM_ID)));
        }
    }

    public void preparePrimaryElementVolumes(ConfigElementData element, VolumeNodeImpl localPrimary, VolumeNodeImpl remoteSecondary, String remoteTarget, Integer remoteLunNumber) throws RemoteException {
        LUImpl remoteLun = remoteSecondary.getParentLU();
        element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, (SrType)localPrimary.getCommKeyClassId());
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Looking for the ISCSI disk in the local site."});
        GeneralSCSIDeviceImpl iSCSIDisk1 = this.getISCSIDisk(localPrimary.getCluster(), remoteTarget, remoteLun);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"The ISCSI disk that was found: ", iSCSIDisk1});
        if (iSCSIDisk1 == null) {
            SrEntityNameFormat remoteTargetNameFormat = new SrEntityNameFormat(remoteTarget);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, (SrType)remoteTargetNameFormat);
            SrLunFormat lun = GeneralSCSIDeviceImpl.parseSCSIDeviceLUN(remoteLunNumber);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, (SrType)lun);
        } else {
            CommKeyClassId configuredDiskID = iSCSIDisk1.getCommKeyClassId();
            element.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, (SrType)configuredDiskID);
            element.setValue(ParameterCode.DR_PAIR_LOCAL_SECONDARY_ID, (SrType)configuredDiskID);
        }
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, (SrType)new SrInteger(remoteSecondary.getBlockSize()));
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, (SrType)new SrLunFormat(remoteSecondary.getNumberOfBlocks(null)));
    }

    public void prepareSecondaryElementVolumes(ConfigElementData element, String localTarget, Integer localLunNumber, Cluster remoteCluster, VolumeNodeImpl localPrimary) throws RemoteException {
        LUImpl localLun = localPrimary.getParentLU();
        GeneralSCSIDeviceImpl iSCSIDisk2 = this.getISCSIDisk(remoteCluster, localTarget, localLun);
        if (iSCSIDisk2 == null) {
            SrEntityNameFormat localTargetNameFormat = new SrEntityNameFormat(localTarget);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_ENTITY_NAME, (SrType)localTargetNameFormat);
            SrLunFormat lun = GeneralSCSIDeviceImpl.parseSCSIDeviceLUN(localLunNumber);
            element.setValue(ParameterCode.PHYSICAL_STORAGE_LUN, (SrType)lun);
        } else {
            CommKeyClassId configuredDiskID = iSCSIDisk2.getCommKeyClassId();
            element.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, (SrType)configuredDiskID);
            element.setValue(ParameterCode.DR_PAIR_REMOTE_PRIMARY_ID, (SrType)configuredDiskID);
        }
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_SIZE, (SrType)new SrInteger(localPrimary.getBlockSize()));
        element.setValue(ParameterCode.DIRECT_ACCESS_DEVICE_BLOCK_NUM, (SrType)new SrLunFormat(localPrimary.getNumberOfBlocks(null)));
    }

    @Override
    public SrFuture<Void> createSyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, CommKeyClassId secondaryId, String localTarget, Integer localLun, String remoteTarget, Integer remoteLun) throws RemoteException, IllegalValueException {
        LUImpl lu;
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        final SrFuture retFuture = new SrFuture("DRRootImpl.createSyncPair");
        this.validatePairCreation(primaryId, secondaryId, localTarget, localLun, remoteTarget, remoteLun, null, null);
        if (localTarget == null) {
            VolumeNodeImpl primaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
            lu = primaryVolume.getParentLU();
            localLun = lu.getLUN();
            localTarget = lu.getParentTarget().getName();
        }
        if (remoteTarget == null) {
            VolumeNodeImpl secondaryVolume = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
            lu = secondaryVolume.getParentLU();
            remoteLun = lu.getLUN();
            remoteTarget = lu.getParentTarget().getName();
        }
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        midFutures.add(this.createLocalSyncPair(initialSyncType, primaryId, remoteTarget, remoteLun, remoteSecondary));
        midFutures.add(this.createRemoteSyncPair(initialSyncType, secondaryId, localTarget, localLun, localPrimary));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> createLocalSyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId primaryId, String remoteTarget, Integer remoteLun, VolumeNodeImpl remoteSecondary) throws RemoteException, IllegalValueException {
        VolumeNodeImpl localPrimary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(primaryId);
        this.isVolumeAndClusterValidForPair(localPrimary);
        ConfigElementData _localCED = new ConfigElementData(ClassID.SYNC_PAIR);
        _localCED.setValue(ParameterCode.DR_SYNC_PAIR_ROLE, (SrType)DRRoleConstant.LOCAL);
        _localCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, (SrType)initialSyncType);
        this.preparePrimaryElementVolumes(_localCED, localPrimary, remoteSecondary, remoteTarget, remoteLun);
        return this.createInCluster(_localCED, localPrimary);
    }

    protected SrFuture<Void> createRemoteSyncPair(DRPairInitialSyncTypeConstant initialSyncType, CommKeyClassId secondaryId, String localTarget, Integer localLun, VolumeNodeImpl localPrimary) throws RemoteException, IllegalValueException {
        VolumeNodeImpl remoteSecondary = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(secondaryId);
        this.isVolumeAndClusterValidForPair(remoteSecondary);
        ConfigElementData _remoteCED = new ConfigElementData(ClassID.SYNC_PAIR);
        _remoteCED.setValue(ParameterCode.DR_SYNC_PAIR_ROLE, (SrType)DRRoleConstant.REMOTE);
        _remoteCED.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, (SrType)initialSyncType);
        _remoteCED.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, (SrType)remoteSecondary.getCommKeyClassId());
        this.prepareSecondaryElementVolumes(_remoteCED, localTarget, localLun, remoteSecondary.getCluster(), localPrimary);
        return this.createInCluster(_remoteCED, remoteSecondary);
    }

    @Override
    public SrFuture<Void> clusterSync() throws RemoteException, IllegalValueException {
        return this.synchronize();
    }

    public void localCopyAllowed(HashSet set, VolumeNodeImpl remoteSecondary, ClusterImpl remoteCluster) throws IllegalValueException {
        GeneralSCSIDevice[] disks = remoteSecondary.getDisksOfVolume();
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"checking if local copy allowed on ", disks});
        for (int i = 0; i < disks.length; ++i) {
            if (((GeneralSCSIDeviceImpl)disks[i]).isDeviceSuitableForLocalCopy(set, remoteSecondary, remoteCluster)) continue;
            throw new IllegalValueException("cannot create this pair since the local copy is not suitable");
        }
    }

    private DRAbstractConsistencyGroupImpl findMatchingGroup(ArrayList list, DRClusterAbstractConsistencyGroupImpl group) throws RemoteException {
        for (DRAbstractConsistencyGroupImpl currGroup : list) {
            if (!currGroup.hasEquivalentElement(group)) continue;
            return currGroup;
        }
        return null;
    }

    private DRLogicObjectImpl findDRObjectContainingElement(ArrayList<DRLogicObjectImpl> list, DRClusterLogicObjectImpl element) {
        for (DRLogicObjectImpl currObject : list) {
            if (!currObject.hasElement(element)) continue;
            return currObject;
        }
        return null;
    }

    public DRLogicObjectImpl findDRObjectWithIdenticalElement(DRClusterLogicObjectImpl element) throws RemoteException {
        ClassID classId = element.getClassId();
        if (classId.equals((Object)ClassID.CONSISTENCY_GROUP)) {
            return this.findDRObjectContainingElement(this.m_consistencyGroups, element);
        }
        if (classId.equals((Object)ClassID.EXTENDED_PAIR)) {
            return this.findDRObjectContainingElement(this.m_extendedPairs, element);
        }
        if (classId.equals((Object)ClassID.SYNC_PAIR)) {
            return this.findDRObjectContainingElement(this.m_syncPairs, element);
        }
        if (classId.equals((Object)ClassID.ASYNC_PAIR)) {
            DRClusterAsyncPairImpl clusterPair = (DRClusterAsyncPairImpl)element;
            return this.findPairContainingClusterPair(this.getDRLogicObjectList(clusterPair.getGroupId().getClassID()), clusterPair);
        }
        return null;
    }

    private DRAbstractConsistencyGroupImpl findGroupWithIdenticalPair(DRClusterAsyncPairImpl pair) throws RemoteException {
        ArrayList groupList = this.getDRLogicObjectList(pair.getGroupId().getClassID());
        DRAbstractConsistencyGroupImpl cgWithIdenticalPair = this.findGroupWithIdenticalPair(groupList, pair);
        return cgWithIdenticalPair;
    }

    private DRAbstractConsistencyGroupImpl findGroupWithIdenticalPair(ArrayList drGroupList, DRClusterAsyncPairImpl pair) throws RemoteException {
        if (drGroupList != null && pair != null) {
            for (int i = 0; i < drGroupList.size(); ++i) {
                ArrayList<DRAsyncPair> pairList;
                DRPairImpl identicalPair;
                DRAbstractConsistencyGroupImpl currGroup = (DRAbstractConsistencyGroupImpl)drGroupList.get(i);
                DRAsyncPair[] currPairs = currGroup.getPairs();
                if (currPairs == null || (identicalPair = (DRPairImpl)this.findDRObjectContainingElement(pairList = new ArrayList<DRAsyncPair>(Arrays.asList(currPairs)), pair)) == null) continue;
                return currGroup;
            }
        }
        return null;
    }

    private DRAsyncPairImpl findPairContainingClusterPair(ArrayList drGroupList, DRClusterAsyncPairImpl pair) throws RemoteException {
        if (drGroupList != null && pair != null) {
            for (int i = 0; i < drGroupList.size(); ++i) {
                ArrayList<DRAsyncPair> pairList;
                DRAsyncPairImpl identicalPair;
                DRAbstractConsistencyGroupImpl currGroup = (DRAbstractConsistencyGroupImpl)drGroupList.get(i);
                DRAsyncPair[] currPairs = currGroup.getPairs();
                if (currPairs == null || (identicalPair = (DRAsyncPairImpl)this.findDRObjectContainingElement(pairList = new ArrayList<DRAsyncPair>(Arrays.asList(currPairs)), pair)) == null) continue;
                return identicalPair;
            }
        }
        return null;
    }

    private DRPairImpl findEquivalentMatchingPair(DRPair[] pairs, DRClusterPairImpl pair) throws RemoteException {
        if (pairs != null) {
            for (int i = 0; i < pairs.length; ++i) {
                DRPairImpl currPair = (DRPairImpl)pairs[i];
                if (!currPair.hasEquivalentElement(pair)) continue;
                return currPair;
            }
        }
        return null;
    }

    private ArrayList getDRLogicObjectList(ClassID classId) throws RemoteException {
        if (classId.equals((Object)ClassID.CONSISTENCY_GROUP)) {
            return this.m_consistencyGroups;
        }
        if (classId.equals((Object)ClassID.EXTENDED_PAIR)) {
            return this.m_extendedPairs;
        }
        if (classId.equals((Object)ClassID.SYNC_PAIR)) {
            return this.m_syncPairs;
        }
        if (classId.equals((Object)ClassID.ASYNC_PAIR)) {
            return this.getAsyncPairList();
        }
        return null;
    }

    private ArrayList getAsyncPairList() {
        ArrayList<DRAsyncPair> asyncPairList = new ArrayList<DRAsyncPair>();
        ArrayList extendedElementList = new ArrayList();
        extendedElementList.addAll(this.m_consistencyGroups);
        extendedElementList.addAll(this.m_extendedPairs);
        int size = extendedElementList.size();
        for (int i = 0; i < size; ++i) {
            DRAbstractConsistencyGroupImpl group = (DRAbstractConsistencyGroupImpl)extendedElementList.get(i);
            DRAsyncPair[] pairs = group.getPairs();
            if (pairs == null) continue;
            for (int j = 0; j < pairs.length; ++j) {
                asyncPairList.add(pairs[j]);
            }
        }
        return asyncPairList;
    }

    private DRAbstractConsistencyGroupImpl createNewGroup(DRClusterAbstractConsistencyGroup group) throws RemoteException {
        DRAbstractConsistencyGroupImpl newGroup;
        ArrayList list = this.getDRLogicObjectList(group.getClassId());
        ClassID classId = group.getClassId();
        if (classId.equals((Object)ClassID.CONSISTENCY_GROUP)) {
            newGroup = new DRConsistencyGroupImpl((DRClusterConsistencyGroupImpl)group);
        } else if (classId.equals((Object)ClassID.EXTENDED_PAIR)) {
            newGroup = new DRExtendedPairImpl((DRClusterExtendedPairImpl)group);
        } else {
            throw new IllegalArgumentException();
        }
        list.add(newGroup);
        return newGroup;
    }

    private void mergeGroups(DRAbstractConsistencyGroupImpl mergeDestinationGroup, DRAbstractConsistencyGroupImpl depracatedGroup) throws IllegalStateException, RemoteException, IllegalValueException {
        DRAsyncPair[] newPairs = depracatedGroup.getPairs();
        if (newPairs != null) {
            for (int i = 0; i < newPairs.length; ++i) {
                mergeDestinationGroup.addPair((DRAsyncPairImpl)newPairs[i]);
                ((DRAsyncPairImpl)newPairs[i]).setConsistencyGroup(mergeDestinationGroup);
            }
        }
        DRPiT[] pits = depracatedGroup.getPiTs();
        for (int i = 0; i < pits.length; ++i) {
            mergeDestinationGroup.addPiT((DRPiTImpl)pits[i]);
            ((DRPiTImpl)pits[i]).setDRObjectParent(mergeDestinationGroup);
        }
        if (depracatedGroup.isPartial() && mergeDestinationGroup.isPartial()) {
            mergeDestinationGroup.setElement(depracatedGroup.getPartialElement());
        } else {
            DRClusterLogicObjectImpl destLocalElement = mergeDestinationGroup.getLocalElement();
            DRClusterLogicObjectImpl depracatedLocalElement = depracatedGroup.getLocalElement();
            if (destLocalElement != null && depracatedLocalElement != null && destLocalElement.canMerge(depracatedLocalElement)) {
                destLocalElement.merge(depracatedLocalElement);
            } else if (destLocalElement == null && depracatedLocalElement != null) {
                mergeDestinationGroup.setElement(depracatedLocalElement);
            }
            DRClusterLogicObjectImpl destRemoteElement = mergeDestinationGroup.getRemoteElement();
            DRClusterLogicObjectImpl depracatedRemoteElement = depracatedGroup.getRemoteElement();
            if (destRemoteElement != null && depracatedRemoteElement != null && destRemoteElement.canMerge(depracatedRemoteElement)) {
                destRemoteElement.merge(depracatedRemoteElement);
            } else if (destRemoteElement == null && depracatedRemoteElement != null) {
                mergeDestinationGroup.setElement(depracatedRemoteElement);
            }
        }
    }

    public void processEvent(RemoteObjectImpl element, int eventType) throws RemoteException {
        DRBlockingEvent event;
        if (element instanceof LogicObjectImpl) {
            event = new DRBlockingEvent((Object)this, (LogicObjectImpl)element, eventType);
        } else if (element instanceof ElementEventImpl) {
            event = new DRBlockingEvent((Object)this, (ElementEventImpl)element, eventType);
        } else {
            throw new IllegalStateException("Undefined type for event arriving to DRRoot");
        }
        this.runEvent(event);
    }

    @Override
    public DRSyncPair[] getSyncPairs() throws RemoteException {
        DRSyncPair[] syncPairs = new DRSyncPair[this.m_syncPairs.size()];
        this.m_syncPairs.toArray(syncPairs);
        return syncPairs;
    }

    private SrFuture<Void> updateTargetsACLWithRemoteInitiatorIdentities() throws RemoteException, IllegalValueException {
        HashMap map = this.collectSinglePairForEachClusterCouple();
        return this.updateClusterCouplesWithDRIdentityAndNames(map);
    }

    private HashMap collectSinglePairForEachClusterCouple() throws RemoteException, IllegalValueException {
        HashMap map = new HashMap();
        int index = 0;
        DRSyncPair[] synchPairs = this.getSyncPairs();
        for (index = 0; index < synchPairs.length; ++index) {
            DRSyncPairImpl syncPairImpl = (DRSyncPairImpl)synchPairs[index];
            this.setClusterCoupleWithItsPair(map, syncPairImpl);
        }
        DRExtendedPair[] extendedPairs = this.getExtendedPairs();
        for (index = 0; index < extendedPairs.length; ++index) {
            DRExtendedPairImpl extendedPairImpl = (DRExtendedPairImpl)extendedPairs[index];
            this.setClusterCoupleWithItsPair(map, (DRAsyncPairImpl)extendedPairImpl.getPair());
        }
        DRConsistencyGroup[] consistencyGroup = this.getConsistencyGroups();
        for (index = 0; index < consistencyGroup.length; ++index) {
            DRConsistencyGroupImpl consistencyGroupImpl = (DRConsistencyGroupImpl)consistencyGroup[index];
            DRAsyncPair[] asyncPairs = consistencyGroupImpl.getPairs();
            for (int index1 = 0; index1 < asyncPairs.length; ++index1) {
                this.setClusterCoupleWithItsPair(map, (DRAsyncPairImpl)asyncPairs[index1]);
            }
        }
        return map;
    }

    private void setClusterCoupleWithItsPair(HashMap map, DRPairImpl pairElement) throws RemoteException, IllegalValueException {
        if (this.isDiscoverCompleted() && pairElement.isComplete()) {
            DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
            ClusterImpl localCluster = localClusterPairElement.getCluster();
            DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
            ClusterImpl remoteCluster = remoteClusterPairElement.getCluster();
            ClusterImpl[] keyMap = new ClusterImpl[]{localCluster, remoteCluster};
            map.put(keyMap, pairElement);
        }
    }

    private SrFuture<Void> updateClusterCouplesWithDRIdentityAndNames(HashMap map) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRRootImpl.updateClusterCouplesWithDRIdentityAndNames");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        Set key = map.keySet();
        HashMap<ClusterImpl, ArrayList<String>> accumalator = new HashMap<ClusterImpl, ArrayList<String>>();
        Iterator i = key.iterator();
        while (i.hasNext()) {
            DRPairImpl pairElement = (DRPairImpl)map.get(i.next());
            midFutures.add(this.updateTargetsACLWithRemoteInitiatorIdentitiesByPair(pairElement, accumalator));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> updateTargetsACLWithRemoteInitiatorIdentitiesByPair(DRPairImpl pairElement, HashMap<ClusterImpl, ArrayList<String>> accumaltor) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRRootImpl.updateTargetsACLWithRemoteInitiatorIdentitiesByPair");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (this.isDiscoverCompleted() && pairElement.isComplete()) {
            DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
            ClusterImpl localCluster = localClusterPairElement.getCluster();
            DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
            ClusterImpl remoteCluster = remoteClusterPairElement.getCluster();
            DRPrimaryVolumeImpl primaryVolume = pairElement.getPrimaryVolume();
            VolumeNode primaryVolumeNode = primaryVolume.getLocalVolume();
            LU primaryVolumeParentLU = primaryVolumeNode.getParentLU();
            Target primaryVolumeExsposedOnTarget = primaryVolumeParentLU.getParentTarget();
            ArrayList<String> initiatorNamesOnRemoteCluster = remoteCluster.getLocalInitiatorNames();
            if ((initiatorNamesOnRemoteCluster = this.addInitiatorNamesForAccumaltor(localCluster, initiatorNamesOnRemoteCluster, accumaltor)) != null && !initiatorNamesOnRemoteCluster.isEmpty()) {
                midFutures.add(localCluster.updateTargetACLWithRemoteInitiatorNames(primaryVolumeExsposedOnTarget, initiatorNamesOnRemoteCluster, initiatorNamesOnRemoteCluster));
            }
            DRSecondaryVolumeImpl secondaryVolume = pairElement.getSecondaryVolume();
            VolumeNode secondaryVolumeNode = secondaryVolume.getRemoteVolume();
            LU secondaryVolumeParentLU = secondaryVolumeNode.getParentLU();
            Target secondaryVolumeExsposedOnTarget = secondaryVolumeParentLU.getParentTarget();
            ArrayList<String> initiatorNamesOnLocalCluster = localCluster.getLocalInitiatorNames();
            if ((initiatorNamesOnLocalCluster = this.addInitiatorNamesForAccumaltor(remoteCluster, initiatorNamesOnLocalCluster, accumaltor)) != null && !initiatorNamesOnLocalCluster.isEmpty()) {
                midFutures.add(remoteCluster.updateTargetACLWithRemoteInitiatorNames(secondaryVolumeExsposedOnTarget, initiatorNamesOnLocalCluster, initiatorNamesOnLocalCluster));
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private ArrayList<String> addInitiatorNamesForAccumaltor(ClusterImpl cluster, ArrayList<String> initiatorNames, HashMap<ClusterImpl, ArrayList<String>> accumaltor) {
        ArrayList<String> existInitiatores = accumaltor.get(cluster);
        if (existInitiatores == null) {
            accumaltor.put(cluster, initiatorNames);
            return initiatorNames;
        }
        ArrayList<String> newInitiatorsNames = new ArrayList<String>();
        for (String name : initiatorNames) {
            if (existInitiatores.contains(name)) continue;
            newInitiatorsNames.add(name);
        }
        existInitiatores.addAll(newInitiatorsNames);
        return newInitiatorsNames;
    }

    private SrFuture<Void> updateTargetsPortalsBetweenSites(DRPairImpl pairElement) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRRootImpl.updateTargetsPortalsBetweenSites");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        if (this.isDiscoverCompleted()) {
            DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
            ClusterImpl localCluster = localClusterPairElement.getCluster();
            DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
            ClusterImpl remoteCluster = remoteClusterPairElement.getCluster();
            midFutures.add(this.updateTargetsPortalsBetweenClusters(localCluster, remoteCluster));
            midFutures.add(this.updateTargetsPortalsBetweenClusters(remoteCluster, localCluster));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> updateTargetsPortalsBetweenClusters(ClusterImpl fromCluster, ClusterImpl toCluster) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRRootImpl.updateTargetsPortalsBetweenClusters");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        ArrayList<PortalTableRowImpl> fromClusterPortals = fromCluster.getAllClusterTargetPortals();
        for (int index = 0; index < fromClusterPortals.size(); ++index) {
            PortalTableRowImpl portal = fromClusterPortals.get(index);
            midFutures.add(portal.synchronizeNewElementOnRemoteCluster(toCluster));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> removeInitiatorNameFromTargetsACL(VSwitch vswitch) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRRootImpl.removeInitiatorNameFromTargetsACL");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        ArrayList<String> removedInitiatorNames = new ArrayList<String>(1);
        removedInitiatorNames.add(vswitch.getISCSIInitiators()[0].getName());
        ClusterImpl vswitchCluster = (ClusterImpl)vswitch.getCluster();
        int index = 0;
        DRSyncPair[] synchPairs = this.getSyncPairs();
        for (index = 0; index < synchPairs.length; ++index) {
            DRSyncPairImpl syncPairImpl = (DRSyncPairImpl)synchPairs[index];
            midFutures.add(this.removeInitiatorNamesFromPairTargetsACL(syncPairImpl, vswitchCluster, removedInitiatorNames));
        }
        DRExtendedPair[] extendedPairs = this.getExtendedPairs();
        for (index = 0; index < extendedPairs.length; ++index) {
            DRExtendedPairImpl extendedPairImpl = (DRExtendedPairImpl)extendedPairs[index];
            midFutures.add(this.removeInitiatorNamesFromPairTargetsACL((DRAsyncPairImpl)extendedPairImpl.getPair(), vswitchCluster, removedInitiatorNames));
        }
        DRConsistencyGroup[] consistencyGroup = this.getConsistencyGroups();
        for (index = 0; index < consistencyGroup.length; ++index) {
            DRConsistencyGroupImpl consistencyGroupImpl = (DRConsistencyGroupImpl)consistencyGroup[index];
            DRAsyncPair[] asyncPairs = consistencyGroupImpl.getPairs();
            for (int index1 = 0; index1 < asyncPairs.length; ++index1) {
                midFutures.add(this.removeInitiatorNamesFromPairTargetsACL((DRAsyncPairImpl)asyncPairs[index1], vswitchCluster, removedInitiatorNames));
            }
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> removeInitiatorNamesFromPairTargetsACL(DRPairImpl pairElement, ClusterImpl changedCluster, ArrayList initiatorNames) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRRootImpl.removeInitiatorNamesFromPairTargetsACL");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        DRClusterPairImpl localClusterPairElement = (DRClusterPairImpl)pairElement.getLocalElement();
        ClusterImpl localCluster = localClusterPairElement.getCluster();
        DRClusterPairImpl remoteClusterPairElement = (DRClusterPairImpl)pairElement.getRemoteElement();
        ClusterImpl remoteCluster = remoteClusterPairElement.getCluster();
        DRPrimaryVolumeImpl primaryVolume = pairElement.getPrimaryVolume();
        VolumeNode primaryVolumeNode = primaryVolume.getLocalVolume();
        LU primaryVolumeParentLU = primaryVolumeNode.getParentLU();
        Target primaryVolumeExsposedOnTarget = primaryVolumeParentLU.getParentTarget();
        DRSecondaryVolumeImpl secondaryVolume = pairElement.getSecondaryVolume();
        VolumeNode secondaryVolumeNode = secondaryVolume.getRemoteVolume();
        LU secondaryVolumeParentLU = secondaryVolumeNode.getParentLU();
        Target secondaryVolumeExsposedOnTarget = secondaryVolumeParentLU.getParentTarget();
        if (changedCluster.equals(localCluster)) {
            midFutures.add(remoteCluster.removeInitiatorNamesFromTargetACL(secondaryVolumeExsposedOnTarget, initiatorNames));
        }
        if (changedCluster.equals(remoteCluster)) {
            midFutures.add(localCluster.removeInitiatorNamesFromTargetACL(primaryVolumeExsposedOnTarget, initiatorNames));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public ArrayList getDRObjects() {
        ArrayList drObjects = new ArrayList();
        if (!this.m_consistencyGroups.isEmpty()) {
            drObjects.addAll(this.getPairsOfAllGroupsInList(this.m_consistencyGroups));
        }
        if (!this.m_extendedPairs.isEmpty()) {
            drObjects.addAll(this.getPairsOfAllGroupsInList(this.m_extendedPairs));
        }
        drObjects.addAll(this.m_consistencyGroups);
        drObjects.addAll(this.m_extendedPairs);
        drObjects.addAll(this.m_syncPairs);
        return drObjects;
    }

    @Override
    public ArrayList getActivateDRObjects() throws RemoteException {
        ArrayList drObjects = new ArrayList();
        drObjects.addAll(this.m_consistencyGroups);
        drObjects.addAll(this.m_extendedPairs);
        drObjects.addAll(this.m_syncPairs);
        return drObjects;
    }

    private ArrayList getAllPairs() {
        ArrayList pairs = new ArrayList();
        pairs.addAll(this.getPairsOfAllGroupsInList(this.m_consistencyGroups));
        pairs.addAll(this.getPairsOfAllGroupsInList(this.m_extendedPairs));
        pairs.addAll(this.m_syncPairs);
        return pairs;
    }

    private ArrayList getPairsOfAllGroupsInList(ArrayList groupList) {
        ArrayList pairs = new ArrayList();
        if (groupList != null) {
            for (int i = 0; i < groupList.size(); ++i) {
                DRAbstractConsistencyGroupImpl currGroup = (DRAbstractConsistencyGroupImpl)groupList.get(i);
                ArrayList currPairs = this.getPairsOf(currGroup);
                if (currPairs == null) continue;
                pairs.addAll(currPairs);
            }
        }
        return pairs;
    }

    private ArrayList getPairsOf(DRAbstractConsistencyGroupImpl group) {
        DRAsyncPair[] pairs = group.getPairs();
        if (pairs != null) {
            ArrayList<DRAsyncPair> pairsList = new ArrayList<DRAsyncPair>(Arrays.asList(pairs));
            return pairsList;
        }
        return null;
    }

    @Override
    public synchronized AlarmSeverity getPropagatedState() {
        AlarmSeverity alarmSeverity = AlarmSeverity.OK;
        for (int i = 0; i < this.getDRObjects().size(); ++i) {
            if (alarmSeverity.isMoreSevereThan(((DRLogicObjectImpl)this.getDRObjects().get(i)).getPropagatedState())) continue;
            alarmSeverity = ((DRLogicObjectImpl)this.getDRObjects().get(i)).getPropagatedState();
        }
        return alarmSeverity;
    }

    private void drElementRemoved(DRLogicObjectImpl element) throws RemoteException {
        this.checkAlarms(element, 3);
        this.checkAlarms(element, null, 3);
        ClassID classId = element.getClassId();
        this.removeStubToRefMapping(element.hashKey());
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, element);
        LogicMgrAOImpl.getInstance().__elementRemoved(elementEvent);
        if (!classId.equals((Object)ClassID.ASYNC_PAIR)) {
            this.getDRLogicObjectList(element.getClassId()).remove(element);
            SystemRootImpl.getInstance().removePropagationStateDependentObjectAndListener(element);
        }
    }

    private void drElementCreated(DRLogicObjectImpl element) throws RemoteException {
        this.setStubToRefMapping(element.hashKey(), element);
        ElementEventImpl elementEvent = new ElementEventImpl((Object)this, element);
        try {
            elementEvent.setParameterList(element.getClientParameterList());
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)ive));
        }
        LogicMgrAOImpl.getInstance().__elementCreated(elementEvent);
        element.registerToPropagatedStateChange();
        ClassID classId = element.getClassId();
        if (!classId.equals((Object)ClassID.ASYNC_PAIR)) {
            this.getDRLogicObjectList(element.getClassId()).add(element);
            SystemRootImpl.getInstance().addPropagationStateDependentObjectAndListener(element);
        }
        this.checkAlarms(element, 1);
    }

    private void drElementChanged(DRLogicObjectImpl element) throws RemoteException {
        try {
            this.drElementChanged(element, null, null);
        }
        catch (IllegalValueException e) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drElementChanged(DRLogicObjectImpl element, DRClusterLogicObjectImpl clusterDRObject, HashMap changedValues) throws RemoteException, IllegalValueException {
        DRInitialSyncStateConstant isyncState;
        ClassID classId = element.getClassId();
        DRClusterLogicObjectImpl activeElement = element.getActiveElement();
        if (!ClassID.ASYNC_PAIR.equals((Object)classId)) {
            SrBITSConstant replicationState;
            if (activeElement != null && this.isDiscoverCompleted() && ((replicationState = (SrBITSConstant)activeElement.getSrValueOf(MasterParameterCode.DR_REPLICATION_STATE)).contains((SrBITSConstant)DRReplicationStateConstant.PLANNED_FAILOVER) || replicationState.contains((SrBITSConstant)DRReplicationStateConstant.FALLBACK))) {
                DRInitialSyncStateConstant isyncState2 = (DRInitialSyncStateConstant)activeElement.getSrValueOf(MasterParameterCode.DR_INITIAL_SYNC_STATE);
                if (element instanceof DRAbstractConsistencyGroupImpl) {
                    long activePendingPiTs = ((DRClusterAbstractConsistencyGroupImpl)activeElement).getPendingPiTs();
                    DRClusterAbstractConsistencyGroupImpl inactiveElement = (DRClusterAbstractConsistencyGroupImpl)element.getInactiveElement();
                    if (!(activePendingPiTs != 0L || inactiveElement != null && inactiveElement.getPendingPiTs() != 0L || DRInitialSyncStateConstant.OK.equals((Object)isyncState2))) {
                        // empty if block
                    }
                } else if (ClassID.SYNC_PAIR.equals((Object)classId) && !DRInitialSyncStateConstant.OK.equals((Object)isyncState2)) {
                    // empty if block
                }
            }
        } else if (element.getLocalElement() != null && DRInitialSyncStateConstant.IN_PROGRESS.equals((Object)(isyncState = (DRInitialSyncStateConstant)element.getLocalElement().getSrValueOf(MasterParameterCode.DR_INITIAL_SYNC_STATE))) && ((DRAsyncPairImpl)element).findLocalCopyToPair() != null) {
            ErrorAssertingListener.listenTo(((DRAsyncPairImpl)element).getLocalSnapshot().offlineCopy(((DRAsyncPairImpl)element).findLocalCopyToPair().getCommKeyClassId()));
        }
        if (classId.isDRPairClassId() && !element.isPartial()) {
            ErrorAssertingListener.listenTo(this.updateTargetsPortalsBetweenSites((DRPairImpl)element));
            ErrorAssertingListener.listenTo(this.updateTargetsACLWithRemoteInitiatorIdentitiesByPair((DRPairImpl)element, new HashMap<ClusterImpl, ArrayList<String>>()));
        }
        if (!element.isInDeletionProcess()) {
            ElementEventImpl elementEvent = new ElementEventImpl((Object)this, element);
            elementEvent.setParameterList(element.getClientParameterList());
            if (clusterDRObject == null || clusterDRObject.equals(activeElement) || activeElement == null || activeElement != clusterDRObject && this.isInactiveSideValues(changedValues)) {
                LogicMgrAOImpl.getInstance().__elementChanged(elementEvent, true);
            } else {
                ClientParameterCode modeCode = ClientParameterCode.getClientParameterCode(clusterDRObject.getParameterCode((ParameterCodes)MasterParameterCode.DR_MODE));
                DRModeConstant changedMode = (DRModeConstant)changedValues.get(modeCode);
                if (changedValues != null && changedMode != null) {
                    LogicMgrAOImpl.getInstance().__elementChanged(elementEvent, true);
                }
            }
        }
        if (changedValues == null || changedValues.size() > 1 || !changedValues.containsKey(ClientParameterCode.DR_PAIR_ONLINE_INIT_SYNC_DATA_TRANSFFERED)) {
            this.checkAlarms(element, 2);
            if (ClassID.ASYNC_PAIR.equals((Object)classId)) {
                DRAsyncPairImpl asyncPair = (DRAsyncPairImpl)element;
                DRAbstractConsistencyGroupImpl cg = asyncPair.getCg();
                this.checkAlarms(cg, 2);
            }
        }
    }

    private boolean isInactiveSideValues(HashMap parameterList) {
        return parameterList.containsKey(ClientParameterCode.DR_CONSISTENCY_GROUP_LAST_PIT_MERGE) || parameterList.containsKey(ClientParameterCode.DR_ASYNC_PAIR_LAST_PIT_MERGE) || parameterList.containsKey(ClientParameterCode.DR_ASYNC_PAIR_SNAPSHOT_VOLUME);
    }

    public DRPairImpl getPairContainsISCSIDisk(VolumeNode volume) {
        ArrayList pairs = this.getAllPairs();
        int size = pairs.size();
        if (pairs != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                DRPairImpl currPair = (DRPairImpl)pairs.get(i);
                if (!currPair.containsISCSIDisk(volume)) continue;
                return currPair;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyVolumeReplaced(VolumeNodeImpl oldVolume, VolumeNodeImpl newVolume) throws RemoteException, InvalidElementException {
        Object object = this.m_replacingVolumeLock;
        synchronized (object) {
            ArrayList allPairs = this.getAllPairs();
            for (DRPairImpl pair : allPairs) {
                boolean isVolumeReplaced = pair.notifyVolumeReplaced(oldVolume, newVolume);
                if (!isVolumeReplaced) continue;
                this.drElementChanged(pair);
            }
            DRPairImpl drPair = this.getPairUsingVolume(newVolume);
            if (drPair != null) {
                if (drPair.isPartial()) {
                    DRClusterPairImpl elementInPair = (DRClusterPairImpl)drPair.getPartialElement();
                    DRPair[] allPairsArray = allPairs.toArray(new DRPair[allPairs.size()]);
                    DRPairImpl equPair = this.findEquivalentMatchingPair(allPairsArray, elementInPair);
                    if (equPair != null && equPair.isPartial() && equPair.getElement(elementInPair.getRole()) == null) {
                        DRClusterPairImpl elementInEquPair = (DRClusterPairImpl)equPair.getPartialElement();
                        if (elementInEquPair.getClassId().equals((Object)ClassID.ASYNC_PAIR)) {
                            this.removeDRClusterAsyncPair((DRClusterAsyncPairImpl)elementInEquPair, true);
                        } else {
                            this.elementRemoved(elementInEquPair);
                        }
                        this.elementCreated(elementInEquPair);
                    }
                }
                this.drElementChanged(drPair);
            }
        }
    }

    public boolean isDiscoverCompleted() throws RemoteException {
        return this.m_isDRDiscoveryCompleted;
    }

    public boolean isAliasExist(String alias) {
        DRConsistencyGroup[] groups = this.getConsistencyGroups();
        for (int i = 0; i < groups.length; ++i) {
            String currAlias = ((DRConsistencyGroupImpl)groups[i]).getAlias();
            if (!currAlias.equals(alias)) continue;
            return true;
        }
        return false;
    }

    public DRLogicObjectImpl getDRObject(DRLogicObject element) throws RemoteException {
        if (element != null) {
            return this.getRefByStub(element.hashKey());
        }
        return null;
    }

    public synchronized SrFuture<Void> synchronize() throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRRootImpl.synchronize");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (ClusterImpl cluster : this.m_clustersDiscoveredInDR) {
            midFutures.add(cluster.getDRManager().synchronize());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    public SrFuture<Void> refreshPendingPits(ClassID aClassId) throws RemoteException {
        final SrFuture retFuture = new SrFuture("DRAbstractConsistencyGroupImpl.refreshPiTs");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        List<VSwitch> vswitches = this.getAllActiveVSwitches();
        for (VSwitch vs : vswitches) {
            ConfigElementData ced = new ConfigElementData(aClassId);
            ced.setValue(ParameterCode.VSWITCH_ID, (SrType)vs.getCommKeyClassId());
            if (ClassID.CONSISTENCY_GROUP.equals((Object)aClassId) || ClassID.EXTENDED_PAIR.equals((Object)aClassId)) {
                ced.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_PITS, (SrType)null);
                ced.setValue(ParameterCode.DR_CONSISTENCY_GROUP_PENDING_DATA, (SrType)null);
            } else if (ClassID.ASYNC_PAIR.equals((Object)aClassId)) {
                ced.setValue(ParameterCode.DR_ASYNC_PAIR_PENDING_PITS, (SrType)null);
                ced.setValue(ParameterCode.DR_ASYNC_PAIR_PENDING_DATA, (SrType)null);
            } else {
                throw new IllegalArgumentException("ClassID " + aClassId + " is not applicable");
            }
            midFutures.add(DataMgrAdapter.getInstance().refreshTableFields(ced));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private List<VSwitch> getAllActiveVSwitches() throws RemoteException {
        ArrayList<VSwitch> retList = new ArrayList<VSwitch>();
        ArrayList<ClusterImpl> clusters = SystemRootImpl.getInstance().getClustersRecursively();
        for (ClusterImpl clusterObj : clusters) {
            VSwitchImpl[] vswitches;
            for (VSwitchImpl vs : vswitches = clusterObj.getConnectedVSwitches()) {
                retList.add(vs);
            }
        }
        return retList;
    }

    private static class DRArrayList
    extends ArrayList {
        private DRArrayList() {
        }

        @Override
        public boolean remove(Object obj) {
            Iterator e = this.iterator();
            if (obj == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    e.remove();
                    return true;
                }
            } else {
                while (e.hasNext()) {
                    if (obj != e.next()) continue;
                    e.remove();
                    return true;
                }
            }
            return false;
        }
    }
}

