/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.dr.DRPrimaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.dr.DRSecondaryVolumeImpl;
import com.sanrad.nms.server.logic.dr.DRVolumeImpl;
import com.sanrad.nms.server.logic.dr.PairEqualityState;
import com.sanrad.nms.server.logic.lu.LU;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDevice;
import com.sanrad.nms.server.logic.physstorage.GeneralSCSIDeviceImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.ChangeConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRInitialSyncStateConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.nms.server.util.types.constants.DRVolumeTypeConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public abstract class DRPairImpl
extends DRLogicObjectImpl
implements DRPair {
    private static SrLogger theLogger = SrLogger.getLogger();
    private DRPrimaryVolumeImpl m_primaryVol;
    private DRSecondaryVolumeImpl m_secondaryVol;

    protected DRPairImpl(DRClusterPairImpl element, DRRoleConstant role) throws RemoteException {
        super(element, role);
        if (role == null || role.equals((Object)DRRoleConstant.NONE)) {
            throw new IllegalArgumentException("Role of " + element + " is " + role);
        }
    }

    protected DRPairImpl(DRClusterPairImpl element) throws RemoteException {
        super(element);
    }

    @Override
    public void setElement(DRClusterLogicObjectImpl element) throws RemoteException {
        super.setElement(element);
        this.checkForDRVolumeUpdate(element.getRole());
    }

    @Override
    public void setElement(DRClusterLogicObjectImpl element, DRRoleConstant role) throws RemoteException {
        if (role == null || role.equals((Object)DRRoleConstant.NONE)) {
            throw new IllegalArgumentException("Role of " + element + " is " + role);
        }
        super.setElement(element, role);
        this.checkForDRVolumeUpdate(role);
    }

    private void checkForDRVolumeRemoveUpdate() {
        if (this.getLocalElement() == null) {
            this.m_primaryVol.clearLocalVolume();
            this.m_secondaryVol.clearLocalVolume();
        } else if (this.getRemoteElement() == null) {
            this.m_primaryVol.clearRemoteVolume();
            this.m_secondaryVol.clearRemoteVolume();
        }
        this.checkForDRVolumesRemove();
    }

    private void createDRVolumeObject(DRVolumeTypeConstant volumeType, VolumeNodeImpl volume, DRRoleConstant role) throws RemoteException {
        if (volumeType.equals(DRVolumeTypeConstant.PRIMARY)) {
            this.m_primaryVol = new DRPrimaryVolumeImpl(volume, role);
        } else {
            this.m_secondaryVol = new DRSecondaryVolumeImpl(volume, role);
        }
    }

    private void checkForDRVolumeTypeUpdate(DRVolumeTypeConstant volumeType, DRRoleConstant role, DRClusterPairImpl elementToUpdate) throws RemoteException {
        VolumeNodeImpl volume = (VolumeNodeImpl)elementToUpdate.getVolume(volumeType);
        DRVolumeImpl drVolume = this.getVolume(volumeType);
        if (drVolume == null) {
            this.createDRVolumeObject(volumeType, volume, role);
        } else {
            drVolume.updateDRVolume(volume, role);
        }
    }

    private void checkForDRVolumeUpdate(DRRoleConstant role) throws RemoteException {
        DRClusterPairImpl elementToUpdate = (DRClusterPairImpl)(role.equals((Object)DRRoleConstant.LOCAL) ? this.getLocalElement() : this.getRemoteElement());
        this.checkForDRVolumeTypeUpdate(DRVolumeTypeConstant.PRIMARY, role, elementToUpdate);
        this.checkForDRVolumeTypeUpdate(DRVolumeTypeConstant.SECONDARY, role, elementToUpdate);
    }

    @Override
    public void removeElement(DRClusterLogicObjectImpl pair) {
        super.removeElement(pair);
        this.checkForDRVolumeRemoveUpdate();
    }

    private void checkForDRVolumesRemove() {
        if (this.m_primaryVol.isEmpty()) {
            this.m_primaryVol = null;
        }
        if (this.m_secondaryVol.isEmpty()) {
            this.m_secondaryVol = null;
        }
    }

    private static boolean isEquivalentVolumes(VolumeNodeImpl vol1, GeneralSCSIDeviceImpl stor2) throws RemoteException {
        if (vol1 != null && stor2 != null) {
            LUImpl vol1LU = vol1.getParentLU();
            String diskTargetName = stor2.getEntityName();
            int diskLun = Integer.parseInt(stor2.getLUN());
            String volTargetName = vol1LU.getParentTarget().getName();
            int volLun = vol1LU.getLUN();
            return diskTargetName.equals(volTargetName) && diskLun == volLun;
        }
        return false;
    }

    public static PairEqualityState equivalent(DRClusterPair clusterPair1, DRClusterPair clusterPair2) throws RemoteException {
        boolean isPair2Local;
        DRClusterPairImpl pair1 = (DRClusterPairImpl)clusterPair1;
        DRClusterPairImpl pair2 = (DRClusterPairImpl)clusterPair2;
        PairEqualityState state = new PairEqualityState();
        boolean isPair1Local = pair1.isLocal();
        if (isPair1Local == (isPair2Local = pair2.isLocal())) {
            state.setIdenticalRole();
        }
        if (pair1.isInternalDR() || pair2.isInternalDR()) {
            state.setInternalDR();
            return state;
        }
        VolumeNodeImpl pair1ExposedVolume = pair1.getExposedVolume();
        VolumeNodeImpl pair2ExposedVolume = pair2.getExposedVolume();
        GeneralSCSIDeviceImpl pair1InternalStorage = (GeneralSCSIDeviceImpl)pair1.getInternalVolume();
        GeneralSCSIDeviceImpl pair2InternalStorage = (GeneralSCSIDeviceImpl)pair2.getInternalVolume();
        boolean isEquivalent1 = DRPairImpl.isEquivalentVolumes(pair1ExposedVolume, pair2InternalStorage);
        boolean isEquivalent2 = DRPairImpl.isEquivalentVolumes(pair2ExposedVolume, pair1InternalStorage);
        if (isEquivalent1 && isEquivalent2) {
            state.setEquivalent();
            if (DRPairImpl.isInverted(pair1, pair1ExposedVolume, pair2, pair2InternalStorage)) {
                state.setInvertedPair();
            }
            return state;
        }
        if (!isEquivalent1 && !isEquivalent2) {
            state.setNotSymmetricDR();
            return state;
        }
        state.setUnEquivalentVolPair();
        return state;
    }

    private static boolean isInverted(DRClusterPairImpl pair1, VolumeNodeImpl vol1, DRClusterPairImpl pair2, VolumeNodeImpl vol2) throws RemoteException {
        return !(vol1.equals(pair1.getPrimaryVolume()) && vol2.equals(pair2.getPrimaryVolume()) || vol1.equals(pair1.getSecondaryVolume()) && vol2.equals(pair2.getSecondaryVolume()));
    }

    public boolean hasEquivalentElement(DRClusterPairImpl pair) throws RemoteException {
        DRClusterPairImpl localElement = (DRClusterPairImpl)this.getLocalElement();
        DRClusterPairImpl remoteElement = (DRClusterPairImpl)this.getRemoteElement();
        if (localElement != null && remoteElement != null) {
            return false;
        }
        boolean isLocal = pair.isLocal();
        if (isLocal && remoteElement != null) {
            if (!remoteElement.getClassId().equals((Object)pair.getClassId())) {
                return false;
            }
            PairEqualityState state = DRPairImpl.equivalent(remoteElement, pair);
            return state.arePairsEquivalent();
        }
        if (!isLocal && localElement != null) {
            if (!localElement.getClassId().equals((Object)pair.getClassId())) {
                return false;
            }
            PairEqualityState state = DRPairImpl.equivalent(localElement, pair);
            return state.arePairsEquivalent();
        }
        return false;
    }

    public DRPrimaryVolumeImpl getPrimaryVolume() {
        return this.m_primaryVol;
    }

    public DRSecondaryVolumeImpl getSecondaryVolume() {
        return this.m_secondaryVol;
    }

    @Override
    public SrFuture<Void> abortInitialSync() throws RemoteException, IllegalValueException {
        throw new IllegalValueException("Cannot preform suspend initial sync on async pair");
    }

    @Override
    public SrFuture<Void> startInitialSync() throws RemoteException, IllegalValueException {
        throw new IllegalValueException("Cannot preform resume initial sync on async pair");
    }

    public DRPairInitialSyncTypeConstant getInitalSyncType() {
        return ((DRClusterPairImpl)this.getNotNullElement()).getInitalSyncType();
    }

    private DRVolumeImpl getVolume(DRVolumeTypeConstant volumeType) {
        if (volumeType.equals(DRVolumeTypeConstant.PRIMARY)) {
            return this.m_primaryVol;
        }
        return this.m_secondaryVol;
    }

    @Override
    public void registerToPropagatedStateChange() {
        this.addPropagationToVolumeNodeIfNotNull(this.getVolume(DRVolumeTypeConstant.PRIMARY).getLocalVolume());
        this.addPropagationToVolumeNodeIfNotNull(this.getVolume(DRVolumeTypeConstant.SECONDARY).getLocalVolume());
        this.addPropagationToVolumeNodeIfNotNull(this.getVolume(DRVolumeTypeConstant.PRIMARY).getRemoteVolume());
        this.addPropagationToVolumeNodeIfNotNull(this.getVolume(DRVolumeTypeConstant.SECONDARY).getRemoteVolume());
    }

    private void addPropagationToVolumeNodeIfNotNull(GeneralLogicObjectImpl node) {
        if (node != null) {
            this.addPropagationStateDependentObjectAndListener(node);
        }
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException, IllegalValueException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_PAIR_PRIMARY_VOLUME, this.getPrimaryVolume().getLocalVolume());
        parameterList.put(ClientParameterCode.DR_PAIR_SECONDARY_VOLUME, this.getSecondaryVolume().getRemoteVolume());
        parameterList.put(ClientParameterCode.DR_PAIR_REMOTE_PRIMARY_VOLUME, this.getPrimaryVolume().getRemoteVolume());
        parameterList.put(ClientParameterCode.DR_PAIR_LOCAL_SECONDARY_VOLUME, this.getSecondaryVolume().getLocalVolume());
        return parameterList;
    }

    @Override
    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("<");
        if (this.getLocalElement() != null) {
            string.append(this.getLocalElement().getCluster().getParentSite().toString());
        }
        if (this.m_primaryVol.toString() != null) {
            string.append("/" + this.m_primaryVol.toString());
        }
        string.append(" - ");
        if (this.getRemoteElement() != null) {
            string.append(this.getRemoteElement().getCluster().getParentSite().toString());
        }
        if (this.m_secondaryVol.toString() != null) {
            string.append("/" + this.m_secondaryVol.toString());
        }
        string.append(">");
        return string.toString();
    }

    protected SrFuture<Void> recover(ConfigElementData ced, CommKeyClassId volume) throws RemoteException, IllegalValueException {
        if (ced == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given CED should not be null."});
            return new CompleteFuture("DRPairImpl.recover");
        }
        DRClusterPairImpl existingPair = null;
        DRRoleConstant roleOfElementToBeRecovered = this.getRoleOfElementToBeRecovered();
        GeneralSCSIDevice iSCSIDisk = null;
        if (roleOfElementToBeRecovered.equals((Object)DRRoleConstant.LOCAL)) {
            existingPair = (DRClusterPairImpl)this.getRemoteElement();
            iSCSIDisk = (GeneralSCSIDevice)((Object)existingPair.getPrimaryVolume());
        } else {
            existingPair = (DRClusterPairImpl)this.getLocalElement();
            iSCSIDisk = (GeneralSCSIDevice)((Object)existingPair.getSecondaryVolume());
        }
        VolumeNodeImpl volumeNode = (VolumeNodeImpl)SystemRootImpl.getInstance().getRefByStub(volume);
        LUImpl volumeLU = volumeNode.getParentLU();
        if (volumeLU == null) {
            throw new IllegalValueException(volumeNode.getClassId() + " " + volumeNode + " should be exposed in order to recover the pair.");
        }
        String serialNumber = iSCSIDisk.getSerialNumber();
        String volumeSerialNumber = volumeLU.getSerialNumber();
        if (volumeSerialNumber != null && !volumeSerialNumber.equals(serialNumber) || serialNumber != null && !serialNumber.equals(volumeSerialNumber)) {
            throw new IllegalValueException(volumeLU.getClassId() + " " + volumeLU + " should have the same serial number as " + iSCSIDisk.getClassId() + " " + iSCSIDisk + " in order to recover the pair.");
        }
        LU luOfPairExposedVolume = existingPair.getLUOfExposedVolume();
        String targetName = ((LUImpl)luOfPairExposedVolume).getParentTarget().getName();
        Integer lu = ((LUImpl)luOfPairExposedVolume).getLUN();
        if (existingPair.equals(this.getLocalElement())) {
            theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"1) The CED before the 'preparePrimaryElementVolumes' is: ", ced});
            DRRootImpl.getInstance().prepareSecondaryElementVolumes(ced, targetName, lu, volumeNode.getCluster(), volumeNode);
            theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"1) The CED after the 'preparePrimaryElementVolumes' is: ", ced});
        } else {
            theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"2) The CED before the 'preparePrimaryElementVolumes' is: ", ced});
            DRRootImpl.getInstance().preparePrimaryElementVolumes(ced, volumeNode, volumeNode, targetName, lu);
            theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"2) The CED after the 'preparePrimaryElementVolumes' is: ", ced});
        }
        ced.setValue(ParameterCode.VIRTUAL_VOLUME_LU, (SrType)volumeNode.getParentLU().getCommKeyClassId());
        DRPairInitialSyncTypeConstant initialSyncType = existingPair.getInitialSyncType();
        ced.setValue(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE, (SrType)initialSyncType);
        theLogger.error(SrLogCategories.SYSTEM, new Object[]{"BUG 6854 --> The CED just before the 'createInCluster' is: ", ced, ". It is called with the volume: ", volumeNode, " which is connected to the VSs: ", Arrays.toString(volumeNode.getConnectedVSwitches())});
        return DRRootImpl.getInstance().createInCluster(ced, volumeNode);
    }

    protected DRRoleConstant getRoleOfElementToBeRecovered() throws RemoteException, IllegalValueException {
        DRClusterPairImpl localPair = (DRClusterPairImpl)this.getLocalElement();
        if (localPair == null) {
            return DRRoleConstant.LOCAL;
        }
        DRClusterPairImpl remotePair = (DRClusterPairImpl)this.getRemoteElement();
        if (remotePair == null) {
            return DRRoleConstant.REMOTE;
        }
        throw new IllegalValueException("attempt to recover DR object ");
    }

    public boolean containsISCSIDisk(VolumeNode volume) {
        VolumeNodeImpl primaryRemote = this.getPrimaryVolume().getRemoteVolume();
        if (volume.equals(primaryRemote)) {
            return true;
        }
        VolumeNodeImpl secondaryLocal = this.getSecondaryVolume().getLocalVolume();
        return volume.equals(secondaryLocal);
    }

    @Override
    public SrFuture<Void> refreshInitialSyncProgress() throws RemoteException {
        final SrFuture retFuture = new SrFuture("DRPairImpl. refreshInitialSyncProgress");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        DRClusterPairImpl local = (DRClusterPairImpl)this.getLocalElement();
        DRClusterPairImpl remote = (DRClusterPairImpl)this.getRemoteElement();
        if (local != null) {
            midFutures.add(local.refreshInitialSyncProgress());
        }
        if (remote != null) {
            midFutures.add(remote.refreshInitialSyncProgress());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> validAndActivateForChildren(ChangeConstant state) throws IllegalValueException {
        if (state instanceof DRActivateConstant) {
            boolean isSnapshotNeeded = this.isSnapshotNeeded((DRActivateConstant)state);
            this.getVolume(DRVolumeTypeConstant.PRIMARY).validAndActivate((DRActivateConstant)state, isSnapshotNeeded);
            this.getVolume(DRVolumeTypeConstant.SECONDARY).validAndActivate((DRActivateConstant)state, isSnapshotNeeded);
        }
        return new CompleteFuture("DRPairImpl.validAndActivateForChildren");
    }

    protected abstract boolean isSnapshotNeeded(DRActivateConstant var1);

    protected boolean isInitialSyncState(DRInitialSyncStateConstant state) {
        DRClusterLogicObjectImpl activeElement = this.getActiveElement();
        if (activeElement != null) {
            return activeElement.isParameterEqual((Parameters)new Parameter(ParameterCode.DR_PAIR_INITIAL_SYNC_STATE, (Object)state), activeElement.getActiveVswitch());
        }
        return false;
    }

    public boolean isUnequivelentPair() {
        if (this.getLocalElement() == null || this.getRemoteElement() == null) {
            return false;
        }
        return !this.m_primaryVol.isVolumeComplete() || !this.m_secondaryVol.isVolumeComplete();
    }

    public boolean isInvertedPair() throws RemoteException {
        if (this.getLocalElement() == null || this.getRemoteElement() == null) {
            return false;
        }
        return this.getPrimaryVolume().getRemoteVolume().isExposed(this.getRemoteElement().getActiveVswitch()) || this.getSecondaryVolume().getLocalVolume().isExposed(this.getLocalElement().getActiveVswitch());
    }

    @Override
    protected String isValid(HashMap parameterList) {
        DRClusterLogicObjectImpl activeElement = this.getActiveElement();
        if (activeElement != null && activeElement.getValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE) == null && activeElement.getValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE).equals(this.getRemoteElement().getValueOf(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE))) {
            return "Your Initial sync type is not the same in the local site and remote site please change the initial sync type";
        }
        return super.isValid(parameterList);
    }

    @Override
    protected void checkThatChildAndFatherAreMached() throws IllegalValueException {
        DRClusterLogicObjectImpl activeElement = this.getActiveElement();
        if (activeElement != null && !((DRClusterPairImpl)activeElement).getExposedVolume().getActiveVswitch().equals(this.getActiveVswitch())) {
            throw new IllegalValueException("Pair is not synchronized in the cluster, please perform cluster synchronization.");
        }
    }

    boolean notifyVolumeReplaced(VolumeNodeImpl oldVolume, VolumeNodeImpl newVolume) throws RemoteException {
        if (this.m_primaryVol != null) {
            if (this.m_primaryVol.getLocalVolume() == oldVolume) {
                this.m_primaryVol.clearLocalVolume();
                this.m_primaryVol.updateDRVolume(newVolume, DRRoleConstant.LOCAL);
                return true;
            }
            if (this.m_primaryVol.getRemoteVolume() == oldVolume) {
                this.m_primaryVol.clearRemoteVolume();
                this.m_primaryVol.updateDRVolume(newVolume, DRRoleConstant.REMOTE);
                return true;
            }
        }
        if (this.m_secondaryVol != null) {
            if (this.m_primaryVol.getLocalVolume() == oldVolume) {
                this.m_secondaryVol.clearLocalVolume();
                this.m_secondaryVol.updateDRVolume(newVolume, DRRoleConstant.LOCAL);
                return true;
            }
            if (this.m_secondaryVol.getRemoteVolume() == oldVolume) {
                this.m_secondaryVol.clearRemoteVolume();
                this.m_secondaryVol.updateDRVolume(newVolume, DRRoleConstant.REMOTE);
                return true;
            }
        }
        return false;
    }
}

