/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.dr;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.MasterParameter;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.constants.ChangeConstant;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class DRActivateImpl
extends DRLogicObjectImpl
implements DRActivate {
    private static SrLogger theLogger = SrLogger.getLogger();

    protected DRActivateImpl(DRClusterLogicObjectImpl element) throws RemoteException {
        super(element);
    }

    @Override
    public SrFuture<Void> plannedFailover() throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRActivateImpl.plannedFailover");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        midFutures.add(this.validAndActivate((ChangeConstant)DRActivateConstant.PLANNED_FAILOVER));
        midFutures.add(this.getLocalElement().changeElementForActiveVswitch(new MasterParameter((ParameterCodes)this.getLocalElement().getActivateParameterCode(), (Object)DRActivateConstant.PLANNED_FAILOVER)));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> disasterOccured() throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRActivateImpl.disasterOccured");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        DRClusterLogicObjectImpl localElement = this.getLocalElement();
        DRClusterLogicObjectImpl remoteElement = this.getRemoteElement();
        if (remoteElement == null) {
            return new CompleteFuture("DRActivateImpl.disasterOccured");
        }
        try {
            midFutures.add(this.validAndActivate((ChangeConstant)DRActivateConstant.DISASTER_FAILOVER));
        }
        catch (IllegalValueException e) {
            if (localElement != null) {
                ClusterImpl localCluster = localElement.getCluster();
                return localCluster.deleteElement();
            }
            return new CompleteFuture("DRActivateImpl.disasterOccured");
        }
        catch (UnsupportedOperationException e) {
            if (localElement != null) {
                ClusterImpl localCluster = localElement.getCluster();
                return localCluster.deleteElement();
            }
            return new CompleteFuture("DRActivateImpl.disasterOccured");
        }
        midFutures.add(this.getRemoteElement().changeElementForActiveVswitch(new MasterParameter((ParameterCodes)this.getRemoteElement().getActivateParameterCode(), (Object)DRActivateConstant.DISASTER_FAILOVER)));
        if (localElement != null) {
            ClusterImpl localCluster = localElement.getCluster();
            midFutures.add(localCluster.deleteElement());
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"disaster fail over has occured"});
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> fallback() throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRActivateImpl.fallback");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        midFutures.add(this.validAndActivate((ChangeConstant)DRActivateConstant.FALLBACK));
        midFutures.add(this.getRemoteElement().changeElementForActiveVswitch(new MasterParameter((ParameterCodes)this.getRemoteElement().getActivateParameterCode(), (Object)DRActivateConstant.FALLBACK)));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    public void activateAndSwitch(DRActivateConstant state) throws RemoteException, IllegalValueException {
    }

    @Override
    public SrFuture<Void> startReplicate() throws RemoteException, IllegalValueException {
        this.validAndActivate((ChangeConstant)DRActivateConstant.START_REPLICATE);
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"start replicate has occured"});
        return ((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(new MasterParameter((ParameterCodes)((DRClusterLogicObjectImpl)this.getClusterElementAccordingToMode()).getActivateParameterCode(), (Object)DRActivateConstant.START_REPLICATE));
    }

    @Override
    public SrFuture<Void> abortReplicate() throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("DRActivateImpl.abortReplicate");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        try {
            midFutures.add(this.validAndActivate((ChangeConstant)DRActivateConstant.ABORT_REPLICATE));
        }
        catch (UnsupportedOperationException e) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The validAndActivate method should not throw an exception for abort replicate."});
            return new CompleteFuture("DRActivateImpl.abortReplicate");
        }
        catch (IllegalValueException ive) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The validAndActivate method should not throw an exception for abort replicate."});
            return new CompleteFuture("DRActivateImpl.abortReplicate");
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"abort replicate has occured"});
        midFutures.add(((LogicObjectImpl)((Object)this.getClusterElementAccordingToMode())).changeElementForActiveVswitch(new MasterParameter((ParameterCodes)((DRClusterLogicObjectImpl)this.getClusterElementAccordingToMode()).getActivateParameterCode(), (Object)DRActivateConstant.ABORT_REPLICATE)));
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public ClusterImpl getCluster() {
        return null;
    }

    public CommKeyRefMap getCommKeyRefMap() {
        return null;
    }

    public VSwitchImpl[] getConnectedVSwitchesList() {
        return null;
    }
}

