/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterSyncPair;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRRoleConstant;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DRClusterSyncPairImpl
extends DRClusterPairImpl
implements DRClusterSyncPair {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public DRClusterSyncPairImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.SYNC_PAIR, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public HashMap changeParameterList(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        HashMap changedValues = super.changeParameterList(aCED);
        DRRoleConstant role = (DRRoleConstant)changedValues.get(ParameterCode.DR_SYNC_PAIR_ROLE);
        if (role != null) {
            this.setRole(role);
        }
        return changedValues;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    public ParameterCode getActivateParameterCode() {
        return ParameterCode.DR_SYNC_PAIR_ACTIVATE;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        ConfigElementData ced = new ConfigElementData(this.getCommKeys(), this.getClassId());
        if (DRRoleConstant.REMOTE.equals((Object)this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_PRIMARY_ID, (SrType)this.getPrimaryVolumeId());
        } else if (DRRoleConstant.LOCAL.equals((Object)this.getRole())) {
            ced.setValue(ParameterCode.DR_PAIR_SECONDARY_ID, (SrType)this.getSecondaryVolumeId());
        }
        return super.deleteElement(ced);
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        ArrayList<ParameterCode> params = new ArrayList<ParameterCode>();
        params.add(ParameterCode.DR_PAIR_INITIAL_SYNC_TYPE);
        params.add(ParameterCode.DR_PAIR_PRIMARY_ID);
        params.add(ParameterCode.DR_PAIR_SECONDARY_ID);
        params.add(ParameterCode.DR_SYNC_PAIR_ROLE);
        return params;
    }

    @Override
    public ConfigElementDataList synchronize(Map<CommKeyClassId, ConfigElementData> accumulator) throws RemoteException, IllegalValueException {
        ConfigElementDataList cedList = new ConfigElementDataList();
        ConfigElementData elem = this.buildCEDForSynchronization(cedList, accumulator);
        if (elem.getCommKeyClassId().getCommKeys() == null) {
            cedList.add((ElementData)elem);
        }
        return cedList;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.DR_SYNC_PAIR_ACTIVATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_SYNC_PAIR_REPLICATION_STATE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.DR_SYNC_PAIR_ROLE, new ParameterCode.Flags(true, false));
        parameterCodeFlagsMap.put(ParameterCode.SYNC_PAIR_CF, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

