/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster.dr;

import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAbstractConsistencyGroupImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPair;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterAsyncPairImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterExtendedPair;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DRClusterExtendedPairImpl
extends DRClusterAbstractConsistencyGroupImpl
implements DRClusterExtendedPair {
    private DRClusterAsyncPairImpl m_pair = null;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public DRClusterExtendedPairImpl(ClusterImpl cluster, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(cluster, ClassID.EXTENDED_PAIR, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public void addPairToGroup(DRClusterAsyncPairImpl newPair) throws IllegalValueException {
        if (this.m_pair != null) {
            throw new IllegalValueException("The pair was already set. pair: " + this.m_pair);
        }
        this.m_pair = newPair;
    }

    @Override
    public DRClusterAsyncPairImpl getPair() {
        return this.m_pair;
    }

    @Override
    public DRClusterAsyncPair[] getPairs() {
        if (this.m_pair != null) {
            return new DRClusterAsyncPair[]{this.m_pair};
        }
        return null;
    }

    @Override
    public HashMap getClientParameterList() throws RemoteException {
        HashMap parameterList = super.getClientParameterList();
        parameterList.put(ClientParameterCode.DR_EXTENDED_PAIR_PAIR, this.getPair());
        return parameterList;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public String toString() {
        DRClusterAsyncPairImpl pair = this.getPair();
        if (pair != null) {
            return "ExtendedPair:" + ((Object)pair).toString();
        }
        return super.toString();
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        return new ArrayList<ParameterCode>();
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

