/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.cluster;

import com.sanrad.SrCliTestUtils;
import com.sanrad.SrTestUtils;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.concurrent.SrExecutionException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;
import junit.framework.TestCase;

public class ClusterImplTest
extends TestCase {
    private static SrTestUtils myTestUtils;
    private Properties myTestProperties = new Properties();

    public ClusterImplTest() {
        if (myTestUtils == null) {
            myTestUtils = SrTestUtils.getInstance();
        }
        try {
            this.myTestProperties.load(new FileInputStream("test//config//ClusterImplTest.properties"));
        }
        catch (FileNotFoundException exp) {
            exp.printStackTrace();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        SrLogger.init((Properties)new Properties());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddNeighborToDisconnectedVS() {
        Site testSite = null;
        try {
            boolean expThrown = false;
            testSite = myTestUtils.createSite("testSite");
            ClusterImpl testCluster = myTestUtils.createCluster("testCluster", testSite);
            String firstVsIp = this.myTestProperties.getProperty("INVALID_VS_IP");
            ClusterImplTest.assertNotNull((String)"The INVALID_VS_IP property could not be read from the properties file.", (Object)firstVsIp);
            String secondVsIp = this.myTestProperties.getProperty("NEIGHBOR_VS_IP");
            ClusterImplTest.assertNotNull((String)"The NEIGHBOR_VS_IP property could not be read from the properties file.", (Object)secondVsIp);
            String expectedErrMsg1 = "Can not add a neighbor to a disconnected VS.";
            String errMsg1 = this.addClusterVswitch(testCluster, firstVsIp);
            if (expectedErrMsg1.equals(errMsg1)) {
                expThrown = true;
            }
            String expectedErrMsg2 = "Can not add a neighbor to a disconnected BOX_PRODUCT_NAME";
            String errMsg2 = this.addClusterVswitch(testCluster, secondVsIp);
            if (!expThrown && expectedErrMsg2.equals(errMsg2)) {
                expThrown = true;
            }
            this.addClusterVswitch(testCluster, firstVsIp);
            String errorMsg = this.addClusterVswitch(testCluster, secondVsIp);
            if (errorMsg != null && errorMsg.startsWith("Can not add a neighbor to a disconnected")) {
                expThrown = true;
            }
            ClusterImplTest.assertTrue((String)"An exception should have been thrown.", (boolean)expThrown);
        }
        catch (Throwable throwable) {
            myTestUtils.removeSite(testSite);
            throw throwable;
        }
        myTestUtils.removeSite(testSite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddAlivedNbr_AxBx() {
        block3: {
            Site testSite = null;
            try {
                this.cliCleanAllNeighbors();
                String vsIp = this.myTestProperties.getProperty("ADD_NBR_TEST_MASTER_IP");
                String nbrIp = this.myTestProperties.getProperty("ADD_NBR_TEST_NEIGHBOR_IP");
                testSite = myTestUtils.createSite("testSite");
                ClusterImplTest.assertNotNull((String)"failed to create testSite", (Object)testSite);
                ClusterImpl testCluster = myTestUtils.createCluster("testCluster", testSite);
                ClusterImplTest.assertNotNull((String)"failed to create testCluster", (Object)testCluster);
                String vsCreationErrMsg = this.addClusterVswitch(testCluster, vsIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + vsIp + ": " + vsCreationErrMsg), (Object)vsCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                String nbrCreationErrMsg = this.addClusterVswitch(testCluster, nbrIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + nbrIp + ": " + nbrCreationErrMsg), (Object)nbrCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                myTestUtils.waitMillis(5000L);
                this.checkAllNeighborsInCluster(testCluster, vsIp, nbrIp, -1, -1);
                if (testSite == null) break block3;
            }
            catch (Throwable throwable) {
                if (testSite != null) {
                    myTestUtils.removeSite(testSite);
                }
                this.cliCleanAllNeighbors();
                throw throwable;
            }
            myTestUtils.removeSite(testSite);
        }
        this.cliCleanAllNeighbors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddAlivedNbr_AxBv() {
        block3: {
            Site testSite = null;
            try {
                this.cliCleanAllNeighbors();
                SrCliTestUtils cli = myTestUtils.getCliTestUtil();
                String vsIp = this.myTestProperties.getProperty("ADD_NBR_TEST_MASTER_IP");
                String nbrIp = this.myTestProperties.getProperty("ADD_NBR_TEST_NEIGHBOR_IP");
                testSite = myTestUtils.createSite("testSite");
                ClusterImplTest.assertNotNull((String)"failed to create testSite", (Object)testSite);
                ClusterImpl testCluster = myTestUtils.createCluster("testCluster", testSite);
                ClusterImplTest.assertNotNull((String)"failed to create testCluster", (Object)testCluster);
                int nbrSwitchID = 0;
                int vsSwitchID = 1;
                cli.cliAddNeighbor(nbrIp, "admin", "admin", vsIp, nbrSwitchID);
                String vsCreationErrMsg = this.addClusterVswitch(testCluster, vsIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + vsIp + ": " + vsCreationErrMsg), (Object)vsCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                String nbrCreationErrMsg = this.addClusterVswitch(testCluster, nbrIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + nbrIp + ": " + nbrCreationErrMsg), (Object)nbrCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                myTestUtils.waitMillis(5000L);
                this.checkAllNeighborsInCluster(testCluster, vsIp, nbrIp, vsSwitchID, nbrSwitchID);
                if (testSite == null) break block3;
            }
            catch (Throwable throwable) {
                if (testSite != null) {
                    myTestUtils.removeSite(testSite);
                }
                this.cliCleanAllNeighbors();
                throw throwable;
            }
            myTestUtils.removeSite(testSite);
        }
        this.cliCleanAllNeighbors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddVswitch_AvBx() {
        block3: {
            Site testSite = null;
            try {
                this.cliCleanAllNeighbors();
                SrCliTestUtils cli = myTestUtils.getCliTestUtil();
                String vsIp = this.myTestProperties.getProperty("ADD_NBR_TEST_MASTER_IP");
                String nbrIp = this.myTestProperties.getProperty("ADD_NBR_TEST_NEIGHBOR_IP");
                testSite = myTestUtils.createSite("testSite");
                ClusterImplTest.assertNotNull((String)"failed to create testSite", (Object)testSite);
                ClusterImpl testCluster = myTestUtils.createCluster("testCluster", testSite);
                ClusterImplTest.assertNotNull((String)"failed to create testCluster", (Object)testCluster);
                boolean nbrSwitchID = false;
                int vsSwitchID = 1;
                cli.cliAddNeighbor(vsIp, "admin", "admin", nbrIp, vsSwitchID);
                String vsCreationErrMsg = this.addClusterVswitch(testCluster, vsIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + vsIp + ": " + vsCreationErrMsg), (Object)vsCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                myTestUtils.waitMillis(10000L);
                VSwitchImpl vsB = testCluster.getVSwitchByIPAddress(nbrIp);
                VSwitchImpl vsA = testCluster.getVSwitchByIPAddress(vsIp);
                ClusterImplTest.assertNull((String)("Cluster " + testCluster + " contains the neighbor " + nbrIp), (Object)vsB);
                ClusterImplTest.assertNotSame((String)("V-Switch " + vsA + " switch ID is not 1 or 0."), (Object)-1, (Object)vsA.getSwitchID());
                ClusterImplTest.assertFalse((String)("V-Switch " + vsIp + " doesn't have any neighbor"), (boolean)vsA.getNeighborTable().isEmpty());
                if (testSite == null) break block3;
            }
            catch (Throwable throwable) {
                if (testSite != null) {
                    myTestUtils.removeSite(testSite);
                }
                this.cliCleanAllNeighbors();
                throw throwable;
            }
            myTestUtils.removeSite(testSite);
        }
        this.cliCleanAllNeighbors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddVswitch_AvBv() {
        block3: {
            Site testSite = null;
            try {
                this.cliCleanAllNeighbors();
                SrCliTestUtils cli = myTestUtils.getCliTestUtil();
                String vsIp = this.myTestProperties.getProperty("ADD_NBR_TEST_MASTER_IP");
                String nbrIp = this.myTestProperties.getProperty("ADD_NBR_TEST_NEIGHBOR_IP");
                testSite = myTestUtils.createSite("testSite");
                ClusterImplTest.assertNotNull((String)"failed to create testSite", (Object)testSite);
                ClusterImpl testCluster = myTestUtils.createCluster("testCluster", testSite);
                ClusterImplTest.assertNotNull((String)"failed to create testCluster", (Object)testCluster);
                int nbrSwitchID = 0;
                int vsSwitchID = 1;
                cli.cliAddNeighbor(vsIp, "admin", "admin", nbrIp, vsSwitchID);
                cli.cliAddNeighbor(nbrIp, "admin", "admin", vsIp, nbrSwitchID);
                String vsCreationErrMsg = this.addClusterVswitch(testCluster, vsIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + vsIp + ": " + vsCreationErrMsg), (Object)vsCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                myTestUtils.waitMillis(10000L);
                this.checkAllNeighborsInCluster(testCluster, vsIp, nbrIp, vsSwitchID, nbrSwitchID);
                if (testSite == null) break block3;
            }
            catch (Throwable throwable) {
                if (testSite != null) {
                    myTestUtils.removeSite(testSite);
                }
                this.cliCleanAllNeighbors();
                throw throwable;
            }
            myTestUtils.removeSite(testSite);
        }
        this.cliCleanAllNeighbors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddDeadNbr_AxBx() {
        block3: {
            Site testSite = null;
            try {
                this.cliCleanAllNeighbors();
                String vsIp = this.myTestProperties.getProperty("ADD_NBR_TEST_MASTER_IP");
                String nbrIp = this.myTestProperties.getProperty("INVALID_VS_IP");
                testSite = myTestUtils.createSite("testSite");
                ClusterImplTest.assertNotNull((String)"failed to create testSite", (Object)testSite);
                ClusterImpl testCluster = myTestUtils.createCluster("testCluster", testSite);
                ClusterImplTest.assertNotNull((String)"failed to create testCluster", (Object)testCluster);
                String vsCreationErrMsg = this.addClusterVswitch(testCluster, vsIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + vsIp + ": " + vsCreationErrMsg), (Object)vsCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                String nbrCreationErrMsg = this.addClusterVswitch(testCluster, nbrIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + nbrIp + ": " + nbrCreationErrMsg), (Object)nbrCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                myTestUtils.waitMillis(10000L);
                ClusterImplTest.assertNull((String)("CLI: V-Switch " + vsIp + " has a neighbor"), (Object)myTestUtils.getCliTestUtil().cliGetNeighborName(vsIp, "admin", "admin"));
                VSwitchImpl disconnectedVs = testCluster.getVSwitchByIPAddress(nbrIp);
                ClusterImplTest.assertNotNull((String)("Cluster " + testCluster + " doesn't contain the neighbor " + nbrIp), (Object)disconnectedVs);
                VSwitchImpl connectedVs = testCluster.getVSwitchByIPAddress(vsIp);
                ClusterImplTest.assertEquals((String)("V-Switch " + connectedVs + " switch ID is not 1 or 0."), (int)-1, (int)connectedVs.getSwitchID());
                ClusterImplTest.assertNull((String)("V-Switch " + vsIp + " has a neighbor"), (Object)connectedVs.getNeighbor(disconnectedVs));
                if (testSite == null) break block3;
            }
            catch (Throwable throwable) {
                if (testSite != null) {
                    myTestUtils.removeSite(testSite);
                }
                this.cliCleanAllNeighbors();
                throw throwable;
            }
            myTestUtils.removeSite(testSite);
        }
        this.cliCleanAllNeighbors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAddDeadNbr_AvBx() {
        block3: {
            Site testSite = null;
            try {
                this.cliCleanAllNeighbors();
                SrCliTestUtils cli = myTestUtils.getCliTestUtil();
                String vsIp = this.myTestProperties.getProperty("ADD_NBR_TEST_MASTER_IP");
                String nbrIp = this.myTestProperties.getProperty("INVALID_VS_IP");
                int vsSwitchID = 1;
                cli.cliAddNeighbor(vsIp, "admin", "admin", nbrIp, vsSwitchID);
                testSite = myTestUtils.createSite("testSite");
                ClusterImplTest.assertNotNull((String)"failed to create testSite", (Object)testSite);
                ClusterImpl testCluster = myTestUtils.createCluster("testCluster", testSite);
                ClusterImplTest.assertNotNull((String)"failed to create testCluster", (Object)testCluster);
                String vsCreationErrMsg = this.addClusterVswitch(testCluster, vsIp);
                ClusterImplTest.assertNull((String)("Failed to create V-Switch " + vsIp + ": " + vsCreationErrMsg), (Object)vsCreationErrMsg);
                myTestUtils.waitForDiscoveryToComplete();
                this.checkVswitchNbrAndSwitchID(testCluster, vsIp, nbrIp, vsSwitchID);
                myTestUtils.waitMillis(10000L);
                VSwitchImpl disconnectedVs = testCluster.getVSwitchByIPAddress(nbrIp);
                ClusterImplTest.assertNotNull((String)("Cluster " + testCluster + " doesn't contain the neighbor " + nbrIp), (Object)disconnectedVs);
                this.checkVswitchNbrAndSwitchID(testCluster, vsIp, nbrIp, vsSwitchID);
                if (testSite == null) break block3;
            }
            catch (Throwable throwable) {
                if (testSite != null) {
                    myTestUtils.removeSite(testSite);
                }
                this.cliCleanAllNeighbors();
                throw throwable;
            }
            myTestUtils.removeSite(testSite);
        }
        this.cliCleanAllNeighbors();
    }

    private void cliCleanAllNeighbors() {
        String cliVsName;
        SrCliTestUtils cli = myTestUtils.getCliTestUtil();
        String vsIp = this.myTestProperties.getProperty("ADD_NBR_TEST_MASTER_IP");
        String nbrIp = this.myTestProperties.getProperty("ADD_NBR_TEST_NEIGHBOR_IP");
        String cliNbrName = cli.cliGetNeighborName(vsIp, "admin", "admin");
        if (cliNbrName != null) {
            System.out.println("Trying to remove neighbor " + cliNbrName + " from " + vsIp);
            cli.cliRemoveNeighbor(vsIp, "admin", "admin", cliNbrName);
        }
        if ((cliVsName = cli.cliGetNeighborName(nbrIp, "admin", "admin")) != null) {
            System.out.println("Trying to remove neighbor " + cliVsName + " from " + nbrIp);
            cli.cliRemoveNeighbor(nbrIp, "admin", "admin", cliVsName);
        }
    }

    private void checkAllNeighborsInCluster(ClusterImpl cluster, String vsIp, String nbrIp, int vsSwitchID, int nbrSwitchID) {
        this.checkVswitchNbrAndSwitchID(cluster, vsIp, nbrIp, vsSwitchID);
        this.checkVswitchNbrAndSwitchID(cluster, nbrIp, vsIp, nbrSwitchID);
    }

    private void checkVswitchNbrAndSwitchID(ClusterImpl cluster, String vsIp, String nbrIp, int switchId) {
        VSwitchImpl vs = cluster.getVSwitchByIPAddress(vsIp);
        ClusterImplTest.assertNotNull((String)("Cluster " + cluster + " doesn't contain V-Switch " + vsIp), (Object)vs);
        if (switchId != -1) {
            String errMsg = "V-Switch " + vs + " switch ID is " + vs.getSwitchID();
            ClusterImplTest.assertEquals((String)errMsg, (int)vs.getSwitchID(), (int)switchId);
        }
        VSwitchImpl otherVs = cluster.getOtherVSwitch(vs);
        ClusterImplTest.assertEquals((String)("Cluster " + cluster + " doesn't contain the expected neighbor " + nbrIp), (String)nbrIp, (String)otherVs.getMgmIPAddr());
        ClusterImplTest.assertNotNull((String)("The V-Switch " + vs + " doesn't have a neighbor " + otherVs), (Object)vs.getNeighbor(otherVs));
    }

    private String addClusterVswitch(Cluster aCluster, String aVswitchIP) {
        String defIpMask = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK);
        int defRetries = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES));
        int defSnmpPort = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_PORT));
        int defTrapPort = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT));
        String defWriteComm = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY);
        String defReadComm = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY);
        int defTimeout = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC));
        SnmpVersion defVersion = SnmpVersion.V2C;
        try {
            LogicMgrAOImpl.getInstance().addClusterVSwitch(aCluster.getCommKeyClassId(), aVswitchIP, defIpMask, defSnmpPort, defTrapPort, defReadComm, defWriteComm, defTimeout, defRetries, defVersion).get();
            System.out.println("V-Switch " + aVswitchIP + " added to cluster " + aCluster);
        }
        catch (SrExecutionException e) {
            return e.getMessage();
        }
        catch (RemoteException e) {
            ClusterImplTest.fail((String)("The test failed because of the exception: " + e));
        }
        catch (InterruptedException e) {
            ClusterImplTest.fail((String)("The test failed because of the exception: " + e));
        }
        return null;
    }
}

