/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.acl.AclImpl;
import com.sanrad.nms.server.logic.acl.PolicyManager;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;

public class PolicyManagerImpl
extends RemoteObjectImpl
implements PolicyManager {
    private Hashtable aclMap = new Hashtable();
    private static SrLogger theLogger = SrLogger.getLogger();

    public void clear() {
        this.aclMap.clear();
    }

    public void removeAcl(Target target) throws RemoteException {
        if (this.checkForTargetExistance(target)) {
            this.aclMap.remove(target);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Removed an ACL for target - ", target.getAlias()});
        } else {
            theLogger.error(SrLogCategories.LEGACY, new Object[]{"Cannot removed an ACL for non existed target ", target.getAlias()});
        }
    }

    @Override
    public Hashtable getAllAcl() {
        return this.aclMap;
    }

    public boolean isConnectedToTarget(IdentityImpl identity) {
        Enumeration elements = this.aclMap.elements();
        while (elements.hasMoreElements()) {
            AclImpl acl = (AclImpl)elements.nextElement();
            if (!acl.isTargetConnected(identity)) continue;
            return true;
        }
        return false;
    }

    public SrFuture<Void> deleteCorrespondingAclEntries(IdentityImpl identity) throws RemoteException, IllegalValueException {
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        final SrFuture retFuture = new SrFuture("PolicyManagerImpl.deleteCorresponingAclEntries_Identity");
        Enumeration elements = this.aclMap.elements();
        while (elements.hasMoreElements()) {
            AclImpl acl = (AclImpl)elements.nextElement();
            midFutures.add(acl.deleteCorrespondingAclEntries(identity));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    public void newTarget(TargetImpl target) throws RemoteException, IllegalValueException, InvalidElementException {
        if (!this.checkForTargetExistance(target)) {
            ConfigElementData aclCED = new ConfigElementData(ClassID.ACL);
            this.aclMap.put(target, new AclImpl(target, aclCED));
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"create a new ACL for target - ", target.getAlias()});
        } else {
            theLogger.error(SrLogCategories.LEGACY, new Object[]{"Failed to create new ACL for target!!!!"});
        }
    }

    private boolean checkForTargetExistance(Target target) throws RemoteException {
        Set keys = this.aclMap.keySet();
        String targetName = target.getName();
        if (targetName == null) {
            theLogger.error(SrLogCategories.LEGACY, new Object[]{"Trying to create new ACL for target with no name!!!!"});
            return true;
        }
        for (Target targetFromMap : keys) {
            if (!targetFromMap.getName().equals(targetName)) continue;
            theLogger.error(SrLogCategories.LEGACY, new Object[]{"Trying to create new ACL for already existed target: ", targetName});
            return true;
        }
        return false;
    }

    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        int result = 0;
        Enumeration e = this.getAllAcl().keys();
        while (e.hasMoreElements()) {
            Target target = (Target)e.nextElement();
            int retVal = this.synchronizeACLEntries(target);
            if (retVal <= result) continue;
            result = retVal;
        }
        return result;
    }

    private int synchronizeACLEntries(Target target) throws RemoteException, IllegalValueException {
        AclImpl acl = (AclImpl)this.getAllAcl().get(target);
        if (acl != null) {
            return acl.synchronize();
        }
        return 0;
    }
}

