/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.logic.CommKeyRefMap;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SynchronizeEvent;
import com.sanrad.nms.server.logic.SynchronizeListener;
import com.sanrad.nms.server.logic.SynchronizeableImpl;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.AclEntry;
import com.sanrad.nms.server.logic.acl.AclEntryImpl;
import com.sanrad.nms.server.logic.acl.AclEntryValidator;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.operation.CreateElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperation;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.operation.RemoveElementOperation;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.constants.IdentityPurposeConstant;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class AclImpl
extends SynchronizeableImpl
implements Acl,
SynchronizeListener {
    private Hashtable<Integer, AclEntryImpl> m_aclEntries = new Hashtable();
    private TargetImpl m_target;
    private int m_highestPosition = 0;
    private Vector m_operations;
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    public AclImpl(TargetImpl target, ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(target.getCluster(), ClassID.ACL, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.m_target = target;
        this.cluster = target.getCluster();
        this.m_target.addSynchronizeListener(this);
        this.m_operations = new Vector();
    }

    @Override
    public Vector<AclEntryImpl> getEntries() throws RemoteException {
        return this.sortEntriesAccordingtoPositions(this.getExposedOnTargetAclEntriesPositions());
    }

    public Vector getAllACLEntriesSorted() throws RemoteException {
        return this.sortEntriesAccordingtoPositions(this.m_aclEntries.keys());
    }

    public AclEntryImpl getFirstEntry() {
        Enumeration<AclEntryImpl> values = this.m_aclEntries.elements();
        while (values.hasMoreElements()) {
            AclEntryImpl entry = values.nextElement();
            if (entry.getPosition() != 0) continue;
            return entry;
        }
        return null;
    }

    public SrFuture<Void> addAclEntry(AclEntryImpl entry) throws RemoteException {
        IdentityImpl identity = entry.getIdentity();
        if (identity != null) {
            identity.addSynchronizeListener(this);
        }
        Integer pos = entry.getPosition();
        if (!identity.isOfRemoteInitiatorDR()) {
            this.setHighestPostionIfHighest(pos);
        }
        this.m_aclEntries.put(pos, entry);
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Adding an ACL entry.... executing next operation."});
        return this.executeNextOperation();
    }

    public synchronized void setHighestPostionIfHighest(Integer position) {
        if (position > this.m_highestPosition) {
            this.m_highestPosition = position;
        }
    }

    private synchronized int getHighestPosition() {
        return this.m_highestPosition;
    }

    private synchronized int incrementHighestPostion() {
        ++this.m_highestPosition;
        int highestPosition = this.getHighestPosition();
        return highestPosition;
    }

    private Vector<AclEntryImpl> sortEntriesAccordingtoPositions(Enumeration keys) throws RemoteException {
        Vector positions = new Vector();
        Vector<AclEntryImpl> entries = new Vector<AclEntryImpl>();
        while (keys.hasMoreElements()) {
            positions.addElement(keys.nextElement());
        }
        Object[] positionsArray = positions.toArray();
        Arrays.sort(positionsArray);
        for (int i = 0; i < positionsArray.length; ++i) {
            AclEntryImpl entry = this.m_aclEntries.get(positionsArray[i]);
            entries.addElement(entry);
        }
        return entries;
    }

    private Enumeration getExposedOnTargetAclEntriesPositions() throws RemoteException {
        Vector<Integer> entries = new Vector<Integer>();
        Enumeration<Integer> e = this.m_aclEntries.keys();
        while (e.hasMoreElements()) {
            Integer key = e.nextElement();
            AclEntryImpl entry = this.m_aclEntries.get(key);
            if (!entry.isRelevantForExposedTarget() && entry.isRedundant()) continue;
            entries.addElement(key);
        }
        return entries.elements();
    }

    private ConfigElementData prepareAclEntry(IdentityImpl identity, Permission permission, int position) throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"creating a new ACL entry."});
        AclEntryValidator aclEntryValidator = new AclEntryValidator(this, identity, this.m_target);
        if (aclEntryValidator.isValid()) {
            ConfigElementData element = new ConfigElementData(ClassID.ACL_ENTRY);
            if (!identity.isOfRemoteInitiatorDR()) {
                Parameter entryPermission = new Parameter(ParameterCode.ACL_ENTRY_ACCESS, (Object)new SrInteger(permission.intValue()));
                element.addParameter(entryPermission);
                Parameter entryPosition = new Parameter(ParameterCode.ACL_ENTRY_POSITION, (Object)new SrInteger(position));
                element.addParameter(entryPosition);
            }
            CommKeyClassId identCommkeyClassId = new CommKeyClassId(identity.getCommKeys(), ClassID.IDENTITY);
            Parameter identityParam = new Parameter(ParameterCode.ACL_ENTRY_IDENTITY, (Object)identCommkeyClassId);
            element.addParameter(identityParam);
            TargetImpl targetImpl = this.m_target;
            CommKeyClassId targetCommkeyClassId = new CommKeyClassId(targetImpl.getCommKeys(), ClassID.ISCSI_TARGET);
            Parameter targetParam = new Parameter(ParameterCode.ACL_ENTRY_TARGET_PARENT, (Object)targetCommkeyClassId);
            element.addParameter(targetParam);
            return element;
        }
        throw new IllegalValueException(aclEntryValidator.getErrorMsg());
    }

    public SrFuture<Void> createAclEntry(IdentityImpl identity, Permission permission, Integer position, List<VSwitchImpl> vswitches) throws RemoteException {
        AclEntryValidator aclEntryValidator = new AclEntryValidator(this, identity, this.m_target);
        if (aclEntryValidator.isValid()) {
            ConfigElementData element = new ConfigElementData(ClassID.ACL_ENTRY);
            if (permission == null) {
                permission = Permission.READ_WRITE;
            }
            if (!identity.isOfRemoteInitiatorDR()) {
                Parameter entryPermission = new Parameter(ParameterCode.ACL_ENTRY_ACCESS, (Object)new SrInteger(permission.intValue()));
                element.addParameter(entryPermission);
                Parameter entryPosition = new Parameter(ParameterCode.ACL_ENTRY_POSITION, (Object)new SrInteger(position));
                element.addParameter(entryPosition);
            }
            ClusterImpl cluster = identity.getCluster();
            return cluster.createElement(element, permission.toString(), vswitches);
        }
        return new FailedFuture((Exception)((Object)new IllegalValueException(aclEntryValidator.getErrorMsg())), "AclImpl.createAclEntry");
    }

    @Override
    public SrFuture<Void> createAclEntry(CommKeyClassId identityCommKeyClassId, Permission permission, Integer position) throws RemoteException {
        IdentityImpl identity = (IdentityImpl)this.getCommKeyRefMap().getRefByCommKeyClassID(identityCommKeyClassId);
        return this.createAclEntry(identity, permission, position, null);
    }

    public SrFuture<Void> createAclEntry(AclEntry entry, List<VSwitchImpl> vswithces) throws RemoteException {
        IdentityImpl identity = (IdentityImpl)entry.getIdentity();
        Permission permission = entry.getPermission();
        Integer position = entry.getPosition();
        return this.createAclEntry(identity, permission, position, vswithces);
    }

    @Override
    public SrFuture<Void> updateAcl(List data) throws RemoteException, IllegalValueException {
        return this.updateAcl((List<List<Object>>)data, (List<VSwitchImpl>)null);
    }

    public SrFuture<Void> updateAcl(List<List<Object>> data, List<VSwitchImpl> vSwitches) throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ ------ UPDATE ACL !!!!"});
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.toDisplayString()});
        int size = data.size();
        ClusterImpl clusterImpl = this.m_target.getCluster();
        CommKeyRefMap refMap = clusterImpl.getCommKeyRefMap();
        ElementOperationList operationsList = new ElementOperationList();
        for (int i = 0; i < size; ++i) {
            int position;
            List<Object> rowData = data.get(i);
            CommKey[] identityCommKey = rowData.get(0);
            if (identityCommKey instanceof CommKeyClassId) {
                identityCommKey = ((CommKeyClassId)identityCommKey).getCommKeys();
            }
            IdentityImpl identityImpl = (IdentityImpl)refMap.getRefByCommKeyClassID(identityCommKey, ClassID.IDENTITY);
            Permission permission = (Permission)rowData.get(1);
            try {
                Object pos = rowData.get(2);
                position = pos instanceof Integer ? ((Integer)pos).intValue() : this.incrementHighestPostion();
            }
            catch (ArrayIndexOutOfBoundsException aiob) {
                position = this.incrementHighestPostion();
            }
            ConfigElementData element = this.prepareAclEntry(identityImpl, permission, position);
            if (identityImpl.isPurposeUnknown()) {
                ConfigElementData identityElement = new ConfigElementData(identityImpl.getCommKeyClassId());
                Parameter parameter = new Parameter(ParameterCode.IDENTITY_PURPOSE, (Object)IdentityPurposeConstant.REMOTE_INITIATOR);
                identityElement.addParameter(parameter);
                ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().changeElement(identityElement));
            }
            CreateElementOperation createOperation = new CreateElementOperation(element);
            operationsList.addElement((ElementOperation)createOperation);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"create operation was added to operation list: ", createOperation});
        }
        boolean isConnectedVswitchesConflict = false;
        if (vSwitches == null) {
            ArrayList<VSwitchImpl> vSwitchesOfNotRedundantEntries = null;
            String msgForVSwitchConflicts = "The Access Control List is not synchronized within the cluster. Please perform \"Cluster Synchronize\".";
            Enumeration<AclEntryImpl> values = this.m_aclEntries.elements();
            while (values.hasMoreElements()) {
                boolean tryToRemoveEntry = true;
                AclEntryImpl entry = values.nextElement();
                if (entry.isEntryForDRRemoteInitiator() || entry.isEntryForDRIdentityAll() || entry.isDefAll()) continue;
                entry.setChangePosition(true);
                if (!entry.isRedundant()) {
                    List<VSwitchImpl> connectedVSwitches = entry.getConnectedVSwitchesAsList();
                    VSwitchImpl vSwitch = connectedVSwitches.get(0);
                    tryToRemoveEntry = vSwitch.isConnected();
                    if (tryToRemoveEntry) {
                        if (vSwitchesOfNotRedundantEntries != null && !vSwitchesOfNotRedundantEntries.contains(vSwitch)) {
                            throw new IllegalValueException(msgForVSwitchConflicts);
                        }
                        if (vSwitchesOfNotRedundantEntries == null) {
                            vSwitchesOfNotRedundantEntries = new ArrayList<VSwitchImpl>();
                            vSwitchesOfNotRedundantEntries.add(vSwitch);
                        }
                    }
                } else if (vSwitchesOfNotRedundantEntries != null && !vSwitchesOfNotRedundantEntries.isEmpty()) {
                    throw new IllegalValueException(msgForVSwitchConflicts);
                }
                if (!tryToRemoveEntry) continue;
                if (entry.getCommKeys().length > 0) {
                    ConfigElementData ced = new ConfigElementData(entry.getCommKeys(), entry.getClassId());
                    RemoveElementOperation removeOperation = new RemoveElementOperation(ced);
                    operationsList.addElement((ElementOperation)removeOperation);
                    theLogger.trace(SrLogCategories.LEGACY, new Object[]{"remove operation was added to operation list: ", removeOperation});
                }
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{entry.getClassId(), " ", entry, " with no CommKey was found when  trying to create a RemoveElementOperation object"});
            }
            if (vSwitchesOfNotRedundantEntries != null && !vSwitchesOfNotRedundantEntries.isEmpty()) {
                vSwitches = vSwitchesOfNotRedundantEntries;
            }
        }
        return clusterImpl.executeOperations(operationsList, vSwitches);
    }

    public SrFuture<Void> updateAcl(List<List<Object>> data, VSwitchImpl vSwitch) throws RemoteException, IllegalValueException {
        ArrayList<VSwitchImpl> vSwitches = null;
        if (vSwitch != null) {
            vSwitches = new ArrayList<VSwitchImpl>();
            vSwitches.add(vSwitch);
        }
        return this.updateAcl(data, vSwitches);
    }

    private Integer getNextPosition(Vector sortedACLEntries, int startFrom, VSwitchImpl vSwitch) throws RemoteException {
        int prevPosition = 0;
        AclEntryImpl aclEntry = null;
        for (int i = startFrom - 1; i > 0; --i) {
            aclEntry = (AclEntryImpl)sortedACLEntries.elementAt(i);
            if (aclEntry.isDefAll() || !aclEntry.isKnownByVSwitch(vSwitch)) continue;
            prevPosition = aclEntry.getPosition(vSwitch);
            break;
        }
        if (aclEntry != null && (aclEntry.isEntryForDRIdentityAll() || aclEntry.isEntryForDRRemoteInitiator())) {
            return null;
        }
        return new Integer(++prevPosition);
    }

    private int synchronizeACLEntries() throws RemoteException, IllegalValueException {
        int result = 0;
        Vector sortedACLEntries = this.getAllACLEntriesSorted();
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        VSwitchImpl otherVSwitch = null;
        Enumeration e = sortedACLEntries.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl aclEntry = (AclEntryImpl)e.nextElement();
            if (aclEntry.isRedundant() || aclEntry.isSynchronizePending()) continue;
            aclEntry.setSynchronizePending(true);
            VSwitchImpl[] connectedVSwitches = aclEntry.getConnectedVSwitches();
            VSwitchImpl connectedVSwitch = connectedVSwitches[0];
            if (!connectedVSwitch.isConnected()) continue;
            VSwitchImpl vSwitch = aclEntry.getCluster().getOtherVSwitch(connectedVSwitch);
            if (otherVSwitch == null) {
                otherVSwitch = vSwitch;
            }
            int entryIndex = sortedACLEntries.indexOf(aclEntry);
            Integer nextPosition = this.getNextPosition(sortedACLEntries, entryIndex, otherVSwitch);
            Vector<Object> rowData = new Vector<Object>();
            IdentityImpl identity = aclEntry.getIdentity();
            rowData.add(identity.getCommKeys());
            if (!aclEntry.isEntryForDRIdentityAll() && !aclEntry.isEntryForDRRemoteInitiator()) {
                rowData.add(aclEntry.getPermission());
            } else {
                rowData.add(null);
            }
            if (nextPosition != null) {
                Integer position = new Integer(nextPosition + data.size());
                rowData.add(position);
            } else {
                rowData.add(null);
            }
            data.add(rowData);
        }
        if (data.size() > 0) {
            ErrorAssertingListener.listenTo(this.updateAcl(data, otherVSwitch));
        }
        return result;
    }

    private SrFuture<Void> executeNextOperation() throws RemoteException {
        if (this.m_operations.isEmpty()) {
            return new CompleteFuture("AclImpl.executeNextOperation");
        }
        Object operation = this.m_operations.remove(0);
        if (operation instanceof ElementOperation) {
            ConfigElementData element = ((ElementOperation)operation).getElement();
            ClusterImpl clusterImpl = this.m_target.getCluster();
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"EXECUTING CREATE ACL_ENTRY: ", element.getSnmpKey()});
            return clusterImpl.createElement(element, ClassID.ACL_ENTRY, element.getValue((ParameterCodes)ParameterCode.ACL_ENTRY_ACCESS).toString(), null);
        }
        try {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"EXECUTING REMOVE ACL_ENTRY "});
            return ((AclEntryImpl)operation).deleteElement();
        }
        catch (IllegalValueException e) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)((Object)e), new Object[]{"Could not delete Acl Entry "});
            return new FailedFuture((Exception)((Object)e), "AclImpl.executeNextOperation");
        }
    }

    @Override
    public TargetImpl getTargetParent() {
        return this.m_target;
    }

    public boolean isTargetConnected(IdentityImpl identity) {
        Enumeration<AclEntryImpl> elements = this.m_aclEntries.elements();
        while (elements.hasMoreElements()) {
            AclEntryImpl aclEntry = elements.nextElement();
            if (!aclEntry.getIdentity().equals(identity)) continue;
            return true;
        }
        return false;
    }

    public SrFuture<Void> deleteCorrespondingAclEntries(IdentityImpl identity) throws RemoteException, IllegalValueException {
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        final SrFuture retFuture = new SrFuture("AclImpl.deleteCorresponingAclEntries");
        Enumeration<AclEntryImpl> elements = this.m_aclEntries.elements();
        while (elements.hasMoreElements()) {
            AclEntryImpl aclEntry = elements.nextElement();
            if (!aclEntry.getIdentity().equals(identity)) continue;
            midFutures.add(aclEntry.deleteElement());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    public AclEntryImpl getEntry(IdentityImpl identity, Permission permission, int position, boolean includePos) {
        Enumeration<AclEntryImpl> entries = this.m_aclEntries.elements();
        while (entries.hasMoreElements()) {
            AclEntryImpl entry = entries.nextElement();
            String identityAlias = identity.getAlias();
            if (entry.getIdentity() == null || !identityAlias.equals(entry.getIdentity().getAlias())) continue;
            if (identityAlias.equals("DEF_ALL")) {
                return this.m_aclEntries.get(new Integer(0));
            }
            if (entry.isChangePosition()) {
                if (entry.getPosition() != position) continue;
                entry.setChangePosition(false);
                return entry;
            }
            return entry;
        }
        return null;
    }

    public SrFuture<Void> removeAclEntry(AclEntry aclEntry) throws RemoteException {
        AclEntryImpl removed = this.m_aclEntries.remove(aclEntry.getPosition());
        if (removed == null) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"COULD NOT DELETE ACL ENTRY FROM THE LIST OF ENTRIES !!!!!!!!!!!!"});
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Removing an ACL entry ", aclEntry.toString(), " .... executing next operation."});
        return this.executeNextOperation();
    }

    @Override
    public HashMap checkConsistencyBetweenVSwitches() {
        HashMap<AclEntryImpl, HashMap> inconsistentValues = new HashMap<AclEntryImpl, HashMap>();
        Enumeration<AclEntryImpl> values = this.m_aclEntries.elements();
        while (values.hasMoreElements()) {
            HashMap map;
            AclEntryImpl entry = values.nextElement();
            if (entry.isDefAll() || (map = entry.checkConsistencyBetweenVSwitches()) == null || map.isEmpty()) continue;
            inconsistentValues.put(entry, map);
        }
        return inconsistentValues;
    }

    public HashMap isOrdered() throws RemoteException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"checking order of positions"});
        HashMap map = this.checkConsistencyBetweenVSwitches();
        Vector<AclEntryImpl> sorted = this.sortEntriesAccordingtoPositions(this.m_aclEntries.keys());
        VSwitchImpl[] vSwitches = this.m_target.getConnectedVSwitches();
        if (vSwitches.length > 1) {
            int[] order = new int[vSwitches.length];
            for (int j = 1; j < sorted.size(); ++j) {
                AclEntryImpl entry = sorted.get(j);
                for (int i = 0; i < vSwitches.length; ++i) {
                    if (!entry.isKnownByVSwitch(vSwitches[i])) continue;
                    Integer pos = entry.getPosition(vSwitches[i]);
                    if (pos > order[i]) {
                        order[i] = pos;
                        continue;
                    }
                    theLogger.trace(SrLogCategories.LEGACY, new Object[]{"order of positions is wrong: "});
                    HashMap<ParameterCode, AclEntryImpl> value = new HashMap<ParameterCode, AclEntryImpl>(1);
                    value.put(ParameterCode.ACL_ENTRY_POSITION, entry);
                    map.put(entry, value);
                }
            }
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"order of positions is OK"});
        }
        return map;
    }

    public List<String> isDefaultAccessInconsistent() {
        AclEntryImpl entry = this.m_aclEntries.get(new Integer(0));
        if (entry != null) {
            Permission access = entry.getPermission();
            VSwitchImpl[] vswitches = entry.getConnectedVSwitches();
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < vswitches.length; ++i) {
                Permission nextPermission = entry.getPermission(vswitches[i]);
                if (access.equals(nextPermission)) continue;
                values.add(access.toString());
                values.add(nextPermission.toString());
                return values;
            }
        }
        return null;
    }

    @Override
    protected String canBeSynchronized() throws RemoteException, IllegalValueException {
        if (this.m_target.isNeedToSynchronize()) {
            if (!this.m_target.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("ACL ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(this.m_target.getClassId());
                msg.append(" ");
                msg.append(this.m_target);
                msg.append(" is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Target " + this.m_target.getAlias() + " is not synchronized yet.";
            return msg;
        }
        Enumeration<AclEntryImpl> e = this.m_aclEntries.elements();
        while (e.hasMoreElements()) {
            IdentityImpl identity;
            AclEntryImpl aclEntry = e.nextElement();
            if (aclEntry.isRedundant() || !(identity = aclEntry.getIdentity()).isNeedToSynchronize()) continue;
            if (!identity.isSynchronizePending()) {
                StringBuffer msg = new StringBuffer("ACL ");
                msg.append(this.toString());
                msg.append(" cannot be synchronized. ");
                msg.append(identity.getClassId());
                msg.append(" ");
                msg.append(identity);
                msg.append(" is not synchronized yet");
                throw new IllegalValueException(msg.toString());
            }
            String msg = "Identity " + identity + " is not synchronized yet.";
            return msg;
        }
        return null;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Start Sync of ACL ", this.toString()});
        if (this.isSynchronizePending()) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Already synchronizing ", this.getClassId(), " ", this.toString()});
            return 1;
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Start to synchronize ", this.getClassId(), " ", this.toString()});
        this.setSynchronizePending(true);
        int retVal = 0;
        try {
            if (!this.isNeedToSynchronize()) {
                this.setSynchronizePending(false);
                return retVal;
            }
            retVal = this.synchronizeMe();
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Sync of ACL ", this.toString(), " SyncMe status ", retVal});
            return retVal;
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive.getMessage()});
            this.setSynchronizePending(false);
            throw ive;
        }
    }

    @Override
    protected String isValid(HashMap parameterList) {
        return null;
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        return null;
    }

    @Override
    public void registerToPropagatedStateChange() {
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    public String toDisplayString() throws RemoteException {
        Vector<AclEntryImpl> entries = this.sortEntriesAccordingtoPositions(this.m_aclEntries.keys());
        StringBuffer sb = new StringBuffer("Entries: ");
        for (int i = 0; i < entries.size(); ++i) {
            AclEntry entry = entries.get(i);
            if (entry.getIdentity() != null) {
                sb.append(entry.getIdentity().getAlias());
            }
            sb.append(", ");
            sb.append(entry.getPermission().toString());
            sb.append(", ");
            sb.append(entry.getPosition());
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<AclEntryImpl> getNotRedundantACLEntries() throws RemoteException {
        ArrayList<AclEntryImpl> notRedundantACLEntries = null;
        Enumeration<AclEntryImpl> e = this.m_aclEntries.elements();
        while (e.hasMoreElements()) {
            AclEntryImpl aclEntry = e.nextElement();
            if (aclEntry.isRedundant() || aclEntry.isDefAll()) continue;
            if (notRedundantACLEntries == null) {
                notRedundantACLEntries = new ArrayList<AclEntryImpl>();
            }
            notRedundantACLEntries.add(aclEntry);
        }
        return notRedundantACLEntries;
    }

    @Override
    public int synchronizeMe() throws RemoteException, IllegalValueException {
        String msg = this.canBeSynchronized();
        if (msg != null) {
            return 2;
        }
        theLogger.info(SrLogCategories.LEGACY, new Object[]{"Sync Me for ACL ", this.toString()});
        this.synchronizeACLEntries();
        return 2;
    }

    @Override
    public String getAlias() {
        return this.getAlias(null);
    }

    @Override
    public String getAlias(VSwitchImpl vSwitch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void synchronizingCompleted(SynchronizeEvent e) {
        if (!this.isSynchronizePending()) {
            return;
        }
        try {
            if (this.isNeedToSynchronize()) {
                this.synchronizeMe();
                return;
            }
            this.doneSynchronizing();
        }
        catch (IllegalValueException ive) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
            this.errorInSynchronizing();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
            this.errorInSynchronizing();
        }
    }

    public int getHighestACLEntryPositionForDR() {
        return this.getHighestPosition() + 1;
    }

    @Override
    protected ArrayList<ParameterCode> getParamsForCreation() {
        return new ArrayList<ParameterCode>();
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

