/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic.acl;

import com.sanrad.nms.server.logic.ErrorMessage;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import java.rmi.RemoteException;
import java.util.List;

public class AclEntryValidator
extends LogicObjectValidator {
    private IdentityImpl m_identity;
    private TargetImpl m_target;

    public AclEntryValidator(Acl acl, IdentityImpl identity, TargetImpl target) {
        this.m_identity = identity;
        this.m_target = target;
    }

    @Override
    public boolean isValid() throws RemoteException {
        List<VSwitchImpl> targetConnectedVSwitches = this.m_target.getConnectedVSwitchesAsList();
        List<VSwitchImpl> identityConnectedVSwitches = this.m_identity.getConnectedVSwitchesAsList();
        int numOfVSwitchesFoundInIdentity = 0;
        for (int index = 0; index < targetConnectedVSwitches.size(); ++index) {
            VSwitchImpl vs = targetConnectedVSwitches.get(index);
            if (!identityConnectedVSwitches.contains(vs)) continue;
            ++numOfVSwitchesFoundInIdentity;
        }
        if (numOfVSwitchesFoundInIdentity == 0) {
            String[] msg = new String[]{this.m_identity.getAlias()};
            this.setErrorMsg(ErrorMessage.IDENTITY_NOT_DEFINED_ON_TARGET_VSWITCHES.getMessage(msg));
            return false;
        }
        return true;
    }
}

