/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.logic.ParametersMap;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class VSwitchMap {
    private Map<VSwitch, ParametersMap> data = new HashMap<VSwitch, ParametersMap>();

    public VSwitchMap(VSwitch[] vswitches, ParameterCode[] codes) {
        this(vswitches, Arrays.asList(codes));
    }

    public VSwitchMap(VSwitch[] vswitches, Collection<ParameterCode> aParameterCodes) {
        for (VSwitch vSwitch : vswitches) {
            this.data.put(vSwitch, new ParametersMap(aParameterCodes));
        }
    }

    public SrType get(VSwitch vswitch, ParameterCode code) {
        if (this.data.get(vswitch) == null) {
            return null;
        }
        return this.data.get(vswitch).get(code);
    }

    public SrType[] getArray(VSwitch vswitch, ParameterCode code) {
        if (this.data.get(vswitch) == null) {
            return null;
        }
        return this.data.get(vswitch).getArray(code);
    }

    public SrType[] set(VSwitch vswitch, ParameterCode code, SrType value) {
        ParametersMap map = this.data.get(vswitch);
        if (map == null) {
            map = new ParametersMap();
            this.data.put(vswitch, map);
            return map.set(code, value);
        }
        return map.set(code, value);
    }

    public Map<ParameterCode, SrType[]> add(VSwitch aVswitch, Collection<ParameterCode> aCodes) {
        HashMap<ParameterCode, SrType[]> retVal = new HashMap<ParameterCode, SrType[]>(aCodes.size());
        for (ParameterCode code : aCodes) {
            retVal.put(code, this.set(aVswitch, code, (SrType[])null));
        }
        return retVal;
    }

    public SrType[] set(VSwitch vswitch, ParameterCode code, SrType[] value) {
        ParametersMap map = this.data.get(vswitch);
        if (map == null) {
            map = new ParametersMap();
            this.data.put(vswitch, map);
            return map.set(code, value);
        }
        map.set(code, value);
        return value;
    }

    public Collection<VSwitch> getVSwitches() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public ParameterCode[] getCodes() {
        HashSet<ParameterCode> codes = new HashSet<ParameterCode>();
        for (VSwitch vSwitch : this.getVSwitches()) {
            ParameterCode[] parameterCodes;
            for (ParameterCode parameterCode : parameterCodes = this.data.get(vSwitch).getCodes()) {
                codes.add(parameterCode);
            }
        }
        return (ParameterCode[])codes.toArray();
    }
}

