/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.DebugLogObject;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.event.SrClusterDiscoveryCompletedEvent;
import com.sanrad.nms.server.event.SrEventObject;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.dr.DRRoot;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationMgr;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationMgrImpl;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.DataBaseCommKey;
import com.sanrad.nms.server.util.FileInterface;
import com.sanrad.nms.server.util.FileInterfaceImpl;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrDebugLogObject;
import com.sanrad.util.Util;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class SystemRootImpl
extends SiteImpl
implements SystemRoot {
    private static SrLogger theLogger = SrLogger.getLogger();
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private static int NO_INFO;
    private static int ERROR;
    private static int INFO;
    private static SystemRootImpl theInstance;
    private Hashtable invalidNeighbors = new Hashtable();
    private static int NEXT_VSWITCH_GROUP_ID;
    private static final int ROOT_ID = -1;
    private boolean m_siteSynchAfterDiscovery = false;
    private DRRootImpl drRoot;
    private boolean m_isDBDiscoveryCompleted = false;
    private FileInterfaceImpl m_fileInterface = null;
    private Object m_alaramsUpdateLock = new Object();

    private SystemRootImpl(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        super(aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        this.toStringValue = Server.SYS_ROOT_SITE_NAME;
        this.drRoot = DRRootImpl.getInstance();
        this.setFileInterfaceSupport();
    }

    public static synchronized SystemRootImpl getInstance() {
        if (theInstance == null) {
            try {
                CommKeyClassId commKeyClassId = new CommKeyClassId((CommKey)new DataBaseCommKey(Integer.toString(-1)), ClassID.SITE);
                ConfigElementData ced = new ConfigElementData(commKeyClassId);
                ced.setValue(ParameterCode.VSWITCH_GROUP_ID, (SrType)new SrInteger(-1));
                ced.setValue(ParameterCode.PARENT_SITE_ID, (SrType)((CommKeyClassId)null));
                ced.setValue(ParameterCode.SITE_ALIAS, (SrType)new SrString(Server.PRODUCT_NAME));
                theInstance = new SystemRootImpl(ced);
                theInstance.changeParameterList(ced);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
                throw new IllegalStateException("Caught a remote exception during init.", re);
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
                throw new IllegalStateException("Caught an IllegalValueException during init.", (Throwable)((Object)ive));
            }
            catch (InvalidElementException iee) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{iee});
                throw new IllegalStateException("Caught an InvalidElementException during init.", (Throwable)((Object)iee));
            }
        }
        return theInstance;
    }

    public Object getAlarmsUpdateLock() {
        return this.m_alaramsUpdateLock;
    }

    public Object getRefByStub(CommKey[] commKeys, ClassID classId) {
        Object ret;
        block2: {
            SiteImpl site;
            if (classId.equals((Object)ClassID.CLUSTER) || classId.equals((Object)ClassID.SITE)) {
                return LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(commKeys, classId);
            }
            ret = this.findRefByStubInSite(this, commKeys, classId);
            if (ret != null) break block2;
            Iterator<SiteImpl> i$ = this.getSiteChildren().iterator();
            while (i$.hasNext() && (ret = this.findRefByStubInSite(site = i$.next(), commKeys, classId)) == null) {
            }
        }
        return ret;
    }

    private Object findRefByStubInSite(SiteImpl site, CommKey[] commKeys, ClassID classId) {
        for (ClusterImpl cluster : site.getClusters()) {
            Object obj = cluster.getCommKeyRefMap().getRefByCommKeyClassID(commKeys, classId);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public Object getRefByStub(CommKeyClassId data) {
        return this.getRefByStub(data.getCommKeys(), data.getClassID());
    }

    public Cluster getClusterOfVSwitch(String vSwitchIp) throws RemoteException {
        for (ClusterImpl cluster : this.getClustersRecursively()) {
            if (!cluster.isContainVSwitch(vSwitchIp)) continue;
            return cluster;
        }
        return null;
    }

    @Override
    protected void sendEventToAllClusters(SrClusterDiscoveryCompletedEvent event) throws RemoteException, InvalidElementException {
        super.sendEventToAllClusters(event);
        if (this.getClustersRecursively().isEmpty()) {
            SystemRootImpl.setStatusReady();
            theLogger.debug(SrLogCategories.INFORMATIVE, (DebugLogObject)new SrDebugLogObject("SystemDiscoveryCompletedEvent was sent to client", (SrEventObject)event));
            LogicMgrAOImpl.getInstance().__systemDiscoveryCompleted(new ElementEventImpl((Object)this, this));
        }
    }

    public VSwitchGroup changeVSwitchGroup(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchGroupImpl vSwitchGroup = LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(aCED.getCommKey(), aCED.getClassId());
        HashMap changedValues = vSwitchGroup.changeParameterList(aCED);
        ElementEventImpl elementEvent = new ElementEventImpl((Object)vSwitchGroup, vSwitchGroup);
        elementEvent.setParameterList(changedValues);
        LogicMgrAOImpl.getInstance().__elementChanged(elementEvent);
        StringBuffer debugMsg = new StringBuffer(vSwitchGroup.getClassId().toString());
        debugMsg.append(" ");
        debugMsg.append(vSwitchGroup);
        debugMsg.append(" was changed");
        theLogger.info(SrLogCategories.LEGACY, new Object[]{debugMsg});
        return vSwitchGroup;
    }

    public VSwitchGroupImpl removeVSwitchGroup(ConfigElementData ced) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchGroupImpl vSwitchGroup = LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(ced.getCommKey(), ced.getClassId());
        AlarmMgrImpl.getInstance().removeAlarmList(vSwitchGroup);
        DrAlarmMgrImpl.getInstance().removeAlarmList(vSwitchGroup);
        LogicMgrAOImpl.removeVSwitchGroup(vSwitchGroup);
        vSwitchGroup.getParentSite().removeVSwitchGroup(vSwitchGroup);
        this.drRoot.processEvent(vSwitchGroup, 3);
        this.removePropagationStateDependentObjectAndListener(vSwitchGroup);
        ElementEventImpl elementEvent = new ElementEventImpl((Object)vSwitchGroup, vSwitchGroup);
        LogicMgrAOImpl.getInstance().__elementRemoved(elementEvent);
        StringBuffer debugMsg = new StringBuffer(vSwitchGroup.getClassId().toString());
        debugMsg.append(" ");
        debugMsg.append(this.cluster);
        debugMsg.append(" was removed");
        theLogger.info(SrLogCategories.LEGACY, new Object[]{debugMsg});
        return vSwitchGroup;
    }

    public boolean isVSwitchAlreadyManaged(String ip) throws RemoteException {
        return this.getClusterOfVSwitch(ip) != null;
    }

    public void notifyDRDiscoveryCompleted() throws RemoteException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"SystemDiscoveryCompletedEvent was sent to client"});
        LogicMgrAOImpl.getInstance().__systemDiscoveryCompleted(new ElementEventImpl((Object)this, this));
    }

    public synchronized SrFuture<Void> notifyClusterDiscoveryCompleted(ClusterImpl cluster) throws RemoteException {
        final SrFuture retFuture = new SrFuture("SystemRootImpl.notifyClusterDiscoveryCompleted");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        SystemRootImpl.setStatusMsg("Cluster " + cluster + " discovery completed", INFO);
        for (VSwitchImpl vSwitch : cluster.getVSwitches()) {
            String invalidIp;
            if (vSwitch.isNeighborValid() || this.invalidNeighbors.containsKey(invalidIp = vSwitch.getInvalidNeighborIp())) continue;
            String vSwitchIp = vSwitch.getMgmIPAddr();
            this.invalidNeighbors.put(vSwitchIp, invalidIp);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{ClassID.VSWITCH, " ", invalidIp, " is invalid neighbor of ", vSwitchIp, " they belong to different clusters"});
        }
        if (!this.isDiscoverCompleted()) {
            retFuture.set(null);
            return new CompleteFuture("The notifyClusterDiscoveryCompleted was called when there are other clusters whose discovery was not completed yet.");
        }
        SystemRootImpl.setStatusReady();
        Enumeration e = this.invalidNeighbors.keys();
        while (e.hasMoreElements()) {
            String vSwitchIp = (String)e.nextElement();
            VSwitchImpl vSwitch = (VSwitchImpl)this.getVSwitchByIPAddress(vSwitchIp);
            String invalidNeighbor = (String)this.invalidNeighbors.get(vSwitchIp);
            ClusterImpl cl = (ClusterImpl)this.getClusterOfVSwitch(invalidNeighbor);
            if (cl == null) continue;
            VSwitchImpl invalidVSwitch = cl.getVSwitchByIPAddress(invalidNeighbor);
            try {
                theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Trying to move ", invalidVSwitch, " from cluster ", cl, " to cluster ", vSwitch.getCluster()});
                midFutures.add(invalidVSwitch.moveToCluster(vSwitch.getCluster().getVSwitchGroupId()));
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
            }
        }
        this.invalidNeighbors.clear();
        if (!this.m_siteSynchAfterDiscovery) {
            this.m_siteSynchAfterDiscovery = true;
            midFutures.add(this.synchronizeSitesForDRPurpose());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> synchronizeSitesForDRPurpose() throws RemoteException {
        final SrFuture retFuture = new SrFuture("SystemRootImpl.synchronizeForDRPurpose");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        ArrayList<SiteImpl> allSites = this.getSites();
        ArrayList<ClusterImpl> allClusters = new ArrayList<ClusterImpl>();
        for (int index = 0; index < allSites.size(); ++index) {
            SiteImpl site = allSites.get(index);
            allClusters.addAll(site.getClusters());
        }
        for (int index1 = 0; index1 < allClusters.size(); ++index1) {
            ClusterImpl currentCluster = (ClusterImpl)allClusters.get(index1);
            midFutures.add(currentCluster.synchronizeForDRPurpose());
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public VSwitch getVSwitchByIPAddress(String vSwitchIp) throws RemoteException {
        for (ClusterImpl cluster : this.getClustersRecursively()) {
            VSwitchImpl vSwitch = cluster.getVSwitchByIPAddress(vSwitchIp);
            if (vSwitch == null) continue;
            return vSwitch;
        }
        return null;
    }

    public static void setStatusReady() {
        SystemRootImpl.setStatusMsg("Ready", INFO);
    }

    public static void setStatusInProcess(String processMsg) {
        SystemRootImpl.setStatusMsg(processMsg, "In process...", NO_INFO);
    }

    public static void addToStatusMessage(String addMsg) {
        StringBuffer msg = new StringBuffer(addMsg);
        msg.append(addMsg);
        SystemRootImpl.setStatusInProcess(msg.toString());
    }

    @Override
    public String getAlias() {
        return this.toStringValue;
    }

    public static void setStatusError(String errorMsg) {
        SystemRootImpl.setStatusMsg(errorMsg, ERROR);
    }

    private static void setStatusMsg(String msg, int level) {
        SystemRootImpl.setStatusMsg(msg, msg, level);
    }

    private static void setStatusMsg(String msg, String trayIconMsg, int level) {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{level, " ", msg});
    }

    @Override
    public DRRoot getDRRoot() throws RemoteException {
        return this.drRoot;
    }

    public synchronized int getNextVSwitchGroupId() throws RemoteException {
        for (VSwitchGroup vSwitchGroup : this.getAllVSwitchGroups()) {
            int vSwitchGroupId = vSwitchGroup.getVSwitchGroupId();
            NEXT_VSWITCH_GROUP_ID = Math.max(NEXT_VSWITCH_GROUP_ID, vSwitchGroupId);
        }
        int retVal = ++NEXT_VSWITCH_GROUP_ID;
        return retVal;
    }

    public ArrayList getAllVSwitchGroups() {
        ArrayList<VSwitchGroupImpl> allVSwitchGroups = new ArrayList<VSwitchGroupImpl>(this.getVSwitchGroups());
        for (VSwitchGroupImpl vSwitchGroup : this.getVSwitchGroups()) {
            if (!vSwitchGroup.getClassId().equals((Object)ClassID.SITE)) continue;
            allVSwitchGroups.addAll(((SiteImpl)vSwitchGroup).getVSwitchGroups());
        }
        return allVSwitchGroups;
    }

    public boolean isSiteAliasExists(String alias) {
        for (SiteImpl site : this.getSites()) {
            if (!site.getAlias().equals(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDiscoverCompleted() throws RemoteException {
        if (!this.m_isDBDiscoveryCompleted) {
            return false;
        }
        ArrayList<VSwitchGroupImpl> vSwitchGroups = this.getVSwitchGroups();
        for (int i = 0; i < vSwitchGroups.size(); ++i) {
            VSwitchGroup currVSwitchGroup = vSwitchGroups.get(i);
            if (currVSwitchGroup.isDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    public TargetImpl getTarget(String targetName) throws RemoteException {
        for (ClusterImpl currCluster : this.getClustersRecursively()) {
            ISCSITargetImpl target = currCluster.getTargetListMgr().getTargetByName(targetName);
            if (target == null) continue;
            return target;
        }
        return null;
    }

    public void setDBDiscoveryCompleted(SrClusterDiscoveryCompletedEvent aEventQueueElement) throws RemoteException, InvalidElementException {
        this.m_isDBDiscoveryCompleted = true;
        this.sendEventToAllClusters(aEventQueueElement);
    }

    @Override
    public void exportConfigurationFile() throws RemoteException {
        StringBuffer pathToXmlDirectory = new StringBuffer();
        pathToXmlDirectory.append(Util.getLocalDir());
        pathToXmlDirectory.append('\\');
        pathToXmlDirectory.append(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SERVER_CONFIG_DIR_NAME));
        try {
            this.compressFiles(pathToXmlDirectory.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void importConfigurationFile() throws RemoteException {
    }

    private void compressFiles(String pathToXmlDirectory) throws IOException {
        StringBuffer sb = new StringBuffer(pathToXmlDirectory);
        sb.append('\\');
        sb.append(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.EXPORT_CONFIGURATION_FILE_NAME));
        String zipName = sb.toString();
        BufferedInputStream origin = null;
        int BUFFER = 2048;
        byte[] data = new byte[2048];
        FileOutputStream dest = new FileOutputStream(zipName);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
        File dir = new File(pathToXmlDirectory);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            int count;
            if (!files[i].toString().endsWith(".xml")) continue;
            FileInputStream fi = new FileInputStream(files[i]);
            origin = new BufferedInputStream(fi, 2048);
            ZipEntry entry = new ZipEntry(files[i].getName());
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            origin.close();
        }
        out.close();
    }

    private void setFileInterfaceSupport() {
        try {
            this.m_fileInterface = new FileInterfaceImpl();
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[]{"FileServer: " + re.getMessage()});
        }
    }

    @Override
    public FileInterface getFileInterface() throws RemoteException {
        return this.m_fileInterface;
    }

    @Override
    public SrStorageNotificationMgr getStorageNotificationManager() throws RemoteException {
        return SrStorageNotificationMgrImpl.getInstance();
    }

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        NO_INFO = 0;
        ERROR = 1;
        INFO = 2;
        theInstance = null;
        NEXT_VSWITCH_GROUP_ID = 0;
    }
}

