/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmGenerator;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.event.SrClusterDiscoveryCompletedEvent;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SiteValidator;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.ClusterValidator;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchValidator;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrDouble;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.FailedFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SiteImpl
extends VSwitchGroupImpl
implements Site {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;
    private SrFuture<Void> myDiscoveryFuture = new CompleteFuture("SiteImpl.Discovery");
    private static SrLogger theLogger;
    private ArrayList<VSwitchGroupImpl> m_vSwitchGroups = new ArrayList();
    private Hashtable m_waitingVSwitches = new Hashtable();
    protected static boolean clustersDiscoveryCompleted;
    private String msg = null;
    public static final int DEFAULT_GENERAL_POLL_INTERVAL = 1;
    public static final int DEFAULT_ISCSI_POLL_INTERVAL = 1;
    public static final int DEFAULT_VIRTUALIZATION_POLL_INTERVAL = 1;
    public static final int DEFAULT_ACL_POLL_INTERVAL = 1;
    public static final int DEFAULT_NETWORKING_POLL_INTERVAL = 1;
    public static final double DEFAULT_STATISTIC_POLL_INTERVAL = 0.16666666666666666;
    private static final HashMap pollingParametersDefaultValues;

    public SiteImpl(ConfigElementData aCED) throws RemoteException, InvalidElementException, IllegalValueException {
        super(ClassID.SITE, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
        for (ParameterCode code : pollingParametersDefaultValues.keySet()) {
            this.setOneParameter(code, pollingParametersDefaultValues.get(code), null);
        }
    }

    @Override
    public AlarmGenerator getAlarmGenerator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerToPropagatedStateChange() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String isValid(HashMap parameterList) {
        String alias = (String)parameterList.get(ClientParameterCode.SITE_ALIAS);
        if (alias != null) {
            if (alias.equals("")) {
                return "Alias cannot be empty";
            }
            if (SystemRootImpl.getInstance().isSiteAliasExists(alias)) {
                return "Alias " + alias + " already exists in " + SystemRootImpl.getInstance() + ". Please select a different alias for " + this.getClassId() + " " + this + ".";
            }
            parameterList.put(ClientParameterCode.SITE_ALIAS, new SrString(alias));
        }
        return null;
    }

    @Override
    protected String canBeDeleted() {
        return null;
    }

    @Override
    public ArrayList<VSwitchGroupImpl> getVSwitchGroups() {
        return this.m_vSwitchGroups;
    }

    public Vector getListCommKeysSameTypeOf(ClassID classId, CommKeyClassId vSwitchData) throws RemoteException {
        return this.getAllCommKeysByClassID(classId, vSwitchData, true);
    }

    public Vector getListOfCommKeys(ClassID classId, CommKeyClassId vSwitchData) throws RemoteException {
        return this.getAllCommKeysByClassID(classId, vSwitchData, false);
    }

    private Vector getAllCommKeysByClassID(ClassID classId, CommKeyClassId vSwitchData, boolean getAllOfSameType) throws RemoteException {
        ArrayList<ClusterImpl> clusters = this.getClustersRecursively();
        for (ClusterImpl cluster : clusters) {
            Vector list = null;
            list = getAllOfSameType ? cluster.getCommKeyRefMap().getListCommKeysSameTypeOf(classId, vSwitchData) : cluster.getCommKeyRefMap().getListOfCommKeys(classId, vSwitchData);
            if (list == null) continue;
            return list;
        }
        return null;
    }

    public ArrayList<SiteImpl> getSiteChildren() {
        ArrayList<SiteImpl> children = new ArrayList<SiteImpl>();
        for (VSwitchGroupImpl vSwitchGroup : this.getVSwitchGroups()) {
            if (!vSwitchGroup.getClassId().equals((Object)ClassID.SITE)) continue;
            children.add((SiteImpl)vSwitchGroup);
        }
        return children;
    }

    @Override
    public ArrayList<ClusterImpl> getClusters() {
        ArrayList<ClusterImpl> clusters = new ArrayList<ClusterImpl>();
        for (VSwitchGroupImpl vSwitchGroup : this.getVSwitchGroups()) {
            if (!vSwitchGroup.getClassId().equals((Object)ClassID.CLUSTER)) continue;
            clusters.add((ClusterImpl)vSwitchGroup);
        }
        return clusters;
    }

    public ArrayList<ClusterImpl> getClustersRecursively() {
        ArrayList<ClusterImpl> clusters = new ArrayList<ClusterImpl>();
        for (VSwitchGroupImpl vSwitchGroup : this.getVSwitchGroups()) {
            if (vSwitchGroup.getClassId().equals((Object)ClassID.CLUSTER)) {
                clusters.add((ClusterImpl)vSwitchGroup);
                continue;
            }
            if (!vSwitchGroup.getClassId().equals((Object)ClassID.SITE)) continue;
            clusters.addAll(((SiteImpl)vSwitchGroup).getClustersRecursively());
        }
        return clusters;
    }

    public ArrayList<ClusterImpl> getClustersInOtherSites(SiteImpl site) {
        ArrayList<ClusterImpl> allClustersInSystem = this.getClustersRecursively();
        ArrayList<ClusterImpl> clustersInSite = site.getClusters();
        allClustersInSystem.removeAll(clustersInSite);
        return allClustersInSystem;
    }

    @Override
    public ArrayList<SiteImpl> getSites() {
        ArrayList<SiteImpl> sites = new ArrayList<SiteImpl>();
        for (VSwitchGroupImpl vSwitchGroup : this.getVSwitchGroups()) {
            if (!vSwitchGroup.getClassId().equals((Object)ClassID.SITE)) continue;
            sites.add((SiteImpl)vSwitchGroup);
        }
        return sites;
    }

    public VSwitchGroup getVSwitchGroup(Integer id) throws RemoteException {
        for (VSwitchGroupImpl vSwitchGroup : this.m_vSwitchGroups) {
            VSwitchGroup vg;
            if (vSwitchGroup.getVSwitchGroupId().compareTo(id) == 0) {
                return vSwitchGroup;
            }
            if (!vSwitchGroup.getClassId().equals((Object)ClassID.SITE) || (vg = ((SiteImpl)vSwitchGroup).getVSwitchGroup(id)) == null) continue;
            return vg;
        }
        return null;
    }

    @Override
    public SrFuture<Void> createSite(String alias) throws RemoteException, IllegalValueException {
        SiteValidator validator = new SiteValidator(this, alias);
        if (!validator.isValid()) {
            return new FailedFuture((Exception)((Object)new IllegalValueException(validator.getErrorMsg())), validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.SITE);
        element.addParameter(new Parameter(ParameterCode.SITE_ALIAS, (Object)new SrString(alias)));
        return this.createVSwitcGroup(element);
    }

    private SrType getPollingInterval(ParameterCode intervalParameterCode) throws RemoteException {
        Parameter pollInterval = this.getParameter((VSwitch)null, intervalParameterCode);
        if (pollInterval != null) {
            return (SrType)pollInterval.getValue();
        }
        return null;
    }

    private void addPollingInterval(ConfigElementData element, ParameterCode intervalParameterCode) throws RemoteException {
        SrType pollIntervalValue = this.getPollingInterval(intervalParameterCode);
        if (pollIntervalValue != null) {
            element.setValue(intervalParameterCode, pollIntervalValue);
        }
    }

    private void addPollingInterval(HashMap map, ParameterCode intervalParameterCode) throws RemoteException {
        SrType pollIntervalValue = this.getPollingInterval(intervalParameterCode);
        if (pollIntervalValue != null) {
            map.put(intervalParameterCode, pollIntervalValue);
        }
    }

    private SrFuture<Void> createVSwitcGroup(ConfigElementData element) throws RemoteException {
        int id = SystemRootImpl.getInstance().getNextVSwitchGroupId();
        element.addParameter(new Parameter(ParameterCode.VSWITCH_GROUP_ID, (Object)new SrInteger(id)));
        element.setValue(ParameterCode.PARENT_SITE_ID, (SrType)this.getCommKeyClassId());
        for (ParameterCode code : pollingParametersDefaultValues.keySet()) {
            this.addPollingInterval(element, code);
        }
        return DataMgrAdapter.getInstance().createElement(element);
    }

    @Override
    public SrFuture<Void> createCluster(String alias) throws RemoteException, IllegalValueException {
        ClusterValidator validator = new ClusterValidator(this, alias);
        if (!validator.isValid()) {
            return new FailedFuture((Exception)((Object)new IllegalValueException(validator.getErrorMsg())), validator.getErrorMsg());
        }
        ConfigElementData element = new ConfigElementData(ClassID.CLUSTER);
        element.addParameter(new Parameter(ParameterCode.CLUSTER_ALIAS, (Object)new SrString(alias)));
        return this.createVSwitcGroup(element);
    }

    public SrFuture<Void> addVSwitchGroup(VSwitchGroupImpl vSwitchGroup) throws RemoteException {
        CompleteFuture retFuture = null;
        if (!this.m_vSwitchGroups.contains(vSwitchGroup)) {
            this.m_vSwitchGroups.add(vSwitchGroup);
        }
        retFuture = vSwitchGroup.getClassId().equals((Object)ClassID.CLUSTER) ? this.addVSwitchIfClusterWaiting((ClusterImpl)vSwitchGroup) : new CompleteFuture("SiteImpl.addVSwitchGroup");
        this.addPropagationStateDependentObjectAndListener(vSwitchGroup);
        this.setPropagatedState(vSwitchGroup.getPropagatedState());
        return retFuture;
    }

    public void removeVSwitchGroup(VSwitchGroupImpl vSwitchGroup) throws RemoteException {
        this.m_vSwitchGroups.remove(vSwitchGroup);
        this.removePropagationStateDependentObjectAndListener(vSwitchGroup);
        vSwitchGroup.clear();
        if (ClassID.CLUSTER.equals((Object)vSwitchGroup.getClassId())) {
            ((ClusterImpl)vSwitchGroup).unregisterBean();
        }
    }

    public void vswitchGroupMoved(VSwitchGroup vSwitchGroup) throws RemoteException {
        this.m_vSwitchGroups.remove(vSwitchGroup);
        this.removePropagationStateDependentObjectAndListener((VSwitchGroupImpl)vSwitchGroup);
    }

    @Override
    public void clear() throws RemoteException {
        ArrayList<VSwitchGroupImpl> vswitchGroups = this.getVSwitchGroups();
        for (VSwitchGroupImpl vswitchGroup : vswitchGroups) {
            vswitchGroup.clear();
        }
        if (this.m_waitingVSwitches != null) {
            this.m_waitingVSwitches.clear();
        }
    }

    @Override
    public String getAlias(VSwitch vSwitch) throws RemoteException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAlias() {
        return (String)this.getValueOf(null, ParameterCode.SITE_ALIAS);
    }

    @Override
    public SrFuture<Void> addVSwitch(String ownerVSwitchGroupName, String ipAddr, String mask, int snmpPort, int trapPort, String readCommunity, String writeCommunity, long timeout, int numberOfRetries, SnmpVersion snmpVersion) throws RemoteException, IllegalValueException {
        VSwitchValidator validator = new VSwitchValidator(null, ipAddr, mask, readCommunity, writeCommunity);
        if (!validator.isValid()) {
            return new FailedFuture((Exception)((Object)new IllegalValueException(validator.getErrorMsg())), validator.getErrorMsg());
        }
        HashMap<ParameterCode, Object> parameters = new HashMap<ParameterCode, Object>();
        parameters.put(ParameterCode.VSWITCH_IP_ADDRESS, ipAddr);
        parameters.put(ParameterCode.VSWITCH_IP_MASK, mask);
        parameters.put(ParameterCode.VSWITCH_SNMP_UDP_PORT, new Integer(snmpPort));
        parameters.put(ParameterCode.VSWITCH_TRAP_UDP_PORT, new Integer(trapPort));
        parameters.put(ParameterCode.VSWITCH_READ_COMMUNITY, readCommunity);
        parameters.put(ParameterCode.VSWITCH_WRITE_COMMUNITY, writeCommunity);
        parameters.put(ParameterCode.VSWITCH_TIMEOUT, new Long(timeout));
        parameters.put(ParameterCode.VSWITCH_MAX_RETRIES, new Integer(numberOfRetries));
        parameters.put(ParameterCode.VSWITCH_SNMP_VERSION, snmpVersion);
        for (ParameterCode code : pollingParametersDefaultValues.keySet()) {
            this.addPollingInterval(parameters, code);
        }
        this.m_waitingVSwitches.put(ownerVSwitchGroupName, parameters);
        return this.createCluster(ownerVSwitchGroupName);
    }

    @Override
    public SrFuture<Void> addVSwitch(String ipAddr, String mask, int snmpPort, int trapPort, String readCommunity, String writeCommunity, long timeout, int numberOfRetries, SnmpVersion snmpVersion) throws RemoteException, IllegalValueException {
        return this.addVSwitch(ipAddr, ipAddr, mask, snmpPort, trapPort, readCommunity, writeCommunity, timeout, numberOfRetries, snmpVersion);
    }

    private SrFuture<Void> addVSwitchIfClusterWaiting(Cluster cluster) throws RemoteException {
        FailedFuture retFuture = null;
        String clusterName = cluster.getAlias();
        HashMap parameters = (HashMap)this.m_waitingVSwitches.get(clusterName);
        if (parameters != null) {
            String ipAddr = (String)parameters.get(ParameterCode.VSWITCH_IP_ADDRESS);
            String mask = (String)parameters.get(ParameterCode.VSWITCH_IP_MASK);
            Integer snmpPort = (Integer)parameters.get(ParameterCode.VSWITCH_SNMP_UDP_PORT);
            Integer trapPort = (Integer)parameters.get(ParameterCode.VSWITCH_TRAP_UDP_PORT);
            String readCommunity = (String)parameters.get(ParameterCode.VSWITCH_READ_COMMUNITY);
            String writeCommunity = (String)parameters.get(ParameterCode.VSWITCH_WRITE_COMMUNITY);
            Long timeout = (Long)parameters.get(ParameterCode.VSWITCH_TIMEOUT);
            Integer numberOfRetries = (Integer)parameters.get(ParameterCode.VSWITCH_MAX_RETRIES);
            SnmpVersion snmpVersion = (SnmpVersion)parameters.get(ParameterCode.VSWITCH_SNMP_VERSION);
            try {
                retFuture = cluster.addVSwitch(ipAddr, mask, snmpPort, trapPort, readCommunity, writeCommunity, timeout, numberOfRetries, snmpVersion);
                this.m_waitingVSwitches.remove(clusterName);
            }
            catch (IllegalValueException ive) {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{ive});
                retFuture = new FailedFuture((Exception)((Object)ive), "SiteImpl.addVSwitchIfClusterWaiting");
            }
        } else {
            retFuture = new CompleteFuture("SiteImpl.addVSwitchIfClusterWaiting");
        }
        return retFuture;
    }

    @Override
    public synchronized int synchronize() throws RemoteException, IllegalValueException {
        theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"This method should not be called!"});
        Iterator<VSwitchGroupImpl> i = this.getVSwitchGroups().iterator();
        if (i.hasNext()) {
            VSwitchGroup vSwitchGroup = i.next();
            return vSwitchGroup.synchronize();
        }
        return 0;
    }

    public VSwitchGroupImpl newVSwitchGroup(ConfigElementData aCED) throws RemoteException, IllegalValueException, InvalidElementException {
        VSwitchGroupImpl vSwitchGroup = null;
        if (aCED.getClassId().equals((Object)ClassID.CLUSTER)) {
            vSwitchGroup = new ClusterImpl(aCED);
        } else if (aCED.getClassId().equals((Object)ClassID.SITE)) {
            vSwitchGroup = new SiteImpl(aCED);
        }
        vSwitchGroup.changeParameterList(aCED);
        if (aCED.getClassId().equals((Object)ClassID.CLUSTER)) {
            VSwitchGroupImpl cluster = vSwitchGroup;
            if (clustersDiscoveryCompleted) {
                ((ClusterImpl)cluster).notifyClusterDBReadingCompleted();
            }
        }
        ElementEventImpl elementEvent = new ElementEventImpl((Object)vSwitchGroup, vSwitchGroup);
        LogicMgrAOImpl.getInstance().__elementCreated(elementEvent);
        StringBuffer debugMsg = new StringBuffer(vSwitchGroup.getClassId().toString());
        debugMsg.append(" ");
        debugMsg.append(vSwitchGroup);
        debugMsg.append(" was created");
        theLogger.info(SrLogCategories.LEGACY, new Object[]{debugMsg});
        return vSwitchGroup;
    }

    protected void sendEventToAllClusters(SrClusterDiscoveryCompletedEvent event) throws RemoteException, InvalidElementException {
        if (event.getType() == 23) {
            clustersDiscoveryCompleted = true;
        }
        for (VSwitchGroupImpl vSwitchGroup : this.getVSwitchGroups()) {
            if (vSwitchGroup.getClassId().equals((Object)ClassID.CLUSTER)) {
                ((ClusterImpl)vSwitchGroup).elementEvent((EventObject)event);
                continue;
            }
            ((SiteImpl)vSwitchGroup).sendEventToAllClusters(event);
        }
    }

    @Override
    public SrFuture<Void> deleteElement() throws RemoteException, IllegalValueException {
        final ArrayList<SrFuture<Void>> retList = new ArrayList<SrFuture<Void>>();
        if (this.canBeDeleted() == null) {
            ArrayList<ClusterImpl> clusters = this.getClusters();
            for (Cluster cluster : clusters) {
                retList.add(cluster.deleteElement());
            }
        }
        final SrFuture retVal = new SrFuture("Site.super delete future");
        final SiteImpl thisSite = this;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().siteDeleteElementFollowUp(thisSite, (SrFuture<Void>)retVal, retList);
            }
        };
        DefaultFutureListener.listenTo((Runnable)runnable, retList);
        return retVal;
    }

    public SrFuture<Void> deleteElementSuper() throws RemoteException, IllegalValueException {
        return super.deleteElement();
    }

    @Override
    public SrFuture<Void> plannedFailover() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        return this.plannedFailover(activateDRObjects);
    }

    @Override
    public SrFuture<Void> plannedFailover(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        final SrFuture retFuture = new SrFuture("Site.plannedFailover");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        boolean throwExp = false;
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl localElement = currActivateObject.getLocalElement();
            if (localElement != null) {
                if (!localElement.getCluster().getParentSite().equals(this)) continue;
                try {
                    midFutures.add(currActivateObjectStub.plannedFailover());
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    throwExp = true;
                    theLogger.trace(SrLogCategories.LEGACY, new Object[]{ive});
                }
                continue;
            }
            throwExp = true;
        }
        if (throwExp) {
            return new FailedFuture((Exception)((Object)new IllegalValueException(this.msg)), this.msg);
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> startReplicate() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        return this.startReplicate(activateDRObjects);
    }

    @Override
    public SrFuture<Void> startReplicate(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.getClassId(), " ", this, " : activating startReplicate on ", activateDRObjects.length, " DR objects"});
        final SrFuture retFuture = new SrFuture("Site.startReplicate");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        boolean throwExp = false;
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl element = (DRClusterLogicObjectImpl)currActivateObject.getClusterElementAccordingToMode();
            if (element != null) {
                if (!element.getCluster().getParentSite().equals(this)) continue;
                try {
                    midFutures.add(currActivateObjectStub.startReplicate());
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    throwExp = true;
                }
                continue;
            }
            throwExp = true;
        }
        if (throwExp) {
            return new FailedFuture((Exception)((Object)new IllegalValueException(this.msg)), this.msg);
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> abortReplicate() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        return this.abortReplicate(activateDRObjects);
    }

    @Override
    public SrFuture<Void> abortReplicate(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        boolean throwExp = false;
        final SrFuture retFuture = new SrFuture("Site.abortReplicate_DRActivate[]");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        boolean isArrayEmpty = true;
        if (activateDRObjects == null || activateDRObjects.length == 0) {
            String expMsg = "There is no active pairs on this site";
            return new FailedFuture((Exception)((Object)new IllegalValueException(expMsg)), expMsg);
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.getClassId(), " ", this, " : activating abortReplicate on ", activateDRObjects.length, " DR objects"});
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl element = (DRClusterLogicObjectImpl)currActivateObject.getClusterElementAccordingToMode();
            if (element != null) {
                if (!element.getCluster().getParentSite().equals(this)) continue;
                isArrayEmpty = false;
                midFutures.add(currActivateObjectStub.abortReplicate());
                continue;
            }
            throwExp = true;
        }
        if (isArrayEmpty) {
            String expMsg = "There is no element in this site";
            return new FailedFuture((Exception)((Object)new IllegalValueException(expMsg)), expMsg);
        }
        if (throwExp) {
            String expMsg = "The DR cluster is null.";
            return new FailedFuture((Exception)((Object)new IllegalValueException(expMsg)), expMsg);
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> fallback() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        return this.fallback(activateDRObjects);
    }

    @Override
    public SrFuture<Void> fallback(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.getClassId(), " ", this, " : activating fallback on ", activateDRObjects.length, " DR objects"});
        boolean throwExp = false;
        final SrFuture retFuture = new SrFuture("Site.fallback_DRActivate[]");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (int i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl remoteElement = currActivateObject.getRemoteElement();
            if (remoteElement != null) {
                if (!remoteElement.getCluster().getParentSite().equals(this)) continue;
                midFutures.add(currActivateObjectStub.fallback());
                continue;
            }
            throwExp = true;
        }
        if (throwExp) {
            String expMsg = "The remote element is null.";
            return new FailedFuture((Exception)((Object)new IllegalValueException(expMsg)), expMsg);
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public SrFuture<Void> disasterOccured() throws RemoteException, IllegalValueException {
        ArrayList activateDRObjectsList = SystemRootImpl.getInstance().getDRRoot().getActivateDRObjects();
        DRActivate[] activateDRObjects = new DRActivate[activateDRObjectsList.size()];
        activateDRObjectsList.toArray(activateDRObjects);
        return this.disasterOccured(activateDRObjects);
    }

    @Override
    public SrFuture<Void> disasterOccured(DRActivate[] activateDRObjects) throws RemoteException, IllegalValueException {
        int i;
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.getClassId(), " ", this, " : activating disasterOccured on ", activateDRObjects.length, " DR objects"});
        if (activateDRObjects.length == 0) {
            String expMsg = "There is no element in site";
            return new FailedFuture((Exception)((Object)new IllegalValueException(expMsg)), expMsg);
        }
        boolean throwExp = false;
        final SrFuture retFuture = new SrFuture("Site.disasterOccured_DRActivate[]");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        ArrayList<ClusterImpl> clustersToBeRemoved = new ArrayList<ClusterImpl>();
        for (i = 0; i < activateDRObjects.length; ++i) {
            DRActivate currActivateObjectStub = activateDRObjects[i];
            DRLogicObjectImpl currActivateObject = DRRootImpl.getInstance().getRefByStub(currActivateObjectStub.hashKey());
            DRClusterLogicObjectImpl remoteElement = currActivateObject.getRemoteElement();
            if (remoteElement != null) {
                ClusterImpl localCluster;
                if (!remoteElement.getCluster().getParentSite().equals(this)) continue;
                try {
                    midFutures.add(currActivateObjectStub.disasterOccured());
                }
                catch (IllegalValueException ive) {
                    this.msg = ive.getMessage();
                    throwExp = true;
                    continue;
                }
                DRClusterLogicObjectImpl localElement = currActivateObject.getLocalElement();
                if (localElement == null || clustersToBeRemoved.contains(localCluster = localElement.getCluster())) continue;
                clustersToBeRemoved.add(localCluster);
                continue;
            }
            throwExp = true;
        }
        for (i = 0; i < clustersToBeRemoved.size(); ++i) {
            Cluster currCluster = (Cluster)clustersToBeRemoved.get(i);
            if (currCluster.isInDeletionProcess()) continue;
            midFutures.add(currCluster.deleteElement());
        }
        if (throwExp) {
            return new FailedFuture((Exception)((Object)new IllegalValueException(this.msg)), this.msg);
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private StringBuffer getObjectsList(ArrayList list) {
        StringBuffer objectsList = new StringBuffer();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (i != 0) {
                    objectsList.append(", ");
                }
                Object obj = list.get(i);
                objectsList.append(obj + " ");
            }
        }
        return objectsList;
    }

    @Override
    public SrFuture<Void> rediscover() throws RemoteException {
        if (!this.myDiscoveryFuture.isDone()) {
            return this.myDiscoveryFuture;
        }
        final SrFuture retFuture = new SrFuture("Site.rediscover");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        this.myDiscoveryFuture = retFuture;
        for (VSwitchGroup vSwitchGroup : this.getVSwitchGroups()) {
            if (vSwitchGroup.isDiscoverCompleted()) {
                midFutures.add(vSwitchGroup.rediscover());
                continue;
            }
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{this.getClassId(), " ", vSwitchGroup, " is already rediscovering..."});
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    @Override
    public boolean isDiscoverCompleted() throws RemoteException {
        ArrayList<ClusterImpl> allClusters = this.getClustersRecursively();
        for (int i = 0; i < allClusters.size(); ++i) {
            Cluster currCluster = allClusters.get(i);
            if (currCluster.isDiscoverCompleted()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setStateSeverity(AlarmSeverity newState) {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.setStateSeverity(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlarmSeverity getPropagatedState() {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.getPropagatedState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlarmSeverity getPropagatedAcknowledgeState() {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            return super.getPropagatedAcknowledgeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAcknowledgeStateSeverity(AlarmSeverity newAckState) {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.setAcknowledgeStateSeverity(newAckState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPropagatedState(AlarmSeverity newPropagatedState) {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.setPropagatedState(newPropagatedState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propagatedStateChanged(PropagatedStateEvent pse) {
        Object object = SystemRootImpl.getInstance().getAlarmsUpdateLock();
        synchronized (object) {
            super.propagatedStateChanged(pse);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Site) {
            try {
                return this.getAlias().equals(((Site)obj).getAlias());
            }
            catch (RemoteException e) {
                theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"got a remote exception in the server."});
            }
        }
        return false;
    }

    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        return null;
    }

    static {
        HashMap<ParameterCode, ParameterCode.Flags> parameterCodeFlagsMap = new HashMap<ParameterCode, ParameterCode.Flags>();
        parameterCodeFlagsMap.put(ParameterCode.SITE_ALIAS, new ParameterCode.Flags(true, false));
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
        theLogger = SrLogger.getLogger();
        clustersDiscoveryCompleted = false;
        pollingParametersDefaultValues = new HashMap();
        pollingParametersDefaultValues.put(ParameterCode.GENERAL_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.ISCSI_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.VIRTUALIZATION_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.ACL_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.NET_POLL_INTERVAL, new SrDouble(1.0));
        pollingParametersDefaultValues.put(ParameterCode.STATISTIC_POLL_INTERVAL, new SrDouble(0.16666666666666666));
    }
}

