/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.types.SrType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ParametersMap {
    private Map<ParameterCode, SrType[]> data = new HashMap<ParameterCode, SrType[]>();

    public ParametersMap() {
    }

    public ParametersMap(ParameterCode[] aCodes) {
        this(Arrays.asList(aCodes));
    }

    public ParametersMap(Collection<ParameterCode> aParameterCodes) {
        this.add(aParameterCodes);
    }

    public SrType get(ParameterCode code) {
        if (this.data.get(code) == null || this.data.get(code).length == 0) {
            return null;
        }
        return this.data.get(code)[0];
    }

    public SrType[] getArray(ParameterCode code) {
        return this.data.get(code);
    }

    public SrType[] set(ParameterCode code, SrType value) {
        return this.set(code, new SrType[]{value});
    }

    public SrType[] set(ParameterCode code, SrType[] value) {
        return this.data.put(code, value);
    }

    public Map<ParameterCode, SrType[]> add(Collection<ParameterCode> aParameterCodes) {
        HashMap<ParameterCode, SrType[]> retVal = new HashMap<ParameterCode, SrType[]>(aParameterCodes.size());
        for (ParameterCode code : aParameterCodes) {
            retVal.put(code, this.set(code, (SrType[])null));
        }
        return retVal;
    }

    public ParameterCode[] getCodes() {
        return (ParameterCode[])this.data.keySet().toArray();
    }
}

