/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import antlr.CharScanner;
import antlr.LLkParser;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import com.sanrad.log.LogManagerImpl;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteObject;
import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.SrServerBundleKeys;
import com.sanrad.nms.server.SrSocketFactory;
import com.sanrad.nms.server.alarm.Alarm;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.DrAlarmMgrImpl;
import com.sanrad.nms.server.alarm.GeneralAlarmMgrImpl;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.cli.CliCommand;
import com.sanrad.nms.server.cli.SpCliLexer;
import com.sanrad.nms.server.cli.SpCliParser;
import com.sanrad.nms.server.cli.executor.CliCommandExecutor;
import com.sanrad.nms.server.cli.executor.CliCommandExecutorMap;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.comm.snmp.SnmpVersion;
import com.sanrad.nms.server.event.AllEventsListener;
import com.sanrad.nms.server.event.DbErrorEvent;
import com.sanrad.nms.server.event.ErrorEvent;
import com.sanrad.nms.server.event.SnmpErrorEvent;
import com.sanrad.nms.server.event.SrClusterDiscoveryCompletedEvent;
import com.sanrad.nms.server.event.SrElementEvent;
import com.sanrad.nms.server.event.SrEvent;
import com.sanrad.nms.server.event.SrEventObject;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.ClientStateEvent;
import com.sanrad.nms.server.logic.ClientStateListener;
import com.sanrad.nms.server.logic.ClientThreadImpl;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementEventImpl;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.EventService;
import com.sanrad.nms.server.logic.EventServiceImpl;
import com.sanrad.nms.server.logic.GeneralAliasObject;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicMgr_AG;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.ServerConnectionException;
import com.sanrad.nms.server.logic.ServerConnectionMgr;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.nms.server.logic.ServerFacade;
import com.sanrad.nms.server.logic.Site;
import com.sanrad.nms.server.logic.SiteImpl;
import com.sanrad.nms.server.logic.Synchronizeable;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.SystemRootImpl;
import com.sanrad.nms.server.logic.VSwitchGroup;
import com.sanrad.nms.server.logic.VSwitchGroupImpl;
import com.sanrad.nms.server.logic.acl.Acl;
import com.sanrad.nms.server.logic.acl.Permission;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.cluster.dr.DRClusterLogicObject;
import com.sanrad.nms.server.logic.dr.DRAbstractConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRActivate;
import com.sanrad.nms.server.logic.dr.DRAsyncPair;
import com.sanrad.nms.server.logic.dr.DRAsyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRConsistencyGroup;
import com.sanrad.nms.server.logic.dr.DRElement;
import com.sanrad.nms.server.logic.dr.DRLogicObjectImpl;
import com.sanrad.nms.server.logic.dr.DRPair;
import com.sanrad.nms.server.logic.dr.DRRootImpl;
import com.sanrad.nms.server.logic.dr.DRSyncPair;
import com.sanrad.nms.server.logic.dr.DRSyncPairImpl;
import com.sanrad.nms.server.logic.dr.DRVolume;
import com.sanrad.nms.server.logic.dr.InnerActivate;
import com.sanrad.nms.server.logic.identity.Identity;
import com.sanrad.nms.server.logic.identity.IdentityImpl;
import com.sanrad.nms.server.logic.iscsi.ISCSISession;
import com.sanrad.nms.server.logic.iscsi.ISCSISessionStatistics;
import com.sanrad.nms.server.logic.lu.LUImpl;
import com.sanrad.nms.server.logic.physstorage.DirectAccessDevice;
import com.sanrad.nms.server.logic.statistics.Statistics;
import com.sanrad.nms.server.logic.storage.SrStorageNotificationMgrImpl;
import com.sanrad.nms.server.logic.storage.Storage;
import com.sanrad.nms.server.logic.target.ISCSIRemotePortalDiscovery;
import com.sanrad.nms.server.logic.target.ISCSIRemoteTarget;
import com.sanrad.nms.server.logic.target.ISCSITargetImpl;
import com.sanrad.nms.server.logic.target.Target;
import com.sanrad.nms.server.logic.target.TargetImpl;
import com.sanrad.nms.server.logic.volume.ConcatinationVolume;
import com.sanrad.nms.server.logic.volume.JournalVolume;
import com.sanrad.nms.server.logic.volume.MirrorVolume;
import com.sanrad.nms.server.logic.volume.MirrorVolumeImpl;
import com.sanrad.nms.server.logic.volume.SnapshotVolume;
import com.sanrad.nms.server.logic.volume.SnapshotVolumeImpl;
import com.sanrad.nms.server.logic.volume.Volume;
import com.sanrad.nms.server.logic.volume.VolumeImpl;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import com.sanrad.nms.server.logic.volume.copy.CopyOperation;
import com.sanrad.nms.server.logic.volume.copy.CopyOperationManager;
import com.sanrad.nms.server.logic.vswitch.Manager;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.logic.vswitch.statistics.InterfacesGroupStatisticsImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.mgr.volume.SimpleVolumeMgr;
import com.sanrad.nms.server.user.User;
import com.sanrad.nms.server.user.UserManagerImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ClientConfigElementData;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.FileInterface;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.ParameterList;
import com.sanrad.nms.server.util.VSwitchClusterMap;
import com.sanrad.nms.server.util.client.ClientCedExecutor;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.nms.server.util.types.SrBoolean;
import com.sanrad.nms.server.util.types.SrInteger;
import com.sanrad.nms.server.util.types.SrIpAddress;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.nms.server.util.types.constants.DRActivateConstant;
import com.sanrad.nms.server.util.types.constants.DRPairInitialSyncTypeConstant;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.SrResourceBundle;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.ErrorAssertingListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrActiveObject;
import com.sanrad.util.concurrent.SrExecutionException;
import com.sanrad.util.concurrent.SrFuture;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class LogicMgrAOImpl
extends LogicMgr_AG
implements Remote,
ServerConnectionMgr,
ClientStateListener {
    private static final String OBJ_NOT_EXIST_MSG = "The given object does not exist.";
    private static SrResourceBundle consts = SrResourceBundle.getInstance((String)"constants", (Locale)Locale.US);
    public static final long DB_UPDATE_DELAY = consts.getIntResource((BundleKeysInterface)SrConstantsBundleKeys.DB_UPDATE_DELAY_MILLISEC);
    EventServiceImpl myEventServiceImpl;
    private static SrLogger theLogger;
    private static LogicMgrAOImpl theInstance;
    private static HashMap<CommKeyClassId, VSwitchGroupImpl> theCkciToVsGroupMap;
    private SrFuture<Void> myLoadFuture = null;
    private SrEventListenerManager myListeners = new SrEventListenerManager();
    SrEventListenerManager.Informer<AllEventsListener, SrEvent> myAllEventsListenerInformer = new SrEventListenerManager.Informer<AllEventsListener, SrEvent>(){

        public void inform(AllEventsListener listener, SrEvent event) {
            listener.handleElementEvent(event);
        }
    };
    SrEventListenerManager.Informer<ClientStateListener, ClientStateEvent> myClientStateInformer = new SrEventListenerManager.Informer<ClientStateListener, ClientStateEvent>(){

        public void inform(ClientStateListener listener, ClientStateEvent event) {
            listener.remoteClientClosed(event);
        }
    };

    private LogicMgrAOImpl() {
        try {
            this.myEventServiceImpl = new EventServiceImpl();
        }
        catch (RemoteException exp1) {
            throw new IllegalStateException("The event service could not be initialized.", exp1);
        }
        DataMgrAdapter.getInstance().addEventListener(this);
        DataMgrAdapter.getInstance().addDbErrorListener(this);
        DataMgrAdapter.getInstance().addErrorListener(this);
        DataMgrAdapter.getInstance().addSnmpErrorListener(this);
        this.addVSwitchGroupCommKeyRefMap(SystemRootImpl.getInstance().getCommKeyClassId(), SystemRootImpl.getInstance());
    }

    public static LogicMgrAOImpl getInstance() {
        return theInstance;
    }

    @Override
    protected void __createAclEntry(final SrFuture<Void> aFuture, String aObject, CommKeyClassId aIdentityCommKeyClassId, Permission aPermission, Integer aPosition) throws Exception {
        CommKeyClassId serverIdentityCommKeyClassId = this.getServerCKCI(aIdentityCommKeyClassId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Acl)) {
            throw new IllegalArgumentException("The given object is a " + curObj + " which is not valid for this method.");
        }
        Acl execObj = (Acl)curObj;
        final SrFuture<Void> dmFuture = execObj.createAclEntry(serverIdentityCommKeyClassId, aPermission, aPosition);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createAclEntryFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createAclEntryFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __updateAcl(final SrFuture<Void> aFuture, String aObject, Vector adata) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Acl)) {
            throw new IllegalArgumentException("The given object is a " + curObj + " which is not valid for this method.");
        }
        Acl execObj = (Acl)curObj;
        final SrFuture<Void> dmFuture = execObj.updateAcl(adata);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.updateAclFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __updateAclFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __systemDiscovery(final SrFuture<Void> aFuture) throws Exception {
        if (this.myLoadFuture == null) {
            this.myLoadFuture = DataMgrAdapter.getInstance().load();
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.systemDiscoveryFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)LogicMgrAOImpl.this.myLoadFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{this.myLoadFuture});
    }

    @Override
    protected Void __systemDiscoveryFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __addUser(final SrFuture<Void> aFuture, String aUserName, String aPassword) throws Exception {
        UserManagerImpl curObj = UserManagerImpl.getInstance();
        final SrFuture dmFuture = curObj.addUser(aUserName, aPassword);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.addUserFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __removeUser(final SrFuture<Void> aFuture, User aUserToRemove) throws Exception {
        UserManagerImpl curObj = UserManagerImpl.getInstance();
        final SrFuture dmFuture = curObj.removeUser(aUserToRemove);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.removeUserFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __removeUsers(final SrFuture<Void> aFuture, Vector aUsersList) throws Exception {
        UserManagerImpl curObj = UserManagerImpl.getInstance();
        final SrFuture dmFuture = curObj.removeUsers(aUsersList);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.removeUserFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __silentAlarms(List aAlarms) throws Exception {
        AlarmMgrImpl.getInstance().silentAlarms(aAlarms);
        DrAlarmMgrImpl.getInstance().silentAlarms(aAlarms);
        return null;
    }

    @Override
    protected Void __acknowledgeAlarms(List aAlarms, long aperiod, String auserName) throws Exception {
        AlarmMgrImpl.getInstance().acknowledgeAlarms(aAlarms, aperiod, auserName);
        DrAlarmMgrImpl.getInstance().acknowledgeAlarms(aAlarms, aperiod, auserName);
        return null;
    }

    @Override
    protected Void __unacknowledgeAlarms(List aAlarms) throws Exception {
        AlarmMgrImpl.getInstance().unacknowledgeAlarms(aAlarms);
        DrAlarmMgrImpl.getInstance().unacknowledgeAlarms(aAlarms);
        return null;
    }

    @Override
    protected Void __setEmailEnabledAlarmTypes(List aEnabledAlarmTypes, List aDisabledAlarmTypes) throws IllegalValueException, RemoteException {
        AlarmMgrImpl.getInstance().setEmailEnabledAlarmTypes(aEnabledAlarmTypes, aDisabledAlarmTypes);
        DrAlarmMgrImpl.getInstance().setEmailEnabledAlarmTypes(aEnabledAlarmTypes, aDisabledAlarmTypes);
        return null;
    }

    @Override
    protected Void __setEmailContactParameters(HashMap aParameters) throws Exception {
        AlarmMgrImpl.getInstance().setEmailContactParameters(aParameters);
        DrAlarmMgrImpl.getInstance().setEmailContactParameters(aParameters);
        SrStorageNotificationMgrImpl.setEmailParameters();
        return null;
    }

    @Override
    protected void __abortCopyOper(final SrFuture<Void> aFuture, String aSource, CopyOperation aCopyOper) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aSource);
        if (!(curObj instanceof CopyOperationManager)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        CopyOperationManager execObj = (CopyOperationManager)curObj;
        final SrFuture<Void> dmFuture = execObj.abortCopyOper(aCopyOper);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.abortCopyOperFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __abortCopyOperFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __addUserFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __removeUserFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshCopyTable(final SrFuture<Void> aFuture, String aSource) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aSource);
        if (!(curObj instanceof CopyOperationManager)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        CopyOperationManager execObj = (CopyOperationManager)curObj;
        final SrFuture<Void> dmFuture = execObj.refreshCopyTable();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.refreshCopyTableFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __refreshCopyTableFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __restoreSnapshots(final SrFuture<Void> aFuture, String aSource, SnapshotVolume[] aSnapshots) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aSource);
        if (!(curObj instanceof CopyOperationManager)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        CopyOperationManager execObj = (CopyOperationManager)curObj;
        final SrFuture<Void> dmFuture = execObj.restoreSnapshots(aSnapshots);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.restoreSnapshotsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __restoreSnapshotsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createAsyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, DRConsistencyGroup aCG) throws Exception {
        CommKeyClassId serverPrimaryId = this.getServerCKCI(aPrimaryId);
        CommKeyClassId serverPrimarySnapshotId = this.getServerCKCI(aPrimarySnapshotId);
        CommKeyClassId serverPrimaryJournalId = this.getServerCKCI(aPrimaryJournalId);
        CommKeyClassId serverSecondaryId = this.getServerCKCI(aSecondaryId);
        CommKeyClassId serverSecondarySnapshotId = this.getServerCKCI(aSecondarySnapshotId);
        CommKeyClassId serverSecondaryJournalId = this.getServerCKCI(aSecondaryJournalId);
        final SrFuture<Void> dmFuture = DRRootImpl.getInstance().createAsyncPair(aInitialSyncType, serverPrimaryId, serverSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, serverPrimarySnapshotId, serverSecondarySnapshotId, aSecondarySnapshotParams, serverPrimaryJournalId, serverSecondaryJournalId, aCG);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createAsyncPairFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __createAsyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, String aCgAlias, HashMap aPitPolicy, HashMap aTransferPolicy, HashMap aMergePolicy) throws Exception {
        CommKeyClassId serverPrimaryId = this.getServerCKCI(aPrimaryId);
        CommKeyClassId serverPrimarySnapshotId = this.getServerCKCI(aPrimarySnapshotId);
        CommKeyClassId serverPrimaryJournalId = this.getServerCKCI(aPrimaryJournalId);
        CommKeyClassId serverSecondaryId = this.getServerCKCI(aSecondaryId);
        CommKeyClassId serverSecondarySnapshotId = this.getServerCKCI(aSecondarySnapshotId);
        CommKeyClassId serverSecondaryJournalId = this.getServerCKCI(aSecondaryJournalId);
        final SrFuture<Void> dmFuture = DRRootImpl.getInstance().createAsyncPair(aInitialSyncType, serverPrimaryId, serverSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, serverPrimarySnapshotId, serverSecondarySnapshotId, aSecondarySnapshotParams, serverPrimaryJournalId, serverSecondaryJournalId, aCgAlias, aPitPolicy, aTransferPolicy, aMergePolicy);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createAsyncPairFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createAsyncPairFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createAsyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun, CommKeyClassId aPrimarySnapshotId, CommKeyClassId aSecondarySnapshotId, HashMap aSecondarySnapshotParams, CommKeyClassId aPrimaryJournalId, CommKeyClassId aSecondaryJournalId, HashMap aPitPolicy, HashMap aTransferPolicy, HashMap aMergePolicy) throws Exception {
        CommKeyClassId serverPrimaryId = this.getServerCKCI(aPrimaryId);
        CommKeyClassId serverPrimarySnapshotId = this.getServerCKCI(aPrimarySnapshotId);
        CommKeyClassId serverPrimaryJournalId = this.getServerCKCI(aPrimaryJournalId);
        CommKeyClassId serverSecondaryId = this.getServerCKCI(aSecondaryId);
        CommKeyClassId serverSecondarySnapshotId = this.getServerCKCI(aSecondarySnapshotId);
        CommKeyClassId serverSecondaryJournalId = this.getServerCKCI(aSecondaryJournalId);
        final SrFuture<Void> dmFuture = DRRootImpl.getInstance().createAsyncPair(aInitialSyncType, serverPrimaryId, serverSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun, serverPrimarySnapshotId, serverSecondarySnapshotId, aSecondarySnapshotParams, serverPrimaryJournalId, serverSecondaryJournalId, aPitPolicy, aTransferPolicy, aMergePolicy);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createAsyncPairFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __createSyncPair(final SrFuture<Void> aFuture, DRPairInitialSyncTypeConstant aInitialSyncType, CommKeyClassId aPrimaryId, CommKeyClassId aSecondaryId, String aLocalTarget, Integer aLocalLun, String aRemoteTarget, Integer aRemoteLun) throws Exception {
        CommKeyClassId serverPrimaryId = this.getServerCKCI(aPrimaryId);
        CommKeyClassId serverSecondaryId = this.getServerCKCI(aSecondaryId);
        final SrFuture<Void> dmFuture = DRRootImpl.getInstance().createSyncPair(aInitialSyncType, serverPrimaryId, serverSecondaryId, aLocalTarget, aLocalLun, aRemoteTarget, aRemoteLun);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSyncPairFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createSyncPairFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __clusterSync(final SrFuture<Void> aFuture) throws Exception {
        final SrFuture<Void> dmFuture = DRRootImpl.getInstance().clusterSync();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.clusterSyncFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __clusterSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    public Void __elementCreated(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending element created event: ", aEvent});
        this.myEventServiceImpl.fireElementCreate(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent element created event: ", aEvent});
        return null;
    }

    @Override
    protected Void __logConfigChange(ElementEvent aEvent) throws Exception {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending log config event: ", aEvent});
        this.myEventServiceImpl.fireLogConfigChange(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent log config event: ", aEvent});
        return null;
    }

    @Override
    public Void __elementRemoved(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending element removed event: ", aEvent});
        this.myEventServiceImpl.fireElementRemove(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent element removed event: ", aEvent});
        return null;
    }

    @Override
    public Void __elementChanged(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending element changed event: ", aEvent});
        this.myEventServiceImpl.fireElementChanged(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent element changed event: ", aEvent});
        return null;
    }

    @Override
    public Void __elementChanged(ElementEvent aEvent, boolean aForce) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending element changed event: ", aEvent});
        this.myEventServiceImpl.fireElementChanged(aEvent, aForce);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent element changed event: ", aEvent});
        return null;
    }

    @Override
    public Void __startDiscovering(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending start discovery event: ", aEvent});
        this.myEventServiceImpl.fireStartDiscovering(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent start discovery event: ", aEvent});
        return null;
    }

    @Override
    public Void __discoverCompleted(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending discovery complete event: ", aEvent});
        this.myEventServiceImpl.fireDiscoverCompleted(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent discovery complete event: ", aEvent});
        if (SystemRootImpl.getInstance().isDiscoverCompleted() && DRRootImpl.getInstance().isDiscoverCompleted()) {
            AlarmMgrImpl.getInstance().verifyEmptyPendingAlarmsAndClear();
            DrAlarmMgrImpl.getInstance().verifyEmptyPendingAlarmsAndClear();
        }
        return null;
    }

    @Override
    public Void __configurationError(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending config error event: ", aEvent});
        this.myEventServiceImpl.fireConfigurationError(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent config error event: ", aEvent});
        return null;
    }

    @Override
    public Void __fatalConfigurationError(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending fatal config error event: ", aEvent});
        this.myEventServiceImpl.fireFatalConfigurationError(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent fatal config error event: ", aEvent});
        return null;
    }

    @Override
    public Void __startManualDiscovering(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending start manual discovery event: ", aEvent});
        this.myEventServiceImpl.fireStartManualDiscovering(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent start manual discovery event: ", aEvent});
        return null;
    }

    @Override
    public Void __startReset(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending start reset event: ", aEvent});
        this.myEventServiceImpl.fireStartReset(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent start reset event: ", aEvent});
        return null;
    }

    @Override
    public Void __alarmOpened(AlarmEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending alarm opened event: ", aEvent});
        this.myEventServiceImpl.fireAlarmOpened(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent alarm opened event: ", aEvent});
        return null;
    }

    @Override
    public Void __alarmClosed(AlarmEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending alarm closed event: ", aEvent});
        this.myEventServiceImpl.fireAlarmClosed(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent alarm closed event: ", aEvent});
        GeneralAlarmMgrImpl.removeAlarmFromMgrs((Alarm)aEvent.getAlarm());
        return null;
    }

    @Override
    public Void __alarmChanged(AlarmEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending alarm changed event: ", aEvent});
        this.myEventServiceImpl.fireAlarmChanged(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent alarm changed event: ", aEvent});
        return null;
    }

    @Override
    public Void __propagatedStateChanged(PropagatedStateEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending propagated state changed event: ", aEvent});
        this.myEventServiceImpl.firePropagatedStateChanged(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent propagated state changed event: ", aEvent});
        return null;
    }

    @Override
    protected Void __snmpError(ElementEvent aEvent) throws Exception {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending snmp error event: ", aEvent});
        this.myEventServiceImpl.fireSnmpError(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent propagated snmp error event: ", aEvent});
        return null;
    }

    @Override
    protected Void __checkConnectivity() throws Exception {
        UserManagerImpl.getInstance().checkConnectivity();
        return null;
    }

    @Override
    protected Void __serverWasShutdown(ElementEvent aEvent) throws Exception {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending server was shutdown event: ", aEvent});
        this.myEventServiceImpl.fireServerShutDown(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent server was shutdown event: ", aEvent});
        return null;
    }

    @Override
    public Void __drDiscoveryStarted(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending DR discovery started event: ", aEvent});
        this.myEventServiceImpl.fireDRDiscoveryStarted(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent DR discovery started event: ", aEvent});
        return null;
    }

    @Override
    public Void __drDiscoveryCompleted(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending DR discovery complete event: ", aEvent});
        this.myEventServiceImpl.fireDRDiscoveryCompleted(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent DR discovery complete event: ", aEvent});
        return null;
    }

    @Override
    public Void __systemDiscoveryCompleted(ElementEvent aEvent) throws RemoteException {
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Sending system discovery completed event: ", aEvent});
        this.myEventServiceImpl.fireSystemDiscoveryCompleted(aEvent);
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Successfully sent system discovery completed event: ", aEvent});
        return null;
    }

    @Override
    protected Boolean __isRegisterAsListener(ElementListener aListener) throws Exception {
        return this.myEventServiceImpl.isRegisterAsListener(aListener);
    }

    @Override
    protected byte[] __downloadFile(String aFileName) throws Exception {
        byte[] retVal = null;
        retVal = SystemRootImpl.getInstance().getFileInterface().downloadFile(aFileName);
        return retVal;
    }

    @Override
    protected Void __uploadFile(byte[] aFiledata) throws Exception {
        SystemRootImpl.getInstance().getFileInterface().uploadFile(aFiledata);
        return null;
    }

    @Override
    protected void __deleteElement(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        final SrFuture<Void> dmFuture = curObj.deleteElement();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.deleteElementFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __deleteElement(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRElement)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRElement execObj = (DRElement)curObj;
        final SrFuture<Void> dmFuture = execObj.deleteElement();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.deleteElementFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __deleteElementFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, CommKeyClassId aObject, ClientParameterCode aCode, Object aValue) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        final SrFuture<Void> dmFuture = curObj.changeElement(aCode, aValue);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.changeElementFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, CommKeyClassId aObject, HashMap aParameterList) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        final SrFuture<Void> dmFuture = curObj.changeElement(aParameterList);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.changeElementFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, String aObject, ClientParameterCode aCode, Object aValue) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        final SrFuture<Void> dmFuture = ((GeneralLogicObject)curObj).changeElement(aCode, aValue);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.changeElementFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __changeElement(final SrFuture<Void> aFuture, String aObject, HashMap aParameterList) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        HashMap<Object, Object> converMap = new HashMap<Object, Object>(this.convertMapToServerCKCI(aParameterList));
        final SrFuture<Void> dmFuture = ((GeneralLogicObject)curObj).changeElement(converMap);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.changeElementFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __changeElementFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected HashMap __checkConsistencyBetweenVSwitches(CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        HashMap retVal = curObj.checkConsistencyBetweenVSwitches();
        return retVal;
    }

    @Override
    protected Boolean __setStateSeverity(CommKeyClassId aObject, AlarmSeverity aState) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        boolean retVal = curObj.setStateSeverity(aState);
        return retVal;
    }

    @Override
    protected Void __setAcknowledgeStateSeverity(CommKeyClassId aObject, AlarmSeverity aSeverity) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        curObj.setAcknowledgeStateSeverity(aSeverity);
        return null;
    }

    @Override
    protected void __refreshFields(final SrFuture<Void> aFuture, List<Object> aObject, ClientParameterCode[] aCodes) throws Exception {
        RemoteObject curObj = null;
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        for (Object curHash : aObject) {
            if (curHash == null) {
                theLogger.debug(SrLogCategories.INFORMATIVE, new Object[]{"The refreshFields method was called with null as the object (this may be caused by a rediscover in the client which removed the id of a pair or CG sent)."});
                continue;
            }
            if (curHash instanceof String) {
                curObj = this.getLogicObjectAndCheckNotNull((String)curHash);
            } else if (curHash instanceof CommKeyClassId) {
                curObj = this.getLogicObjectAndCheckNotNull((CommKeyClassId)curHash);
            } else {
                throw new IllegalArgumentException("The given objects should all be String instances or CKCI instance, but the list contains an " + curHash.getClass() + " instance.");
            }
            ClassID classId = ((GeneralLogicObject)curObj).getClassId();
            if (classId.isDRClassId()) {
                midFutures.add(DRRootImpl.getInstance().refreshPendingPits(classId));
                break;
            }
            midFutures.add(((GeneralLogicObject)curObj).refreshFields(aCodes));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)aFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
    }

    @Override
    protected Void __refreshFieldsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startReplicate(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRActivate) && !(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof DRActivate) {
            final SrFuture<Void> dmFuture = ((DRActivate)curObj).startReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.startReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Site) {
            final SrFuture<Void> dmFuture = ((Site)curObj).startReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.startReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given object is of type " + curObj.getClass() + " which was not caught in the parameter validation");
        }
    }

    @Override
    protected void __startReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRActivate) && !(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof DRActivate) {
            final SrFuture<Void> dmFuture = ((DRActivate)((Object)curObj)).startReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.startReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Site) {
            final SrFuture<Void> dmFuture = ((Site)((Object)curObj)).startReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.startReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given object is of type " + curObj.getClass() + " which was not caught in the parameter validation");
        }
    }

    @Override
    protected Void __startReplicateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortReplicate(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRActivate) && !(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof DRActivate) {
            final SrFuture<Void> dmFuture = ((DRActivate)curObj).abortReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.abortReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Site) {
            final SrFuture<Void> dmFuture = ((Site)curObj).abortReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.abortReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given object is of type " + curObj.getClass() + " which was not caught in the parameter validation");
        }
    }

    @Override
    protected void __abortReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRActivate) && !(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof DRActivate) {
            final SrFuture<Void> dmFuture = ((DRActivate)((Object)curObj)).abortReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.abortReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Site) {
            final SrFuture<Void> dmFuture = ((Site)((Object)curObj)).abortReplicate();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.abortReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given object is of type " + curObj.getClass() + " which was not caught in the parameter validation");
        }
    }

    @Override
    protected void __plannedFailover(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRActivate) && !(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        LogicMgrAOImpl.stopPollingAndTraps((GeneralLogicObjectImpl)curObj);
        if (curObj instanceof DRActivate) {
            final DRActivate execObj = (DRActivate)curObj;
            final SrFuture<Void> dmFuture = execObj.plannedFailover();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.plannedFailoverFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Site) {
            final Site execObj = (Site)curObj;
            final SrFuture<Void> dmFuture = execObj.plannedFailover();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.plannedFailoverFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given object is of type " + curObj.getClass() + " which was not caught in the parameter validation");
        }
    }

    @Override
    protected void __fallback(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRActivate) && !(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        LogicMgrAOImpl.stopPollingAndTraps((GeneralLogicObjectImpl)curObj);
        if (curObj instanceof DRActivate) {
            final DRActivate execObj = (DRActivate)curObj;
            final SrFuture<Void> dmFuture = execObj.fallback();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.fallbackFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Site) {
            final Site execObj = (Site)curObj;
            final SrFuture<Void> dmFuture = execObj.fallback();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.fallbackFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given object is of type " + curObj.getClass() + " which was not caught in the parameter validation");
        }
    }

    @Override
    protected Void __fallbackFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture, GeneralLogicObject aObj) {
        LogicMgrAOImpl.restartPollingAndTraps((GeneralLogicObjectImpl)aObj);
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __disasterOccured(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRActivate) && !(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        final GeneralLogicObject execObj = (GeneralLogicObject)curObj;
        if (curObj instanceof DRActivate) {
            final SrFuture<Void> dmFuture = ((DRActivate)curObj).disasterOccured();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.disasterOccuredFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Site) {
            final SrFuture<Void> dmFuture = ((Site)curObj).disasterOccured();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.disasterOccuredFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The parameter validation is invalid. An instance of " + curObj.getClass() + " should have been found in the parameter validation.");
        }
    }

    @Override
    protected void __forceReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRAbstractConsistencyGroup)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRAbstractConsistencyGroup execObj = (DRAbstractConsistencyGroup)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.forceReplicate();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.forceReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __forceReplicateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshPiTs(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRAbstractConsistencyGroup) && !(curObj instanceof DRAsyncPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof DRAbstractConsistencyGroup) {
            final SrFuture<Void> dmFuture = ((DRAbstractConsistencyGroup)curObj).refreshPiTs();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.refreshPiTsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof DRAsyncPair) {
            final SrFuture<Void> dmFuture = ((DRAsyncPair)curObj).refreshPiTs();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.refreshPiTsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The parameter validation is invalid. An instance of " + curObj.getClass() + " should have been found in the parameter validation.");
        }
    }

    @Override
    protected Void __refreshPiTsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __recover(final SrFuture<Void> aFuture, String aObject, CommKeyClassId aVolume) throws Exception {
        CommKeyClassId serverVolume = this.getServerCKCI(aVolume);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRSyncPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        final DRSyncPairImpl execObj = (DRSyncPairImpl)curObj;
        LogicMgrAOImpl.stopPollingAndTraps(execObj);
        final SrFuture<Void> dmFuture = execObj.recover(serverVolume);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.recoverFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __recoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture, GeneralLogicObject aObj) throws Exception {
        LogicMgrAOImpl.restartPollingAndTraps((GeneralLogicObjectImpl)aObj);
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __recover(final SrFuture<Void> aFuture, String aObject, CommKeyClassId aVolume, CommKeyClassId aSnapshot, CommKeyClassId aJournal) throws Exception {
        CommKeyClassId serverVolume = this.getServerCKCI(aVolume);
        CommKeyClassId serverSnapshot = this.getServerCKCI(aSnapshot);
        CommKeyClassId serverJournal = this.getServerCKCI(aJournal);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRAsyncPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        final DRAsyncPairImpl execObj = (DRAsyncPairImpl)curObj;
        LogicMgrAOImpl.stopPollingAndTraps(execObj);
        final SrFuture<Void> dmFuture = execObj.recover(serverVolume, serverSnapshot, serverJournal);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.recoverFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Boolean __checkNonFunctionalOfVolumes(String aObject) throws Exception {
        boolean retVal = false;
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRAsyncPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRAsyncPair execObj = (DRAsyncPair)curObj;
        retVal = execObj.checkNonFunctionalOfVolumes();
        return retVal;
    }

    @Override
    protected void __endInitialSync(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRAsyncPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRAsyncPair execObj = (DRAsyncPair)curObj;
        final SrFuture<Void> dmFuture = execObj.endInitialSync();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.endInitialSyncFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __endInitialSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortInitialSync(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRPair execObj = (DRPair)curObj;
        final SrFuture<Void> dmFuture = execObj.abortInitialSync();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.abortInitialSyncFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __abortInitialSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startInitialSync(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRPair execObj = (DRPair)curObj;
        final SrFuture<Void> dmFuture = execObj.startInitialSync();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.startInitialSyncFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __startInitialSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshInitialSyncProgress(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRPair)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRPair execObj = (DRPair)curObj;
        final SrFuture<Void> dmFuture = execObj.refreshInitialSyncProgress();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.refreshInitialSyncProgressFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __refreshInitialSyncProgressFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected DRSyncPair __returnSource(String aObject) throws Exception {
        DRSyncPair retVal = null;
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof InnerActivate)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        InnerActivate execObj = (InnerActivate)curObj;
        retVal = execObj.returnSource();
        return retVal;
    }

    @Override
    protected Boolean __validAndActivate(String aObject, DRActivateConstant aState, boolean aIsSnapshotNeeded) throws Exception {
        boolean retVal = false;
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRVolume)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRVolume execObj = (DRVolume)curObj;
        retVal = execObj.validAndActivate(aState, aIsSnapshotNeeded);
        return retVal;
    }

    @Override
    protected String[] __checkAliasConsistencyBetweenVSwitches(CommKeyClassId aObject) throws Exception {
        String[] retVal = null;
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof GeneralAliasObject)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        GeneralAliasObject execObj = (GeneralAliasObject)((Object)curObj);
        retVal = execObj.checkAliasConsistencyBetweenVSwitches();
        return retVal;
    }

    @Override
    protected Integer __synchronize(CommKeyClassId aObject) throws IllegalArgumentException, IllegalValueException, RemoteException {
        int retVal = 0;
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Synchronizeable) && !(curObj instanceof VSwitchGroup)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof Synchronizeable) {
            retVal = ((Synchronizeable)((Object)curObj)).synchronize();
        } else if (curObj instanceof VSwitchGroup) {
            retVal = ((VSwitchGroup)((Object)curObj)).synchronize();
        } else {
            throw new IllegalStateException("The given parameter is of type " + curObj.getClassId() + " which is not valid for this method and has not been " + "caught in the parameter validation.");
        }
        return retVal;
    }

    @Override
    protected void __createIdentityName(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Identity)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Identity execObj = (Identity)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createIdentityName(aName);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createIdentityNameFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __createSRPCredentials(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName, String aPassword) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Identity)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Identity execObj = (Identity)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createSRPCredentials(aName, aPassword);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSRPCredentialsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __createCHAPCredentials(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName, String aPassword, boolean aisRadiusEnabled) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Identity)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Identity execObj = (Identity)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createCHAPCredentials(aName, aPassword, aisRadiusEnabled);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createCHAPCredentialsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createCHAPCredentialsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __createSRPCredentialsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __createIdentityNameFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __discoverRemoteTargets(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof ISCSIRemotePortalDiscovery)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        ISCSIRemotePortalDiscovery execObj = (ISCSIRemotePortalDiscovery)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.discoverRemoteTargets();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.discoverRemoteTargetsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __discoverRemoteTargetsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISCSIRemoteTargetPortal(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIp, int aPort, int aPortalGroupTag) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof ISCSIRemoteTarget)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        ISCSIRemoteTarget execObj = (ISCSIRemoteTarget)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createISCSIRemoteTargetPortal(aIp, aPort, aPortalGroupTag);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createISCSIRemoteTargetPortalFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createISCSIRemoteTargetPortalFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __setExposed(CommKeyClassId aObject, boolean aExposed) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        execObj.setExposed(aExposed);
        return null;
    }

    @Override
    protected Void __setFree(CommKeyClassId aObject, boolean aFree) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        execObj.setFree(aFree);
        return null;
    }

    @Override
    protected Void __setParent(CommKeyClassId aObject, VolumeNode aParent, int aStam) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        execObj.setParent(aParent, aStam);
        return null;
    }

    @Override
    protected Void __setParentLU(CommKeyClassId aObject, LUImpl aParent) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNodeImpl execObj = (VolumeNodeImpl)curObj;
        execObj.setParentLU(aParent);
        return null;
    }

    @Override
    protected void __mirrorSync(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.mirrorSync();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.mirrorSyncFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __mirrorSyncFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __offlineCopy(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aDestination) throws Exception {
        CommKeyClassId serverDestination = this.getServerCKCI(aDestination);
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.offlineCopy(serverDestination);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.offlineCopyFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __offlineCopyFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __replace(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aNewVolume) throws Exception {
        CommKeyClassId serverNewVolume = this.getServerCKCI(aNewVolume);
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.replace(serverNewVolume);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.replaceFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __replaceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __addMirror(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aChild, String aMirrVolAlias, boolean aAutoSync) throws Exception {
        CommKeyClassId serverChild = this.getServerCKCI(aChild);
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.addMirror(serverChild, aMirrVolAlias, aAutoSync);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.addMirrorFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __addMirrorFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __resize(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aChild, String aMirrVolAlias) throws Exception {
        CommKeyClassId serverChild = this.getServerCKCI(aChild);
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VolumeNode)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VolumeNode execObj = (VolumeNode)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.resize(serverChild, aMirrVolAlias);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.resizeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __resizeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSubDirectAccessDevice(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias, BigInteger aSize) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DirectAccessDevice)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DirectAccessDevice execObj = (DirectAccessDevice)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createSubDirectAccessDevice(aAlias, aSize);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSubDirectAccessDeviceFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createSubDirectAccessDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSubDirectAccessDevice(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias, BigInteger aStartAddr, BigInteger aSize) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DirectAccessDevice)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DirectAccessDevice execObj = (DirectAccessDevice)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createSubDirectAccessDevice(aAlias, aStartAddr, aSize);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSubDirectAccessDeviceFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __createSubDirectAccessDevice(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DirectAccessDevice)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DirectAccessDevice execObj = (DirectAccessDevice)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createSubDirectAccessDevice(aAlias);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSubDirectAccessDeviceFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __expand(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof ConcatinationVolume) && !(curObj instanceof MirrorVolume)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof ConcatinationVolume) {
            final SrFuture<Void> dmFuture = ((ConcatinationVolume)((Object)curObj)).expand();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.expandFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof MirrorVolume) {
            final SrFuture<Void> dmFuture = ((MirrorVolume)((Object)curObj)).expand();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.expandFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given argument is a " + curObj.getClassId() + " instance, which is an invalid for for this method and has not been caught in" + " the parameter validation.");
        }
    }

    @Override
    protected Void __expandFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __retract(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof ConcatinationVolume)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        ConcatinationVolume execObj = (ConcatinationVolume)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.retract();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.retractFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __retractFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshPercentUtilization(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof JournalVolume)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        JournalVolume execObj = (JournalVolume)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.refreshPercentUtilization();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.refreshPercentUtilizationFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __refreshPercentUtilizationFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __breakMirror(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId[] aChildren) throws Exception {
        CommKeyClassId[] serverChildren = this.getServerCKCI(aChildren);
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof MirrorVolume)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        MirrorVolume execObj = (MirrorVolume)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.breakMirror(serverChildren);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.breakMirrorFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __breakMirrorFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __setActivedState(final SrFuture<Void> aFuture, CommKeyClassId aObject, SnapshotActivateTypeConstants aState) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof SnapshotVolume)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        SnapshotVolume execObj = (SnapshotVolume)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.setActivedState(aState);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.setActivedStateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __setActivedStateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __restore(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof SnapshotVolume)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        SnapshotVolume execObj = (SnapshotVolume)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.restore();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.restoreFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __restoreFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startPolling(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Statistics)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Statistics execObj = (Statistics)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.startPolling();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.startPollingFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __startPollingFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __stopPolling(final SrFuture<Integer> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Statistics)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Statistics execObj = (Statistics)((Object)curObj);
        final SrFuture<Integer> dmFuture = execObj.stopPolling();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.stopPollingFinished((SrFuture<Integer>)aFuture, (SrFuture<Integer>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __stopPollingFinished(SrFuture<Integer> aFutureToUpdate, SrFuture<Integer> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected ISCSISession __getSessionStub(CommKeyClassId aObject) throws Exception {
        ISCSISession retVal = null;
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof ISCSISessionStatistics)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        ISCSISessionStatistics execObj = (ISCSISessionStatistics)((Object)curObj);
        retVal = execObj.getSessionStub();
        return retVal;
    }

    @Override
    protected void __rediscover(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        if (this.myLoadFuture == null || !this.myLoadFuture.isDone()) {
            throw new IllegalStateException("Can not execute rediscover before the system was initially discovered.");
        }
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof SystemRoot || curObj instanceof Site || curObj instanceof Cluster || curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof VSwitchGroup) {
            VSwitchGroup execObj = (VSwitchGroup)((Object)curObj);
            final SrFuture<Void> dmFuture = execObj.rediscover();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.updateFutureByGivenFuture(dmFuture, aFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof VSwitch) {
            VSwitch execObj = (VSwitch)((Object)curObj);
            final SrFuture<Void> dmFuture = execObj.rediscover();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.updateFutureByGivenFuture(dmFuture, aFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given instance is of an invalid type but it has not been detected in the parameter verification.");
        }
    }

    @Override
    protected Void __rediscoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __manualDiscover(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (curObj == null || !(curObj instanceof VSwitch) && !(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof VSwitch) {
            final SrFuture<Void> dmFuture = ((VSwitch)((Object)curObj)).manualDiscover();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.manualDiscoverFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else if (curObj instanceof Cluster) {
            final SrFuture<Void> dmFuture = ((Cluster)((Object)curObj)).manualDiscover();
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.manualDiscoverFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
        } else {
            throw new IllegalStateException("The given argument is of the type " + curObj.getClassId() + " which is invalid for this method, and has not been " + "caught in the parameter validation.");
        }
    }

    @Override
    protected Void __manualDiscoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __reset(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitch execObj = (VSwitch)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.reset();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.resetFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __resetFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __shutdown(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitch execObj = (VSwitch)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.shutdown();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.shutdownFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __shutdownFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __wakeOnLAN(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitch execObj = (VSwitch)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.wakeOnLAN();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.wakeOnLANFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __wakeOnLANFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createIPTableRow(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIP, String aMask, String aActivity, String aInterfaceName) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitch execObj = (VSwitch)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createIPTableRow(aIP, aMask, aActivity, aInterfaceName);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createIPTableRowFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createIPTableRowFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createIPRouteTableRow(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aDestIP, String aDestMask, String aGateway, String aInterfaceName) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitch execObj = (VSwitch)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createIPRouteTableRow(aDestIP, aDestMask, aGateway, aInterfaceName);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createIPRouteTableRowFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createIPRouteTableRowFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createPortalTableRow(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIP, int aPort) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitch execObj = (VSwitch)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createPortalTableRow(aIP, aPort);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createPortalTableRowFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createPortalTableRowFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __refreshRemoteDiscoveryPortalsTable(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitch)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitch execObj = (VSwitch)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.refreshRemoteDiscoveryPortalsTable();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.refreshRemoteDiscoveryPortalsTableFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __refreshRemoteDiscoveryPortalsTableFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __addVSwitch(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Site execObj = (Site)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.addVSwitch(aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.addVSwitchFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __addVSwitchFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Boolean __isDiscoverCompleted(CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof VSwitchGroup)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        VSwitchGroup execObj = (VSwitchGroup)((Object)curObj);
        return execObj.isDiscoverCompleted();
    }

    @Override
    protected void __addClusterVSwitch(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        ClusterImpl execObj = (ClusterImpl)curObj;
        if (execObj.getVSwitchesCount() == 1) {
            execObj.setAddNeighborContext();
        }
        final SrFuture<Void> dmFuture = execObj.addVSwitch(aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.addClusterVSwitchFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __addClusterVSwitchFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createIdentity(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias, String aDescription) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Cluster execObj = (Cluster)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createIdentity(aAlias, aDescription);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createIdentityFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createIdentityFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __deleteObjects(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId[] aCkciToDelete) throws Exception {
        if (aCkciToDelete == null) {
            throw new IllegalArgumentException("The given CKCI array should not be null.");
        }
        CommKeyClassId[] serverCkciToDelete = this.getServerCKCI(aCkciToDelete);
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Cluster execObj = (Cluster)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.deleteObjects(serverCkciToDelete);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.deleteObjectsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __deleteObjectsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createRadiusServer(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aServerIP, String aPort, String aKey) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Cluster execObj = (Cluster)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createRadiusServer(aServerIP, aPort, aKey);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createRadiusServerFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createRadiusServerFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISNSServer(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aServerIP) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Cluster execObj = (Cluster)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createISNSServer(aServerIP);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createISNSServerFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createISNSServerFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __moveToSite(final SrFuture<Void> aFuture, CommKeyClassId aObject, CommKeyClassId aSite) throws Exception {
        CommKeyClassId serverSite = this.getServerCKCI(aSite);
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Cluster execObj = (Cluster)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.moveToSite(serverSite);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.moveToSiteFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __moveToSiteFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createRemoteDiscoveryPortal(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aIpAddress, Integer aPort) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Cluster)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Cluster execObj = (Cluster)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createRemoteDiscoveryPortal(aIpAddress, aPort);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createRemoteDiscoveryPortalFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createRemoteDiscoveryPortalFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createCluster(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Site execObj = (Site)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createCluster(aAlias);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createClusterFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createClusterFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSite(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aAlias) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Site execObj = (Site)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.createSite(aAlias);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSiteFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createSiteFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __plannedFailover(final SrFuture<Void> aFuture, CommKeyClassId aObject, DRActivate[] aDrActivateObjects) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        final SiteImpl execObj = (SiteImpl)curObj;
        LogicMgrAOImpl.stopPollingAndTraps(execObj);
        final SrFuture<Void> dmFuture = execObj.plannedFailover(aDrActivateObjects);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.plannedFailoverFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __plannedFailoverFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture, GeneralLogicObject aObj) {
        LogicMgrAOImpl.restartPollingAndTraps((GeneralLogicObjectImpl)aObj);
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __fallback(final SrFuture<Void> aFuture, CommKeyClassId aObject, DRActivate[] aDrActivateObjects) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        final SiteImpl execObj = (SiteImpl)curObj;
        LogicMgrAOImpl.stopPollingAndTraps(execObj);
        final SrFuture<Void> dmFuture = execObj.fallback(aDrActivateObjects);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.fallbackFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __disasterOccured(final SrFuture<Void> aFuture, CommKeyClassId aObject, DRActivate[] aDrActivateObjects) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        final SiteImpl execObj = (SiteImpl)curObj;
        LogicMgrAOImpl.stopPollingAndTraps(execObj);
        final SrFuture<Void> dmFuture = execObj.disasterOccured(aDrActivateObjects);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.disasterOccuredFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture, execObj);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __disasterOccuredFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture, GeneralLogicObject aObj) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __abortReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject, DRActivate[] aDrActivateObjects) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Site execObj = (Site)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.abortReplicate(aDrActivateObjects);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.abortReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __abortReplicateFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __startReplicate(final SrFuture<Void> aFuture, CommKeyClassId aObject, DRActivate[] aDrActivateObjects) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Site execObj = (Site)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.startReplicate(aDrActivateObjects);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.startReplicateFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected FileInterface __getFileInterface() throws Exception {
        FileInterface retVal = null;
        retVal = SystemRootImpl.getInstance().getFileInterface();
        return retVal;
    }

    @Override
    protected Void __exportConfigurationFile() throws Exception {
        SystemRootImpl.getInstance().exportConfigurationFile();
        return null;
    }

    @Override
    protected Void __importConfigurationFile() throws Exception {
        SystemRootImpl.getInstance().importConfigurationFile();
        return null;
    }

    @Override
    protected Integer __getCopyPercentage(CommKeyClassId aObject) throws Exception {
        int retVal = 0;
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof CopyOperation)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        CopyOperation execObj = (CopyOperation)((Object)curObj);
        retVal = execObj.getCopyPercentage();
        return retVal;
    }

    @Override
    protected void __abortOperation(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof CopyOperation)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        CopyOperation execObj = (CopyOperation)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.abortOperation();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.abortOperationFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __abortOperationFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __restartOperation(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof CopyOperation)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        CopyOperation execObj = (CopyOperation)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.restartOperation();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.restartOperationFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __restartOperationFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __validAndActivateCluster(CommKeyClassId aObject, ParameterList aParams) throws IllegalArgumentException, IllegalValueException, RemoteException {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof DRClusterLogicObject)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        DRClusterLogicObject execObj = (DRClusterLogicObject)((Object)curObj);
        execObj.validAndActivate(aParams);
        return null;
    }

    @Override
    protected Void __setClientLogProperties(Properties aProps) throws Exception {
        LogManagerImpl.getInstance().setClientLogProperties(aProps);
        return null;
    }

    @Override
    protected Void __setCliLogProperties(Properties aProps) throws Exception {
        LogManagerImpl.getInstance().setCliLogProperties(aProps);
        return null;
    }

    @Override
    protected Void __setServerLogProperties(Properties aProps) throws Exception {
        LogManagerImpl.getInstance().setServerLogProperties(aProps);
        return null;
    }

    @Override
    protected Properties __getClientLogProps() throws Exception {
        Properties retVal = null;
        retVal = LogManagerImpl.getInstance().getClientLogProps();
        return retVal;
    }

    @Override
    protected Properties __getServerLogProps() throws Exception {
        Properties retVal = null;
        retVal = LogManagerImpl.getInstance().getServerLogProps();
        return retVal;
    }

    @Override
    protected CommKeyClassId __getPhysStorBySimpleVol(char aAgentId, String aSimpleVolId) throws Exception {
        CommKeyClassId retVal = null;
        retVal = SimpleVolumeMgr.getInstance().getPhysStorBySimpleVol(aAgentId, aSimpleVolId);
        return retVal;
    }

    @Override
    protected String __getSimpleVolByPhysStor(char aAgentId, CommKeyClassId aPhysStorData) throws Exception {
        String retVal = null;
        CommKeyClassId serverPhysStorData = this.getServerCKCI(aPhysStorData);
        retVal = SimpleVolumeMgr.getInstance().getSimpleVolByPhysStor(aAgentId, serverPhysStorData);
        return retVal;
    }

    @Override
    protected void __createConcatinationVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId[] achildrenCommKeyClassId) throws Exception {
        CommKeyClassId[] serverChildrenCommKeyClassId = this.getServerCKCI(achildrenCommKeyClassId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createConcatinationVolume(aVolAlias, serverChildrenCommKeyClassId);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createConcatinationVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createConcatinationVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createMirrorVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId[] achildrenCommKeyClassId) throws Exception {
        CommKeyClassId[] serverChildrenCommKeyClassId = this.getServerCKCI(achildrenCommKeyClassId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createMirrorVolume(aVolAlias, serverChildrenCommKeyClassId);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createMirrorVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createMirrorVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSnapshotVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId aSourceVolume, CommKeyClassId aChildCKCI, int aThreshold) throws Exception {
        CommKeyClassId serverSourceVolume = this.getServerCKCI(aSourceVolume);
        CommKeyClassId serverChildCKCI = this.getServerCKCI(aChildCKCI);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createSnapshotVolume(aVolAlias, serverSourceVolume, serverChildCKCI, aThreshold);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSnapshotVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createSnapshotVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createSnapshotVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId aSourceVolume, CommKeyClassId aChildCKCI, int aThreshold, SnapshotActivateTypeConstants aSnapActType) throws Exception {
        CommKeyClassId serverSourceVolume = this.getServerCKCI(aSourceVolume);
        CommKeyClassId serverChildCKCI = this.getServerCKCI(aChildCKCI);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createSnapshotVolume(aVolAlias, serverSourceVolume, serverChildCKCI, aThreshold, aSnapActType);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createSnapshotVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __createStripeVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId[] achildrenCommKeyClassId, BigInteger aStripeSize) throws Exception {
        CommKeyClassId[] serverChildrenCommKeyClassId = this.getServerCKCI(achildrenCommKeyClassId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createStripeVolume(aVolAlias, serverChildrenCommKeyClassId, aStripeSize);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createStripeVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createStripeVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createTransparentVolume(final SrFuture<Void> aFuture, String aObject, String aVolAlias, CommKeyClassId achildCommKeyClassId) throws Exception {
        CommKeyClassId serverChildCommKeyClassId = this.getServerCKCI(achildCommKeyClassId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createTransparentVolume(aVolAlias, serverChildCommKeyClassId);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createTransparentVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createTransparentVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createJournalVolume(final SrFuture<Void> aFuture, String aObject, String aAlias, Integer aThreshold, CommKeyClassId aVolumeNodeChildId, CommKeyClassId aActiveOnVswitchId) throws Exception {
        CommKeyClassId serverVolumeNodeChildId = this.getServerCKCI(aVolumeNodeChildId);
        CommKeyClassId serverActiveOnVswitchId = this.getServerCKCI(aActiveOnVswitchId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createJournalVolume(aAlias, aThreshold, serverVolumeNodeChildId, serverActiveOnVswitchId);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createJournalVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createJournalVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __exposeVolume(final SrFuture<Void> aFuture, String aObject, int aLuNumber, CommKeyClassId aVolumeCommKeyClassId, CommKeyClassId aTargetCommKeyClassId) throws Exception {
        CommKeyClassId serverVolumeCommKeyClassId = this.getServerCKCI(aVolumeCommKeyClassId);
        CommKeyClassId serverTargetCommKeyClassId = this.getServerCKCI(aTargetCommKeyClassId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.exposeVolume(aLuNumber, serverVolumeCommKeyClassId, serverTargetCommKeyClassId);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.exposeVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __exposeVolumeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __exposeVolume(final SrFuture<Void> aFuture, String aObject, int aLuNumber, CommKeyClassId aVolumeCommKeyClassId, CommKeyClassId aTargetCommKeyClassId, String aSerialNumber) throws Exception {
        CommKeyClassId serverVolumeCommKeyClassId = this.getServerCKCI(aVolumeCommKeyClassId);
        CommKeyClassId serverTargetCommKeyClassId = this.getServerCKCI(aTargetCommKeyClassId);
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.exposeVolume(aLuNumber, serverVolumeCommKeyClassId, serverTargetCommKeyClassId, aSerialNumber);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.exposeVolumeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __createISCSITarget(final SrFuture<Void> aFuture, String aObject, String aName, String aAlias, String aVS) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createISCSITarget(aName, aAlias, aVS);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createISCSITargetFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createISCSITargetFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISCSITarget(final SrFuture<Void> aFuture, String aObject, String aName, String aAlias, Permission aDefaultAccess, String aVS) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createISCSITarget(aName, aAlias, aDefaultAccess, aVS);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createISCSITargetFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __readSnapshotVolumes(final SrFuture<Void> aFuture, String aObject) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.readSnapshotVolumes();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.readSnapshotVolumesFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __readSnapshotVolumesFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createGeneralISCSIDevice(final SrFuture<Void> aFuture, String aObject, PhysicalStorageTypeConstant aType, String aAlias, String aTarget, int aLun, String aSerialNumber) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createGeneralISCSIDevice(aType, aAlias, aTarget, aLun, aSerialNumber);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createGeneralISCSIDeviceFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createGeneralISCSIDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createGeneralParallelSCSIDevice(final SrFuture<Void> aFuture, String aObject, PhysicalStorageTypeConstant aType, String aAlias, int aPort, int aBus, int aLun, String aSerialNumber) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createGeneralParallelSCSIDevice(aType, aAlias, aPort, aBus, aLun, aSerialNumber);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createGeneralParallelSCSIDeviceFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createGeneralParallelSCSIDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createGeneralFiberChannelDevice(final SrFuture<Void> aFuture, String aObject, PhysicalStorageTypeConstant aType, String aAlias, byte[] aTargetName, int aLun, String aSerialNumber) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createGeneralFiberChannelDevice(aType, aAlias, aTargetName, aLun, aSerialNumber);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createGeneralFiberChannelDeviceFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createGeneralFiberChannelDeviceFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __createISCSIRemoteTarget(final SrFuture<Void> aFuture, String aObject, String aRemoteTargetName, String aRemoteTargetAlias) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.createISCSIRemoteTarget(aRemoteTargetName, aRemoteTargetAlias);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.createISCSIRemoteTargetFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __createISCSIRemoteTargetFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __discoverRemoteTargets(final SrFuture<Void> aFuture, String aObject, ISCSIRemotePortalDiscovery[] aRemoteDiscoveryPortals) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.discoverRemoteTargets(aRemoteDiscoveryPortals);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.discoverRemoteTargetsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __activateDeactivateSnapshots(final SrFuture<Void> aFuture, String aObject, SnapshotVolume[] aSnapshots, SnapshotActivateTypeConstants aSnapActivateType) throws Exception {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        final SrFuture<Void> dmFuture = execObj.activateDeactivateSnapshots(aSnapshots, aSnapActivateType);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.activateDeactivateSnapshotsFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __activateDeactivateSnapshotsFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Volume __getVolumeByAlias(String aObject, String aAlias) throws Exception {
        Volume retVal = null;
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage) && !(curObj instanceof VolumeTree)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        if (curObj instanceof Storage) {
            retVal = ((Storage)curObj).getVolumeByAlias(aAlias);
        } else if (curObj instanceof VolumeTree) {
            retVal = ((VolumeTree)curObj).getVolumeByAlias(aAlias);
        } else {
            throw new IllegalStateException("The argument is of the type " + curObj.getClass() + " which is invalid for this method, and has not been caught in the parameter" + " validation.");
        }
        return retVal;
    }

    @Override
    protected Volume __getExposedOrUnexposedVolumeByAlias(String aObject, String aAlias) throws Exception {
        Volume retVal = null;
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Storage)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Storage execObj = (Storage)curObj;
        retVal = execObj.getExposedOrUnexposedVolumeByAlias(aAlias);
        return retVal;
    }

    @Override
    protected Void __changePassword(String aObject, String aOldPassword, String aNewPassword) throws IllegalArgumentException, IllegalValueException, RemoteException {
        RemoteObject curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof User)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        User execObj = (User)curObj;
        execObj.changePassword(aOldPassword, aNewPassword);
        return null;
    }

    @Override
    protected Void __siteDeleteElementFollowUp(SiteImpl aTriggeringSite, final SrFuture<Void> aFutureToUpdate, List<SrFuture<Void>> aFinishedFutures) throws Exception {
        for (SrFuture<Void> curFuture : aFinishedFutures) {
            try {
                curFuture.get();
            }
            catch (Exception e) {
                aFutureToUpdate.setException((Throwable)e);
                return null;
            }
        }
        final SrFuture<Void> superFuture = aTriggeringSite.deleteElementSuper();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFuture(superFuture, aFutureToUpdate);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{superFuture});
        return null;
    }

    public void bindToRMIRegistry(Registry registry, String aRegName) throws RemoteException {
        String hostname = Server.getHostAddress();
        int exportPort = Server.getRMIExportPort();
        if (exportPort > 0) {
            UnicastRemoteObject.exportObject(this, exportPort, (RMIClientSocketFactory)new SrSocketFactory(hostname), (RMIServerSocketFactory)new SrSocketFactory(hostname));
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{this, " was exported via port ", exportPort});
        } else {
            UnicastRemoteObject.exportObject(this);
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{this, " was exported via \"any\" (no special) port "});
        }
        String serverObjectName = aRegName;
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Trying to bind ", this, " to ", serverObjectName});
        try {
            registry.bind(serverObjectName, this);
        }
        catch (AccessException ae) {
            theLogger.fatal(SrLogCategories.LEGACY, (Throwable)ae, new Object[0]);
        }
        catch (AlreadyBoundException abe) {
            theLogger.fatal(SrLogCategories.LEGACY, (Throwable)abe, new Object[0]);
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{this, " binding to ", serverObjectName, " succeeded"});
    }

    @Override
    public ServerFacade openSession(ServerEventsListener aListener) throws ServerConnectionException {
        try {
            return (ServerFacade)this.innerOpenSession(aListener).get();
        }
        catch (InterruptedException exp) {
            theLogger.error(SrLogCategories.ERROR, (Throwable)exp, new Object[]{"Could not connect the listener " + aListener + " to the server."});
            ServerConnectionException newExp = new ServerConnectionException("Could not connect the listener " + aListener + " to the server.", exp);
            throw newExp;
        }
        catch (ExecutionException exp) {
            theLogger.error(SrLogCategories.ERROR, (Throwable)exp, new Object[]{"Could not connect the listener " + aListener + " to the server."});
            ServerConnectionException newExp = new ServerConnectionException("Could not connect the listener " + aListener + " to the server.", exp.getCause());
            throw newExp;
        }
    }

    @Override
    protected Integer __stopPollingFollowUp(InterfacesGroupStatisticsImpl aObj, SrFuture<Integer> aFutureToUpdate, SrFuture<Integer> aFromBaseFuture) throws Exception {
        int counter = (Integer)aFromBaseFuture.get();
        if (counter == 0) {
            aObj.clearInterfacesData();
        }
        aFutureToUpdate.set((Object)counter);
        return counter;
    }

    @Override
    protected Void __updateFutureByGivenFutures(final List<SrFuture<Void>> aSourceFuture, final SrFuture<Void> aTargetFuture, final Runnable aFollowUp) throws Exception {
        if (aSourceFuture == null || aTargetFuture == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given parameters should not be null. aSourceFuture = ", aSourceFuture, "; aTargetFuture = ", aTargetFuture});
        }
        for (SrFuture<Void> curFuture : aSourceFuture) {
            if (curFuture.isDone()) continue;
            theLogger.warn(SrLogCategories.ILLEGAL_STATE, new Object[]{"The __updateFutureByGivenFutures method was called although one of the source futures is not done. Source futures = ", aSourceFuture, ". The stack trace of the future which is not complete is: ", curFuture.getStackTraceString(), "; A listener has been created for the futures and it will recall __updateFutureByGivenFutures"});
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.updateFutureByGivenFutures(aSourceFuture, (SrFuture<Void>)aTargetFuture, aFollowUp);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, aSourceFuture);
            return null;
        }
        aFollowUp.run();
        if (aSourceFuture.size() == 0) {
            aTargetFuture.set(null);
        }
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
        for (SrFuture<Void> curFuture : aSourceFuture) {
            try {
                curFuture.get();
            }
            catch (ExecutionException exp) {
                exceptions.add(exp);
            }
        }
        if (exceptions.size() > 0) {
            SrExecutionException expt = new SrExecutionException(exceptions);
            aTargetFuture.setException((Throwable)expt);
        } else {
            aTargetFuture.set(aSourceFuture.get(0).get());
        }
        return null;
    }

    @Override
    protected <T> Void __updateFutureByGivenFutures(final List<SrFuture<T>> aSourceFuture, final SrFuture<T> aTargetFuture, final Callable aFollowUp) throws Exception {
        if (aSourceFuture == null || aTargetFuture == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given parameters should not be null. aSourceFuture = ", aSourceFuture, "; aTargetFuture = ", aTargetFuture});
        }
        for (SrFuture<T> curFuture : aSourceFuture) {
            if (curFuture.isDone()) continue;
            theLogger.warn(SrLogCategories.BUG, new Object[]{"The __updateFutureByGivenFutures method was called although one of the source futures is not done. Source futures = ", aSourceFuture, ". The stack trace of the future which is not complete is: ", curFuture.getStackTraceString(), "; A listener has been created for the futures and it will recall __updateFutureByGivenFutures"});
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.updateFutureByGivenFutures(aSourceFuture, aTargetFuture, aFollowUp);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, aSourceFuture);
            return null;
        }
        aFollowUp.call();
        if (aSourceFuture.size() == 0) {
            aTargetFuture.set(null);
        }
        ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>();
        for (SrFuture<T> curFuture : aSourceFuture) {
            try {
                curFuture.get();
            }
            catch (ExecutionException exp) {
                exceptions.add(exp);
            }
        }
        if (exceptions.size() > 0) {
            SrExecutionException expt = new SrExecutionException(exceptions);
            aTargetFuture.setException((Throwable)expt);
        } else {
            aTargetFuture.set(aSourceFuture.get(0).get());
        }
        return null;
    }

    @Override
    protected <T> Void __waitForFuturesAndUpdateFromCallable(List<SrFuture<T>> aSourceFuture, SrFuture<T> aTargetFuture, Callable aFollowUp) throws Exception {
        if (aSourceFuture == null || aTargetFuture == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given parameters should not be null. aSourceFuture = ", aSourceFuture, "; aTargetFuture = ", aTargetFuture});
        }
        ArrayList exceptions = new ArrayList();
        for (SrFuture<T> curFuture : aSourceFuture) {
            try {
                curFuture.get();
            }
            catch (ExecutionException exp) {}
        }
        aFollowUp.call();
        return null;
    }

    public static void removeVSwitchGroup(VSwitchGroup aVSwitchGroup) throws RemoteException {
        theLogger.traceEntering("", new Object[]{aVSwitchGroup});
        if (theCkciToVsGroupMap.remove(aVSwitchGroup.getCommKeyClassId()) == null) {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Failed to remove ", aVSwitchGroup.getClassId(), " ", aVSwitchGroup});
        } else {
            AlarmMgrImpl.getInstance().vSwitchGroupWasRemoved(aVSwitchGroup);
        }
        theLogger.traceExiting();
    }

    public static VSwitchGroupImpl getVSwitchGroupByCommKeyClassId(CommKey[] aCommKeys, ClassID aClassId) {
        return LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(new CommKeyClassId(aCommKeys, aClassId));
    }

    public static VSwitchGroupImpl getVSwitchGroupByCommKeyClassId(CommKeyClassId aVSwitchGroupId) {
        return theCkciToVsGroupMap.get(aVSwitchGroupId);
    }

    private void addVSwitchGroupCommKeyRefMap(CommKeyClassId aVSwitchGroupCommKeyClassId, VSwitchGroupImpl aVSwitchGroup) {
        theCkciToVsGroupMap.put(aVSwitchGroupCommKeyClassId, aVSwitchGroup);
    }

    private void newVSwitchGroup(ConfigElementData aCed) throws RemoteException, InvalidElementException {
        theLogger.traceEntering("", new Object[]{aCed});
        try {
            CommKeyClassId parentSiteCommKeyClassId = (CommKeyClassId)aCed.getValue((ParameterCodes)ParameterCode.PARENT_SITE_ID);
            if (parentSiteCommKeyClassId == null || parentSiteCommKeyClassId.getCommKeys() == null) {
                parentSiteCommKeyClassId = SystemRootImpl.getInstance().getCommKeyClassId();
                aCed.setValue(ParameterCode.PARENT_SITE_ID, (SrType)parentSiteCommKeyClassId);
            }
            SiteImpl parentSite = (SiteImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(parentSiteCommKeyClassId);
            VSwitchGroupImpl vSwitchGroup = parentSite.newVSwitchGroup(aCed);
            CommKeyClassId vSwitchGroupCommKeyClassId = new CommKeyClassId(aCed.getCommKey(), aCed.getClassId());
            this.addVSwitchGroupCommKeyRefMap(vSwitchGroupCommKeyClassId, vSwitchGroup);
        }
        catch (IllegalValueException ive) {
            theLogger.fatal(SrLogCategories.EXCEPTION, (Throwable)((Object)ive), new Object[0]);
        }
        theLogger.traceExiting();
    }

    @Override
    protected Void __handleElementEvent(SrEvent aEvent) throws Exception {
        this.handleEvent((SrEventObject)aEvent);
        return null;
    }

    @Override
    protected Void __newDBError(DbErrorEvent aEvent) throws Exception {
        return null;
    }

    @Override
    protected Void __fatalConfigurationError(ErrorEvent aEvent) throws Exception {
        this.handleEvent((SrEventObject)aEvent);
        return null;
    }

    @Override
    protected Void __configurationError(ErrorEvent aEvent) throws Exception {
        return null;
    }

    @Override
    protected Void __newSnmpError(SnmpErrorEvent aEvent) throws Exception {
        this.handleEvent((SrEventObject)aEvent);
        return null;
    }

    @Override
    protected Void __newSnmpTimeOutError(SnmpErrorEvent aEvent) throws Exception {
        this.handleEvent((SrEventObject)aEvent);
        return null;
    }

    private void handleEvent(SrEventObject aEvent) {
        if (aEvent instanceof SrEvent) {
            this.myListeners.fireEvent(AllEventsListener.class, (EventObject)((SrEvent)aEvent), this.myAllEventsListenerInformer);
        }
        try {
            if (aEvent instanceof ErrorEvent) {
                this.handleErrorEvent((ErrorEvent)aEvent);
                return;
            }
            theLogger.logAndAssert(SrLogCategories.ERROR, aEvent instanceof SrEvent, new Object[]{"The given event must be an ErrorEvent instance or a SrEvent instance but it is a " + aEvent.getClass() + " instance."});
            SrEvent eventQueueElement = (SrEvent)aEvent;
            ClusterImpl relevantCluster = null;
            int eventType = eventQueueElement.getType();
            if (eventType == 1 || eventType == 2 || eventType == 4 || eventType == 3 || eventType == 8 || eventType == 9 || eventType == 13 || eventType == 10 || eventType == 15 || eventType == 11 || eventType == 18 || eventType == 12 || eventType == 24) {
                SrElementEvent eventElement = (SrElementEvent)eventQueueElement;
                ConfigElementDataList cedList = eventElement.getElements();
                if (cedList != null) {
                    for (ElementData ced : cedList) {
                        if (ced.getClassId().isVSwitchGroup()) {
                            this.vSwitchGroupEvent((ConfigElementData)ced, eventType);
                        } else if ((eventType == 1 || eventType == 8) && ced.getClassId().equals((Object)ClassID.VSWITCH)) {
                            SrInteger clusterId = (SrInteger)ced.getValue((ParameterCodes)ParameterCode.VSWITCH_GROUP_ID);
                            if (clusterId != null) {
                                relevantCluster = (ClusterImpl)SystemRootImpl.getInstance().getVSwitchGroup((Integer)clusterId.value());
                            } else {
                                String ip = ((SrIpAddress)ced.getValue((ParameterCodes)ParameterCode.VSWITCH_IP_ADDRESS)).toDisplayString();
                                relevantCluster = (ClusterImpl)SystemRootImpl.getInstance().getClusterOfVSwitch(ip);
                            }
                        } else if (eventType != 1 && eventType != 2 || !ced.getClassId().equals((Object)ClassID.ALARM_TYPE) && !ced.getClassId().equals((Object)ClassID.EMAIL_CONTACT)) {
                            CommKeyClassId vSwitchId = (CommKeyClassId)ced.getValue((ParameterCodes)ParameterCode.VSWITCH_ID);
                            if (vSwitchId == null && ced.getClassId().equals((Object)ClassID.VSWITCH)) {
                                vSwitchId = ced.getCommKeyClassId();
                            }
                            if (vSwitchId == null) {
                                vSwitchId = CommKeyUtil.getVSwitchData((char)ced.getCommKeyClassId().getMyFirstSnmpAgentIndex());
                            }
                            if (vSwitchId != null) {
                                CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(vSwitchId);
                                relevantCluster = (ClusterImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(clusterId);
                            } else {
                                theLogger.error(SrLogCategories.LEGACY, new Object[]{"If this code is reached then the scenario should be reviewed and we should decide if having no cluster to send the event to is valid. ", "EventType: ", eventType, " ", ced.getClassId(), " ", ClassID.VSWITCH, " id is null. Event: ", aEvent});
                            }
                        }
                        if (relevantCluster == null) continue;
                        relevantCluster.elementEvent((EventObject)eventQueueElement);
                        relevantCluster = null;
                        break;
                    }
                }
            } else if (eventType != 14) {
                if (eventType == 23) {
                    SystemRootImpl.getInstance().setDBDiscoveryCompleted((SrClusterDiscoveryCompletedEvent)eventQueueElement);
                } else if (eventType != 20) {
                    if (eventType == 6 || eventType == 7 || eventType == 16 || eventType == 17) {
                        CommKeyClassId vSwitchId = eventQueueElement.getVSwitchData();
                        if (vSwitchId != null) {
                            CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(vSwitchId);
                            relevantCluster = (ClusterImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(clusterId);
                        }
                    } else {
                        theLogger.error(SrLogCategories.LEGACY, new Object[]{"Event type ", eventType, " not found in LogicMgr"});
                    }
                }
            }
            if (relevantCluster != null) {
                relevantCluster.elementEvent((EventObject)eventQueueElement);
                Object var3_6 = null;
            }
        }
        catch (RemoteException re) {
            theLogger.logAndAssert(SrLogCategories.ERROR, (Throwable)re);
        }
        catch (InvalidElementException iee) {
            theLogger.logAndAssert(SrLogCategories.ERROR, (Throwable)((Object)iee));
        }
        catch (Throwable th) {
            theLogger.logAndAssert(SrLogCategories.ERROR, th);
        }
    }

    private void handleErrorEvent(ErrorEvent aEvent) throws InvalidElementException, RemoteException {
        switch (aEvent.getErrorType()) {
            case 2: {
                this.handleSnmpError((SnmpErrorEvent)aEvent);
                break;
            }
            case 1: {
                this.handleSnmpTimeoutError((SnmpErrorEvent)aEvent);
                break;
            }
            case 3: {
                this.handleConfigurationError(aEvent);
                break;
            }
            case 4: {
                this.handleFatalConfigurationError(aEvent);
            }
        }
    }

    private void handleConfigurationError(ErrorEvent aEvent) throws InvalidElementException, RemoteException {
        CommKeyClassId source = aEvent.getVSwitchData();
        CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
        ClusterImpl cluster = (ClusterImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(clusterId);
        if (cluster != null) {
            cluster.elementEvent((EventObject)aEvent);
        } else {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Cluster ", clusterId, " not found - configuration error ", aEvent, " was received"});
        }
    }

    private void handleFatalConfigurationError(ErrorEvent aEvent) throws InvalidElementException, RemoteException {
        CommKeyClassId source = aEvent.getVSwitchData();
        if (source != null) {
            CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
            ClusterImpl cluster = (ClusterImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(clusterId);
            if (cluster != null) {
                cluster.elementEvent((EventObject)aEvent);
            } else {
                theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Cluster ", clusterId, " not found - fatal configuration error " + aEvent + " was received"});
            }
        } else {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{ClassID.VSWITCH, " is missing in Fatal Configuration Error of ", aEvent.getSource(), " ", aEvent.getMessage()});
        }
    }

    private void handleSnmpError(SnmpErrorEvent aEvent) throws InvalidElementException, RemoteException {
        CommKeyClassId source = aEvent.getVSwitchData();
        CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
        ClusterImpl cluster = (ClusterImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(clusterId);
        if (cluster != null) {
            cluster.elementEvent((EventObject)aEvent);
        } else {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Cluster ", clusterId, " not found - SNMP error ", aEvent, " was received"});
        }
    }

    private void handleSnmpTimeoutError(SnmpErrorEvent aEvent) throws InvalidElementException, RemoteException {
        CommKeyClassId source = aEvent.getVSwitchData();
        if (source == null) {
            return;
        }
        CommKeyClassId clusterId = VSwitchClusterMap.getInstance().getClusterId(source);
        ClusterImpl cluster = (ClusterImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(clusterId);
        if (cluster != null) {
            cluster.elementEvent((EventObject)aEvent);
        } else {
            theLogger.warn(SrLogCategories.LEGACY, new Object[]{"Cluster ", clusterId, " not found - SNMP timeOut ", aEvent, " was received"});
        }
    }

    private void vSwitchGroupEvent(ConfigElementData aCed, int aEventType) throws RemoteException, InvalidElementException, IllegalValueException {
        if (aEventType == 1) {
            LogicMgrAOImpl.getInstance().newVSwitchGroup(aCed);
        } else if (aEventType == 3) {
            SystemRootImpl.getInstance().removeVSwitchGroup(aCed);
        } else if (aEventType == 2) {
            SystemRootImpl.getInstance().changeVSwitchGroup(aCed);
        } else if (aEventType == 12 || aEventType == 13 || aEventType == 11) {
            ClusterImpl vSwitchGroup = (ClusterImpl)LogicMgrAOImpl.getVSwitchGroupByCommKeyClassId(aCed.getCommKey(), aCed.getClassId());
            this.vSwitchGroupOperationFailed(aEventType, vSwitchGroup, aCed.getParametersList());
        }
    }

    private void vSwitchGroupOperationFailed(int aEventType, VSwitchGroupImpl aElement, HashMap aParameterList) throws RemoteException {
        StringBuffer msg = null;
        if (aEventType == 13) {
            msg = new StringBuffer("Failed to read ");
        } else if (aEventType == 12) {
            msg = new StringBuffer("Failed to remove ");
        } else if (aEventType == 11) {
            msg = new StringBuffer("Failed to change ");
        } else {
            msg = new StringBuffer("Undefined \"Failed\" event type in operationFailed()");
            msg.append(aEventType);
            theLogger.error(SrLogCategories.LEGACY, new Object[]{msg});
            return;
        }
        msg.append(aElement.getClassId());
        if (aEventType == 12) {
            aElement.clearDeletionStatus();
        }
        msg.append(" ");
        msg.append(aElement);
        ElementEventImpl event = new ElementEventImpl((Object)aElement, aElement);
        event.setErrorMesaage(msg.toString());
        LogicMgrAOImpl.getInstance().__configurationError(event);
        theLogger.warn(SrLogCategories.LEGACY, new Object[]{msg});
    }

    @Override
    protected <T> Void __updateFutureByGivenFuture(final SrFuture<T> aSource, final SrFuture<T> aTarget) throws Exception {
        if (!aSource.isDone()) {
            theLogger.warn(SrLogCategories.BUG, new Object[]{"The __updateFutureByGivenFuture method was called although the source future is not done. Source future = ", aSource, ". The stack trace of the future which is not complete is: ", aSource.getStackTraceString(), "; A listener has been created for the future and it will recall __updateFutureByGivenFutures"});
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.updateFutureByGivenFuture(aSource, aTarget);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{aSource});
            return null;
        }
        SrActiveObject.updateFutureByGivenFuture(aSource, aTarget);
        return null;
    }

    @Override
    protected Void __updateFutureByGivenFutures(final List<SrFuture<Void>> aSource, final SrFuture<Void> aTarget) throws Exception {
        for (SrFuture<Void> curFuture : aSource) {
            if (curFuture.isDone()) continue;
            theLogger.warn(SrLogCategories.BUG, new Object[]{"The __updateFutureByGivenFutures method was called although one of the source futures is not done. Source futures = ", aSource, ". The stack trace of the future which is not complete is: ", curFuture.getStackTraceString(), "; A listener has been created for the futures and it will recall __updateFutureByGivenFutures"});
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.updateFutureByGivenFutures(aSource, (SrFuture<Void>)aTarget);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, aSource);
            return null;
        }
        SrActiveObject.updateFutureByGivenFutures(aSource, aTarget);
        return null;
    }

    public void removeElementListener(ClientThreadImpl aListener) {
        try {
            this.myEventServiceImpl.removeElementListener(aListener);
        }
        catch (RemoteException exp) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"Could not terminate the client thread: ", aListener, " because of a remote exception."});
        }
    }

    public void removeElementListener(ElementListener aListener) {
        try {
            this.myEventServiceImpl.removeElementListener(aListener);
        }
        catch (RemoteException exp) {
            theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"Could not terminate the client thread: ", aListener, " because of a remote exception."});
        }
    }

    public void removeElementListener(ClientStateListener aListener) {
        this.myEventServiceImpl.removeClientStateListener(aListener);
    }

    public void addElementListener(ClientStateListener aListener) {
        this.myEventServiceImpl.addClientStateListener(aListener);
    }

    @Deprecated
    public EventService getEventServiceImpl() {
        return this.myEventServiceImpl;
    }

    public void addAllEventsListener(AllEventsListener aListener) {
        this.myListeners.add((EventListener)aListener);
    }

    public void removeAllEventsListener(AllEventsListener aListener) {
        this.myListeners.remove((EventListener)aListener);
    }

    @Override
    public void remoteClientClosed(ClientStateEvent aEvent) {
        this.myListeners.fireEvent(ClientStateListener.class, (EventObject)aEvent, this.myClientStateInformer);
    }

    @Override
    protected ServerFacade __innerOpenSession(ServerEventsListener aListener) throws Exception {
        if (aListener == null) {
            theLogger.debug(SrLogCategories.DEBUG, new Object[]{"The given listener is null. The client isn't intersting in being a listener."});
        }
        ClientThreadImpl retVal = new ClientThreadImpl(aListener);
        if (aListener != null) {
            this.myEventServiceImpl.addElementListener(retVal);
        }
        return retVal;
    }

    @Override
    protected void __addVSwitch(final SrFuture<Void> aFuture, CommKeyClassId aObject, String aName, String aIpAddr, String aMask, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, int aNumOfRetries, SnmpVersion aSnmpVer) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (!(curObj instanceof Site)) {
            throw new IllegalArgumentException("The given object is an " + curObj.getClass() + " which is not valid for this method.");
        }
        Site execObj = (Site)((Object)curObj);
        final SrFuture<Void> dmFuture = execObj.addVSwitch(aName, aIpAddr, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.addVSwitchFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    public CommKeyClassId getServerCKCI(CommKeyClassId aClientCKCI) {
        if (aClientCKCI == null) {
            return null;
        }
        LogicObjectImpl serverObj = (LogicObjectImpl)this.getLogicObject(aClientCKCI);
        if (serverObj == null) {
            return null;
        }
        CommKeyClassId serverCKCI = serverObj.getCommKeyClassId();
        theLogger.info(SrLogCategories.CLIENT_SERVER_INTERFACE, new Object[]{"Converted client CKCI: ", aClientCKCI, " to server CKCI: ", serverCKCI});
        return serverCKCI;
    }

    private CommKeyClassId[] getServerCKCI(CommKeyClassId[] aClientCKCI) throws RemoteException {
        if (aClientCKCI == null) {
            return null;
        }
        Object[] retVal = new CommKeyClassId[aClientCKCI.length];
        for (int index = 0; index < aClientCKCI.length; ++index) {
            retVal[index] = this.getServerCKCI(aClientCKCI[index]);
        }
        theLogger.info(SrLogCategories.CLIENT_SERVER_INTERFACE, new Object[]{"Converted client CKCI array: ", Arrays.toString(aClientCKCI), " to server CKCI array: ", Arrays.toString(retVal)});
        return retVal;
    }

    @Override
    protected Void __addMirrorFollowUp(MirrorVolumeImpl aMirror, VolumeNodeImpl aChild, SrFuture<Void> aFutureToUpdate) throws Exception {
        aMirror.addMirrorFollowUp(aChild, aMirror, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __updateTargetACLWithRemoteInitiatorNamesFollowup(final SrFuture<Void> aFutureToUpdate, ClusterImpl aCluster, TargetImpl aLocalTargetImpl, IdentityImpl aKnownIden, VSwitch[] aTargetConnectedVSwitches) throws Exception {
        final SrFuture<Void> followUpFuture = aCluster.updateTargetACLWithRemoteInitiatorNamesFollowUp(aLocalTargetImpl, aKnownIden, aTargetConnectedVSwitches);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.updateFutureByGivenFuture(followUpFuture, aFutureToUpdate);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{followUpFuture});
        return null;
    }

    @Override
    protected void __startStatisticsPolling(final SrFuture<Void> aFuture, CommKeyClassId aVs, ClassID aStatType) throws Exception {
        if (aVs == null) {
            throw new IllegalArgumentException("The given VS list should not be null.");
        }
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aVs);
        if (!(curObj instanceof VSwitchImpl)) {
            throw new IllegalArgumentException("The given VS list must contain only VSs but it contains a " + curObj.getClassId());
        }
        final SrFuture<Void> dmFuture = ((VSwitchImpl)curObj).getStatistics(aStatType).startPolling();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.startPollingFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __stopStatisticsPolling(final SrFuture<Integer> aFuture, CommKeyClassId aVs, ClassID aStatType) throws Exception {
        if (aVs == null) {
            throw new IllegalArgumentException("The given VS list should not be null.");
        }
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aVs);
        if (!(curObj instanceof VSwitchImpl)) {
            throw new IllegalArgumentException("The given VS list must contain only VSs but it contains a " + curObj.getClassId());
        }
        final SrFuture<Integer> dmFuture = ((VSwitchImpl)curObj).getStatistics(aStatType).stopPolling();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.stopPollingFinished((SrFuture<Integer>)aFuture, (SrFuture<Integer>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    private RemoteObject getRemoteObjectFromList(Collection aList, String aHash) {
        if (aList == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given list should not be null"});
            return null;
        }
        for (Object execObj : aList) {
            if (execObj instanceof Collection) {
                RemoteObject retVal = this.getRemoteObjectFromList((Collection)execObj, aHash);
                if (retVal == null) continue;
                theLogger.traceExiting("Normal Exit", new Object[]{retVal});
                return retVal;
            }
            if (!(execObj instanceof RemoteObject)) continue;
            try {
                if (!((RemoteObject)execObj).hashKey().equals(aHash)) continue;
                theLogger.traceExiting("Normal Exit", new Object[]{execObj});
                return (RemoteObject)execObj;
            }
            catch (RemoteException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has been thrown inside a server context."});
            }
        }
        theLogger.traceExiting("Normal Exit", new Object[]{"NULL"});
        return null;
    }

    private RemoteObject getLogicObjectAndCheckNotNull(String aHash) throws IllegalValueException {
        RemoteObject retVal = this.getLogicObject(aHash);
        if (retVal == null) {
            throw new IllegalValueException("The given object does not exist. The given ID " + aHash);
        }
        return retVal;
    }

    public RemoteObject getLogicObject(String aHash) {
        if (aHash == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given parameter should not be null."});
            theLogger.traceExiting("Exit because of invalid parameter.", new Object[]{"NULL"});
            return null;
        }
        DRLogicObjectImpl retVal = null;
        try {
            retVal = DRRootImpl.getInstance().getRefByStub(aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            retVal = this.getRemoteObjectFromList(DRRootImpl.getInstance().getDRObjects(), aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            retVal = this.getRemoteObjectFromList(Arrays.asList(DRRootImpl.getInstance().getExtendedPairs()), aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            retVal = this.getRemoteObjectFromList(Arrays.asList(DRRootImpl.getInstance().getSyncPairs()), aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            retVal = this.getRemoteObjectFromList(AlarmMgrImpl.getInstance().getAllAlarms().values(), aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            retVal = this.getRemoteObjectFromList(DrAlarmMgrImpl.getInstance().getAllAlarms().values(), aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            List<ClusterImpl> clusters = this.getAllClusters();
            for (ClusterImpl curCluster : clusters) {
                if (curCluster.getCopyOperManager().hashKey().equals(aHash)) {
                    theLogger.traceExiting("Normal exit.", new Object[]{curCluster.getCopyOperManager()});
                    return curCluster.getCopyOperManager();
                }
                Vector<ISCSITargetImpl> allTargets = curCluster.getStorage().getTargetList();
                for (ISCSITargetImpl curTarget : allTargets) {
                    Acl curACL = ((Target)curTarget).getAclForTarget();
                    if (curACL == null || !curACL.hashKey().equals(aHash)) continue;
                    theLogger.traceExiting("Normal exit.", new Object[]{curACL});
                    return curACL;
                }
                if (curCluster.getStorage().hashKey().equals(aHash)) {
                    theLogger.traceExiting("Normal exit.", new Object[]{curCluster.getStorage()});
                    return curCluster.getStorage();
                }
                retVal = this.getRemoteObjectFromList(curCluster.getCopyOperManager().getAllCopyOpers(), aHash);
                if (retVal != null) {
                    theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                    return retVal;
                }
                retVal = this.getRemoteObjectFromList(curCluster.getCommKeyRefMap().getAllRefs(), aHash);
                if (retVal != null) {
                    theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                    return retVal;
                }
                retVal = this.getRemoteObjectFromList(Arrays.asList(DRRootImpl.getInstance().getConsistencyGroups()), aHash);
                if (retVal == null) continue;
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            retVal = this.getRemoteObjectFromList(UserManagerImpl.getInstance().getAllUsers().values(), aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
            retVal = this.getRemoteObjectFromList(SystemRootImpl.getInstance().getSites(), aHash);
            if (retVal != null) {
                theLogger.traceExiting("Normal exit.", new Object[]{retVal});
                return retVal;
            }
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception was thrown inside a server context."});
        }
        catch (IllegalValueException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)((Object)exp), new Object[]{"A remote exception was thrown inside a server context."});
        }
        if (retVal != null) {
            theLogger.traceExiting("Normal exit.", new Object[]{retVal});
            return retVal;
        }
        theLogger.traceExiting("Normal exit.", new Object[0]);
        theLogger.info(SrLogCategories.CLIENT_SERVER_INTERFACE, new Object[]{"A logic object corresponding to the given hashkey ", aHash, " is null."});
        return null;
    }

    private GeneralLogicObjectImpl getLogicObjectAndCheckNotNull(CommKeyClassId aID) throws IllegalValueException {
        GeneralLogicObjectImpl retVal = this.getLogicObject(aID);
        if (retVal == null) {
            throw new IllegalValueException("The given object does not exist. The given ID " + aID);
        }
        return retVal;
    }

    public GeneralLogicObjectImpl getLogicObject(CommKeyClassId aID) {
        if (aID == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given parameter is invalid. aID = ", aID});
            return null;
        }
        if (aID.equals((Object)SystemRootImpl.getInstance().getCommKeyClassId())) {
            return SystemRootImpl.getInstance();
        }
        ArrayList<SiteImpl> sites = SystemRootImpl.getInstance().getSites();
        for (SiteImpl curSite : sites) {
            if (!curSite.getCommKeyClassId().equals((Object)aID)) continue;
            return curSite;
        }
        List<ClusterImpl> clusters = this.getAllClusters();
        for (ClusterImpl curCluster : clusters) {
            if (aID.equals((Object)curCluster.getCommKeyClassId())) {
                return curCluster;
            }
            GeneralLogicObjectImpl retVal = (GeneralLogicObjectImpl)curCluster.getCommKeyRefMap().getRefByCommKeyClassID(aID);
            if (retVal == null) continue;
            theLogger.logAndAssert(SrLogCategories.ERROR, retVal instanceof GeneralLogicObject, new Object[]{"The CommKeyRefMap contains a value of type " + retVal.getClass() + " which is not a general logic object."});
            return retVal;
        }
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Could not find the logic object associated with the CKCI: ", aID});
        this.checkAndLogPotentialCorruptedList(aID);
        return null;
    }

    private void checkAndLogPotentialCorruptedList(CommKeyClassId aCKCI) {
        ArrayList<ClusterImpl> allClusters = new ArrayList<ClusterImpl>();
        allClusters.addAll(SystemRootImpl.getInstance().getClusters());
        for (SiteImpl curSite : SystemRootImpl.getInstance().getSites()) {
            allClusters.addAll(curSite.getClusters());
        }
        ElementData retVal = null;
        for (ClusterImpl curCluster : allClusters) {
            retVal = curCluster.getCorruptionMgr().getCorruptedElementData(aCKCI);
            if (retVal == null) continue;
            theLogger.info(SrLogCategories.DB_CORRUPTION, new Object[]{"CKCI ", aCKCI, " is corrupted in cluster ", curCluster, " and associated to the element data: ", retVal});
            return;
        }
    }

    private List<ClusterImpl> getAllClusters() {
        ArrayList<ClusterImpl> retList = new ArrayList<ClusterImpl>();
        retList.addAll(SystemRootImpl.getInstance().getClusters());
        ArrayList<SiteImpl> sites = SystemRootImpl.getInstance().getSites();
        if (sites == null) {
            return retList;
        }
        for (SiteImpl curSite : sites) {
            retList.addAll(curSite.getClusters());
        }
        return retList;
    }

    @Override
    protected Void __generateAlarms(GeneralAlarmMgrImpl aAlarmMgr, ClusterImpl aCluster) throws Exception {
        if (!LogicMgrAOImpl.isInDiscoveryProcess(aCluster)) {
            aAlarmMgr.generateAlarmsInner(aCluster);
        }
        return null;
    }

    private static boolean isInDiscoveryProcess(ClusterImpl aCluster) {
        if (aCluster != null) {
            return !aCluster.isDiscoverCompleted();
        }
        try {
            return !DRRootImpl.getInstance().isDiscoverCompleted();
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has been thrown inside a server context."});
            return false;
        }
    }

    @Override
    protected Void __generateAlarms(GeneralAlarmMgrImpl aAlarmMgr, ClusterImpl aCluster, int aEventType, GeneralLogicObjectImpl aSource, VSwitch aVS) throws Exception {
        if (LogicMgrAOImpl.isInDiscoveryProcess(aCluster)) {
            return null;
        }
        aAlarmMgr.generateAlarmsInner(aCluster, aEventType, aSource, (VSwitchImpl)aVS);
        return null;
    }

    private static void stopPollingAndTraps(GeneralLogicObjectImpl aObject) {
        if (aObject == null) {
            throw new IllegalArgumentException("The given object should not be null.");
        }
        VSwitch[] curVSs = aObject.getConnectedVSwitches();
        LogicMgrAOImpl.stopPollingAndTraps(curVSs);
    }

    private static void restartPollingAndTraps(GeneralLogicObjectImpl aObject) {
        if (aObject == null) {
            throw new IllegalArgumentException("The given object should not be null.");
        }
        VSwitch[] curVSs = aObject.getConnectedVSwitches();
        LogicMgrAOImpl.restartPollingAndTraps(curVSs);
    }

    private static void stopPollingAndTraps(VSwitch[] aVSs) {
        if (aVSs == null) {
            throw new IllegalArgumentException("The VS array should not be null");
        }
        for (VSwitch curVS : aVSs) {
            try {
                CommKeyClassId curVsCKCI = curVS.getCommKeyClassId();
                LogicMgrAOImpl.stopAllPollingForVS(curVsCKCI);
                for (Manager manager : curVS.getManagerTable()) {
                    try {
                        if (!LogicMgrAOImpl.isSameManager(curVsCKCI, manager)) continue;
                        LogicMgrAOImpl.disableTraps(manager, curVS);
                    }
                    catch (SrCommException exp) {
                        theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"Could not suspend the traps for VS ", curVS, " because of the following exception: "});
                    }
                }
            }
            catch (RemoteException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception was thrown inside a server context."});
            }
        }
    }

    private static void restartPollingAndTraps(VSwitch[] aVSs) {
        if (aVSs == null) {
            throw new IllegalArgumentException("The VS array should not be null");
        }
        for (VSwitch curVS : aVSs) {
            try {
                CommKeyClassId curVsCKCI = curVS.getCommKeyClassId();
                LogicMgrAOImpl.restartAllPollingForVS(curVsCKCI);
                for (Manager manager : curVS.getManagerTable()) {
                    try {
                        if (!LogicMgrAOImpl.isSameManager(curVsCKCI, manager)) continue;
                        LogicMgrAOImpl.enableTraps(manager, curVS);
                    }
                    catch (SrCommException exp) {
                        theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"Could not restart the traps for VS ", curVS, " because of the following exception: "});
                    }
                }
            }
            catch (RemoteException exp) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception was thrown inside a server context."});
            }
        }
    }

    private static void enableTraps(Manager aManager, VSwitch aVS) {
        LogicMgrAOImpl.setTraps(aManager, aVS, true);
    }

    private static void disableTraps(Manager aManager, VSwitch aVS) {
        LogicMgrAOImpl.setTraps(aManager, aVS, false);
    }

    private static boolean isSameManager(CommKeyClassId aVs, Manager aMgr) throws SrCommException {
        if (aVs == null || aMgr == null) {
            throw new IllegalArgumentException("The given agruments should not be null. aVs = " + aVs + "; aMgr = " + aMgr);
        }
        try {
            boolean isSameIp = DataMgrAdapter.getInstance().getSnmpManagerIp(aVs).equals(aMgr.getIPAddress());
            if (!isSameIp) {
                return false;
            }
            return DataMgrAdapter.getInstance().getManagerTrapPort(aVs) == aMgr.getTrapPort().intValue();
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has been thrown inside a server context."});
            return false;
        }
    }

    private static void setTraps(Manager aManager, VSwitch aVS, boolean aVal) {
        if (aManager == null) {
            throw new IllegalArgumentException("The given manager should not be null");
        }
        try {
            if (aVal == aManager.isTrapEnable()) {
                return;
            }
            ConfigElementData trapCED = new ConfigElementData(aManager.getCommKeyClassId());
            trapCED.addParameter(new Parameter(ParameterCode.MANAGER_TRAP_ENABLE, (Object)new SrBoolean(aVal)));
            trapCED.addParameter(new Parameter(ParameterCode.VSWITCH_ID, (Object)aVS.getCommKeyClassId()));
            ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().changeElement(trapCED));
        }
        catch (RemoteException exp) {
            theLogger.error(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has been thrown inside a server context"});
        }
    }

    private static void stopAllPollingForVS(CommKeyClassId aVS) {
        if (aVS == null) {
            throw new IllegalArgumentException("the given VS should not be null.");
        }
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Stopping polling for VS " + aVS});
        ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().suspendPolling());
    }

    private static void restartAllPollingForVS(CommKeyClassId aVS) {
        if (aVS == null) {
            throw new IllegalArgumentException("the given VS should not be null.");
        }
        theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Restarting polling for VS " + aVS});
        ErrorAssertingListener.listenTo(DataMgrAdapter.getInstance().resumePolling());
    }

    @Override
    protected void __updateDB(final SrFuture<Void> aFuture, final ClusterImpl aCluster) throws Exception {
        if (!aCluster.isDiscoverCompleted()) {
            theLogger.debug(SrLogCategories.NEIGHBOR_DB, new Object[]{"The discovery of cluster ", aCluster, " is not yet complete, therefore the update DB is stopped since ", "there will be a new one once the discovery is complete."});
            aFuture.set(null);
            return;
        }
        final SrFuture<List<String>> fromDmFuture = DataMgrAdapter.getInstance().getAllVSs(aCluster.getAlias(), aCluster.getParentSite().getAlias());
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.updateDBFollowUp(aCluster, (SrFuture<Void>)aFuture, (SrFuture<List<String>>)fromDmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{fromDmFuture});
    }

    @Override
    protected void __updateDBFollowUp(final SrFuture<Void> aFuture, final ClusterImpl aCluster, final SrFuture<Void> aFutureToUpdate, SrFuture<List<String>> aFromLogicFuture) throws Exception {
        SrFuture<Void> removeFuture = new SrFuture<Void>("LogicMgrAOImpl__updateDBFollowUp");
        List vsIPs = null;
        vsIPs = (List)aFromLogicFuture.get();
        if (aCluster.isDiscoverCompleted() && vsIPs != null && vsIPs.size() > 1) {
            removeFuture = aCluster.findAndRemoveRedundantVS(vsIPs);
        }
        final SrFuture<Void> toFinishFuture = removeFuture;
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.updateDBFinished((SrFuture<Void>)aFutureToUpdate, (SrFuture<Void>)toFinishFuture, aCluster);
                aFuture.set(null);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{toFinishFuture});
    }

    @Override
    protected Void __updateDBFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture, ClusterImpl aCluster) throws Exception {
        for (VSwitchImpl curVS : aCluster.getVSwitches()) {
            curVS.setAlwaysEnableDeletion(false);
        }
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    private Map<Object, Object> convertMapToServerCKCI(Map<?, ?> aMap) {
        if (aMap == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        HashMap<Object, Object> retVal = new HashMap<Object, Object>();
        for (Object curKey : aMap.keySet()) {
            Object curVal = aMap.get(curKey);
            if (curVal instanceof Iterable) {
                Iterable<Object> convertedIter = this.convertIterableToServerCKCI((Iterable)curVal);
                theLogger.info(SrLogCategories.CLIENT_SERVER_INTERFACE, new Object[]{"Converted client CKCI list: ", curVal, " to server CKCI list: ", convertedIter});
                retVal.put(curKey, convertedIter);
                continue;
            }
            if (curVal instanceof CommKeyClassId) {
                CommKeyClassId convertCKCI = this.getServerCKCI((CommKeyClassId)curVal);
                theLogger.info(SrLogCategories.CLIENT_SERVER_INTERFACE, new Object[]{"Converted client CKCI: ", curVal, " to server CKCI: ", convertCKCI});
                retVal.put(curKey, convertCKCI);
                continue;
            }
            retVal.put(curKey, curVal);
        }
        return retVal;
    }

    private Iterable<Object> convertIterableToServerCKCI(Iterable<?> aIterable) {
        if (aIterable == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        ArrayList<Object> retVal = new ArrayList<Object>();
        for (Object curObj : aIterable) {
            if (curObj instanceof Iterable) {
                Iterable<Object> convertedIter = this.convertIterableToServerCKCI((Iterable)curObj);
                theLogger.info(SrLogCategories.CLIENT_SERVER_INTERFACE, new Object[]{"Converted client CKCI list: ", curObj, " to server CKCI list: ", convertedIter});
                retVal.add(convertedIter);
                continue;
            }
            if (curObj instanceof CommKeyClassId) {
                CommKeyClassId convertCKCI = this.getServerCKCI((CommKeyClassId)curObj);
                theLogger.info(SrLogCategories.CLIENT_SERVER_INTERFACE, new Object[]{"Converted client CKCI: ", curObj, " to server CKCI: ", convertCKCI});
                retVal.add(convertCKCI);
                continue;
            }
            retVal.add(curObj);
        }
        return retVal;
    }

    private VSwitchImpl getVsByIp(String aIP) {
        if (aIP == null) {
            throw new IllegalArgumentException("The given argument should not be null.");
        }
        ArrayList<SiteImpl> allSites = new ArrayList<SiteImpl>();
        allSites.add(SystemRootImpl.getInstance());
        allSites.addAll(SystemRootImpl.getInstance().getSites());
        ArrayList<ClusterImpl> allClusters = new ArrayList<ClusterImpl>();
        for (SiteImpl curSite : allSites) {
            allClusters.addAll(curSite.getClusters());
        }
        for (ClusterImpl curCluster : allClusters) {
            VSwitchImpl curVS = curCluster.getVSwitchByIPAddress(aIP);
            if (curVS == null) continue;
            return curVS;
        }
        return null;
    }

    @Override
    protected void __getOrAddVSwitch(final SrFuture<VSwitch> aFuture, final String aIP, String aMask, String aClusterName, int aNumOfRetries, int aSnmpPort, int aTrapPort, String aReadCommunity, String aWriteCommunity, long aTimeout, SnmpVersion aSnmpVer) throws Exception {
        if (aIP == null || aClusterName == null) {
            throw new IllegalArgumentException("The given parameters should not be null. aIP = " + aIP + "; aClusterName = " + aClusterName);
        }
        VSwitchImpl existingVS = this.getVsByIp(aIP);
        if (existingVS != null) {
            aFuture.set((Object)existingVS);
            return;
        }
        final SrFuture<Void> addVSFuture = SystemRootImpl.getInstance().addVSwitch(aClusterName, aIP, aMask, aSnmpPort, aTrapPort, aReadCommunity, aWriteCommunity, aTimeout, aNumOfRetries, aSnmpVer);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.getOrAddVSwitchFinished(3000L, (SrFuture<VSwitch>)aFuture, (SrFuture<Void>)addVSFuture, aIP);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{addVSFuture});
    }

    @Override
    protected Void __getOrAddVSwitchFinished(SrFuture<VSwitch> aFutureToUpdate, SrFuture<Void> aFromLogicFuture, String aIP) throws Exception {
        String rerunStr = "LogicMgrAOImpl.__getOrAddVSwitchFinished - Rerun";
        try {
            aFromLogicFuture.get();
        }
        catch (SrExecutionException exp) {
            aFutureToUpdate.setException((Throwable)exp);
            return null;
        }
        catch (InterruptedException exp) {
            aFutureToUpdate.setException((Throwable)exp);
            return null;
        }
        VSwitchImpl existingVS = this.getVsByIp(aIP);
        if (existingVS == null) {
            if (aFromLogicFuture.getDescription().equals(rerunStr)) {
                String errStr = "The VS was not created even though there was no exception from the SystemRootImpl.getInstance().addVSwitch method. This might be connected to timing bugs in SiteImpl.m_waitingVSwitches.";
                theLogger.error(SrLogCategories.ERROR, new Object[]{errStr});
                aFutureToUpdate.setException((Throwable)new IllegalStateException(errStr));
                return null;
            }
            LogicMgrAOImpl.getInstance().getOrAddVSwitchFinished(3000L, aFutureToUpdate, aFromLogicFuture, aIP);
            return null;
        }
        aFutureToUpdate.set((Object)existingVS);
        return null;
    }

    public SnapshotVolumeImpl getSnapshotByAlias(ClusterImpl aCluster, String aAlias) {
        if (aCluster == null || aAlias == null) {
            throw new IllegalArgumentException("The given parameters should not be null. aCluster = " + aCluster + "; aAlias = " + aAlias);
        }
        VolumeImpl retVal = aCluster.getVolumeMgr().getVolumeByAlias(aAlias);
        if (retVal == null) {
            theLogger.warn(SrLogCategories.INFORMATIVE, new Object[]{"The volume associated to the alias ", aAlias, " in the cluster ", aCluster, " was not found. A ", ClassID.SNAPSHOT_VOLUME, " was expected."});
            return null;
        }
        if (ClassID.SNAPSHOT_VOLUME.equals((Object)retVal.getClassId())) {
            return (SnapshotVolumeImpl)retVal;
        }
        theLogger.warn(SrLogCategories.INFORMATIVE, new Object[]{"The volume type found for the alias ", aAlias, " in the cluster ", aCluster, " is ", retVal.getClassId(), " where ", ClassID.SNAPSHOT_VOLUME, " was expected."});
        return null;
    }

    @Override
    protected void __execCliCommand(final SrFuture<Void> aFuture, String aCliCommand) throws Exception {
        SpCliLexer lexer = null;
        SpCliParser parser = null;
        SrFuture actFuture = null;
        try {
            lexer = new SpCliLexer((Reader)new StringReader(aCliCommand));
            parser = new SpCliParser((TokenStream)lexer);
            parser.cliCommand();
            final CliCommand command = parser.getResult();
            if (command.getType() == CliCommand.CliCommandType.UNKNOWN_TYPE_COMMAND) {
                aFuture.setException((Throwable)new IllegalArgumentException("A valid command must be specified using the '-cli' parameter.\nValid commands are:\n\tvolume snapshot activate\n\tvolume snapshot deactivate\n\tqos activate\n\tqos deactivate\n\tqos limit"));
                return;
            }
            if (command.getIP() == null) {
                aFuture.setException((Throwable)new IllegalArgumentException("The given IP is invalid."));
                return;
            }
            String defIpMask = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_IP_MASK);
            int defRetries = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_NUM_OF_RETRIES));
            int defSnmpPort = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_PORT));
            int defTrapPort = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_TRAP_PORT));
            String defWriteComm = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_WRITE_COMMUNITY);
            String defReadComm = Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_READ_COMMUNITY);
            int defTimeout = new Integer(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.SNMP_DEFAULT_TIMEOUT_MILISEC));
            SnmpVersion defVersion = SnmpVersion.V2C;
            actFuture = new SrFuture("LogicMgrAOImpl.__execCliCommand");
            actFuture.set((Object)this.getVsByIp(command.getIP()));
            final SrFuture finalFuture = actFuture;
            Runnable toRun = new Runnable(){

                @Override
                public void run() {
                    LogicMgrAOImpl.this.execCliCommandFollowUp((SrFuture<Void>)aFuture, (SrFuture<VSwitch>)finalFuture, command);
                }
            };
            DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{finalFuture});
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException(this.getAntrlError(aCliCommand, (CharScanner)lexer, (LLkParser)parser), e);
        }
        catch (TokenStreamException e) {
            throw new IllegalArgumentException(this.getAntrlError(aCliCommand, (CharScanner)lexer, (LLkParser)parser), e);
        }
    }

    private String getAntrlError(String aInput, CharScanner aLexer, LLkParser aParser) {
        String retVal = "Error while parsing the command: " + aInput + '\n';
        String tokenStart = aLexer.getText();
        ParserSharedInputState parserState = aParser.getInputState();
        Token curToken = null;
        try {
            curToken = parserState.getInput().getInput().nextToken();
        }
        catch (TokenStreamException e1) {
            retVal = retVal + (Object)((Object)e1);
            return retVal;
        }
        String tokenEnd = curToken.getText();
        retVal = retVal + "Could not parse: " + tokenStart + tokenEnd;
        return retVal;
    }

    @Override
    protected void __execCliCommandFollowUp(SrFuture<Void> aFuture, final SrFuture<Void> aFutureToUpdate, SrFuture<VSwitch> aVsFuture, CliCommand aCliCommand) throws Exception {
        VSwitchImpl curVS = null;
        try {
            curVS = (VSwitchImpl)aVsFuture.get();
        }
        catch (SrExecutionException exp) {
            aFutureToUpdate.setException((Throwable)exp);
            aFuture.setException((Throwable)exp);
            return;
        }
        catch (InterruptedException exp) {
            aFutureToUpdate.setException((Throwable)exp);
            aFuture.setException((Throwable)exp);
            return;
        }
        if (curVS == null) {
            IllegalArgumentException exp = new IllegalArgumentException(Server.BUNDLE.getString((BundleKeysInterface)SrServerBundleKeys.CLI_VS_IS_NOT_MANAGED, new String[]{aCliCommand.getIP()}));
            aFuture.setException((Throwable)exp);
            aFutureToUpdate.setException((Throwable)exp);
        }
        CliCommandExecutor curExec = CliCommandExecutorMap.getInstance().getCliCommandExecutor(aCliCommand.getType());
        final List actFuture = curExec.executeCliCommand(curVS.getCluster(), aCliCommand);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.execCliCommandFinished((SrFuture<Void>)aFutureToUpdate, actFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (Collection)actFuture);
        aFuture.set(null);
    }

    @Override
    protected Void __execCliCommandFinished(SrFuture<Void> aFutureToUpdate, List<SrFuture<Void>> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFutures(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __configureElementsTree(final SrFuture<Void> aFuture, ClientConfigElementData aCreationData) throws Exception {
        final SrFuture future = ClientCedExecutor.getInstance().config(aCreationData);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.configureElementsTreeFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)future);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{future});
    }

    @Override
    protected Void __configureElementsTreeFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aSourceFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aSourceFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __suspendPolling(final SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        final SrFuture<Void> dmFuture = DataMgrAdapter.getInstance().suspendPolling(aPollingType);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.suspendPollingFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected void __resumePolling(final SrFuture<Void> aFuture, PollingGroupType aPollingType) throws Exception {
        final SrFuture<Void> dmFuture = DataMgrAdapter.getInstance().resumePolling(aPollingType);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.this.resumePollingFinished((SrFuture<Void>)aFuture, (SrFuture<Void>)dmFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{dmFuture});
    }

    @Override
    protected Void __suspendPollingFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected Void __resumePollingFinished(SrFuture<Void> aFutureToUpdate, SrFuture<Void> aFromLogicFuture) throws Exception {
        SrActiveObject.updateFutureByGivenFuture(aFromLogicFuture, aFutureToUpdate);
        return null;
    }

    @Override
    protected void __deleteElementTree(final SrFuture<Void> aFuture, CommKeyClassId aObject) throws Exception {
        GeneralLogicObjectImpl curObj = this.getLogicObjectAndCheckNotNull(aObject);
        if (curObj == null) {
            throw new IllegalArgumentException("No element was found in the server for the given ID " + aObject);
        }
        final List<SrFuture<Void>> dmFuture = curObj.deleteElementTree();
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                SrActiveObject.updateFutureByGivenFutures((List)dmFuture, (SrFuture)aFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, dmFuture);
    }

    static {
        theInstance = null;
        theCkciToVsGroupMap = null;
        theCkciToVsGroupMap = new HashMap();
        theLogger = SrLogger.getLogger();
        theInstance = new LogicMgrAOImpl();
    }
}

