/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.RemoteEvent;
import com.sanrad.nms.server.RemoteObjectImpl;
import com.sanrad.nms.server.alarm.AlarmSeverity;
import com.sanrad.nms.server.alarm.AlarmType;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEventImpl;
import com.sanrad.nms.server.alarm.event.PropagatedStateEventListener;
import com.sanrad.nms.server.logic.ClientParameterCode;
import com.sanrad.nms.server.logic.GeneralLogicObject;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.Parameters;
import com.sanrad.util.SrEventListenerManager;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class GeneralLogicObjectImpl
extends RemoteObjectImpl
implements GeneralLogicObject,
PropagatedStateEventListener {
    private ClassID m_classId = null;
    private BitSet m_state = new BitSet(AlarmType.getCount());
    private AlarmSeverity state = AlarmSeverity.OK;
    private AlarmSeverity propagationState = AlarmSeverity.OK;
    private AlarmSeverity ackState = AlarmSeverity.OK;
    private ArrayList<GeneralLogicObjectImpl> propagationStateDependent = new ArrayList();
    private boolean deletionProcessCompleted = false;
    private boolean deletionProcessStarted = false;
    private static SrLogger theLogger = SrLogger.getLogger();
    protected SrEventListenerManager m_listeners = new SrEventListenerManager();
    SrEventListenerManager.RemoteInformer<PropagatedStateEventListener, PropagatedStateEvent> propagatedStateChangedInformer = new SrEventListenerManager.RemoteInformer<PropagatedStateEventListener, PropagatedStateEvent>(){

        public void inform(PropagatedStateEventListener listener, PropagatedStateEvent event) {
            listener.propagatedStateChanged(event);
        }
    };
    private SrFuture<Void> myInDeletionFuture = null;

    protected GeneralLogicObjectImpl() throws RemoteException {
    }

    public GeneralLogicObjectImpl(ClassID classId) throws RemoteException {
        this.m_classId = classId;
    }

    @Override
    public ClassID getClassId() {
        return this.m_classId;
    }

    @Override
    public boolean isInDeletionProcess() {
        return this.myInDeletionFuture != null;
    }

    public void setInDeletionProcess(SrFuture<Void> aFuture) {
        if (aFuture == null) {
            throw new IllegalArgumentException("The given future should not be null.");
        }
        this.myInDeletionFuture = aFuture;
    }

    protected void clearInDeletionProcess() {
        this.myInDeletionFuture = null;
    }

    protected SrFuture<Void> getInDeletionFuture() {
        return this.myInDeletionFuture;
    }

    protected void setOn(AlarmType alarmType) {
        this.m_state.set(alarmType.getStateIndex());
    }

    protected void setOff(AlarmType alarmType) {
        this.m_state.clear(alarmType.getStateIndex());
    }

    public boolean isStateOn(AlarmType alarmType) {
        return this.m_state.get(alarmType.getStateIndex());
    }

    public boolean setStateSeverity(AlarmSeverity newState) {
        if (!this.state.equals((Object)newState)) {
            AlarmSeverity currentPropagatedState = this.getPropagatedState();
            this.state = newState;
            this.notifyNewPropagationState(currentPropagatedState);
            return true;
        }
        return false;
    }

    @Override
    public AlarmSeverity getPropagatedState() {
        AlarmSeverity as = AlarmSeverity.moreSevere((AlarmSeverity)this.state, (AlarmSeverity)this.propagationState);
        return as;
    }

    private void notifyNewPropagationState(AlarmSeverity propagatedStateBeforeChange) {
        if (!propagatedStateBeforeChange.equals((Object)this.getPropagatedState())) {
            try {
                PropagatedStateEventImpl event = new PropagatedStateEventImpl((Object)this, this.getPropagatedState());
                LogicMgrAOImpl.getInstance().__propagatedStateChanged((PropagatedStateEvent)event);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public AlarmSeverity getPropagatedAcknowledgeState() {
        AlarmSeverity as = AlarmSeverity.moreSevere((AlarmSeverity)this.ackState, (AlarmSeverity)this.propagationState);
        return as;
    }

    @Override
    public void setAcknowledgeStateSeverity(AlarmSeverity newAckState) {
        AlarmSeverity currentPropagatedAckState = this.getPropagatedAcknowledgeState();
        this.ackState = newAckState;
        this.notifyNewPropagationAcknowledgeState(currentPropagatedAckState);
    }

    private void notifyNewPropagationAcknowledgeState(AlarmSeverity propagatedAckStateBeforeChange) {
        if (!propagatedAckStateBeforeChange.equals((Object)this.getPropagatedAcknowledgeState())) {
            try {
                PropagatedStateEventImpl event = new PropagatedStateEventImpl((Object)this, this.getPropagatedAcknowledgeState());
                this.m_listeners.fireEvent(PropagatedStateEventListener.class, (RemoteEvent)event, this.propagatedStateChangedInformer);
            }
            catch (RemoteException re) {
                theLogger.error(SrLogCategories.EXCEPTION, (Throwable)re, new Object[]{"Couldn't initialize PropagatedStateEventImpl because ", re.getMessage()});
            }
        }
    }

    public void setPropagatedState(AlarmSeverity newPropagatedState) {
        boolean propagationStateIsNew;
        boolean bl = propagationStateIsNew = !newPropagatedState.equals((Object)this.propagationState);
        if (propagationStateIsNew) {
            AlarmSeverity currentPropagatedState = this.getPropagatedState();
            AlarmSeverity currentAckPropagatedState = this.getPropagatedAcknowledgeState();
            if (newPropagatedState.isMoreSevereThan(this.propagationState)) {
                this.propagationState = newPropagatedState;
            } else if (newPropagatedState.isLessSevereThan(this.propagationState)) {
                this.propagationState = this.getDependentPropagatedState();
            }
            this.notifyNewPropagationState(currentPropagatedState);
            this.notifyNewPropagationAcknowledgeState(currentAckPropagatedState);
            this.notifyNewPropagationAcknowledgeState(newPropagatedState);
        }
    }

    public void propagatedStateChanged(PropagatedStateEvent pse) {
        try {
            this.setPropagatedState(pse.getState());
        }
        catch (RemoteException re) {
            theLogger.error(SrLogCategories.LEGACY, (Throwable)re, new Object[0]);
        }
    }

    private AlarmSeverity getDependentPropagatedState() {
        AlarmSeverity propState = AlarmSeverity.OK;
        for (GeneralLogicObjectImpl dependent : this.propagationStateDependent) {
            AlarmSeverity dependentState = dependent.getPropagatedAcknowledgeState();
            if (!dependentState.isMoreSevereThan(propState)) continue;
            propState = dependentState;
        }
        return propState;
    }

    public void addPropagatedStateEventListener(PropagatedStateEventListener listener) {
        this.m_listeners.add((EventListener)listener);
    }

    public void removePropagatedStateEventListener(PropagatedStateEventListener listener) {
        this.m_listeners.remove((EventListener)listener);
    }

    public void addPropagationStateDependentObject(GeneralLogicObjectImpl obj) {
        if (!this.propagationStateDependent.contains(obj)) {
            this.propagationStateDependent.add(obj);
            this.setPropagatedState(this.getDependentPropagatedState());
        }
    }

    public void addPropagationStateDependentObject(List<? extends LogicObjectImpl> objs) {
        for (LogicObjectImpl logicObjectImpl : objs) {
            if (this.propagationStateDependent.contains(logicObjectImpl)) continue;
            this.propagationStateDependent.add(logicObjectImpl);
        }
        this.setPropagatedState(this.getDependentPropagatedState());
    }

    public void clearPropagationStateDependentObject() {
        for (GeneralLogicObjectImpl obj : this.propagationStateDependent) {
            obj.clearPropagatedStateOf();
            obj.clearPropagationStateDependentObject();
        }
        this.propagationStateDependent.clear();
        this.setStateSeverity(AlarmSeverity.OK);
        this.setAcknowledgeStateSeverity(AlarmSeverity.OK);
        this.setPropagatedState(AlarmSeverity.OK);
    }

    public void clearPropagatedStateOf() {
    }

    public void removePropagationStateDependentObjectAndListener(GeneralLogicObjectImpl obj) {
        obj.removePropagatedStateEventListener(this);
        this.propagationStateDependent.remove(obj);
        this.setPropagatedState(this.getDependentPropagatedState());
    }

    public Vector<GeneralLogicObjectImpl> getPropagationStateDependent() {
        Vector<GeneralLogicObjectImpl> propagationDependent = new Vector<GeneralLogicObjectImpl>(this.propagationStateDependent);
        for (GeneralLogicObjectImpl obj : this.propagationStateDependent) {
            propagationDependent.addAll(obj.getPropagationStateDependent());
        }
        return propagationDependent;
    }

    public abstract void registerToPropagatedStateChange();

    public void unregisterToPropagatedStateChange() {
    }

    public boolean isDeletionProcessCompleted() {
        return this.deletionProcessCompleted;
    }

    public void setDeletionProcessCompleted() {
        this.deletionProcessCompleted = true;
    }

    public int getConnectedVSwitchCounter() {
        return this.getConnectedVSwitches().length;
    }

    public void addPropagationStateDependentObjectAndListener(GeneralLogicObjectImpl obj) {
        obj.addPropagatedStateEventListener(this);
        this.addPropagationStateDependentObject(obj);
    }

    public void setDeletionProcessStarted() {
        this.deletionProcessStarted = true;
    }

    public boolean isDeletionProcessStarted() {
        return this.deletionProcessStarted;
    }

    public int hashCode() {
        if (this.getClassId() == null) {
            return super.hashCode();
        }
        return this.getClassId().hashCode();
    }

    @Override
    public SrFuture<Void> refresh() {
        return new CompleteFuture("GeneralLogicObjectImpl.refresh");
    }

    @Override
    public SrFuture<Void> refreshFields(ClientParameterCode[] codes) {
        return new CompleteFuture("GeneralLogicObjectImpl.refreshFields");
    }

    protected abstract String isValid(HashMap var1);

    protected abstract String canBeDeleted();

    public abstract boolean equalsByCommKey(Object var1);

    @Override
    public abstract HashMap checkConsistencyBetweenVSwitches();

    public abstract VSwitchImpl[] getConnectedVSwitches();

    public abstract boolean isParameterEqual(Parameters var1, VSwitchImpl var2);

    public abstract List<SrFuture<Void>> deleteElementTree() throws IllegalValueException;

    public abstract String validateChange(Map<ClientParameterCode, Object> var1);

    public abstract String validateDeletion();
}

