/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.event.AlarmEvent;
import com.sanrad.nms.server.alarm.event.PropagatedStateEvent;
import com.sanrad.nms.server.logic.ElementEvent;
import com.sanrad.nms.server.logic.ElementListener;
import com.sanrad.nms.server.logic.ServerEventsListener;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;

public class ElementListenerToServerEventsListenerAdapter
implements ServerEventsListener {
    private static SrLogger theLogger = SrLogger.getLogger();
    private ElementListener myElementListener = null;

    public ElementListenerToServerEventsListenerAdapter(ElementListener aElementListener) {
        if (aElementListener == null) {
            theLogger.logAndAssert(SrLogCategories.ERROR, new Object[]{"The given element listener should not be null"});
        }
        this.myElementListener = aElementListener;
    }

    public String toString() {
        return this.myElementListener.toString();
    }

    public SrFuture<Void> alarmChanged(AlarmEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.alarmChanged(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> alarmClosed(AlarmEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.alarmClosed(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> alarmOpened(AlarmEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.alarmOpened(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> alreadyKnownByVSwitch(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.alreadyKnownByVSwitch(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> checkConnectivity() throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.checkConnectivity();
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> configurationError(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.configurationError(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> connectionTimeOut(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.connectionTimeOut(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> discoverCompleted(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.discoverCompleted(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> drDiscoveryCompleted(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.drDiscoveryCompleted(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> drDiscoveryStarted(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.drDiscoveryStarted(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> elementChanged(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.elementChanged(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> elementCreated(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.elementCreate(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> elementRemoved(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.elementRemove(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> fatalConfigurationError(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.fatalConfigurationError(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> fireElementRemoveFromVSwitch(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.fireElementRemoveFromVSwitch(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> propagatedStateChanged(PropagatedStateEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.propagatedStateChanged(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> serverWasShutdown(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.serverWasShutdown(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> snmpError(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.snmpError(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> startDiscovering(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.startDiscovering(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> startManualDiscovering(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.startManualDiscovering(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> startReset(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.startReset(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public SrFuture<Void> systemDiscoveryCompleted(ElementEvent aEvent) throws RemoteException {
        if (this.myElementListener != null) {
            this.myElementListener.systemDiscoveryCompleted(aEvent);
        }
        return new CompleteFuture("ElementListenerToServerEventsListenerAdapter");
    }

    public String hashKey() throws RemoteException {
        return this.myElementListener.hashKey();
    }

    public int hashCode() {
        return this.myElementListener.hashCode();
    }

    public boolean equals(Object aObj) {
        if (aObj == null || !(aObj instanceof ElementListenerToServerEventsListenerAdapter)) {
            return false;
        }
        ElementListenerToServerEventsListenerAdapter compAdap = (ElementListenerToServerEventsListenerAdapter)aObj;
        return this.myElementListener.equals(compAdap.myElementListener);
    }
}

