/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.comm.exception.SrCommException;
import com.sanrad.nms.server.event.DataMgrListener;
import com.sanrad.nms.server.event.DbErrorListener;
import com.sanrad.nms.server.event.ErrorListener;
import com.sanrad.nms.server.event.SnmpErrorListener;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.mgr.DataMgrAOImpl;
import com.sanrad.nms.server.mgr.operation.ElementOperationList;
import com.sanrad.nms.server.mgr.polling.PollingGroupType;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.constants.VolumeOperationType;
import com.sanrad.util.alarm.HistoryAlarmData;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.IFuture;
import com.sanrad.util.concurrent.SrFuture;
import java.util.List;
import java.util.Properties;

public class DataMgrAdapter {
    private static final DataMgrAdapter theInstance = new DataMgrAdapter();
    private static SrLogger theLogger = SrLogger.getLogger();
    private Boolean myIsLogicUpdateFutureEnabled = ServerPropertiesFetcher.isLogicUpdateFutureEnabled();

    private DataMgrAdapter() {
        System.out.println("The 'logicUpdateFutureEnable' flag is set to " + this.myIsLogicUpdateFutureEnabled);
    }

    public static DataMgrAdapter getInstance() {
        return theInstance;
    }

    public SrFuture<Void> addDbErrorListener(DbErrorListener aListener) {
        return DataMgrAOImpl.getInstance().addDbErrorListener(aListener);
    }

    public SrFuture<Void> addErrorListener(ErrorListener aListener) {
        return DataMgrAOImpl.getInstance().addErrorListener(aListener);
    }

    public SrFuture<Void> addEventListener(DataMgrListener aListener) {
        return DataMgrAOImpl.getInstance().addEventListener(aListener);
    }

    public SrFuture<Void> addSnmpErrorListener(SnmpErrorListener aListener) {
        return DataMgrAOImpl.getInstance().addSnmpErrorListener(aListener);
    }

    public SrFuture<Void> attachIdentityToTargetACL(ConfigElementData aIdentityCed, CommKeyClassId aTargetId) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().attachIdentityToTargetACL(aIdentityCed, aTargetId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.attachIdentityToTargetACL");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> changeElement(ConfigElementData aCed) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().changeElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.changeElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> suspendPolling() {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().suspendAllPolling();
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.suspendPolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> suspendPolling(PollingGroupType aPollingType) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().suspendPolling(aPollingType);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.suspendPolling(" + aPollingType + ")");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> resumePolling(PollingGroupType aPollingType) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().resumePolling(aPollingType);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.resumePolling(" + aPollingType + ")");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> resumePolling() {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().resumeAllPolling();
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.resumePolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> createElement(ConfigElementData aCed) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().createElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.createElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> createElement(ConfigElementDataList aCedList) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().createElement(aCedList);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.createElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> discover(CommKeyClassId aVswitchId) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().discover(aVswitchId);
        SrFuture retFuture = new SrFuture("DataMgrAdapter.discover");
        this.updateThroughLogic(dmFuture, retFuture);
        return retFuture;
    }

    public SrFuture<Void> executeOperations(ElementOperationList aOperationsList) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().executeOperations(aOperationsList);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.executeOperations");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<String> getSnmpManagerIPAddress(CommKey[] aVSwitchCommKeys) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().getSnmpManagerIPAddress(aVSwitchCommKeys);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.getSnmpManagerIPAddress");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> load() {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().load();
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.load");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<ConfigElementDataList> loadCluster(String aCluster) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().loadCluster(aCluster);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.loadCluster");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public List<HistoryAlarmData> loadFromFile(String aFileName) {
        return DataMgrAOImpl.getInstance().synchLoadHistoryAlarmsFromFile(aFileName);
    }

    public SrFuture<Void> operate(ConfigElementData aCed, VolumeOperationType aOperType) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().executeVolumeOperation(aCed, aOperType);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.operate");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> readElement(ConfigElementData aCed) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().readElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.readElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> readElementFields(ConfigElementData aCed) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().readElementFields(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.readElementFields");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> refreshTableFields(ConfigElementData aCed) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().refreshTableFields(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.refreshTableFields");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeDbErrorListener(DbErrorListener aListener) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().removeDbErrorListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.removeDbErrorListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeElement(ConfigElementData aCed) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().removeElement(aCed);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.removeElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeElement(ConfigElementDataList aCedList) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().removeElement(aCedList);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.removeElement");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeErrorListener(ErrorListener aListener) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().removeErrorListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.removeErrorListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeEventListener(DataMgrListener aListener) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().removeEventListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.removeEventListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> removeSnmpErrorListener(SnmpErrorListener aListener) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().removeSnmpErrorListener(aListener);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.removeSnmpErrorListener");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> setToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarm) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().setToFile(aFileName, aAlarm);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.setToFile");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public void synchSetToFile(String aFileName, Iterable<? extends HistoryAlarmData> aAlarms) {
        DataMgrAOImpl.getInstance().syncSetToFile(aFileName, aAlarms);
    }

    public void shutdown() {
        DataMgrAOImpl.getInstance().shutdown();
    }

    public SrFuture<Void> startPollingProcess(CommKeyClassId aVswitchId) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().startPollingProcess(aVswitchId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.startPollingProcess");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> startPolling(PollingGroupType aPollingType, CommKeyClassId aVswitchId) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().startPolling(aPollingType, aVswitchId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.startPolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Void> stopPolling(PollingGroupType aPollingType, CommKeyClassId aVswitchId) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().stopPolling(aPollingType, aVswitchId);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.stopPolling");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public String getSnmpManagerIp(CommKeyClassId aVS) throws SrCommException {
        return DataMgrAOImpl.getSnmpManagerIp((CommKeyClassId)aVS);
    }

    public int getManagerTrapPort(CommKeyClassId aVS) {
        return DataMgrAOImpl.getManagerTrapPort((CommKeyClassId)aVS);
    }

    public SrFuture<Void> setPropertiesToFile(String aFileName, Properties aProperties) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().setPropertiesToFile(aFileName, aProperties);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.setPropertiesToFile");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<Properties> loadPropertiesFromFile(String aFileName) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().loadPropertiesFromFile(aFileName);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.loadPropertiesFromFile");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    public SrFuture<List<String>> getAllVSs(String aCluster, String aSite) {
        SrFuture dmFuture = DataMgrAOImpl.getInstance().getAllVSs(aCluster, aSite);
        if (this.myIsLogicUpdateFutureEnabled.booleanValue()) {
            SrFuture retFuture = new SrFuture("DataMgrAdapter.getAllVSs");
            this.updateThroughLogic(dmFuture, retFuture);
            return retFuture;
        }
        return dmFuture;
    }

    private synchronized <T> void updateThroughLogic(final SrFuture<T> aSource, final SrFuture<T> aTarget) {
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                if (!aSource.isDone()) {
                    theLogger.fatal(SrLogCategories.ILLEGAL_STATE, new Object[]{"The future ", aSource, " which was created by the following stacktrace: ", aSource.getStackTraceString(), " has been given to the update future by given future before ", "it has been updated where the target future = ", aTarget, ";  The stack trace is: ", Thread.currentThread().getStackTrace()});
                }
                LogicMgrAOImpl.getInstance().updateFutureByGivenFuture(aSource, aTarget);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, (IFuture[])new IFuture[]{aSource});
    }

    public SrFuture<Void> configureElements(ConfigElementDataList aCedList) {
        SrFuture retFuture = new SrFuture("DataMgrAdapter.configureElements");
        SrFuture dmFuture = DataMgrAOImpl.getInstance().configureElements(aCedList);
        this.updateThroughLogic(dmFuture, retFuture);
        return retFuture;
    }
}

