/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.DebugLogObject;
import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.alarm.AlarmMgrImpl;
import com.sanrad.nms.server.event.SrCreateElementEvent;
import com.sanrad.nms.server.logic.GeneralLogicObjectImpl;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObject;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.ConfigElementDataList;
import com.sanrad.nms.server.util.types.ElementData;
import com.sanrad.util.DoubleMultiHashMap;
import com.sanrad.util.SrDebugLogObject;
import com.sanrad.util.SrPostponedExecutor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DBCorruptionMgr {
    private SrLogger theLogger = SrLogger.getLogger();
    private ClusterImpl myCluster;
    private ArrayList<CorruptionHandler> myCorruptionHandlers = new ArrayList();

    public DBCorruptionMgr(ClusterImpl aCluster) {
        if (aCluster == null) {
            throw new IllegalArgumentException("Cluster cannot be null");
        }
        this.myCluster = aCluster;
        this.myCorruptionHandlers.add(new CkidInCedCorruptionHandler());
        this.myCorruptionHandlers.add(new MissingChildCorruptionHandler());
    }

    public ElementData getCorruptedElementData(CommKeyClassId aElementId) {
        for (CorruptionHandler handler : this.myCorruptionHandlers) {
            ElementData ed = handler.getCorruptedElementData(aElementId);
            if (ed == null) continue;
            return ed;
        }
        return null;
    }

    public void handleInvalidElementException(InvalidElementException aIEE) {
        this.theLogger.error(SrLogCategories.ERROR, (Throwable)((Object)aIEE), new Object[0]);
        ConfigElementData ced = aIEE.getInvalidCED();
        if (this.myCluster.isDiscoverCompleted()) {
            try {
                AlarmMgrImpl.getInstance().generateAlarms(this.myCluster);
                AlarmMgrImpl.getInstance().clearPendingAlarms(this.myCluster);
            }
            catch (RemoteException exp) {
                this.theLogger.logAndAssert(SrLogCategories.EXCEPTION, (Throwable)exp, new Object[]{"A remote exception has been thrown in the serve context."});
            }
        }
    }

    private void generateAlarmsAfterRemovingCurruptedElement() {
        if (this.myCluster.isDiscoverCompleted()) {
            AlarmMgrImpl.getInstance().generateAlarms(this.myCluster, 2, (GeneralLogicObjectImpl)this.myCluster, null);
        }
    }

    public Set<Map.Entry<ElementData, Set<CommKeyClassId>>> getCorruptedElementsForAlarms() {
        HashSet<Map.Entry<ElementData, Set<CommKeyClassId>>> set = new HashSet<Map.Entry<ElementData, Set<CommKeyClassId>>>();
        for (CorruptionHandler handler : this.myCorruptionHandlers) {
            set.addAll(handler.getCorruptedElementsForAlarms());
        }
        return set;
    }

    public void elementRemoved(CommKeyClassId aRemovedElementId) throws RemoteException {
        if (aRemovedElementId == null) {
            throw new IllegalArgumentException("aCKCID should never be null, or else we remove all the elements that failed self validation.");
        }
        ElementData edToRemove = null;
        for (CorruptionHandler handler : this.myCorruptionHandlers) {
            ElementData tempED = handler.removeCorruptedElementData(aRemovedElementId);
            if (edToRemove != null) continue;
            edToRemove = tempED;
        }
        if (edToRemove != null) {
            this.theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Removed element from inconsistent pending elements: ", edToRemove});
            this.generateAlarmsAfterRemovingCurruptedElement();
        }
    }

    public void subElementCreated(CommKeyClassId aChildIdInVswitch, LogicObject aCreatedChild, SrPostponedExecutor aPostEventExecutor) {
        HashSet<ElementData> elementDataSet = new HashSet<ElementData>();
        for (CorruptionHandler handler : this.myCorruptionHandlers) {
            elementDataSet.addAll(handler.removeAssociatedElements(aChildIdInVswitch));
        }
        for (ElementData elementData : elementDataSet) {
            try {
                this.theLogger.info(SrLogCategories.INFORMATIVE, new Object[]{"Removed element from inconsistent pending elements: " + elementData + " that was dependant on: " + aCreatedChild.getClassId() + " " + aCreatedChild});
            }
            catch (RemoteException e) {
                this.theLogger.error(SrLogCategories.EXCEPTION, (Throwable)e, new Object[]{"RemoveException was thrown in server flow"});
            }
            final SrCreateElementEvent tmpEvent = new SrCreateElementEvent((Object)this, elementData);
            Runnable runCreateEvent = new Runnable(){

                @Override
                public void run() {
                    DBCorruptionMgr.this.myCluster.elementEvent((EventObject)tmpEvent);
                }
            };
            aPostEventExecutor.addOperation(runCreateEvent);
        }
        if (!elementDataSet.isEmpty()) {
            this.generateAlarmsAfterRemovingCurruptedElement();
        }
    }

    public boolean setAsPendingIfDependedOnMissingElements(ElementData aED) {
        boolean isElementOK = true;
        for (CorruptionHandler handler : this.myCorruptionHandlers) {
            isElementOK &= handler.handleCorruption(aED);
        }
        return isElementOK;
    }

    public void clear() {
        for (CorruptionHandler handler : this.myCorruptionHandlers) {
            handler.clear();
        }
    }

    public void elementChanged(ConfigElementData aCED, SrPostponedExecutor aPostEventExecutor) {
        ElementData ed = this.getCorruptedElementData(aCED.getCommKeyClassId());
        if (ed != null) {
            this.theLogger.debug(SrLogCategories.INFORMATIVE, (DebugLogObject)new SrDebugLogObject("updating a CED in the pending mapping.", (ElementData)aCED));
            ed.addParameter(aCED.getParametersList());
        }
    }

    private class MissingChildCorruptionHandler
    extends CorruptionHandler {
        private HashMap<ClassID, HashSet<CommKeyClassId>> myMissingTypeToCorruptedIdMap;
        private HashMap<CommKeyClassId, ElementData> myIdToCorruptedElementMap;

        private MissingChildCorruptionHandler() {
            this.myMissingTypeToCorruptedIdMap = new HashMap();
            this.myIdToCorruptedElementMap = new HashMap();
        }

        @Override
        void clear() {
            this.myMissingTypeToCorruptedIdMap.clear();
            this.myIdToCorruptedElementMap.clear();
        }

        @Override
        ElementData getCorruptedElementData(CommKeyClassId aElementId) {
            return this.myIdToCorruptedElementMap.get(aElementId);
        }

        @Override
        boolean handleCorruption(ElementData aED) {
            boolean isCorrupted = true;
            if (aED.getClassId().equals((Object)ClassID.ISCSI_REMOTE_INITIATOR)) {
                CommKeyClassId scsiTargetId = (CommKeyClassId)aED.getValue((ParameterCodes)ParameterCode.SCSI_TARGET_ID);
                if (DBCorruptionMgr.this.myCluster.getISCSIId(scsiTargetId) == null) {
                    this.addCorruptedElement(aED, ClassID.ISCSI_TARGET);
                    isCorrupted = false;
                }
            }
            return isCorrupted;
        }

        @Override
        ElementData removeCorruptedElementData(CommKeyClassId aElementId) {
            for (ClassID classId : this.myMissingTypeToCorruptedIdMap.keySet()) {
                Set commkeySet = this.myMissingTypeToCorruptedIdMap.get(classId);
                commkeySet.remove(aElementId);
                if (!commkeySet.isEmpty()) continue;
                this.myMissingTypeToCorruptedIdMap.remove(classId);
            }
            return this.myIdToCorruptedElementMap.remove(aElementId);
        }

        private void addCorruptedElement(ElementData aED, ClassID aMissingElementType) {
            System.err.println(">>>>>>>>>Element added due to missing " + aMissingElementType + ", element = " + aED);
            CommKeyClassId id = aED.getCommKeyClassId();
            this.myIdToCorruptedElementMap.put(id, aED);
            HashSet<Object> idSet = this.myMissingTypeToCorruptedIdMap.get(aMissingElementType);
            if (idSet == null) {
                idSet = new HashSet();
                this.myMissingTypeToCorruptedIdMap.put(aMissingElementType, idSet);
            }
            idSet.add(id);
        }

        @Override
        Set<ElementData> removeAssociatedElements(CommKeyClassId aChildId) {
            HashSet<ElementData> set = new HashSet<ElementData>();
            HashSet<CommKeyClassId> ids = this.myMissingTypeToCorruptedIdMap.get(aChildId.getClassID());
            if (ids != null) {
                for (CommKeyClassId id : ids) {
                    ElementData ed = this.myIdToCorruptedElementMap.get(id);
                    if (ed == null) continue;
                    System.err.println(">>>>>>>>>Element removed due to creation of " + aChildId + ", element = " + ed);
                    set.add(ed);
                }
            }
            return set;
        }

        @Override
        Set<Map.Entry<ElementData, Set<CommKeyClassId>>> getCorruptedElementsForAlarms() {
            return new HashSet<Map.Entry<ElementData, Set<CommKeyClassId>>>();
        }
    }

    private class CkidInCedCorruptionHandler
    extends CorruptionHandler {
        private DoubleMultiHashMap<CommKeyClassId, ElementData> myPendingNewElementsWithMissingSubElements;

        private CkidInCedCorruptionHandler() {
            this.myPendingNewElementsWithMissingSubElements = new DoubleMultiHashMap();
        }

        @Override
        boolean handleCorruption(ElementData aED) {
            boolean wasNotAddedAsPending = true;
            for (Map.Entry entry : aED.getParametersList().entrySet()) {
                ParameterCodes pc = (ParameterCodes)entry.getKey();
                Object val = entry.getValue();
                if (val == null) continue;
                if (val instanceof ConfigElementDataList) {
                    ConfigElementDataList cedList = (ConfigElementDataList)val;
                    for (ElementData ed : cedList) {
                        wasNotAddedAsPending &= DBCorruptionMgr.this.setAsPendingIfDependedOnMissingElements(ed);
                    }
                    continue;
                }
                if (val instanceof ElementData) {
                    wasNotAddedAsPending &= DBCorruptionMgr.this.setAsPendingIfDependedOnMissingElements((ElementData)val);
                    continue;
                }
                if (val instanceof CommKeyClassId[]) {
                    CommKeyClassId[] ckcidArray;
                    for (CommKeyClassId childId : ckcidArray = (CommKeyClassId[])val) {
                        wasNotAddedAsPending &= this.validateAndAddCorruptedElement(childId, pc, aED);
                    }
                    continue;
                }
                if (!(val instanceof CommKeyClassId)) continue;
                CommKeyClassId childId = (CommKeyClassId)val;
                wasNotAddedAsPending &= this.validateAndAddCorruptedElement(childId, pc, aED);
            }
            return wasNotAddedAsPending;
        }

        boolean validateAndAddCorruptedElement(CommKeyClassId aChildElementId, ParameterCodes aChildCodeInParent, ElementData aED) {
            if (aED == null) {
                throw new IllegalArgumentException("aED can NEVER be null.");
            }
            if (aED.getClassId().isVolume() && MasterParameterCode.PARENT.isMatching(aChildCodeInParent)) {
                return true;
            }
            CommKey[] commKeys = aChildElementId.getCommKeys();
            boolean isAllNull = true;
            for (CommKey key : commKeys) {
                isAllNull &= key.getKey().endsWith(".0");
            }
            if (isAllNull) {
                return true;
            }
            if (aChildElementId.getClassID().equals((Object)ClassID.ISCSI_INITIATOR) || aChildElementId.getClassID().equals((Object)ClassID.SCSI_INITIATOR) || aChildElementId.getClassID().equals((Object)ClassID.SCSI_TARGET)) {
                return true;
            }
            if (aChildElementId.getClassID().equals((Object)ClassID.ISCSI_SESSION)) {
                return true;
            }
            if (aChildElementId.equals((Object)aED.getCommKeyClassId())) {
                DBCorruptionMgr.this.theLogger.logAndAssert(SrLogCategories.ERROR, aED.getClassId().equals((Object)ClassID.VSWITCH), new Object[]{"only a V-Switch can be passed when its CKCID equals to the passed in CKCID. " + aED});
                return true;
            }
            if (DBCorruptionMgr.this.myCluster.getCommKeyRefMap().getRefByCommKeyClassID(aChildElementId) != null) {
                return true;
            }
            this.addCorruptedElementToPending(aChildElementId, aED);
            return false;
        }

        private void addCorruptedElementToPending(CommKeyClassId aCKCID, ElementData aCED) {
            String tmpMsg = "";
            tmpMsg = aCKCID == null ? "failed self validation" : "depends on " + aCKCID;
            DBCorruptionMgr.this.theLogger.warn(SrLogCategories.INFORMATIVE, new Object[]{"adding corrupted element to pending. " + aCED + ", " + tmpMsg + "."});
            this.myPendingNewElementsWithMissingSubElements.put((Object)aCKCID, (Object)aCED);
        }

        @Override
        public ElementData getCorruptedElementData(CommKeyClassId aElementId) {
            for (Set elementDataSet : this.myPendingNewElementsWithMissingSubElements.values()) {
                for (ElementData ed : elementDataSet) {
                    if (!ed.getCommKeyClassId().equals((Object)aElementId)) continue;
                    return ed;
                }
            }
            return null;
        }

        @Override
        void clear() {
            this.myPendingNewElementsWithMissingSubElements.clear();
        }

        @Override
        ElementData removeCorruptedElementData(CommKeyClassId aElementId) {
            ElementData ed = this.getCorruptedElementData(aElementId);
            if (ed != null) {
                this.myPendingNewElementsWithMissingSubElements.removeValue((Object)ed);
            }
            return ed;
        }

        @Override
        Set<ElementData> removeAssociatedElements(CommKeyClassId aChildId) {
            Set edSet = this.myPendingNewElementsWithMissingSubElements.remove((Object)aChildId);
            return edSet != null ? edSet : new HashSet();
        }

        @Override
        public Set<Map.Entry<ElementData, Set<CommKeyClassId>>> getCorruptedElementsForAlarms() {
            HashSet<Map.Entry<ElementData, Set<CommKeyClassId>>> inconsistentEDs = new HashSet<Map.Entry<ElementData, Set<CommKeyClassId>>>(this.myPendingNewElementsWithMissingSubElements.entrySetReverse());
            return this.cleanPendingNewElementsWithMissingSubElements(inconsistentEDs);
        }

        private Set<Map.Entry<ElementData, Set<CommKeyClassId>>> cleanPendingNewElementsWithMissingSubElements(Set<Map.Entry<ElementData, Set<CommKeyClassId>>> aInconsistentEDs) {
            if (!aInconsistentEDs.isEmpty()) {
                HashSet<CommKeyClassId> depenantEDsIDs = new HashSet<CommKeyClassId>(aInconsistentEDs.size());
                for (Map.Entry<ElementData, Set<CommKeyClassId>> entry : aInconsistentEDs) {
                    depenantEDsIDs.add(entry.getKey().getCommKeyClassId());
                }
                Iterator<Map.Entry<ElementData, Set<CommKeyClassId>>> itr = aInconsistentEDs.iterator();
                while (itr.hasNext()) {
                    Map.Entry<ElementData, Set<CommKeyClassId>> entry;
                    entry = itr.next();
                    if (!depenantEDsIDs.containsAll((Collection)entry.getValue())) continue;
                    itr.remove();
                }
            }
            return aInconsistentEDs;
        }
    }

    private abstract class CorruptionHandler {
        private CorruptionHandler() {
        }

        abstract boolean handleCorruption(ElementData var1);

        abstract ElementData getCorruptedElementData(CommKeyClassId var1);

        abstract ElementData removeCorruptedElementData(CommKeyClassId var1);

        abstract void clear();

        abstract Set<ElementData> removeAssociatedElements(CommKeyClassId var1);

        abstract Set<Map.Entry<ElementData, Set<CommKeyClassId>>> getCorruptedElementsForAlarms();
    }
}

