/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitch;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.CommKey;
import com.sanrad.nms.server.util.CommKeyClassId;
import com.sanrad.nms.server.util.CommKeyUtil;
import com.sanrad.nms.server.util.SnmpCommKey;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class CommKeyRefMap
implements Serializable {
    private Hashtable commKeyMap = new Hashtable();
    private Hashtable vSwitchCommKeyMap = new Hashtable();
    private Hashtable clusterCommKeyMap = new Hashtable();
    private static SrLogger theLogger = SrLogger.getLogger();

    public Vector getAllRefs() {
        HashMap refsMap = new HashMap(this.commKeyMap.size());
        Enumeration e = this.commKeyMap.keys();
        while (e.hasMoreElements()) {
            refsMap.put(this.commKeyMap.get(e.nextElement()), null);
        }
        Set keys = refsMap.keySet();
        Vector refs = new Vector(keys);
        return refs;
    }

    public void addCommKeyClassIdAndRef(CommKey[] commKeys, ClassID classId, Object ref) {
        CommKeyClassId commKeyClassID = new CommKeyClassId(commKeys, classId);
        this.addCommKeyClassIdAndRef(commKeyClassID, ref);
    }

    private synchronized void addCommKeyClassIdAndRef(CommKeyClassId commKeyClassID, Object ref) {
        if (commKeyClassID.getClassID().equals((Object)ClassID.VSWITCH)) {
            this.vSwitchCommKeyMap.put(commKeyClassID, ref);
        } else if (commKeyClassID.getClassID().equals((Object)ClassID.CLUSTER)) {
            this.clusterCommKeyMap.put(commKeyClassID, ref);
        } else {
            if (commKeyClassID.getSnmpCommKey() == null) {
                theLogger.error(SrLogCategories.ERROR, (Throwable)new IllegalArgumentException("Inserting an invalid entry to Ref. map: Key - " + commKeyClassID + ", value - " + ref), new Object[0]);
            }
            this.commKeyMap.put(commKeyClassID, ref);
        }
    }

    public Object removeCommKeyClassIdAndRef(CommKey commKey, ClassID classId) throws RemoteException {
        CommKeyClassId commKeyClassID = new CommKeyClassId(commKey, classId);
        return this.removeCommKeyClassIdAndRef(commKeyClassID);
    }

    public Object removeCommKeyClassIdAndRef(CommKey[] commKeys, ClassID classId) throws RemoteException {
        CommKeyClassId commKeyClassID = new CommKeyClassId(commKeys, classId);
        return this.removeCommKeyClassIdAndRef(commKeyClassID);
    }

    public synchronized Object removeCommKeyClassIdAndRef(CommKeyClassId commKeyClassID) throws RemoteException {
        VSwitchImpl vSwitch;
        VSwitchImpl removedRef = null;
        removedRef = commKeyClassID.getClassID().equals((Object)ClassID.VSWITCH) ? (vSwitch = (VSwitchImpl)this.vSwitchCommKeyMap.remove(commKeyClassID)) : (commKeyClassID.getClassID().equals((Object)ClassID.CLUSTER) ? this.clusterCommKeyMap.remove(commKeyClassID) : this.commKeyMap.remove(commKeyClassID));
        return removedRef;
    }

    public void printHashTable() {
        this.printHashTable(this.commKeyMap, "", null);
    }

    private void printHashTable(Hashtable table, String msg, CommKeyClassId commKeyClassId) {
        if (commKeyClassId != null) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"$$$$$$$$$$$$$$$$$$$$$$$$$$$$     ", msg, " ", commKeyClassId.getClassID(), commKeyClassId.getCommKeys()[0].getKey()});
        }
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{e.nextElement()});
        }
        if (commKeyClassId != null) {
            theLogger.trace(SrLogCategories.LEGACY, new Object[]{"$$$$$$$$$$$$$$$$$$$$$$$$$$$$      End of ", msg, " ", commKeyClassId.getClassID(), commKeyClassId.getCommKeys()[0].getKey()});
        }
    }

    public Object getRefByCommKeyClassID(CommKey commKey, ClassID classId) {
        CommKeyClassId commKeyClassID = new CommKeyClassId(commKey, classId);
        return this.getRefByCommKeyClassID(commKeyClassID);
    }

    public Object getRefByCommKeyClassID(CommKey[] commKeys, ClassID classId) {
        CommKeyClassId commKeyClassID = new CommKeyClassId(commKeys, classId);
        return this.getRefByCommKeyClassID(commKeyClassID);
    }

    public Object getRefByCommKeyClassID(CommKeyClassId commKeyClassID) {
        if (commKeyClassID != null && commKeyClassID.getCommKeys() != null) {
            if (commKeyClassID.getClassID().equals((Object)ClassID.VSWITCH)) {
                return this.vSwitchCommKeyMap.get(commKeyClassID);
            }
            if (commKeyClassID.getClassID().equals((Object)ClassID.CLUSTER)) {
                return this.clusterCommKeyMap.get(commKeyClassID);
            }
            return this.commKeyMap.get(commKeyClassID);
        }
        return null;
    }

    public void clear(VSwitch vSwitch) throws RemoteException {
        Enumeration e = this.commKeyMap.elements();
        while (e.hasMoreElements()) {
            LogicObjectImpl element = (LogicObjectImpl)e.nextElement();
            CommKeyClassId commKeyClassID = new CommKeyClassId(element.getCommKeys(), element.getClassId());
            int result = element.decrementConnectedVSwitchCounter(vSwitch.getCommKeys());
            if (result != 0) continue;
            this.commKeyMap.remove(commKeyClassID);
        }
    }

    public void clear() throws RemoteException {
        Enumeration e = this.commKeyMap.elements();
        while (e.hasMoreElements()) {
            LogicObjectImpl element = (LogicObjectImpl)e.nextElement();
            element.clear();
        }
        e = this.vSwitchCommKeyMap.elements();
        while (e.hasMoreElements()) {
            VSwitchImpl vSwitch = (VSwitchImpl)e.nextElement();
            vSwitch.clear();
        }
        e = this.clusterCommKeyMap.elements();
        while (e.hasMoreElements()) {
            ClusterImpl cluster = (ClusterImpl)e.nextElement();
            cluster.clear();
        }
        this.commKeyMap.clear();
    }

    public Vector getListCommKeysSameTypeOf(ClassID classId, CommKeyClassId vSwitchData) {
        return this.getAllCommKeysByClassID(classId, vSwitchData, true);
    }

    public Vector getListOfCommKeys(ClassID classId, CommKeyClassId vSwitchData) {
        return this.getAllCommKeysByClassID(classId, vSwitchData, false);
    }

    private Vector getAllCommKeysByClassID(ClassID classId, CommKeyClassId vSwitchData, boolean isAllOfSameType) {
        if (this.getRefByCommKeyClassID(vSwitchData) == null) {
            return null;
        }
        Vector<CommKeyClassId> commKeys = new Vector<CommKeyClassId>();
        for (CommKeyClassId current : this.commKeyMap.keySet()) {
            boolean isMatchingClassID;
            CommKey[] commkeys = current.getCommKeys();
            SnmpCommKey snmpCommkey = CommKeyUtil.getSnmpCommKey((CommKey[])commkeys);
            CommKeyClassId currentVSwitch = CommKeyUtil.getVSwitchData((char)snmpCommkey.getSnmpAgentIndex());
            ClassID currentClassID = current.getClassID();
            boolean bl = isMatchingClassID = isAllOfSameType ? currentClassID.isSameType(classId) : currentClassID.equals((Object)classId);
            if (currentVSwitch == null || !isMatchingClassID || !currentVSwitch.equals((Object)vSwitchData)) continue;
            commKeys.add(current);
        }
        return commKeys;
    }
}

