/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.log.SrLogCategories;
import com.sanrad.log.SrLogger;
import com.sanrad.nms.server.exception.TypeMismatchException;
import com.sanrad.nms.server.logic.DataMgrAdapter;
import com.sanrad.nms.server.logic.LogicMgrAOImpl;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.volume.VolumeNodeImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.MasterParameterCode;
import com.sanrad.nms.server.util.Parameter;
import com.sanrad.nms.server.util.ParameterCode;
import com.sanrad.nms.server.util.ParameterCodes;
import com.sanrad.nms.server.util.types.SrString;
import com.sanrad.nms.server.util.types.SrType;
import com.sanrad.util.concurrent.CompleteFuture;
import com.sanrad.util.concurrent.DefaultFutureListener;
import com.sanrad.util.concurrent.SrFuture;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class AliasSynchronizer {
    private static SrLogger theLogger = SrLogger.getLogger();
    private String myDefAliasRegExp;
    private String myPrefix;

    public AliasSynchronizer(String aPrefix) {
        this.myPrefix = aPrefix;
        this.myDefAliasRegExp = this.myPrefix + "(_([0-9])+)+";
    }

    public <T extends VolumeNodeImpl> SrFuture<Void> sync(List<T> aDevices) {
        theLogger.traceEntering("", new Object[]{aDevices});
        if (aDevices.size() == 0) {
            return new CompleteFuture("AliasSynchronizer.sync.CompleteFuture");
        }
        final SrFuture retFuture = new SrFuture("AliasSynchronizer.sync");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        this.syncParamValidate(aDevices);
        theLogger.logAndAssert(SrLogCategories.ERROR, aDevices.get(0) != null, new Object[]{"There should be at least one device in the device list."});
        AliasParams curAliasParams = this.getMaxStorAndPart(((VolumeNodeImpl)aDevices.get(0)).getCluster());
        Iterator<T> devices = aDevices.iterator();
        while (devices.hasNext()) {
            midFutures.add(this.syncAlias((VolumeNodeImpl)devices.next(), curAliasParams));
        }
        theLogger.traceExiting("", new Object[0]);
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        return retFuture;
    }

    private SrFuture<Void> syncAlias(VolumeNodeImpl aDevice, AliasParams aParams) {
        theLogger.traceEntering("", new Object[]{aDevice, aParams});
        this.syncAliasParamValidate(aDevice, aParams);
        List<SrType> aliases = this.getAliasDiff(aDevice);
        if (aliases == null) {
            theLogger.traceExiting("", new Object[0]);
            return new CompleteFuture("AliasSynchronizer.syncAlias");
        }
        int userDefAliases = 0;
        for (SrType curAlias : aliases) {
            if (!this.isUserAlias(curAlias)) continue;
            ++userDefAliases;
        }
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"The number of user aliases found is: ", userDefAliases});
        if (userDefAliases > 1) {
            theLogger.traceExiting("", new Object[0]);
            return new CompleteFuture("AliasSynchronizer.syncAlias");
        }
        if (userDefAliases == 1) {
            theLogger.traceExiting("", new Object[0]);
            return this.copyAlias(aliases, aDevice);
        }
        theLogger.traceExiting("", new Object[0]);
        return this.createNewAlias(aDevice, aParams);
    }

    private void syncAliasParamValidate(VolumeNodeImpl aDevice, AliasParams aParams) {
        if (aParams == null || aDevice == null) {
            throw new IllegalArgumentException();
        }
    }

    public <T extends VolumeNodeImpl> SrFuture<Void> sync(T aDevice) {
        theLogger.trace(SrLogCategories.LEGACY, new Object[]{"Enter method sync Parameters: " + aDevice});
        theLogger.traceEntering("", new Object[]{aDevice});
        this.syncParamValidate(aDevice);
        ArrayList<T> singleDevice = new ArrayList<T>();
        singleDevice.add(aDevice);
        theLogger.traceExiting("", new Object[0]);
        return this.sync((T)((Object)singleDevice));
    }

    private SrFuture<Void> createNewAlias(VolumeNodeImpl aDevice, AliasParams aParams) {
        theLogger.traceEntering("", new Object[]{aDevice, aParams});
        this.createNewAliasParamValidate(aDevice, aParams);
        String newAlias = this.getNewAlias(aParams.getMaxStor(), aParams.getMaxPart());
        SrFuture<Void> retFuture = this.changeAlias(newAlias, aDevice);
        if (aParams.getMaxStor() >= Integer.MAX_VALUE) {
            aParams.setMaxPart(aParams.getMaxPart() + 1);
            aParams.setMyMaxStor(1);
        } else {
            aParams.setMyMaxStor(aParams.getMaxStor() + 1);
        }
        theLogger.traceExiting("", new Object[0]);
        return retFuture;
    }

    private AliasParams getMaxStorAndPart(Cluster aCurrentCluster) {
        theLogger.traceEntering("", new Object[]{aCurrentCluster});
        this.getMaxStorAndPartParamValidate(aCurrentCluster);
        int maxStorNum = 0;
        int maxPartNum = 0;
        try {
            List storageDevsList = aCurrentCluster.getStorage().getStorageDevices();
            for (VolumeNodeImpl curStor : storageDevsList) {
                for (VSwitchImpl curVS : curStor.getConnectedVSwitchesAsList()) {
                    String curAlias = curStor.getAlias(curVS);
                    if (this.isUserAlias(curAlias)) continue;
                    int curParts = this.getAliasParts(curAlias);
                    int curStorNum = this.getAliasStorNum(curAlias);
                    if (curParts > maxPartNum) {
                        maxPartNum = curParts;
                        maxStorNum = curStorNum;
                        continue;
                    }
                    if (curStorNum <= maxStorNum || curParts != maxPartNum) continue;
                    maxStorNum = curStorNum;
                }
            }
        }
        catch (RemoteException e) {
            theLogger.error(SrLogCategories.LEGACY, new Object[]{"Could not change the alias value."});
            throw new IllegalStateException("Could not change the alias value.");
        }
        theLogger.traceExiting("", new Object[]{new AliasParams(maxStorNum, maxPartNum)});
        return new AliasParams(maxStorNum, maxPartNum);
    }

    private int getAliasStorNum(String aAlias) {
        theLogger.traceEntering("", new Object[]{aAlias});
        this.getAliasPartsParamValidate(aAlias);
        String[] splitedAlias = aAlias.split("_");
        int curStorNum = Integer.parseInt(splitedAlias[splitedAlias.length - 1]);
        theLogger.traceExiting("", new Object[]{curStorNum});
        return curStorNum;
    }

    private int getAliasParts(String aAlias) {
        theLogger.traceEntering("", new Object[]{aAlias});
        this.getAliasPartsParamValidate(aAlias);
        String[] splitedAlias = aAlias.split("_");
        int curParts = splitedAlias.length - 2;
        theLogger.traceExiting("", new Object[]{curParts});
        return curParts;
    }

    private void getAliasPartsParamValidate(String aAlias) {
        if (aAlias == null) {
            throw new IllegalArgumentException();
        }
        if (this.isUserAlias(aAlias)) {
            throw new IllegalArgumentException("The given parameter is: " + aAlias + " and it must be a VS alias at this point.");
        }
    }

    private String getNewAlias(int aMaxStorNum, int aMaxPartNum) {
        theLogger.traceEntering("", new Object[]{aMaxPartNum, aMaxStorNum});
        this.getNewAliasParamValidate(aMaxStorNum, aMaxPartNum);
        StringBuffer retAlias = new StringBuffer(this.myPrefix);
        for (int index = 0; index < aMaxPartNum; ++index) {
            retAlias.append("_1");
        }
        if (aMaxStorNum >= Integer.MAX_VALUE) {
            retAlias.append("_1_1");
        } else {
            retAlias.append("_").append(aMaxStorNum + 1);
        }
        theLogger.traceExiting("", new Object[]{retAlias});
        return retAlias.toString();
    }

    private void getNewAliasParamValidate(int aMaxStorNum, int aMaxPartNum) {
        if (aMaxStorNum < 1 || aMaxPartNum < 0) {
            throw new IllegalArgumentException();
        }
    }

    private void createNewAliasParamValidate(VolumeNodeImpl aDevice, AliasParams aParam) {
        if (aParam == null || aDevice == null) {
            throw new IllegalArgumentException();
        }
    }

    private void getMaxStorAndPartParamValidate(Cluster aCurrentCluster) {
        if (aCurrentCluster == null) {
            throw new IllegalArgumentException();
        }
    }

    private SrFuture<Void> copyAlias(List<SrType> aAliases, VolumeNodeImpl aDevice) {
        theLogger.traceEntering("", new Object[]{aAliases, aDevice});
        this.copyAliasParamValidate(aAliases, aDevice);
        ArrayList<SrString> aliasesList = new ArrayList<SrString>();
        Iterator<SrType> aliasIter = aAliases.iterator();
        while (aliasIter.hasNext()) {
            aliasesList.add((SrString)aliasIter.next());
        }
        String userAlias = null;
        for (SrString curAlias : aliasesList) {
            if (!this.isUserAlias((SrType)curAlias)) continue;
            userAlias = (String)curAlias.value();
            break;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"The user alias found is: " + userAlias});
        theLogger.traceExiting("", new Object[0]);
        return this.changeAlias(userAlias, aDevice);
    }

    private SrFuture<Void> changeAlias(String aAlias, VolumeNodeImpl aDevice) {
        theLogger.traceEntering("", new Object[]{aAlias, aDevice});
        final SrFuture retFuture = new SrFuture("AliasSynchronizer.changeAlias");
        final ArrayList<SrFuture<Void>> midFutures = new ArrayList<SrFuture<Void>>();
        this.changeAliasParamValidate(aAlias, aDevice);
        SrString SrAlias = new SrString(aAlias);
        for (VSwitchImpl curVS : aDevice.getConnectedVSwitchesAsList()) {
            if (aDevice.getAlias(curVS).equals(aAlias)) continue;
            ConfigElementData ced = new ConfigElementData(aDevice.getCommKeyClassId());
            Parameter parameter = new Parameter(aDevice.getParameterCode((ParameterCodes)MasterParameterCode.ALIAS), (Object)SrAlias);
            ced.addParameter(parameter);
            parameter = new Parameter(ParameterCode.VSWITCH_ID, (Object)curVS.getCommKeyClassId());
            ced.addParameter(parameter);
            midFutures.add(DataMgrAdapter.getInstance().changeElement(ced));
        }
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                LogicMgrAOImpl.getInstance().updateFutureByGivenFutures(midFutures, (SrFuture<Void>)retFuture);
            }
        };
        DefaultFutureListener.listenTo((Runnable)toRun, midFutures);
        theLogger.traceExiting("", new Object[0]);
        return retFuture;
    }

    private void changeAliasParamValidate(String aAlias, VolumeNodeImpl aDevice) {
        if (aAlias == null) {
            throw new IllegalArgumentException();
        }
        if (aDevice == null) {
            throw new IllegalArgumentException();
        }
    }

    private void copyAliasParamValidate(List<SrType> aAliases, VolumeNodeImpl aDevice) {
        if (aDevice == null) {
            throw new IllegalArgumentException();
        }
        if (aAliases == null) {
            throw new IllegalArgumentException();
        }
        if (aAliases.size() < 2) {
            throw new IllegalArgumentException();
        }
    }

    private boolean isUserAlias(SrType aAlias) {
        theLogger.traceEntering("", new Object[]{aAlias});
        this.isUserAliasParamValidate(aAlias);
        boolean retVal = this.isUserAlias((String)((SrString)aAlias).value());
        theLogger.traceExiting("", new Object[]{retVal});
        return retVal;
    }

    private boolean isUserAlias(String aAlias) {
        theLogger.traceEntering("", new Object[]{aAlias});
        this.isUserAliasParamValidate(aAlias);
        boolean retVal = false;
        if (!aAlias.matches(this.myDefAliasRegExp)) {
            theLogger.traceExiting("", new Object[]{true});
            return true;
        }
        retVal = this.isAliasOverflow(aAlias);
        theLogger.traceExiting("", new Object[]{retVal});
        return retVal;
    }

    private boolean isAliasOverflow(String aAlias) {
        theLogger.traceEntering("", new Object[]{aAlias});
        this.isAliasOverflowParamValidate(aAlias);
        boolean retVal = false;
        String[] parts = aAlias.split("_");
        for (int index = 1; index < parts.length; ++index) {
            try {
                Integer.parseInt(parts[index]);
                continue;
            }
            catch (NumberFormatException e) {
                retVal = true;
                break;
            }
        }
        theLogger.traceExiting("", new Object[]{retVal});
        return retVal;
    }

    private void isAliasOverflowParamValidate(String aAlias) {
        if (aAlias == null) {
            throw new IllegalArgumentException();
        }
        if (!aAlias.matches(this.myDefAliasRegExp)) {
            throw new IllegalArgumentException();
        }
    }

    private void isUserAliasParamValidate(SrType aAlias) {
        if (aAlias == null) {
            throw new IllegalArgumentException();
        }
        if (!(aAlias instanceof SrString)) {
            throw new IllegalArgumentException();
        }
    }

    private void isUserAliasParamValidate(String aAlias) {
        if (aAlias == null) {
            throw new IllegalArgumentException();
        }
    }

    private void getAliasDiffParamValidate(VolumeNodeImpl aDevice) {
        if (aDevice == null) {
            throw new IllegalArgumentException();
        }
    }

    private List<SrType> getAliasDiff(VolumeNodeImpl aDevice) {
        theLogger.traceEntering("", new Object[]{aDevice});
        this.getAliasDiffParamValidate(aDevice);
        ArrayList<SrType> retList = new ArrayList<SrType>();
        HashMap inconsis = aDevice.checkConsistencyBetweenVSwitches();
        if (inconsis == null) {
            theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"No inconsistencies found."});
            theLogger.traceExiting("", new Object[]{"null"});
            return null;
        }
        ParameterCode aliasParam = aDevice.getParameterCode((ParameterCodes)MasterParameterCode.ALIAS);
        Object aliasIncon = inconsis.get(aliasParam);
        if (aliasIncon == null) {
            theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"No inconsistencies found."});
            theLogger.traceExiting("", new Object[]{"null"});
            return null;
        }
        if (!(aliasIncon instanceof Object[])) {
            TypeMismatchException exp = new TypeMismatchException("Parameter value should be of type SrType.");
            theLogger.error(SrLogCategories.ERROR, new Object[]{"Parameter value should be of type SrType."});
            throw exp;
        }
        Object[] tmpArr = (Object[])aliasIncon;
        if (tmpArr.length == 0) {
            theLogger.traceExiting("", new Object[]{"null"});
            return null;
        }
        theLogger.trace(SrLogCategories.INFORMATIVE, new Object[]{"Inconsistencies found."});
        for (int index = 0; index < tmpArr.length; ++index) {
            if (!(tmpArr[index] instanceof SrType)) {
                TypeMismatchException exp = new TypeMismatchException("Parameter value should be of type SrType.");
                theLogger.error(SrLogCategories.ERROR, new Object[]{"Parameter value should be of type SrType."});
                throw exp;
            }
            retList.add((SrType)tmpArr[index]);
        }
        theLogger.traceExiting("The return list size is:", new Object[]{retList.size()});
        return retList;
    }

    private <T extends VolumeNodeImpl> void syncParamValidate(T aDevice) {
        if (aDevice == null) {
            throw new IllegalArgumentException();
        }
    }

    private <T extends VolumeNodeImpl> void syncParamValidate(List<T> aDevices) {
        if (aDevices == null) {
            throw new IllegalArgumentException();
        }
    }

    private class AliasParams {
        private int myMaxStor = 0;
        private int myMaxPart = 0;

        public AliasParams(int aStor, int aPart) {
            this.myMaxStor = aStor;
            this.myMaxPart = aPart;
        }

        public int getMaxPart() {
            return this.myMaxPart;
        }

        public void setMaxPart(int aMaxPart) {
            this.myMaxPart = aMaxPart;
        }

        public int getMaxStor() {
            return this.myMaxStor;
        }

        public void setMyMaxStor(int myMaxStor) {
            this.myMaxStor = myMaxStor;
        }
    }
}

