/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.ServerPropertiesFetcher;
import com.sanrad.nms.server.SrSocketFactory;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.SystemRoot;
import com.sanrad.nms.server.logic.cluster.Cluster;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.volume.SnapshotManager;
import com.sanrad.nms.server.logic.volume.VolumeNode;
import com.sanrad.nms.server.logic.volume.VolumeTree;
import com.sanrad.nms.server.user.UserManager;
import com.sanrad.nms.server.util.types.constants.PhysicalStorageTypeConstant;
import com.sanrad.nms.server.util.types.constants.SnapshotActivateTypeConstants;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.ExecutionException;

public class AliasSyncTest {
    private static final String DEVELOPMENT_PROPERTIES_FILE_PATH = "/Program Files/SANRAD/VSS/StoragePro/server";
    private static SystemRoot systemRoot = null;

    public static void main(String[] args) {
        Registry registry = AliasSyncTest.getRegistry();
        String serverObjectName = "UserManager";
        try {
            UserManager userManager = (UserManager)registry.lookup(serverObjectName);
            systemRoot = userManager.getSystemRoot();
            AliasSyncTest.test();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void test() throws RemoteException {
        ArrayList clusters = systemRoot.getClusters();
        if (clusters == null || clusters.size() == 0) {
            System.out.println("Test failed, because there were no clusters found.");
            return;
        }
        Cluster localCluster = (Cluster)clusters.get(0);
        try {
            localCluster.getStorage().createGeneralISCSIDevice(PhysicalStorageTypeConstant.PHYS_STOR_TYPE_DIRECT_ACCESS_DEVICE, "target1", "target1", 0, "serial1").get();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (IllegalValueException e) {
            e.printStackTrace();
        }
        catch (InterruptedException exp) {
            exp.printStackTrace();
        }
        catch (ExecutionException exp) {
            exp.printStackTrace();
        }
        Vector vec = localCluster.getStorage().getVolumeForest();
        VolumeNode source = ((VolumeTree)vec.elementAt(0)).getTreeRoot();
        VolumeNode target = ((VolumeTree)vec.elementAt(1)).getTreeRoot();
        try {
            localCluster.getStorage().createSnapshotVolume("EranSnap", source.getCommKeyClassId(), target.getCommKeyClassId(), 10, SnapshotActivateTypeConstants.SNAPSHOT_ACTIVE).get();
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (IllegalValueException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException exp) {
            exp.printStackTrace();
        }
        catch (ExecutionException exp) {
            exp.printStackTrace();
        }
        SnapshotManager snapImpl = ((ClusterImpl)localCluster).getVolumeMgr().getSnapshotManager();
    }

    private static Registry getRegistry() {
        try {
            Registry registry = LocateRegistry.getRegistry(null, Integer.parseInt(AliasSyncTest.getPort()), (RMIClientSocketFactory)new SrSocketFactory(null));
            return registry;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String getPort() {
        String port = null;
        port = ServerPropertiesFetcher.getRMIRegistryPort();
        if (port == null) {
            return "2917";
        }
        return port;
    }
}

