/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.Server;
import com.sanrad.nms.server.logic.LogicObjectValidator;
import com.sanrad.util.BundleKeysInterface;
import com.sanrad.util.SrConstantsBundleKeys;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public abstract class AliasObjectValidator
extends LogicObjectValidator {
    public static final int ALIAS_MAX_LENGTH = Integer.parseInt(Server.CONSTANSTS_BUNDLE.getString((BundleKeysInterface)SrConstantsBundleKeys.ALIAS_MAX_LENGTH));
    private static final List<Character> NON_VALID_CHARACTERS = Arrays.asList(Character.valueOf('&'), Character.valueOf('#'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('!'), Character.valueOf('*'));
    protected String alias;

    protected AliasObjectValidator(String alias) {
        this.alias = alias;
    }

    @Override
    protected boolean isValid() throws RemoteException {
        String errMsg = AliasObjectValidator.isAliasValid(this.alias);
        if (errMsg != null) {
            this.setErrorMsg(errMsg);
            return false;
        }
        return true;
    }

    public static String isAliasValid(String alias) {
        if (alias.length() > ALIAS_MAX_LENGTH) {
            return "Alias cannot exceed " + ALIAS_MAX_LENGTH + " characters. Please select a different alias";
        }
        char[] chars = new char[alias.length()];
        alias.getChars(0, alias.length(), chars, 0);
        for (int i = 0; i < chars.length; ++i) {
            if (!NON_VALID_CHARACTERS.contains(Character.valueOf(chars[i]))) continue;
            StringBuffer errorMsg = new StringBuffer("Alias ");
            errorMsg.append(alias);
            errorMsg.append(" is not valid. Alias cannot contain the characters ");
            errorMsg.append(NON_VALID_CHARACTERS);
            errorMsg.append(". Please select a different alias");
            return errorMsg.toString();
        }
        return null;
    }
}

