/*
 * Decompiled with CFR 0.152.
 */
package com.sanrad.nms.server.logic;

import com.sanrad.nms.server.logic.AliasObject;
import com.sanrad.nms.server.logic.AliasObjectValidator;
import com.sanrad.nms.server.logic.IllegalValueException;
import com.sanrad.nms.server.logic.InvalidElementException;
import com.sanrad.nms.server.logic.LogicObjectImpl;
import com.sanrad.nms.server.logic.cluster.ClusterImpl;
import com.sanrad.nms.server.logic.vswitch.VSwitchImpl;
import com.sanrad.nms.server.mgr.ConfigElementData;
import com.sanrad.nms.server.util.ClassID;
import com.sanrad.nms.server.util.ParameterCode;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AliasObjectImpl
extends LogicObjectImpl
implements AliasObject {
    private static Map<ParameterCode, ParameterCode.Flags> theParameterCodeFlagsMap;

    protected AliasObjectImpl(ClusterImpl cluster, ClassID classId, ConfigElementData aCED) throws RemoteException, InvalidElementException, IllegalValueException {
        super(cluster, classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    protected AliasObjectImpl(ClassID classId, ConfigElementData aCED) throws RemoteException, InvalidElementException, IllegalValueException {
        super(classId, aCED);
        this.validateAndInit(aCED, theParameterCodeFlagsMap);
    }

    @Override
    public String[] checkAliasConsistencyBetweenVSwitches() throws RemoteException {
        String alias2;
        String alias1;
        VSwitchImpl[] vSwitches = this.getConnectedVSwitches();
        if (vSwitches.length > 1 && !(alias1 = this.getAlias(vSwitches[0])).equals(alias2 = this.getAlias(vSwitches[1]))) {
            String[] aliases = new String[vSwitches.length];
            aliases[0] = alias1;
            aliases[1] = alias2;
            return aliases;
        }
        return null;
    }

    protected String isAliasValid(String alias) {
        return AliasObjectValidator.isAliasValid(alias);
    }

    public abstract String getAlias(VSwitchImpl var1);

    static {
        HashMap parameterCodeFlagsMap = new HashMap();
        theParameterCodeFlagsMap = Collections.unmodifiableMap(parameterCodeFlagsMap);
    }
}

