/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import java.awt.Window;
import junit.framework.Assert;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.impl.components.JFakeTooltip;
import org.mozilla.browser.test.MozillaTest;

public class TooltipTest
extends MozillaTest {
    private static final String TEST_URL = TooltipTest.resolveURL("tooltip.html");

    public void testTooltip() {
        TooltipTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, TEST_URL));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.mousemove(TooltipTest.this.win, "tip1", 0.5f, 0.5f));
            }
        });
        final boolean[] found = new boolean[]{false};
        for (int waited = 0; waited < 10000 && !found[0]; waited += 300) {
            MozillaExecutor.swingSyncExec(new Runnable(){

                public void run() {
                    JFakeTooltip t = TooltipTest.this.findTooltip();
                    if (t != null && t.isVisible()) {
                        found[0] = true;
                    }
                }
            });
            try {
                Thread.sleep(300L);
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)"wait interrupted", (Throwable)e);
            }
        }
        TooltipTest.assertTrue((boolean)found[0]);
    }

    private JFakeTooltip findTooltip() {
        Window[] wins;
        for (Window w : wins = this.win.getOwnedWindows()) {
            JFakeTooltip t;
            String l;
            if (!(w instanceof JFakeTooltip) || !(l = (t = (JFakeTooltip)w).getTooltipLabel().getText()).equals("Title Tooltip")) continue;
            return t;
        }
        return null;
    }
}

