/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import java.util.List;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.test.MozillaTest;

public class PopupTest
extends MozillaTest {
    private static final String TEST_URL = PopupTest.resolveURL("popup.html");

    public void testOpen() {
        PopupTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, TEST_URL));
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Open1"));
            }
        });
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup1", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Close1"));
            }
        });
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup1", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Open1"));
            }
        });
        final MozillaWindow childWin = (MozillaWindow)MozillaAutomation.waitForWindowWithTitle("Popup1", 3000);
        Assert.assertNotNull((Object)childWin);
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(childWin, "Close"));
            }
        });
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup1", 3000));
    }

    public void testDouble() {
        this.testOpen();
        PopupTest.flushSwingJobs();
        this.testOpen();
    }

    public void testMixedOrder() {
        PopupTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, TEST_URL));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Open1"));
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Open2"));
            }
        });
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup1", 3000));
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup2", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Close2"));
            }
        });
        PopupTest.assertNotNull((Object)MozillaAutomation.waitForWindowWithTitle("Popup1", 3000));
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup2", 3000));
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Close1"));
            }
        });
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup1", 3000));
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup2", 3000));
    }

    public void dis_testManyOpens() throws Exception {
        PopupTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, TEST_URL));
        log.debug((Object)"opening...");
        MozillaExecutor.swingSyncExec(new Runnable(){

            public void run() {
                MozillaInitialization.getWinCreator().ensurePrecreatedWindows(20);
            }
        });
        for (int i = 0; i < 20; ++i) {
            MozillaExecutor.mozSyncExec(new Runnable(){

                public void run() {
                    Assert.assertFalse((boolean)MozillaAutomation.click(PopupTest.this.win, "Open3"));
                }
            });
            PopupTest.flushMozillaJobs();
            PopupTest.flushSwingJobs();
        }
        log.debug((Object)"openned");
        log.debug((Object)"closing...");
        List<IMozillaWindow> wins = MozillaAutomation.waitForNumWindowsWithTitle("Popup3", 20, 10000);
        PopupTest.assertEquals((int)20, (int)wins.size());
        for (IMozillaWindow iwin : wins) {
            MozillaWindow win = (MozillaWindow)iwin;
            win.setVisible(false);
            win.dispose();
        }
        PopupTest.assertNull((Object)MozillaAutomation.waitForNoWindowWithTitle("Popup3", 10000));
        wins = MozillaExecutor.mozSyncExec(new Callable<List<IMozillaWindow>>(){

            @Override
            public List<IMozillaWindow> call() throws Exception {
                return MozillaAutomation.getOpennedWindows();
            }
        });
        PopupTest.assertEquals((int)1, (int)wins.size());
        log.debug((Object)"closed");
    }

    public void testZZZ() {
    }
}

