/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import java.io.File;
import java.net.URL;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.test.AllTests;

public abstract class MozillaTest
extends TestCase {
    static Log log = LogFactory.getLog(MozillaTest.class);
    MozillaWindow win;

    protected void setUp() throws Exception {
        this.win = new MozillaWindow();
        this.win.setBounds(200, 200, 600, 450);
        this.win.setVisible(true);
    }

    protected void tearDown() throws Exception {
        this.win.setVisible(false);
        this.win.dispose();
        MozillaTest.flushMozillaJobs();
        MozillaTest.flushSwingJobs();
    }

    protected static void flushMozillaJobs() {
        try {
            MozillaExecutor.mozSyncExec(new Runnable(){

                public void run() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void flushSwingJobs() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String resolveURL(String relPath) {
        File base;
        try {
            File rf;
            AllTests t = new AllTests();
            URL u = t.getClass().getResource("");
            for (base = new File(u.toURI()); base != null && !(rf = new File(base, "test/res")).exists(); base = base.getParentFile()) {
            }
        }
        catch (Exception e) {
            log.error((Object)"failed to resolve relative path", (Throwable)e);
            base = null;
        }
        if (base != null) {
            File f = new File(base, "test/res");
            f = new File(f, relPath);
            return f.toURI().toString();
        }
        return relPath;
    }
}

