/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.test.MozillaTest;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class DOMTest
extends MozillaTest {
    public void testUserData() {
        DOMTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, "about:"));
        Document doc = this.win.getDocument();
        this.doNodeTest(doc);
    }

    private void doNodeTest(Node n) {
        Object o1 = new Object();
        Object o2 = new Object();
        for (String key : new String[]{"aaa", "bbb"}) {
            Object ret = n.setUserData(key, o1, null);
            DOMTest.assertNull((Object)ret);
            ret = n.getUserData(key);
            DOMTest.assertSame((Object)ret, (Object)o1);
            ret = n.setUserData(key, o2, null);
            DOMTest.assertSame((Object)ret, (Object)o1);
            ret = n.getUserData(key);
            DOMTest.assertSame((Object)ret, (Object)o2);
            ret = n.setUserData(key, null, null);
            DOMTest.assertSame((Object)ret, (Object)o2);
            ret = n.getUserData(key);
            DOMTest.assertSame((Object)ret, null);
        }
    }

    public void testRange() {
        DOMTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, "about:"));
        Document doc = this.win.getDocument();
        DocumentRange dr = (DocumentRange)((Object)doc);
        Range r = dr.createRange();
        int s1 = r.getStartOffset();
        int e1 = r.getEndOffset();
        DOMTest.assertEquals((int)s1, (int)0);
        DOMTest.assertEquals((int)e1, (int)0);
        NodeList nl = doc.getElementsByTagName("li");
        DOMTest.assertTrue((nl.getLength() >= 3 ? 1 : 0) != 0);
        Node n1 = nl.item(1);
        Node n2 = nl.item(2);
        r.setStartBefore(n1);
        r.setEndAfter(n2);
        int s2 = r.getStartOffset();
        int e2 = r.getEndOffset();
        DOMTest.assertFalse((s2 == 0 && e2 == 0 ? 1 : 0) != 0);
        DocumentFragment f = r.extractContents();
        String s = f.getTextContent();
        DOMTest.assertTrue((boolean)s.contains("Read"));
    }

    public void testDocumentView() {
        DOMTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, "about:"));
        Document doc = this.win.getDocument();
        DocumentView docView = (DocumentView)((Object)doc);
        AbstractView view = docView.getDefaultView();
        DOMTest.assertNotNull((Object)view);
    }

    public void testDocumentTraversal() {
        DOMTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, "about:"));
        Document doc = this.win.getDocument();
        DocumentTraversal dt = (DocumentTraversal)((Object)doc);
        TreeWalker w = dt.createTreeWalker(doc.getDocumentElement(), -1, null, false);
        Node n = w.nextNode();
        while (n != null) {
            DOMTest.assertNotNull((Object)n);
            n = w.nextNode();
        }
    }

    public void testDocumentEvent() {
        DOMTest.assertFalse((boolean)MozillaAutomation.blockingLoad(this.win, "about:"));
        Document doc = this.win.getDocument();
        DocumentEvent de = (DocumentEvent)((Object)doc);
        Event ev = de.createEvent("mouseevent");
        DOMTest.assertNotNull((Object)ev);
    }
}

