/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.test;

import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.test.MozillaTest;
import org.mozilla.interfaces.nsIPrefBranch;
import org.mozilla.interfaces.nsIPrefService;

public class CloseTest
extends MozillaTest {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testClose1() {
        this.win = new MozillaWindow();
        this.win.setBounds(200, 200, 300, 300);
        this.win.setVisible(true);
        this.win.setVisible(false);
        this.win.dispose();
        int numAfter = this.countWindows();
        CloseTest.assertEquals((int)0, (int)numAfter);
    }

    public void testClose2() {
        this.win = new MozillaWindow();
        this.win.setBounds(200, 200, 300, 300);
        this.win.setVisible(true);
        int numBefore = this.countWindows();
        CloseTest.assertEquals((int)1, (int)numBefore);
        this.win.load("about:blank");
        this.win.setVisible(false);
        this.win.dispose();
        int numAfter = this.countWindows();
        CloseTest.assertEquals((int)0, (int)numAfter);
    }

    public void testClose3() {
        this.win = new MozillaWindow();
        this.win.setBounds(200, 200, 300, 300);
        this.win.setVisible(true);
        int numBefore = this.countWindows();
        CloseTest.assertEquals((int)1, (int)numBefore);
        this.win.reload();
        this.win.setVisible(false);
        this.win.dispose();
        int numAfter = this.countWindows();
        CloseTest.assertEquals((int)0, (int)numAfter);
    }

    void disableCache() {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIPrefService ps = XPCOMUtils.getService("@mozilla.org/preferences-service;1", nsIPrefService.class);
                nsIPrefBranch pref = ps.getBranch(null);
                pref.setIntPref("browser.sessionhistory.max_total_viewers", 0);
                pref.setBoolPref("browser.cache.memory.enable", 0);
                pref.setBoolPref("browser.cache.disk.enable", 0);
            }
        });
    }

    int countWindows() {
        final int[] num = new int[]{0};
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                num[0] = MozillaAutomation.getOpennedWindows().size();
            }
        });
        return num[0];
    }

    public static void forceGC() {
        log.debug((Object)"forcing GC...");
        for (int i = 0; i < 10; ++i) {
            System.gc();
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                log.error((Object)"wait interrupted", (Throwable)e);
            }
        }
        log.debug((Object)"done");
    }
}

