/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl.components;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JImageButton
extends JButton {
    private static final long serialVersionUID = 7017355128969755464L;
    static Log log = LogFactory.getLog(JImageButton.class);

    public JImageButton(String label, String iconNormal) {
        this(label, iconNormal, null, null, null);
    }

    public JImageButton(String label, String normalIcon, String pressedIcon, String rolloverIcon, String disabledIcon) {
        super(label);
        this.setIcon(JImageButton.createImageIcon(normalIcon));
        this.setPressedIcon(JImageButton.createImageIcon(pressedIcon));
        this.setRolloverIcon(JImageButton.createImageIcon(rolloverIcon));
        this.setDisabledIcon(JImageButton.createImageIcon(disabledIcon));
    }

    public JImageButton(String label, Icon normalIcon, Icon pressedIcon, Icon rolloverIcon, Icon disabledIcon) {
        super(label);
        this.setIcon(normalIcon);
        this.setPressedIcon(pressedIcon);
        this.setRolloverIcon(rolloverIcon);
        this.setDisabledIcon(disabledIcon);
    }

    public static ImageIcon createImageIcon(String filename) {
        if (filename == null) {
            return null;
        }
        String path = "images/" + filename;
        URL u = JImageButton.class.getResource(path);
        if (u == null) {
            return null;
        }
        try {
            ImageIcon icon = new ImageIcon(u);
            return icon;
        }
        catch (Exception e) {
            log.error((Object)"failed to load image", (Throwable)e);
            return null;
        }
    }
}

