/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.IMozillaWindowFactory;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.DOMAdapter;
import org.mozilla.browser.impl.MozillaContainer;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsIDocShellTreeItem;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURIContentListener;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWindowCreator;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class WindowCreator
implements nsIWindowCreator {
    private static IMozillaWindowFactory winFactory = new DefaultWindowFactory();
    private List<IMozillaWindow> precreatedWins = new LinkedList<IMozillaWindow>();

    public static void setWindowFactory(IMozillaWindowFactory f) {
        winFactory = f;
    }

    public static IMozillaWindowFactory getWindowFactory() {
        return winFactory;
    }

    public nsISupports queryInterface(String aIID) {
        return Mozilla.queryInterface((nsISupports)this, (String)aIID);
    }

    public void ensurePrecreatedWindows() {
        this.ensurePrecreatedWindows(3);
    }

    public void ensurePrecreatedWindows(int winNum) {
        assert (!MozillaExecutor.isMozillaThread());
        while (this.precreatedWins.size() < winNum) {
            if (winFactory == null) {
                return;
            }
            IMozillaWindow w = winFactory.create(false);
            if (!(w instanceof Component)) {
                return;
            }
            this.precreatedWins.add(w);
            Component c = (Component)((Object)w);
            c.addNotify();
        }
    }

    public nsIWebBrowserChrome createChromeWindow(nsIWebBrowserChrome parent, long chromeFlags) {
        assert (!this.precreatedWins.isEmpty());
        IMozillaWindow newWin = this.precreatedWins.remove(0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowCreator.this.ensurePrecreatedWindows();
            }
        });
        if (newWin == null) {
            throw new XPCOMException(2147500037L);
        }
        MozillaContainer newWinContainer = newWin.getMozillaContainer();
        if (newWinContainer == null) {
            throw new XPCOMException(2147500037L);
        }
        IMozillaWindow parentWin = null;
        if (parent != null) {
            parentWin = MozillaAutomation.findWindow(parent);
        }
        newWin.setParentWindow(parentWin);
        ChromeAdapter newChromeAdapter = WindowCreator.attachBrowser(newWin, chromeFlags, parentWin);
        if (newChromeAdapter == null) {
            throw new XPCOMException(2147500037L);
        }
        return newChromeAdapter;
    }

    public static ChromeAdapter attachBrowser(IMozillaWindow win, long chromeFlags, IMozillaWindow parentWin) {
        assert (MozillaExecutor.isMozillaThread());
        MozillaContainer con = win.getMozillaContainer();
        if (!con.isDisplayable()) {
            return null;
        }
        if (chromeFlags == 1L) {
            chromeFlags = 4094L;
        }
        nsIWebBrowser webBrowser = XPCOMUtils.create("@mozilla.org/embedding/browser/nsWebBrowser;1", nsIWebBrowser.class);
        ChromeAdapter chromeAdapter = new ChromeAdapter(win, webBrowser, chromeFlags);
        webBrowser.setContainerWindow((nsIWebBrowserChrome)chromeAdapter);
        nsIDocShellTreeItem item = XPCOMUtils.qi((nsISupports)webBrowser, nsIDocShellTreeItem.class);
        item.setItemType(chromeAdapter.isChromeWindow() ? 3 : 2);
        Rectangle dim = con.getBounds();
        nsIBaseWindow baseWindow = XPCOMUtils.qi((nsISupports)webBrowser, nsIBaseWindow.class);
        baseWindow.initWindow(con.getMozillaCanvas().createHandle(dim), 0L, 0, 0, dim.width, dim.height);
        baseWindow.create();
        webBrowser.addWebBrowserListener((nsISupports)chromeAdapter.getProgressAdapter(), "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        webBrowser.setParentURIContentListener((nsIURIContentListener)chromeAdapter.getContentAdapter());
        nsIDOMWindow2 domWin = XPCOMUtils.qi((nsISupports)webBrowser.getContentDOMWindow(), nsIDOMWindow2.class);
        nsIDOMEventTarget et = domWin.getWindowRoot();
        for (String ev : DOMAdapter.hookedEvents) {
            et.addEventListener(ev, (nsIDOMEventListener)chromeAdapter.getDOMAdapter(), false);
        }
        ChromeAdapter parentChromeAdapter = null;
        if (parentWin != null) {
            parentChromeAdapter = parentWin.getChromeAdapter();
        }
        win.onAttachBrowser(chromeAdapter, parentChromeAdapter);
        return chromeAdapter;
    }

    public static void detachBrowser(IMozillaWindow win) {
        assert (MozillaExecutor.isMozillaThread());
        MozillaContainer con = win.getMozillaContainer();
        ChromeAdapter chromeAdapter = win.getChromeAdapter();
        if (chromeAdapter == null) {
            return;
        }
        win.onDetachBrowser();
        nsIWebBrowser webBrowser = chromeAdapter.getWebBrowser();
        nsIDOMWindow2 domWin = XPCOMUtils.qi((nsISupports)webBrowser.getContentDOMWindow(), nsIDOMWindow2.class);
        nsIDOMEventTarget et = domWin.getWindowRoot();
        for (String ev : DOMAdapter.hookedEvents) {
            et.removeEventListener(ev, (nsIDOMEventListener)chromeAdapter.getDOMAdapter(), false);
        }
        webBrowser.setParentURIContentListener(null);
        webBrowser.removeWebBrowserListener((nsISupports)chromeAdapter.getProgressAdapter(), "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
        nsIBaseWindow baseWindow = XPCOMUtils.qi((nsISupports)webBrowser, nsIBaseWindow.class);
        baseWindow.destroy();
        con.getMozillaCanvas().destroyHandle();
        webBrowser.setContainerWindow(null);
    }

    static class DefaultWindowFactory
    implements IMozillaWindowFactory {
        DefaultWindowFactory() {
        }

        public IMozillaWindow create(boolean attach) {
            return new MozillaWindow(attach, null, null);
        }
    }
}

