/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtils {
    static Log log = LogFactory.getLog(FileUtils.class);

    public static String replaceExtensionInFileName(String file_name, String in_ext, String out_ext) {
        int idx = file_name.lastIndexOf(46);
        if (idx >= 0 && (in_ext == null || file_name.substring(idx + 1).equalsIgnoreCase(in_ext))) {
            return file_name.substring(0, idx + 1) + out_ext;
        }
        return file_name + "." + out_ext;
    }

    public static String joinPaths(String path1, String path2) {
        if (path1.endsWith("" + File.separatorChar)) {
            return path1 + path2;
        }
        return path1 + File.separatorChar + path2;
    }

    public static String getFileName(String path) {
        int idx = path.lastIndexOf(File.separatorChar);
        return idx >= 0 ? path.substring(idx + 1) : path;
    }

    public static void createZip(File f, OutputStream os) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        zos.setMethod(8);
        FileUtils.recZip(zos, f, "");
        zos.close();
    }

    private static void recZip(ZipOutputStream zos, File zipBaseDir, String relPath) throws IOException {
        File f = new File(zipBaseDir, relPath);
        if (f.exists()) {
            if (f.isDirectory()) {
                String[] flist = f.list();
                for (int i = 0; i < flist.length; ++i) {
                    String childRelPath = relPath.length() > 0 ? relPath + File.separator + flist[i] : flist[i];
                    FileUtils.recZip(zos, zipBaseDir, childRelPath);
                }
            } else {
                int len;
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                zos.putNextEntry(new ZipEntry(relPath));
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                ((InputStream)in).close();
            }
        }
    }

    public static byte[] readFile(File f) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(f);
        BufferedInputStream is = new BufferedInputStream(fis);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)is).read(buf)) != -1) {
            bos.write(buf, 0, len);
        }
        ((InputStream)is).close();
        fis.close();
        return bos.toByteArray();
    }

    public static byte[] readStream(InputStream is) {
        try {
            int n;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1000];
            while ((n = is.read(buf, 0, buf.length)) != -1) {
                bos.write(buf, 0, n);
            }
            is.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            log.error((Object)"error reading stream", (Throwable)e);
            return new byte[0];
        }
    }

    public static File toFile(URL url) {
        try {
            String path = URLDecoder.decode(url.getPath(), "UTF-8");
            String proto = url.getProtocol();
            return FileUtils.toFile(path, proto);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"error converting url to filename", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static File toFile(URI uri) {
        try {
            String path = URLDecoder.decode(uri.getPath(), "UTF-8");
            String proto = uri.getScheme();
            return FileUtils.toFile(path, proto);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"error converting uri to filename", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static File urlToFile(String uri) {
        try {
            if (uri.startsWith("file:")) {
                URL u = new URL(uri);
                return FileUtils.toFile(u);
            }
            return null;
        }
        catch (MalformedURLException e) {
            log.error((Object)"malformed url", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static File toFile(String path, String proto) {
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        if (File.separatorChar == '\\' && proto != null && proto.equals("file") && path.startsWith("\\")) {
            path = path.substring(1);
        }
        return new File(path);
    }
}

