/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventBuffer {
    static Log log = LogFactory.getLog(EventBuffer.class);
    Map<String, Long> eventBuffer = new HashMap<String, Long>();

    public void record(String anEventName) {
        log.debug((Object)("recording event:" + anEventName));
        this.eventBuffer.put(anEventName, new Long(System.currentTimeMillis()));
    }

    public void replayOn(Object aTarget) {
        ArrayList<Map.Entry<String, Long>> entryList = new ArrayList<Map.Entry<String, Long>>(this.eventBuffer.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        for (Map.Entry entry : entryList) {
            String event = (String)entry.getKey();
            try {
                log.debug((Object)("replaying event:" + event));
                Method method = EventBuffer.getPrivateMethod(event, aTarget);
                method.invoke(aTarget, new Object[0]);
            }
            catch (Exception e) {
                log.debug((Object)("Could not replay event " + event + " on " + aTarget));
                e.printStackTrace();
            }
        }
        this.eventBuffer.clear();
    }

    public static Method getPrivateMethod(String aMethodName, Object anObject) {
        Method[] methods = anObject.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!aMethodName.equals(methods[i].getName())) continue;
            methods[i].setAccessible(true);
            return methods[i];
        }
        return null;
    }

    public static void main(String[] args) {
        Object o = new Object(){

            public void onHop() {
                System.err.println("Hop");
            }

            public void onHey() {
                System.err.println("Hey");
            }
        };
        EventBuffer eb = new EventBuffer();
        eb.record("onHop");
        eb.record("onHey");
        eb.record("onHop");
        eb.replayOn(o);
    }
}

