/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.awt.Insets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ContentAdapter;
import org.mozilla.browser.impl.DOMAdapter;
import org.mozilla.browser.impl.ProgressAdapter;
import org.mozilla.browser.impl.WindowCreator;
import org.mozilla.browser.impl.components.JFakeTooltip;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIEmbeddingSiteWindow;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsIJSContextStack;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsITooltipListener;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWebBrowserChromeFocus;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class ChromeAdapter
implements nsIWebBrowserChrome,
nsIWebBrowserChromeFocus,
nsIEmbeddingSiteWindow,
nsIInterfaceRequestor,
nsITooltipListener {
    static Log log = LogFactory.getLog(ChromeAdapter.class);
    protected final IMozillaWindow window;
    private boolean isChromeWindow;
    private long chromeFlags;
    private final nsIWebBrowser webBrowser;
    private final ContentAdapter contentAdapter;
    private final ProgressAdapter progressAdapter;
    private final DOMAdapter domAdapter;
    private String mozTitle;
    private boolean mozVisibility = false;
    boolean inModalLoop = false;
    private boolean chromeLoaded;
    private JFakeTooltip tooltip;

    public ChromeAdapter(IMozillaWindow window, nsIWebBrowser webBrowser, long chromeFlags) {
        this.window = window;
        this.webBrowser = webBrowser;
        this.contentAdapter = new ContentAdapter(this);
        this.progressAdapter = new ProgressAdapter(this);
        this.domAdapter = new DOMAdapter(this);
        this.isChromeWindow = (chromeFlags & 0x80000000L) != 0L;
        this.chromeFlags = chromeFlags;
    }

    public String getTitle() {
        assert (MozillaExecutor.isMozillaThread());
        return this.mozTitle;
    }

    public void setTitle(final String title) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)("setTitle=" + title));
        this.mozTitle = title;
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ChromeAdapter.this.window.onSetTitle(title);
            }
        });
    }

    public long getSiteWindow() {
        assert (MozillaExecutor.isMozillaThread());
        return this.window.getMozillaContainer().getMozillaCanvas().getHandle();
    }

    public void setFocus() {
        assert (MozillaExecutor.isMozillaThread());
        nsIBaseWindow baseWindow = XPCOMUtils.qi((nsISupports)this.webBrowser, nsIBaseWindow.class);
        baseWindow.setFocus();
    }

    public void setVisibility(boolean aVisibility) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)("setVisibility=" + aVisibility));
        this.mozVisibility = aVisibility;
        if (this.isChromeWindow && !this.chromeLoaded) {
            return;
        }
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ChromeAdapter.this.window.onSetVisible(ChromeAdapter.this.mozVisibility);
            }
        });
    }

    public boolean getVisibility() {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)("getVisibility=" + this.mozVisibility));
        return this.mozVisibility || !this.isChromeWindow && this.window.getMozillaContainer() != null && this.window.getMozillaContainer().isDisplayable();
    }

    public void getDimensions(long flags, int[] x, int[] y, int[] cx, int[] cy) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)"getDimension");
        nsIBaseWindow baseWindow = XPCOMUtils.qi((nsISupports)this.webBrowser, nsIBaseWindow.class);
        if ((flags & 1L) != 0L && (flags & 6L) != 0L) {
            baseWindow.getPositionAndSize(x, y, cx, cy);
        } else if ((flags & 1L) != 0L) {
            baseWindow.getPosition(x, y);
        } else if ((flags & 6L) != 0L) {
            baseWindow.getSize(cx, cy);
        } else {
            throw new XPCOMException(2147942487L);
        }
    }

    public void setDimensions(long flags, int x, int y, int cx, int cy) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)String.format("setDimension flag=%d %d,%d %dx%d\n", flags, x, y, cx, cy));
        nsIBaseWindow baseWindow = XPCOMUtils.qi((nsISupports)this.webBrowser, nsIBaseWindow.class);
        if ((flags & 1L) != 0L && (flags & 6L) != 0L) {
            baseWindow.setPositionAndSize(x, y, cx, cy, true);
        } else if ((flags & 1L) != 0L) {
            baseWindow.setPosition(x, y);
        } else if ((flags & 6L) != 0L) {
            baseWindow.setSize(cx, cy, true);
        } else {
            throw new XPCOMException(2147942487L);
        }
    }

    public nsIWebBrowser getWebBrowser() {
        assert (MozillaExecutor.isMozillaThread());
        return this.webBrowser;
    }

    public void setWebBrowser(nsIWebBrowser aWebBrowser) {
        assert (MozillaExecutor.isMozillaThread());
        assert (this.webBrowser != aWebBrowser);
    }

    public long getChromeFlags() {
        return this.chromeFlags;
    }

    public void setStatus(long statusType, final String status) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)("set status=" + status));
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ChromeAdapter.this.window.onSetStatus(status);
            }
        });
    }

    public void setChromeFlags(long aChromeFlags) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)String.format("setChromeFlags %d", aChromeFlags));
    }

    public void destroyBrowserWindow() {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)"destroyBrowserWindow");
        if (this.inModalLoop) {
            this.exitModalEventLoop(0L);
        }
        WindowCreator.detachBrowser(this.window);
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ChromeAdapter.this.window.onCloseWindow();
            }
        });
    }

    public void sizeBrowserTo(final int aCX, final int aCY) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)String.format("sizeBrowserTo %d %d", aCX, aCY));
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                Insets insets = ChromeAdapter.this.window.getInsets();
                int width = aCX + insets.left + insets.right;
                int height = aCY + insets.top + insets.bottom;
                ChromeAdapter.this.window.onSetSize(width, height);
            }
        });
    }

    public void showAsModal() {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)"showAsModal");
        nsIJSContextStack stack = XPCOMUtils.getService("@mozilla.org/js/xpc/ContextStack;1", nsIJSContextStack.class);
        stack.push(0L);
        this.inModalLoop = true;
        MozillaExecutor.mozEnterModalEventLoop(this);
        long cx = stack.pop();
        assert (cx == 0L);
    }

    public boolean isWindowModal() {
        log.trace((Object)"isWindowModal");
        return this.inModalLoop;
    }

    public void exitModalEventLoop(long aStatus) {
        log.trace((Object)"exitModalEventLoop");
        MozillaExecutor.mozExitModalEventLoop();
        this.inModalLoop = false;
    }

    public void focusNextElement() {
        log.trace((Object)"focusNextElement");
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ChromeAdapter.this.window.getMozillaContainer().getMozillaCanvas().transferFocus();
            }
        });
    }

    public void focusPrevElement() {
        log.trace((Object)"focusPrevElement");
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                ChromeAdapter.this.window.getMozillaContainer().getMozillaCanvas().transferFocusBackward();
            }
        });
    }

    public nsISupports getInterface(String riid) {
        if (riid.equals("{a6cf906b-15b3-11d2-932e-00805f8add32}")) {
            nsIDOMWindow contentDOMWindow = this.webBrowser.getContentDOMWindow();
            return contentDOMWindow;
        }
        return this.queryInterface(riid);
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    public void contentFinishedLoading() {
        if (this.isChromeWindow) {
            this.chromeLoaded = true;
            nsIDOMWindow domWindow = this.webBrowser.getContentDOMWindow();
            if (domWindow == null) {
                return;
            }
            domWindow.sizeToContent();
            boolean visibility = this.getVisibility();
            if (visibility) {
                this.setVisibility(true);
            }
        }
    }

    public IMozillaWindow getWindow() {
        return this.window;
    }

    public void onShowTooltip(final int XCoords, final int YCoords, final String tipText) {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)String.format("shot tooltip: %d,%d '%s'", XCoords, YCoords, tipText));
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                if (ChromeAdapter.this.tooltip == null) {
                    ChromeAdapter.this.tooltip = JFakeTooltip.create(ChromeAdapter.this.window);
                }
                ChromeAdapter.this.tooltip.setup(XCoords, YCoords, tipText);
                ChromeAdapter.this.tooltip.setVisible(true);
            }
        });
    }

    public void onHideTooltip() {
        assert (MozillaExecutor.isMozillaThread());
        log.trace((Object)"hide tip");
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                if (ChromeAdapter.this.tooltip == null) {
                    return;
                }
                ChromeAdapter.this.tooltip.setVisible(false);
                ChromeAdapter.this.tooltip.dispose();
                ChromeAdapter.this.tooltip = null;
            }
        });
    }

    public ContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    public ProgressAdapter getProgressAdapter() {
        return this.progressAdapter;
    }

    public DOMAdapter getDOMAdapter() {
        return this.domAdapter;
    }

    public boolean isChromeWindow() {
        return this.isChromeWindow;
    }
}

