/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.impl;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIThread;
import org.mozilla.interfaces.nsIThreadManager;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public abstract class BlockingURLLoader {
    protected final IMozillaWindow win;
    private final Semaphore sem;
    private boolean loadFailed = false;
    private long loadTimeout = 30000L;

    public BlockingURLLoader(IMozillaWindow win) {
        this.win = win;
        this.sem = new Semaphore(2);
    }

    public boolean getLoadFailed() {
        return this.loadFailed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load() {
        final GeckoAdapter ga = new GeckoAdapter();
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                ChromeAdapter chromeAdapter = BlockingURLLoader.this.win.getChromeAdapter();
                if (chromeAdapter == null) {
                    return;
                }
                chromeAdapter.getWebBrowser().addWebBrowserListener((nsISupports)ga, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
            }
        });
        this.sem.acquireUninterruptibly(2);
        this.onLoadStarted();
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                try {
                    if (BlockingURLLoader.this.triggerURLLoading()) {
                        BlockingURLLoader.this.loadFailed = true;
                    }
                }
                catch (XPCOMException e) {
                    BlockingURLLoader.this.loadFailed = true;
                }
            }
        });
        if (!this.loadFailed) {
            if (!MozillaExecutor.isMozillaThread()) {
                try {
                    if (this.sem.tryAcquire(2, this.loadTimeout, TimeUnit.MILLISECONDS)) {
                        // empty if block
                    }
                }
                catch (InterruptedException e) {}
            } else {
                long start = System.currentTimeMillis();
                nsIThreadManager tm = XPCOMUtils.getService("@mozilla.org/thread-manager;1", nsIThreadManager.class);
                nsIThread mt2 = tm.getMainThread();
                while (!this.sem.tryAcquire(2)) {
                    if (mt2.hasPendingEvents()) {
                        mt2.processNextEvent(false);
                    }
                    if (System.currentTimeMillis() - start < this.loadTimeout) continue;
                }
            }
        }
        this.onLoadEnded();
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                ChromeAdapter chromeAdapter = BlockingURLLoader.this.win.getChromeAdapter();
                if (chromeAdapter == null) {
                    return;
                }
                chromeAdapter.getWebBrowser().removeWebBrowserListener((nsISupports)ga, "{570f39d1-efd0-11d3-b093-00a024ffc08c}");
            }
        });
    }

    public void setLoadTimeout(long millis) {
        this.loadTimeout = millis;
    }

    public long getLoadTimeut() {
        return this.loadTimeout;
    }

    public abstract boolean triggerURLLoading();

    public abstract void onLoadStarted();

    public abstract void onLoadEnded();

    private class GeckoAdapter
    implements nsIWebProgressListener {
        private int loadsNum = 0;

        private GeckoAdapter() {
        }

        public void started() {
            BlockingURLLoader.this.sem.release();
            ++this.loadsNum;
        }

        public void stopped(nsIRequest aRequest, long aStatus) {
            if (this.loadsNum > 0) {
                if (aStatus != 0L) {
                    BlockingURLLoader.this.loadFailed = true;
                } else {
                    long s;
                    nsIHttpChannel hc = XPCOMUtils.qi((nsISupports)aRequest, nsIHttpChannel.class);
                    if (hc != null && (s = hc.getResponseStatus()) != 200L) {
                        BlockingURLLoader.this.loadFailed = true;
                    }
                }
                BlockingURLLoader.this.sem.release();
                --this.loadsNum;
            }
        }

        public void onStateChange(nsIWebProgress aWebProgress, nsIRequest aRequest, long aStateFlags, long aStatus) {
            if ((aStateFlags & 0x40000L) != 0L && (aStateFlags & 1L) != 0L) {
                this.started();
            }
            if ((aStateFlags & 0x40000L) != 0L && (aStateFlags & 0x10L) != 0L) {
                this.stopped(aRequest, aStatus);
            }
        }

        public void onLocationChange(nsIWebProgress arg0, nsIRequest arg1, nsIURI arg2) {
        }

        public void onProgressChange(nsIWebProgress arg0, nsIRequest arg1, int arg2, int arg3, int arg4, int arg5) {
        }

        public void onSecurityChange(nsIWebProgress arg0, nsIRequest arg1, long arg2) {
        }

        public void onStatusChange(nsIWebProgress arg0, nsIRequest arg1, long arg2, String arg3) {
        }

        public nsISupports queryInterface(String iid) {
            return Mozilla.queryInterface((nsISupports)this, (String)iid);
        }
    }
}

