/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.examples;

import java.util.Arrays;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.examples.Example13_Editor;
import org.mozilla.interfaces.nsIClipboardDragDropHooks;
import org.mozilla.interfaces.nsICommandManager;
import org.mozilla.interfaces.nsICommandParams;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDragSession;
import org.mozilla.interfaces.nsIEditingSession;
import org.mozilla.interfaces.nsIEditor;
import org.mozilla.interfaces.nsIFormatConverter;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsISupportsArray;
import org.mozilla.interfaces.nsISupportsCString;
import org.mozilla.interfaces.nsISupportsString;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;

public class Example14_EditorDnD {
    static DndHook dndHook = new DndHook();

    public static void main(String[] args) {
        MozillaWindow win = new MozillaWindow();
        win.setSize(500, 600);
        win.setVisible(true);
        MozillaAutomation.blockingLoad(win, "about:");
        Example13_Editor.initializeHTMLEditor(win);
        Example14_EditorDnD.installDnDHook(win);
    }

    public static void installDnDHook(final IMozillaWindow win) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIWebBrowser webBrowser = win.getChromeAdapter().getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi((nsISupports)webBrowser, nsIInterfaceRequestor.class);
                nsIDOMWindow domWin = webBrowser.getContentDOMWindow();
                nsIEditingSession editorSession = (nsIEditingSession)ir.getInterface("{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
                nsIEditor editor = editorSession.getEditorForWindow(domWin);
                assert (editor != null);
                nsICommandManager cm = (nsICommandManager)ir.getInterface("{080d2001-f91e-11d4-a73c-f9242928207c}");
                nsICommandParams p = XPCOMUtils.create("@mozilla.org/embedcomp/command-params;1", nsICommandParams.class);
                p.setISupportsValue("addhook", (nsISupports)dndHook);
                cm.doCommand("cmd_clipboardDragDropHook", p, domWin);
            }
        });
    }

    static class FormatConverter
    implements nsIFormatConverter {
        private static final String[] fromMimes = new String[]{"application/x-moz-nativehtml", "text/html", "text/unicode"};
        private static final String[] toMimes = new String[]{"text/unicode"};

        FormatConverter() {
        }

        public boolean canConvert(String fromDataFlavor, String toDataFlavor) {
            return Arrays.asList(fromMimes).contains(fromDataFlavor) && Arrays.asList(toMimes).contains(toDataFlavor);
        }

        public void convert(String fromDataFlavor, nsISupports fromData, long dataLen, String toDataFlavor, nsISupports[] toData, long[] dataToLen) {
            String d = "";
            nsISupportsCString s1 = XPCOMUtils.qi(fromData, nsISupportsCString.class);
            if (s1 != null) {
                d = s1.getData();
            } else {
                nsISupportsString s2 = XPCOMUtils.qi(fromData, nsISupportsString.class);
                if (s2 != null) {
                    d = s2.getData();
                }
            }
            nsISupportsString s = XPCOMUtils.create("@mozilla.org/supports-string;1", nsISupportsString.class);
            s.setData(d);
            toData[0] = s;
            dataToLen[0] = d.length();
        }

        public nsISupportsArray getInputDataFlavors() {
            nsISupportsArray a = XPCOMUtils.create("@mozilla.org/supports-array;1", nsISupportsArray.class);
            for (String mime : fromMimes) {
                nsISupportsCString s = XPCOMUtils.create("@mozilla.org/supports-cstring;1", nsISupportsCString.class);
                s.setData(mime);
                a.appendElement((nsISupports)s);
            }
            return a;
        }

        public nsISupportsArray getOutputDataFlavors() {
            nsISupportsArray a = XPCOMUtils.create("@mozilla.org/supports-array;1", nsISupportsArray.class);
            for (String mime : toMimes) {
                nsISupportsCString s = XPCOMUtils.create("@mozilla.org/supports-cstring;1", nsISupportsCString.class);
                s.setData(mime);
                a.appendElement((nsISupports)s);
            }
            return a;
        }

        public nsISupports queryInterface(String uuid) {
            return Mozilla.queryInterface((nsISupports)this, (String)uuid);
        }
    }

    static class DndHook
    implements nsIClipboardDragDropHooks {
        private static final String TEXT_UNICODE = "text/unicode";

        DndHook() {
        }

        public boolean allowDrop(nsIDOMEvent event, nsIDragSession session) {
            if (!session.isDataFlavorSupported(TEXT_UNICODE)) {
                return false;
            }
            nsIDOMNode target = XPCOMUtils.qi((nsISupports)event.getTarget(), nsIDOMNode.class);
            if (target == null) {
                return false;
            }
            String name = target.getLocalName();
            return name != null && name.equalsIgnoreCase("a");
        }

        public boolean allowStartDrag(nsIDOMEvent event) {
            return false;
        }

        public boolean onCopyOrDrag(nsIDOMEvent event, nsITransferable trans) {
            return false;
        }

        public boolean onPasteOrDrop(nsIDOMEvent event, nsITransferable trans) {
            nsIFormatConverter fc = trans.getConverter();
            assert (fc == null);
            trans.setConverter((nsIFormatConverter)new FormatConverter());
            nsISupports[] aData = new nsISupports[]{null};
            long[] aDataLen = new long[]{0L};
            trans.getTransferData(TEXT_UNICODE, aData, aDataLen);
            nsISupportsString ss = XPCOMUtils.qi(aData[0], nsISupportsString.class);
            String s = ss.getData();
            nsIDOMElement target = XPCOMUtils.qi((nsISupports)event.getTarget(), nsIDOMElement.class);
            if (target == null) {
                return true;
            }
            nsIDOMElement targetParent = XPCOMUtils.qi((nsISupports)target.getParentNode(), nsIDOMElement.class);
            if (targetParent == null) {
                return true;
            }
            nsIDOMDocument doc = targetParent.getOwnerDocument();
            nsIDOMElement e = doc.createElement("a");
            e.setAttribute("href", "about:");
            nsIDOMText t = doc.createTextNode(s);
            e.appendChild((nsIDOMNode)t);
            targetParent.appendChild((nsIDOMNode)e);
            return false;
        }

        public nsISupports queryInterface(String uuid) {
            return Mozilla.queryInterface((nsISupports)this, (String)uuid);
        }
    }
}

