/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.examples;

import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaWindow;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.interfaces.nsICommandManager;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDOMWindow2;
import org.mozilla.interfaces.nsIEditingSession;
import org.mozilla.interfaces.nsIEditor;
import org.mozilla.interfaces.nsIEditorStyleSheets;
import org.mozilla.interfaces.nsIHTMLEditor;
import org.mozilla.interfaces.nsIHTMLInlineTableEditor;
import org.mozilla.interfaces.nsIHTMLObjectResizer;
import org.mozilla.interfaces.nsIInterfaceRequestor;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;

public class Example13_Editor {
    static final String kNormalStyleSheet = "chrome://editor/content/EditorContent.css";
    static final String kAllTagsStyleSheet = "chrome://editor/content/EditorAllTags.css";
    static final String kParagraphMarksStyleSheet = "chrome://editor/content/EditorParagraphMarks.css";
    static final String kContentEditableStyleSheet = "resource://gre/res/contenteditable.css";

    public static void main(String[] args) {
        MozillaWindow win = new MozillaWindow();
        win.setSize(500, 600);
        win.setVisible(true);
        MozillaAutomation.blockingLoad(win, "about:license");
        Example13_Editor.initializeHTMLEditor(win);
        Example13_Editor.modifyHTMLContent(win);
        Example13_Editor.addClickListener(win);
    }

    public static void initializeHTMLEditor(final IMozillaWindow win) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIWebBrowser webBrowser = win.getChromeAdapter().getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi((nsISupports)webBrowser, nsIInterfaceRequestor.class);
                nsIDOMWindow domWin = webBrowser.getContentDOMWindow();
                nsIEditingSession editorSession = (nsIEditingSession)ir.getInterface("{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
                editorSession.makeWindowEditable(domWin, "html", false, true, true);
                nsIEditor editor = editorSession.getEditorForWindow(domWin);
                assert (editor != null);
                nsIHTMLEditor htmlEditor = XPCOMUtils.qi((nsISupports)editor, nsIHTMLEditor.class);
                assert (htmlEditor != null);
                htmlEditor.ignoreSpuriousDragEvent(true);
                htmlEditor.setReturnInParagraphCreatesNewParagraph(true);
                nsIHTMLObjectResizer resizer = XPCOMUtils.qi((nsISupports)htmlEditor, nsIHTMLObjectResizer.class);
                assert (resizer != null);
                resizer.setObjectResizingEnabled(true);
                resizer.refreshResizers();
                nsIHTMLInlineTableEditor tableEditor = XPCOMUtils.qi((nsISupports)htmlEditor, nsIHTMLInlineTableEditor.class);
                assert (tableEditor != null);
            }
        });
    }

    public static void modifyHTMLContent(final IMozillaWindow win) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIWebBrowser webBrowser = win.getChromeAdapter().getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi((nsISupports)webBrowser, nsIInterfaceRequestor.class);
                nsIDOMWindow domWin = webBrowser.getContentDOMWindow();
                nsIEditingSession editorSession = (nsIEditingSession)ir.getInterface("{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
                nsIEditor editor = editorSession.getEditorForWindow(domWin);
                assert (editor != null);
                nsISelection sel = editor.getSelection();
                nsIDOMElement e = domWin.getDocument().getElementById("section-1");
                sel.collapse((nsIDOMNode)e, 0);
                nsICommandManager cm = (nsICommandManager)ir.getInterface("{080d2001-f91e-11d4-a73c-f9242928207c}");
                for (int i = 0; i < 50; ++i) {
                    cm.doCommand("cmd_insertHR", null, domWin);
                }
            }
        });
    }

    public static void addClickListener(final IMozillaWindow win) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIWebBrowser webBrowser = win.getChromeAdapter().getWebBrowser();
                nsIInterfaceRequestor ir = XPCOMUtils.qi((nsISupports)webBrowser, nsIInterfaceRequestor.class);
                nsIDOMWindow2 domWin = XPCOMUtils.qi((nsISupports)webBrowser.getContentDOMWindow(), nsIDOMWindow2.class);
                nsIEditingSession editorSession = (nsIEditingSession)ir.getInterface("{274cd32e-3675-47e1-9d8a-fc6504ded9ce}");
                nsIEditor editor = editorSession.getEditorForWindow((nsIDOMWindow)domWin);
                assert (editor != null);
                nsIEditorStyleSheets es = XPCOMUtils.qi((nsISupports)editor, nsIEditorStyleSheets.class);
                es.addOverrideStyleSheet(Example13_Editor.kContentEditableStyleSheet);
                final nsIHTMLObjectResizer resizer = XPCOMUtils.qi((nsISupports)editor, nsIHTMLObjectResizer.class);
                assert (resizer != null);
                resizer.setObjectResizingEnabled(true);
                nsIDOMEventTarget et = domWin.getWindowRoot();
                et.addEventListener("click", new nsIDOMEventListener(){

                    public void handleEvent(nsIDOMEvent event) {
                        nsIDOMElement el = XPCOMUtils.qi((nsISupports)event.getTarget(), nsIDOMElement.class);
                        if (el == null) {
                            return;
                        }
                        resizer.hideResizers();
                        resizer.showResizers(el);
                    }

                    public nsISupports queryInterface(String uuid) {
                        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
                    }
                }, true);
            }
        });
    }
}

