/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.common.Platform;

public abstract class XULRunnerFinder {
    static Log log = LogFactory.getLog(XULRunnerFinder.class);

    public static boolean checkXULRunner(File f, String version, String source) {
        if (!XULRunnerFinder.isXULRunnerDir(f)) {
            log.warn((Object)("Invalid mozswing xulrunner " + source));
            return false;
        }
        if (!XULRunnerFinder.checkVersion(f, version)) {
            log.warn((Object)("Mismatched mozswing xulrunner version " + source + " requested version: " + version));
            return false;
        }
        return true;
    }

    public static File findXULRunner() {
        FindMethod[] findMethods = new FindMethod[]{new EnvironmentFinder(), new JavaPropertyFinder(), new JavaLibraryPathFinder(), new JavaPreferencesFinder(), new JNLPConfigFinder(), new JarFolderAndParentsFinder()};
        return XULRunnerFinder.findXULRunner(findMethods, null);
    }

    public static File findXULRunner(FindMethod[] findMethods, String version) {
        for (FindMethod findMethod : findMethods) {
            log.debug((Object)("Looking for xulrunner home with: " + findMethod.getClass().getName()));
            File file = findMethod.find(version);
            if (file == null) continue;
            log.debug((Object)("Found xulrunner home: " + file));
            return file;
        }
        return null;
    }

    private static boolean isLaunchedFromWebstart() {
        try {
            Class<?> smClass = Class.forName("javax.jnlp.ServiceManager");
            if (smClass == null) {
                return false;
            }
            Method lookup = smClass.getMethod("lookup", String.class);
            if (lookup == null) {
                return false;
            }
            Object bs = lookup.invoke(null, "javax.jnlp.BasicService");
            return bs != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isXULRunnerDir(File f1) {
        File f3;
        File f2;
        switch (Platform.platform) {
            case Linux: 
            case Solaris: {
                f2 = new File(f1, "libxul.so");
                f3 = new File(f1, "libjavaxpcomglue.so");
                break;
            }
            case OSX: {
                f2 = new File(f1, "xulrunner");
                f3 = new File(f1, "libjavaxpcomglue.jnilib");
                break;
            }
            default: {
                f2 = new File(f1, "xul.dll");
                f3 = new File(f1, "javaxpcomglue.dll");
            }
        }
        return f1.isDirectory() && f1.canRead() && f2.isFile() && f2.canRead() && f3.isFile() && f3.canRead();
    }

    public static String getVersion(File xulrunnerHome) {
        try {
            File xulrunnerVersionFile = new File(xulrunnerHome, "version.properties");
            FileInputStream xulrunnerVersionIS = new FileInputStream(xulrunnerVersionFile);
            Properties versionProps = new Properties();
            versionProps.load(xulrunnerVersionIS);
            return versionProps.getProperty("version");
        }
        catch (IOException e) {
            log.warn((Object)("Cannot determine version of: " + xulrunnerHome));
            return null;
        }
    }

    public static boolean checkVersion(File xulrunnerHome, String version) {
        if (version == null) {
            return true;
        }
        String homeVersion = XULRunnerFinder.getVersion(xulrunnerHome);
        if (homeVersion == null) {
            return false;
        }
        return homeVersion.equals(version);
    }

    public static class JarFolderAndParentsFinder
    implements FindMethod {
        public File find(String version) {
            String[] reldirs = new String[]{"native/${OS}/xulrunner", "native/${OS}-${ARCH}/xulrunner", "xulrunner-build/build/compile/mozilla/dist/bin"};
            try {
                URL u = XULRunnerFinder.class.getResource("");
                String uproto = u.getProtocol();
                if ("jar".equals(uproto)) {
                    String upath = u.getPath();
                    upath = upath.substring(0, upath.indexOf(33));
                    u = new URL(upath);
                    uproto = u.getProtocol();
                }
                File base = null;
                if ("file".equals(uproto)) {
                    base = new File(u.toURI());
                }
                while (base != null) {
                    for (String rel : reldirs) {
                        rel = rel.replace("${OS}", Platform.platform.libDir());
                        File f = new File(base, rel = rel.replace("${ARCH}", Platform.platform.arch()));
                        if (!XULRunnerFinder.isXULRunnerDir(f) || !XULRunnerFinder.checkVersion(f, version)) continue;
                        return f;
                    }
                    base = base.getParentFile();
                }
            }
            catch (Exception e) {
                log.error((Object)"failed to locate xulrunner", (Throwable)e);
            }
            return null;
        }
    }

    public static class JNLPConfigFinder
    implements FindMethod {
        public File find(String version) {
            if (XULRunnerFinder.isLaunchedFromWebstart()) {
                System.err.println("Looking for webstart muffin");
                try {
                    Policy.setPolicy(new Policy(){

                        public PermissionCollection getPermissions(CodeSource codesource) {
                            Permissions perms = new Permissions();
                            perms.add(new AllPermission());
                            return perms;
                        }

                        public void refresh() {
                        }
                    });
                    System.err.println("Added All Permissions Policy");
                    Class<?> jnlpConfigClazz = Class.forName("org.mozilla.browser.jnlp.JNLPConfig");
                    Method getNativeDir = jnlpConfigClazz.getMethod("getNativeDir", null);
                    System.err.println("Calling getNativeDir method");
                    String jnlpDir = (String)getNativeDir.invoke(null, (Object[])null);
                    System.err.println("found jnlp config muffin: " + jnlpDir);
                    if (jnlpDir != null && jnlpDir.length() > 0) {
                        String rel = "native/${OS}/xulrunner";
                        File f = new File(jnlpDir, rel = rel.replace("${OS}", Platform.platform.libDir()));
                        if (XULRunnerFinder.checkXULRunner(f, version, "webstart muffin")) {
                            return f;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Failed searching JNLP location", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }

    public static class JavaPreferencesFinder
    implements FindMethod {
        public static final String PREFERENCE_XULRUNNER_INSTALL_DIRS = "/org/mozdev/mozswing/xulrunner-versions";

        public File find(String version) {
            if (!XULRunnerFinder.isLaunchedFromWebstart()) {
                return null;
            }
            Preferences node = Preferences.systemRoot().node(PREFERENCE_XULRUNNER_INSTALL_DIRS);
            log.debug((Object)("Looking for version " + version + " in preference: " + PREFERENCE_XULRUNNER_INSTALL_DIRS));
            if (version == null) {
                try {
                    String[] childrenNames;
                    String[] arr$ = childrenNames = node.childrenNames();
                    int len$ = arr$.length;
                    int i$ = 0;
                    if (i$ < len$) {
                        String string = arr$[i$];
                        Preferences versionNode = node.node(string);
                        return this.find(versionNode, version);
                    }
                }
                catch (BackingStoreException e) {
                    e.printStackTrace();
                }
            } else {
                Preferences versionNode = node.node(version);
                return this.find(versionNode, version);
            }
            return null;
        }

        public File find(Preferences versionNode, String version) {
            try {
                String[] keys;
                for (String key : keys = versionNode.keys()) {
                    String directory = versionNode.get(key, null);
                    File f = new File(directory);
                    if (!XULRunnerFinder.checkXULRunner(f, version, "java preference: " + versionNode.absolutePath() + "/" + key + "=" + directory)) continue;
                    return f;
                }
            }
            catch (BackingStoreException e) {
                log.warn((Object)"Problem looking up mozswing xulrunner home in preferences", (Throwable)e);
            }
            return null;
        }
    }

    public static class JavaLibraryPathFinder
    implements FindMethod {
        public File find(String version) {
            String nativelibdirProp = System.getProperty("java.library.path");
            if (nativelibdirProp != null && nativelibdirProp.length() > 0) {
                StringTokenizer st = new StringTokenizer(nativelibdirProp, File.pathSeparator);
                while (st.hasMoreTokens()) {
                    String nativeLibraryDir = st.nextToken();
                    File f = new File(nativeLibraryDir, "xulrunner");
                    if (!XULRunnerFinder.isXULRunnerDir(f) || !XULRunnerFinder.checkVersion(f, version)) continue;
                    return f;
                }
            }
            return null;
        }
    }

    public static class JavaPropertyFinder
    implements FindMethod {
        private static final String MOZSWING_XULRUNNER_HOME = "mozswing.xulrunner.home";

        public File find(String version) {
            File f;
            String xuldirProp = System.getProperty(MOZSWING_XULRUNNER_HOME);
            if (xuldirProp != null && xuldirProp.length() > 0 && XULRunnerFinder.checkXULRunner(f = new File(xuldirProp), version, "java property: mozswing.xulrunner.home=" + xuldirProp)) {
                return f;
            }
            return null;
        }
    }

    public static class EnvironmentFinder
    implements FindMethod {
        private static final String MOZSWING_XULRUNNER_HOME = "MOZSWING_XULRUNNER_HOME";

        public File find(String version) {
            File f;
            String xuldirEnv = System.getenv(MOZSWING_XULRUNNER_HOME);
            if (xuldirEnv != null && xuldirEnv.length() > 0 && XULRunnerFinder.checkXULRunner(f = new File(xuldirEnv), version, "environment variable: MOZSWING_XULRUNNER_HOME=" + xuldirEnv)) {
                return f;
            }
            return null;
        }
    }

    public static interface FindMethod {
        public File find(String var1);
    }
}

