/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIComponentRegistrar;
import org.mozilla.interfaces.nsIEventTarget;
import org.mozilla.interfaces.nsIFactory;
import org.mozilla.interfaces.nsIProxyObjectManager;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIThread;
import org.mozilla.interfaces.nsIThreadManager;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPCOMUtils {
    static Log log = LogFactory.getLog(XPCOMUtils.class);

    private static String guessIID(Class c) {
        try {
            String name = c.getName();
            String baseName = c.getSimpleName();
            String iidFieldName = name.startsWith("org.mozilla.interfaces.ns") ? String.format("NS_%s_IID", baseName.substring(2).toUpperCase()) : String.format("%s_IID", baseName.toUpperCase());
            Field f = c.getDeclaredField(iidFieldName);
            String iid = (String)f.get(c);
            return iid;
        }
        catch (Throwable e) {
            log.error((Object)"failed to resolve IID of an XPCOM interface", e);
            return null;
        }
    }

    private static String guessCID(Class c) {
        try {
            String baseName = c.getSimpleName();
            String iidFieldName = String.format("%s_CID", baseName.toUpperCase());
            Field f = c.getDeclaredField(iidFieldName);
            String cid = (String)f.get(c);
            return cid;
        }
        catch (Throwable e) {
            log.error((Object)"failed to resolve CID of an XPCOM component", e);
            return null;
        }
    }

    public static <T extends nsISupports> T proxy(nsISupports obj, Class<T> c) {
        try {
            Mozilla moz = Mozilla.getInstance();
            String iid = XPCOMUtils.guessIID(c);
            nsIServiceManager sm = moz.getServiceManager();
            nsIThreadManager tm = (nsIThreadManager)sm.getServiceByContractID("@mozilla.org/thread-manager;1", "{056216f5-8803-46b4-9199-d95bc1f0446f}");
            nsIThread mt2 = tm.getMainThread();
            nsIProxyObjectManager pm = (nsIProxyObjectManager)sm.getService("{eea90d41-b059-11d2-915e-c12b696c9333}", "{ee8ce1e3-0319-4bd9-8f70-7258b21c7733}");
            nsISupports t = pm.getProxyForObject((nsIEventTarget)mt2, iid, obj, 1);
            return (T)t;
        }
        catch (Throwable e) {
            log.error((Object)"failed to create XPCOM proxy", e);
            return null;
        }
    }

    public static <T extends nsISupports> T asyncProxy(nsISupports obj, Class<T> c) {
        try {
            Mozilla moz = Mozilla.getInstance();
            String iid = XPCOMUtils.guessIID(c);
            nsIServiceManager sm = moz.getServiceManager();
            nsIThreadManager tm = (nsIThreadManager)sm.getServiceByContractID("@mozilla.org/thread-manager;1", "{056216f5-8803-46b4-9199-d95bc1f0446f}");
            nsIThread mt2 = tm.getMainThread();
            nsIProxyObjectManager pm = (nsIProxyObjectManager)sm.getService("{eea90d41-b059-11d2-915e-c12b696c9333}", "{ee8ce1e3-0319-4bd9-8f70-7258b21c7733}");
            nsISupports t = pm.getProxyForObject((nsIEventTarget)mt2, iid, obj, 2);
            return (T)t;
        }
        catch (Throwable e) {
            log.error((Object)"failed to create XPCOM proxy", e);
            return null;
        }
    }

    public static <T extends nsISupports> T create(String contractID, Class<T> c) {
        try {
            Mozilla moz = Mozilla.getInstance();
            String iid = XPCOMUtils.guessIID(c);
            nsIComponentManager componentManager = moz.getComponentManager();
            nsISupports t = componentManager.createInstanceByContractID(contractID, null, iid);
            return (T)t;
        }
        catch (Throwable e) {
            log.error((Object)"failed to create XPCOM object", e);
            return null;
        }
    }

    public static <T extends nsISupports> T createProxy(String contractID, Class<T> c) {
        try {
            Mozilla moz = Mozilla.getInstance();
            String iid = XPCOMUtils.guessIID(c);
            nsIComponentManager componentManager = XPCOMUtils.proxy((nsISupports)moz.getComponentManager(), nsIComponentManager.class);
            nsISupports t1 = componentManager.createInstanceByContractID(contractID, null, iid);
            T t2 = XPCOMUtils.proxy(t1, c);
            return t2;
        }
        catch (Throwable e) {
            log.error((Object)"failed to create XPCOM object", e);
            return null;
        }
    }

    public static <T extends nsISupports> T getService(String contractID, Class<T> c) {
        try {
            Mozilla moz = Mozilla.getInstance();
            String iid = XPCOMUtils.guessIID(c);
            nsIServiceManager serviceManager = moz.getServiceManager();
            nsISupports t = serviceManager.getServiceByContractID(contractID, iid);
            return (T)t;
        }
        catch (Throwable e) {
            log.error((Object)"failed to create XPCOM service", e);
            return null;
        }
    }

    public static <T extends nsISupports> T getServiceProxy(String contractID, Class<T> c) {
        try {
            Mozilla moz = Mozilla.getInstance();
            String iid = XPCOMUtils.guessIID(c);
            nsIServiceManager serviceManager = XPCOMUtils.proxy((nsISupports)moz.getServiceManager(), nsIServiceManager.class);
            nsISupports t1 = serviceManager.getServiceByContractID(contractID, iid);
            T t2 = XPCOMUtils.proxy(t1, c);
            return t2;
        }
        catch (Throwable e) {
            log.error((Object)"failed to create XPCOM service", e);
            return null;
        }
    }

    public static <T extends nsISupports> T qi(nsISupports obj, Class<T> c) {
        try {
            if (obj == null) {
                return null;
            }
            String iid = XPCOMUtils.guessIID(c);
            nsISupports t = obj.queryInterface(iid);
            return (T)t;
        }
        catch (XPCOMException e) {
            if (e.errorcode != 2147500034L) {
                log.error((Object)"failed to query-interface an XPCOM object", (Throwable)e);
            }
            return null;
        }
        catch (Throwable e) {
            log.error((Object)"failed to query-interface an XPCOM object", e);
            return null;
        }
    }

    public static void register(String contractID, nsIFactory factory) {
        Mozilla moz = Mozilla.getInstance();
        nsIComponentRegistrar componentRegistrar = moz.getComponentRegistrar();
        String name = factory.getClass().getSimpleName();
        String cid = XPCOMUtils.guessCID(factory.getClass());
        componentRegistrar.registerFactory(cid, name, contractID, factory);
    }
}

