/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.MozillaContainer;
import org.mozilla.browser.impl.WindowCreator;
import org.mozilla.browser.impl.components.JChromeButton;
import org.mozilla.browser.mt;
import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebNavigation;
import org.w3c.dom.Document;

public class MozillaWindow
extends JFrame
implements IMozillaWindow {
    private static final long serialVersionUID = 1L;
    static Log log = LogFactory.getLog(MozillaWindow.class);
    protected final IMozillaWindow.VisibilityMode toolbarVisMode;
    protected final IMozillaWindow.VisibilityMode statusbarVisMode;
    protected JToolBar toolbar;
    protected JButton backButton;
    protected JButton forwardButton;
    protected JButton reloadButton;
    protected JButton stopButton;
    protected JButton goButton;
    protected JTextField urlBar;
    protected MozillaContainer mozContainer;
    protected JTextField statusField;
    protected IMozillaWindow parentWin;
    private ChromeAdapter chromeAdapter;
    private boolean attachNewBrowserOnCreation;
    private String pendingUriToLoad;
    private String pendingContentToLoad;
    private String pendingContentUriToLoad;
    private Dimension initialPreferredlSize;
    private static int DEFAULT_WIDTH = 300;
    private static int DEFAULT_HEIGHT = 300;

    public MozillaWindow() {
        this(true, null, null);
    }

    public MozillaWindow(IMozillaWindow.VisibilityMode toolbarVisMode, IMozillaWindow.VisibilityMode statusbarVisMode) {
        this(true, toolbarVisMode, statusbarVisMode);
    }

    public MozillaWindow(boolean attachNewBrowserOnCreation, IMozillaWindow.VisibilityMode toolbarVisMode, IMozillaWindow.VisibilityMode statusbarVisMode) {
        this.attachNewBrowserOnCreation = attachNewBrowserOnCreation;
        this.setDefaultCloseOperation(2);
        MozillaInitialization.initialize();
        this.toolbarVisMode = toolbarVisMode != null ? toolbarVisMode : IMozillaWindow.VisibilityMode.DEFAULT;
        this.statusbarVisMode = statusbarVisMode != null ? statusbarVisMode : IMozillaWindow.VisibilityMode.DEFAULT;
        this.initialPreferredlSize = new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT);
        this.createChrome();
    }

    public void attachNewBrowser() {
        assert (MozillaExecutor.isMozillaThread());
        WindowCreator.attachBrowser(this, 1L, null);
    }

    public void onAttachBrowser(final ChromeAdapter chromeAdapter, final ChromeAdapter parentChromeAdapter) {
        assert (MozillaExecutor.isMozillaThread());
        assert (chromeAdapter != null);
        assert (this.chromeAdapter == null);
        this.chromeAdapter = chromeAdapter;
        this.mozContainer.onAttachBrowser(chromeAdapter);
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                boolean showStatusbar;
                boolean showToolbar;
                IMozillaWindow.VisibilityMode vm = MozillaWindow.this.toolbarVisMode;
                if (vm == IMozillaWindow.VisibilityMode.DEFAULT && parentChromeAdapter != null) {
                    vm = parentChromeAdapter.getWindow().getToolbarVisibilityMode();
                }
                switch (vm) {
                    case FORCED_VISIBLE: {
                        showToolbar = true;
                        break;
                    }
                    case FORCED_HIDDEN: {
                        showToolbar = false;
                        break;
                    }
                    default: {
                        showToolbar = (chromeAdapter.getChromeFlags() & 0x60L) != 0L;
                    }
                }
                MozillaWindow.this.toolbar.setVisible(showToolbar);
                IMozillaWindow.VisibilityMode vm2 = MozillaWindow.this.statusbarVisMode;
                if (vm2 == IMozillaWindow.VisibilityMode.DEFAULT && parentChromeAdapter != null) {
                    vm2 = parentChromeAdapter.getWindow().getStatusbarVisibilityMode();
                }
                switch (vm2) {
                    case FORCED_VISIBLE: {
                        showStatusbar = true;
                        break;
                    }
                    case FORCED_HIDDEN: {
                        showStatusbar = false;
                        break;
                    }
                    default: {
                        showStatusbar = (chromeAdapter.getChromeFlags() & 0x80L) != 0L && (chromeAdapter.getChromeFlags() & 0x40000000L) == 0L;
                    }
                }
                MozillaWindow.this.statusField.setVisible(showStatusbar);
                MozillaWindow.this.adjustLocation(chromeAdapter.getChromeFlags());
                if (MozillaWindow.this.parentWin != null) {
                    MozillaWindow.this.setSize(MozillaWindow.this.parentWin.getSize());
                } else {
                    MozillaWindow.this.setPreferredSize(MozillaWindow.this.initialPreferredlSize);
                }
                if (MozillaWindow.this.pendingUriToLoad != null) {
                    MozillaWindow.this.load(MozillaWindow.this.pendingUriToLoad);
                } else if (MozillaWindow.this.pendingContentToLoad != null) {
                    MozillaWindow.this.loadHTML(MozillaWindow.this.pendingContentToLoad, MozillaWindow.this.pendingContentUriToLoad);
                }
                MozillaWindow.this.pendingUriToLoad = (MozillaWindow.this.pendingContentToLoad = (MozillaWindow.this.pendingContentUriToLoad = null));
            }
        });
    }

    public void onDetachBrowser() {
        assert (MozillaExecutor.isMozillaThread());
        this.chromeAdapter = null;
        this.mozContainer.onDetachBrowser();
    }

    protected void createChrome() {
        this.createToolbar();
        this.toolbar.setVisible(false);
        this.createMozillaPanel();
        this.createStatusbar();
        this.statusField.setVisible(false);
    }

    protected void createToolbar() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "North");
        this.backButton = new JChromeButton("back", mt.t("MozillaWindow.Tooltip_Back"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaWindow.this.goBack();
            }
        });
        this.toolbar.add(this.backButton);
        this.forwardButton = new JChromeButton("forward", mt.t("MozillaWindow.Tooltip_Forward"));
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaWindow.this.goForward();
            }
        });
        this.toolbar.add(this.forwardButton);
        this.reloadButton = new JChromeButton("reload", mt.t("MozillaWindow.Tooltip_Reload"));
        this.reloadButton.setEnabled(false);
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaWindow.this.reload();
            }
        });
        this.toolbar.add(this.reloadButton);
        this.stopButton = new JChromeButton("stop", mt.t("MozillaWindow.Tooltip_Stop"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaWindow.this.stop();
            }
        });
        this.toolbar.add(this.stopButton);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.urlBar = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        p.add((Component)this.urlBar, c);
        this.urlBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = MozillaWindow.this.urlBar.getText();
                MozillaWindow.this.load(uri);
            }
        });
        this.toolbar.add(p);
        this.goButton = new JChromeButton("go", mt.t("MozillaWindow.Tooltip_Go"));
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = MozillaWindow.this.urlBar.getText();
                MozillaWindow.this.load(uri);
            }
        });
        this.toolbar.add(this.goButton);
    }

    protected void createMozillaPanel() {
        this.mozContainer = new MozillaContainer();
        this.add((Component)this.mozContainer, "Center");
    }

    public void addNotify() {
        super.addNotify();
        if (MozillaInitialization.isInitialized()) {
            MozillaInitialization.winCreator.ensurePrecreatedWindows();
            if (this.attachNewBrowserOnCreation) {
                Runnable r = new Runnable(){

                    public void run() {
                        MozillaWindow.this.attachNewBrowser();
                    }
                };
                MozillaExecutor.mozAsyncExec(r);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected void createStatusbar() {
        this.statusField = new JTextField("");
        this.statusField.setEditable(false);
        this.statusField.setFocusable(false);
        this.add((Component)this.statusField, "South");
    }

    protected void adjustLocation(long chromeMask) {
        if (this.parentWin == null || !this.parentWin.isShowing()) {
            return;
        }
        Point pos = this.parentWin.getLocationOnScreen();
        if ((chromeMask & 0x8000000L) != 0L) {
            Point p = new Point((int)this.parentWin.getSize().getWidth() / 2, (int)this.parentWin.getSize().getHeight() / 2);
            p.translate((int)(-this.getSize().getWidth()) / 2, (int)(-this.getSize().getHeight()) / 2);
            log.trace((Object)String.format("adjustLocation: %d, %d", p.x, p.y));
            pos.translate(p.x, p.y);
            if (pos.x < 0) {
                pos.x = 0;
            }
            if (pos.y < 0) {
                pos.y = 0;
            }
        } else {
            Insets insets = this.getInsets();
            pos.translate(insets.top, insets.top);
        }
        this.setLocation(pos);
    }

    public void goBack() {
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaWindow.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goBack();
            }
        });
    }

    public void goForward() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaWindow.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goForward();
            }
        });
    }

    public void reload() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaWindow.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.reload(0L);
            }
        });
    }

    public void stop() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaWindow.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.stop(3L);
            }
        });
    }

    public void load(final String uri) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        if (this.chromeAdapter == null) {
            this.pendingUriToLoad = uri;
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaWindow.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.loadURI(uri, 0L, null, null, null);
            }
        });
    }

    public void loadHTML(String content) {
        this.loadHTML(null, content);
    }

    public void loadHTML(final String content, final String asUrl) {
        if (content == null) {
            return;
        }
        if (this.chromeAdapter == null) {
            this.pendingContentToLoad = content;
            this.pendingContentUriToLoad = asUrl;
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                MozillaAutomation.triggerLoadHTML(MozillaWindow.this, content, asUrl);
            }
        });
    }

    public String getUrl() {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaExecutor.mozSyncExecQuiet(new Callable<String>(){

            @Override
            public String call() {
                return MozillaAutomation.getCurrentURI(MozillaWindow.this);
            }
        });
    }

    public Object jsexec(String script) {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaAutomation.executeJavascript(this, script);
    }

    public MozillaContainer getMozillaContainer() {
        return this.mozContainer;
    }

    public ChromeAdapter getChromeAdapter() {
        return this.chromeAdapter;
    }

    public void setParentWindow(IMozillaWindow parentWin) {
        this.parentWin = parentWin;
    }

    public IMozillaWindow getParentWindow() {
        return this.parentWin;
    }

    public void onSetStatus(String text) {
        this.statusField.setText(text);
    }

    public void onEnableBackButton(boolean enabled) {
        this.backButton.setEnabled(enabled);
    }

    public void onEnableForwardButton(boolean enabled) {
        this.forwardButton.setEnabled(enabled);
    }

    public void onEnableReloadButton(boolean enabled) {
        this.reloadButton.setEnabled(true);
    }

    public void onEnableStopButton(boolean enabled) {
        this.stopButton.setEnabled(enabled);
    }

    public void onSetUrlbarText(String url) {
        this.urlBar.setText(url);
    }

    public void onSetSize(int w, int h) {
        this.setSize(w, h);
    }

    public void onSetTitle(String title) {
        this.setTitle(title);
    }

    public void onSetVisible(boolean visibility) {
        this.setVisible(visibility);
    }

    public void onLoadingStarted() {
    }

    public void onLoadingEnded() {
    }

    public void onCloseWindow() {
        this.onSetVisible(false);
        this.dispose();
    }

    public void onDispatchEvent(AWTEvent e) {
        super.processEvent(e);
    }

    public Document getDocument() {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaExecutor.mozSyncExecQuiet(new Callable<Document>(){

            @Override
            public Document call() {
                nsIDOMDocument nsdoc = MozillaWindow.this.chromeAdapter.getWebBrowser().getContentDOMWindow().getDocument();
                return (Document)NodeFactory.getNodeInstance((nsIDOMNode)nsdoc);
            }
        });
    }

    public void setInitialPreferredlSize(Dimension preferredSize) {
        this.initialPreferredlSize = preferredSize;
    }

    public IMozillaWindow.VisibilityMode getToolbarVisibilityMode() {
        return this.toolbarVisMode;
    }

    public IMozillaWindow.VisibilityMode getStatusbarVisibilityMode() {
        return this.statusbarVisMode;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public JTextField getStatusbar() {
        return this.statusField;
    }

    public static void main(String[] args) throws Exception {
        String url = "about:";
        if (args.length >= 2 && (args[0].equals("-url") || args[0].equals("--url"))) {
            url = args[1];
        }
        MozillaWindow frame = new MozillaWindow();
        frame.setDefaultCloseOperation(3);
        frame.setBounds(200, 200, 1024, 768);
        frame.load(url);
        frame.setVisible(true);
    }
}

