/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.IMozillaWindow;
import org.mozilla.browser.MozillaAutomation;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.MozillaContainer;
import org.mozilla.browser.impl.WindowCreator;
import org.mozilla.browser.impl.components.JChromeButton;
import org.mozilla.browser.mt;
import org.mozilla.dom.NodeFactory;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebNavigation;
import org.w3c.dom.Document;

public class MozillaPanel
extends JPanel
implements IMozillaWindow {
    private static final long serialVersionUID = 1L;
    static Log log = LogFactory.getLog(MozillaPanel.class);
    protected final IMozillaWindow.VisibilityMode toolbarVisMode;
    protected final IMozillaWindow.VisibilityMode statusbarVisMode;
    protected JToolBar toolbar;
    protected JButton backButton;
    protected JButton forwardButton;
    protected JButton reloadButton;
    protected JButton stopButton;
    protected JButton goButton;
    protected JTextField urlBar;
    protected MozillaContainer mozContainer;
    protected JTextField statusField;
    protected IMozillaWindow parentWin;
    private ChromeAdapter chromeAdapter;
    private boolean attachNewBrowserOnCreation;
    private String pendingUriToLoad;
    private String pendingContentToLoad;
    private String pendingContentUriToLoad;
    private Dimension initialPreferredSize;
    private static int DEFAULT_WIDTH = 300;
    private static int DEFAULT_HEIGHT = 300;
    protected boolean updateTitle = true;

    public MozillaPanel() {
        this(true, null, null);
    }

    public MozillaPanel(IMozillaWindow.VisibilityMode toolbarVisMode, IMozillaWindow.VisibilityMode statusbarVisMode) {
        this(true, toolbarVisMode, statusbarVisMode);
    }

    public MozillaPanel(boolean attachNewBrowserOnCreation, IMozillaWindow.VisibilityMode toolbarVisMode, IMozillaWindow.VisibilityMode statusbarVisMode) {
        this.attachNewBrowserOnCreation = attachNewBrowserOnCreation;
        MozillaInitialization.initialize();
        this.toolbarVisMode = toolbarVisMode != null ? toolbarVisMode : IMozillaWindow.VisibilityMode.DEFAULT;
        this.statusbarVisMode = statusbarVisMode != null ? statusbarVisMode : IMozillaWindow.VisibilityMode.DEFAULT;
        this.initialPreferredSize = new Dimension(DEFAULT_WIDTH, DEFAULT_HEIGHT);
        this.createChrome();
    }

    public void attachNewBrowser() {
        assert (MozillaExecutor.isMozillaThread());
        WindowCreator.attachBrowser(this, 1L, null);
    }

    public void onAttachBrowser(final ChromeAdapter chromeAdapter, final ChromeAdapter parentChromeAdapter) {
        assert (MozillaExecutor.isMozillaThread());
        assert (chromeAdapter != null);
        assert (this.chromeAdapter == null);
        this.chromeAdapter = chromeAdapter;
        this.mozContainer.onAttachBrowser(chromeAdapter);
        MozillaExecutor.swingAsyncExec(new Runnable(){

            public void run() {
                boolean showStatusbar;
                boolean showToolbar;
                IMozillaWindow.VisibilityMode vm = MozillaPanel.this.toolbarVisMode;
                if (vm == IMozillaWindow.VisibilityMode.DEFAULT && parentChromeAdapter != null) {
                    vm = parentChromeAdapter.getWindow().getToolbarVisibilityMode();
                }
                switch (vm) {
                    case FORCED_VISIBLE: {
                        showToolbar = true;
                        break;
                    }
                    case FORCED_HIDDEN: {
                        showToolbar = false;
                        break;
                    }
                    default: {
                        showToolbar = (chromeAdapter.getChromeFlags() & 0x60L) != 0L;
                    }
                }
                MozillaPanel.this.toolbar.setVisible(showToolbar);
                IMozillaWindow.VisibilityMode vm2 = MozillaPanel.this.statusbarVisMode;
                if (vm2 == IMozillaWindow.VisibilityMode.DEFAULT && parentChromeAdapter != null) {
                    vm2 = parentChromeAdapter.getWindow().getStatusbarVisibilityMode();
                }
                switch (vm2) {
                    case FORCED_VISIBLE: {
                        showStatusbar = true;
                        break;
                    }
                    case FORCED_HIDDEN: {
                        showStatusbar = false;
                        break;
                    }
                    default: {
                        showStatusbar = (chromeAdapter.getChromeFlags() & 0x80L) != 0L && (chromeAdapter.getChromeFlags() & 0x40000000L) == 0L;
                    }
                }
                MozillaPanel.this.statusField.setVisible(showStatusbar);
                MozillaPanel.this.adjustLocation(chromeAdapter.getChromeFlags());
                if (MozillaPanel.this.parentWin != null) {
                    MozillaPanel.this.setSize(MozillaPanel.this.parentWin.getSize());
                } else {
                    MozillaPanel.this.setPreferredSize(MozillaPanel.this.initialPreferredSize);
                }
                if (MozillaPanel.this.pendingUriToLoad != null) {
                    MozillaPanel.this.load(MozillaPanel.this.pendingUriToLoad);
                } else if (MozillaPanel.this.pendingContentToLoad != null) {
                    MozillaPanel.this.loadHTML(MozillaPanel.this.pendingContentToLoad, MozillaPanel.this.pendingContentUriToLoad);
                }
                MozillaPanel.this.pendingUriToLoad = (MozillaPanel.this.pendingContentToLoad = (MozillaPanel.this.pendingContentUriToLoad = null));
            }
        });
    }

    public void onDetachBrowser() {
        assert (MozillaExecutor.isMozillaThread());
        this.chromeAdapter = null;
        this.mozContainer.onDetachBrowser();
    }

    protected void createChrome() {
        this.setLayout(new BorderLayout());
        this.createToolbar();
        this.toolbar.setVisible(false);
        this.createMozillaPanel();
        this.createStatusbar();
        this.statusField.setVisible(false);
    }

    protected void createToolbar() {
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "North");
        this.backButton = new JChromeButton("back", mt.t("MozillaPanel.Tooltip_Back"));
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.goBack();
            }
        });
        this.toolbar.add(this.backButton);
        this.forwardButton = new JChromeButton("forward", mt.t("MozillaPanel.Tooltip_Forward"));
        this.forwardButton.setEnabled(false);
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.goForward();
            }
        });
        this.toolbar.add(this.forwardButton);
        this.reloadButton = new JChromeButton("reload", mt.t("MozillaPanel.Tooltip_Reload"));
        this.reloadButton.setEnabled(false);
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.reload();
            }
        });
        this.toolbar.add(this.reloadButton);
        this.stopButton = new JChromeButton("stop", mt.t("MozillaPanel.Tooltip_Stop"));
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MozillaPanel.this.stop();
            }
        });
        this.toolbar.add(this.stopButton);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.urlBar = new JTextField();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        p.add((Component)this.urlBar, c);
        this.urlBar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = MozillaPanel.this.urlBar.getText();
                MozillaPanel.this.load(uri);
            }
        });
        this.toolbar.add(p);
        this.goButton = new JChromeButton("go", mt.t("MozillaPanel.Tooltip_Go"));
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String uri = MozillaPanel.this.urlBar.getText();
                MozillaPanel.this.load(uri);
            }
        });
        this.toolbar.add(this.goButton);
    }

    protected void createMozillaPanel() {
        this.mozContainer = new MozillaContainer();
        this.add((Component)this.mozContainer, "Center");
    }

    public void addNotify() {
        super.addNotify();
        if (MozillaInitialization.isInitialized()) {
            MozillaInitialization.winCreator.ensurePrecreatedWindows();
            if (this.attachNewBrowserOnCreation) {
                Runnable r = new Runnable(){

                    public void run() {
                        MozillaPanel.this.attachNewBrowser();
                    }
                };
                MozillaExecutor.mozAsyncExec(r);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
    }

    protected void createStatusbar() {
        this.statusField = new JTextField("");
        this.statusField.setEditable(false);
        this.statusField.setFocusable(false);
        this.add((Component)this.statusField, "South");
    }

    protected void adjustLocation(long chromeMask) {
    }

    public void goBack() {
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goBack();
            }
        });
    }

    public void goForward() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.goForward();
            }
        });
    }

    public void reload() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.reload(0L);
            }
        });
    }

    public void stop() {
        if (this.chromeAdapter == null) {
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.stop(3L);
            }
        });
    }

    public void load(final String uri) {
        if (uri == null || uri.length() == 0) {
            return;
        }
        if (this.chromeAdapter == null) {
            this.pendingUriToLoad = uri;
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation nav = XPCOMUtils.qi((nsISupports)MozillaPanel.this.chromeAdapter.getWebBrowser(), nsIWebNavigation.class);
                nav.loadURI(uri, 0L, null, null, null);
            }
        });
    }

    public void loadHTML(String content) {
        this.loadHTML(content, null);
    }

    public void loadHTML(final String content, final String asUrl) {
        if (content == null) {
            return;
        }
        if (this.chromeAdapter == null) {
            this.pendingContentToLoad = content;
            this.pendingContentUriToLoad = asUrl;
            return;
        }
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                MozillaAutomation.triggerLoadHTML(MozillaPanel.this, content, asUrl);
            }
        });
    }

    public String getUrl() {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaExecutor.mozSyncExecQuiet(new Callable<String>(){

            @Override
            public String call() {
                return MozillaAutomation.getCurrentURI(MozillaPanel.this);
            }
        });
    }

    public Object jsexec(String script) {
        if (this.chromeAdapter == null) {
            return null;
        }
        return MozillaAutomation.executeJavascript(this, script);
    }

    public MozillaContainer getMozillaContainer() {
        return this.mozContainer;
    }

    public ChromeAdapter getChromeAdapter() {
        return this.chromeAdapter;
    }

    public void setParentWindow(IMozillaWindow parentWin) {
        this.parentWin = parentWin;
    }

    public IMozillaWindow getParentWindow() {
        return this.parentWin;
    }

    public void onSetStatus(String text) {
        this.statusField.setText(text);
    }

    public void onEnableBackButton(boolean enabled) {
        this.backButton.setEnabled(enabled);
    }

    public void onEnableForwardButton(boolean enabled) {
        this.forwardButton.setEnabled(enabled);
    }

    public void onEnableReloadButton(boolean enabled) {
        this.reloadButton.setEnabled(true);
    }

    public void onEnableStopButton(boolean enabled) {
        this.stopButton.setEnabled(enabled);
    }

    public void onSetUrlbarText(String url) {
        this.urlBar.setText(url);
    }

    public void onSetSize(int w, int h) {
        log.debug((Object)"ignored onSetSize in mozpanel");
    }

    public void setUpdateTitle(boolean updateTitle) {
        this.updateTitle = updateTitle;
    }

    public void onSetTitle(String title) {
        if (this.updateTitle) {
            this.setTitle(title);
        }
    }

    public void setTitle(String title) {
        Container tabPane;
        Container tab = this;
        for (tabPane = this.getParent(); tabPane != null && !(tabPane instanceof JTabbedPane); tabPane = tabPane.getParent()) {
            tab = tabPane;
        }
        if (tabPane != null) {
            JTabbedPane tabPane2 = (JTabbedPane)tabPane;
            int idx = tabPane2.indexOfComponent(tab);
            if (idx >= 0) {
                tabPane2.setTitleAt(idx, title);
            }
        } else {
            Window win = SwingUtilities.getWindowAncestor(this);
            if (win instanceof Frame) {
                Frame f = (Frame)win;
                f.setTitle(title);
            } else if (win instanceof Dialog) {
                Dialog d = (Dialog)win;
                d.setTitle(title);
            }
        }
    }

    public String getTitle() {
        Container tabPane;
        Container tab = this;
        for (tabPane = this.getParent(); tabPane != null && !(tabPane instanceof JTabbedPane); tabPane = tabPane.getParent()) {
            tab = tabPane;
        }
        if (tabPane != null) {
            JTabbedPane tabPane2 = (JTabbedPane)tabPane;
            int idx = tabPane2.indexOfComponent(tab);
            if (idx >= 0) {
                return tabPane2.getTitleAt(idx);
            }
            log.error((Object)"Unknown tab index");
            return "";
        }
        Window win = SwingUtilities.getWindowAncestor(this);
        if (win instanceof Frame) {
            Frame f = (Frame)win;
            return f.getTitle();
        }
        if (win instanceof Dialog) {
            Dialog d = (Dialog)win;
            return d.getTitle();
        }
        log.error((Object)"Unknown window type");
        return "";
    }

    public void onSetVisible(boolean visibility) {
        this.setVisible(visibility);
    }

    public void onLoadingStarted() {
    }

    public void onLoadingEnded() {
    }

    public void onCloseWindow() {
        log.debug((Object)"Ignoring mozilla request to close the panel");
    }

    public void onDispatchEvent(AWTEvent e) {
        super.processEvent(e);
    }

    public Document getDocument() {
        if (this.chromeAdapter == null) {
            return null;
        }
        nsIDOMDocument nsdoc = this.chromeAdapter.getWebBrowser().getContentDOMWindow().getDocument();
        return (Document)NodeFactory.getNodeInstance((nsIDOMNode)nsdoc);
    }

    public void setInitialPreferredSize(Dimension preferredSize) {
        this.initialPreferredSize = preferredSize;
    }

    public IMozillaWindow.VisibilityMode getToolbarVisibilityMode() {
        return this.toolbarVisMode;
    }

    public IMozillaWindow.VisibilityMode getStatusbarVisibilityMode() {
        return this.statusbarVisMode;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public JTextField getStatusbar() {
        return this.statusField;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 600);
        MozillaPanel moz = new MozillaPanel();
        moz.load("about:");
        frame.getContentPane().add(moz);
        frame.setVisible(true);
    }
}

