/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.awt.Toolkit;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaException;
import org.mozilla.browser.MozillaInitialization;
import org.mozilla.browser.MozillaRuntimeException;
import org.mozilla.browser.RunnableEx;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.common.Platform;
import org.mozilla.browser.impl.ChromeAdapter;
import org.mozilla.browser.impl.CocoaUtils;
import org.mozilla.browser.impl.jna.Gtk;
import org.mozilla.interfaces.nsIAppShell;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIRunnable;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIThread;
import org.mozilla.interfaces.nsIThreadManager;
import org.mozilla.xpcom.Mozilla;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MozillaExecutor {
    static Log log = LogFactory.getLog(MozillaExecutor.class);
    private static final MozillaExecutor singleton = new MozillaExecutor();
    private static Thread mozillaThread;
    private final Semaphore initLock;
    private static final List<PendingTask> postponedMozTaks;
    private int nestingLevel = 0;

    private MozillaExecutor() {
        try {
            this.initLock = new Semaphore(1);
            this.initLock.acquire();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void loadLib(String libName, String libFileName, File libDir) {
        assert (libName != null && libFileName != null);
        if (libDir == null) {
            System.loadLibrary(libName);
            return;
        }
        File libFile = new File(libDir, libFileName);
        if (!libFile.exists()) {
            System.loadLibrary(libName);
            return;
        }
        System.load(libFile.getAbsolutePath());
    }

    protected static void mozInit(File xulrunnerDir, File nativeLibsDir, final RunnableEx task) throws MozillaException {
        block13: {
            if (Platform.platform == Platform.OSX) {
                try {
                    MozillaExecutor.loadLib("cocoautils", "libcocoautils.jnilib", nativeLibsDir);
                    CocoaUtils.syncExecOnAppKitThread(task);
                    mozillaThread = CocoaUtils.appkitThread;
                    assert (mozillaThread != null);
                    break block13;
                }
                catch (Throwable t) {
                    throw new MozillaException(t);
                }
            }
            if (Platform.usingGTK2Toolkit()) {
                LookAndFeel laf = UIManager.getLookAndFeel();
                String jdkWithGtkLafFix = "1.7";
                if (!"false".equals(System.getProperty("mozswing.gtklaf_check")) && "GTK".equals(laf.getID()) && !Platform.checkJavaVersion(jdkWithGtkLafFix, "")) {
                    throw new MozillaException(String.format("JDK version %s or newer is required if using the GTK look & feel", jdkWithGtkLafFix));
                }
                try {
                    Class.forName("sun.awt.X11.XEmbedCanvasPeer");
                    System.setProperty("sun.awt.xembedserver", "true");
                }
                catch (Throwable t) {
                    throw new MozillaException("jdk does not support XEMBED protocol", t);
                }
            }
            final Semaphore taskLock = new Semaphore(1);
            try {
                taskLock.acquire();
            }
            catch (InterruptedException e) {
                log.error((Object)"wait interrupted", (Throwable)e);
            }
            final Throwable[] taskException = new Throwable[1];
            mozillaThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        if (Platform.usingGTK2Toolkit()) {
                            Toolkit tk = Toolkit.getDefaultToolkit();
                            tk.sync();
                            Gtk.gtk.gtk_init(null, null);
                            Gtk.gtk.gdk_error_trap_push();
                        }
                        task.run();
                    }
                    catch (Throwable t) {
                        taskException[0] = t;
                        return;
                    }
                    finally {
                        taskLock.release();
                    }
                    Mozilla moz = Mozilla.getInstance();
                    nsIComponentManager componentManager = moz.getComponentManager();
                    String NS_APPSHELL_CID = "{2d96b3df-c051-11d1-a827-0040959a28c9}";
                    nsIAppShell appShell = (nsIAppShell)componentManager.createInstance(NS_APPSHELL_CID, null, "{501403e9-a091-4780-ba55-cfd1e21287a1}");
                    appShell.run();
                }
            };
            mozillaThread.setDaemon(true);
            mozillaThread.setName("Mozilla");
            mozillaThread.start();
            try {
                taskLock.acquire();
            }
            catch (InterruptedException e) {
                log.error((Object)"wait interrupted", (Throwable)e);
            }
            if (taskException[0] != null) {
                throw new MozillaException(taskException[0]);
            }
        }
        MozillaExecutor.singleton.initLock.release();
    }

    private void syncExec(Runnable task) throws MozillaRuntimeException {
        if (MozillaExecutor.isMozillaThread()) {
            try {
                task.run();
            }
            catch (Throwable e) {
                throw new MozillaRuntimeException("wrapped exception from mozilla task", e);
            }
        } else {
            MozCallable c = new MozCallable(task);
            nsIRunnable p = XPCOMUtils.proxy(c, nsIRunnable.class);
            p.run();
            if (c.error != null) {
                throw new MozillaRuntimeException("wrapped exception from mozilla task", c.error);
            }
        }
    }

    private void syncExec(RunnableEx task) throws MozillaException {
        if (MozillaExecutor.isMozillaThread()) {
            try {
                task.call();
            }
            catch (Throwable e) {
                throw new MozillaException("wrapped exception from mozilla task", e);
            }
        } else {
            MozCallable<Void> c = new MozCallable<Void>(task);
            nsIRunnable p = XPCOMUtils.proxy(c, nsIRunnable.class);
            p.run();
            if (((MozCallable)c).error != null) {
                throw new MozillaException("wrapped exception from mozilla task", ((MozCallable)c).error);
            }
        }
    }

    private <V> V syncExec(Callable<V> task) throws MozillaException {
        if (MozillaExecutor.isMozillaThread()) {
            try {
                return task.call();
            }
            catch (Throwable e) {
                throw new MozillaException("wrapped exception from mozilla task", e);
            }
        }
        MozCallable<V> c = new MozCallable<V>(task);
        nsIRunnable p = XPCOMUtils.proxy(c, nsIRunnable.class);
        p.run();
        if (((MozCallable)c).error != null) {
            throw new MozillaException("wrapped exception from mozilla task", ((MozCallable)c).error);
        }
        return (V)((MozCallable)c).result;
    }

    private <V> MozCallable<V> asyncExec(final Runnable task) {
        final MozillaRuntimeException from = new MozillaRuntimeException();
        MozCallable c = new MozCallable(new Runnable(){

            public void run() {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    log.error((Object)"error in asynchronus mozilla task", t);
                    log.error((Object)"called from:", (Throwable)from);
                }
            }
        });
        if (Platform.platform == Platform.OSX) {
            CocoaUtils.asyncExecOnAppKitThread(c);
        } else {
            nsIRunnable p = XPCOMUtils.asyncProxy(c, nsIRunnable.class);
            p.run();
        }
        return c;
    }

    public static boolean isMozillaThread() {
        String name;
        Thread ct = Thread.currentThread();
        boolean b = mozillaThread != null ? ct == mozillaThread : (name = ct.getName()).startsWith("AWT-EventQueue") || name.startsWith("AWT-AppKit");
        return b;
    }

    public static void mozSyncExec(Runnable task) throws MozillaRuntimeException {
        singleton.syncExec(task);
    }

    public static void mozSyncExec(RunnableEx task) throws MozillaException {
        singleton.syncExec(task);
    }

    public static <V> V mozSyncExec(Callable<V> task) throws MozillaException {
        return singleton.syncExec(task);
    }

    public static <V> V mozSyncExecQuiet(Callable<V> task) throws MozillaRuntimeException {
        try {
            return singleton.syncExec(task);
        }
        catch (Exception e) {
            throw new MozillaRuntimeException(e);
        }
    }

    public static MozCallable<Void> mozAsyncExec(Runnable task) {
        return singleton.asyncExec(task);
    }

    public static void mozPostponableSyncExec(Runnable task) {
        if (MozillaInitialization.isInitialized()) {
            MozillaExecutor.mozSyncExec(task);
        } else {
            PendingTask ptask = new PendingTask(task, new Throwable());
            postponedMozTaks.add(ptask);
        }
    }

    static void runPostponedPreInitTasks() {
        for (PendingTask ptask : postponedMozTaks) {
            try {
                MozillaExecutor.mozSyncExec(ptask.task);
            }
            catch (Throwable t) {
                log.error((Object)"error in postponed mozilla task", t);
                log.error((Object)"called from:", ptask.postedFrom);
            }
        }
    }

    public static void swingSyncExec(final Runnable task) throws RuntimeException {
        final Throwable[] swingError = new Throwable[]{null};
        Runnable swingTask = new Runnable(){

            public void run() {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    swingError[0] = t;
                }
            }
        };
        try {
            SwingUtilities.invokeAndWait(swingTask);
        }
        catch (Exception e) {
            throw new MozillaRuntimeException(e);
        }
        if (swingError[0] != null) {
            throw new MozillaRuntimeException(swingError[0]);
        }
    }

    public static void swingSyncExec(final RunnableEx task) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            final Throwable[] swingError = new Throwable[]{null};
            Runnable swingTask = new Runnable(){

                public void run() {
                    try {
                        task.run();
                    }
                    catch (Throwable t) {
                        swingError[0] = t;
                    }
                }
            };
            SwingUtilities.invokeAndWait(swingTask);
            if (swingError[0] != null) {
                throw new Exception(swingError[0]);
            }
        }
    }

    public static void swingAsyncExec(Runnable task) {
        SwingUtilities.invokeLater(task);
    }

    private void enterModalEventLoop(ChromeAdapter chromeAdapter) {
        assert (MozillaExecutor.isMozillaThread());
        if (Platform.platform != Platform.OSX) {
            int currLevel = this.nestingLevel++;
            nsIThreadManager tm = XPCOMUtils.getService("@mozilla.org/thread-manager;1", nsIThreadManager.class);
            nsIThread mt2 = tm.getMainThread();
            while (this.nestingLevel > currLevel) {
                mt2.processNextEvent(true);
            }
            assert (this.nestingLevel == currLevel);
        } else {
            CocoaUtils.runModal();
        }
    }

    private void exitModalEventLoop() {
        assert (MozillaExecutor.isMozillaThread());
        if (Platform.platform != Platform.OSX) {
            --this.nestingLevel;
        } else {
            CocoaUtils.stopModal();
        }
    }

    public static void mozEnterModalEventLoop(ChromeAdapter chromeAdapter) {
        singleton.enterModalEventLoop(chromeAdapter);
    }

    public static void mozExitModalEventLoop() {
        singleton.exitModalEventLoop();
    }

    static {
        postponedMozTaks = new LinkedList<PendingTask>();
    }

    private static class PendingTask {
        final Runnable task;
        final Throwable postedFrom;

        public PendingTask(Runnable task, Throwable postedFrom) {
            this.task = task;
            this.postedFrom = postedFrom;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MozCallable<V>
    implements nsIRunnable,
    Runnable {
        private final Runnable task1;
        private final Callable<V> task2;
        private V result;
        private Throwable error;

        public MozCallable(Callable<V> task) {
            this.task1 = null;
            this.task2 = task;
        }

        public MozCallable(Runnable task) {
            this.task1 = task;
            this.task2 = null;
        }

        @Override
        public void run() {
            if (this.task1 == null && this.task2 == null) {
                return;
            }
            try {
                if (this.task1 != null) {
                    this.task1.run();
                }
                if (this.task2 != null) {
                    this.result = this.task2.call();
                }
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        public nsISupports queryInterface(String uuid) {
            return Mozilla.queryInterface((nsISupports)this, (String)uuid);
        }
    }
}

