/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.browser;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.browser.MozillaException;
import org.mozilla.browser.MozillaExecutor;
import org.mozilla.browser.RunnableEx;
import org.mozilla.browser.XPCOMUtils;
import org.mozilla.browser.common.Platform;
import org.mozilla.browser.impl.LocationProvider;
import org.mozilla.browser.impl.XREAppData;
import org.mozilla.browser.impl.jna.Gdk;
import org.mozilla.browser.impl.jna.Gtk;
import org.mozilla.browser.impl.jna.X11;
import org.mozilla.browser.mt;
import org.mozilla.interfaces.nsIAppShell;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.interfaces.nsIWebBrowserChrome;
import org.mozilla.interfaces.nsIWebBrowserFocus;
import org.mozilla.interfaces.nsIWebNavigation;
import org.mozilla.xpcom.IAppFileLocProvider;
import org.mozilla.xpcom.IXREAppData;
import org.mozilla.xpcom.Mozilla;

public class MozillaBrowserMini
extends Canvas
implements nsIWebBrowserChrome {
    private static final long serialVersionUID = 1L;
    static Log log = LogFactory.getLog(MozillaBrowserMini.class);
    public static nsIAppShell appShell;
    public static boolean initialized;
    public nsIWebBrowser webBrowser;
    private Gtk.GtkWindow gtkPtr = null;

    public MozillaBrowserMini() {
        if (!initialized) {
            try {
                final File xulrunnerDir = new File(System.getProperty("user.home") + "/mozswing/xulrunner-build/build/compile/mozilla/dist/bin");
                File f = File.createTempFile("swing-mozilla", "");
                f.delete();
                final File profDir = f;
                profDir.mkdirs();
                MozillaExecutor.mozInit(xulrunnerDir, null, new RunnableEx(){

                    public void run() throws Exception {
                        Mozilla moz = Mozilla.getInstance();
                        moz.initialize(xulrunnerDir);
                        LocationProvider locProvider = new LocationProvider(xulrunnerDir, profDir);
                        moz.initEmbedding(xulrunnerDir, xulrunnerDir, (IAppFileLocProvider)locProvider, (IXREAppData)new XREAppData());
                        initialized = true;
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)"failed to initialize mozilla", (Throwable)e);
            }
        }
    }

    private long getHandle() {
        Mozilla moz = Mozilla.getInstance();
        if (Platform.usingGTK2Toolkit()) {
            X11.Window awtID = new X11.Window((int)moz.getNativeHandleFromAWT((Object)this));
            assert (!awtID.isNull());
            this.gtkPtr = Gtk.gtk.gtk_window_new(1);
            assert (this.gtkPtr != null);
            X11.Window gtkID = Gtk.gtk.gdk_x11_drawable_get_xid(this.gtkPtr.window);
            Gdk.GdkDisplay display = Gtk.gtk.gdk_display_get_default();
            X11.Display xdisplay = Gtk.gtk.gdk_x11_display_get_xdisplay(display);
            X11.INSTANCE.XReparentWindow(xdisplay, gtkID, awtID, 0, 0);
            return this.gtkPtr.getPeer();
        }
        long h = moz.getNativeHandleFromAWT((Object)this);
        assert (h != 0L);
        return h;
    }

    public void addNotify() {
        super.addNotify();
        try {
            MozillaExecutor.mozSyncExec(new RunnableEx(){

                public void run() throws Exception {
                    MozillaBrowserMini.this.webBrowser = XPCOMUtils.create("@mozilla.org/embedding/browser/nsWebBrowser;1", nsIWebBrowser.class);
                    MozillaBrowserMini.this.webBrowser.setContainerWindow((nsIWebBrowserChrome)MozillaBrowserMini.this);
                    nsIBaseWindow baseWindow = (nsIBaseWindow)MozillaBrowserMini.this.webBrowser.queryInterface("{046bc8a0-8015-11d3-af70-00a024ffc08c}");
                    Rectangle dim = MozillaBrowserMini.this.getBounds();
                    if (dim.isEmpty()) {
                        dim.setSize(300, 300);
                    }
                    baseWindow.initWindow(MozillaBrowserMini.this.getHandle(), 0L, 0, 0, dim.width, dim.height);
                    baseWindow.create();
                    baseWindow.setVisibility(true);
                    String url = new File(System.getProperty("user.home")).toURI().toString();
                    MozillaBrowserMini.this.loadURL(url);
                    nsIWebBrowserFocus webBrowserFocus = (nsIWebBrowserFocus)MozillaBrowserMini.this.webBrowser.queryInterface("{9c5d3c58-1dd1-11b2-a1c9-f3699284657a}");
                    webBrowserFocus.activate();
                }
            });
        }
        catch (MozillaException e) {
            log.error((Object)"failed to initialize mozilla", (Throwable)e);
        }
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                MozillaBrowserMini.this.onResize();
            }

            public void componentMoved(ComponentEvent e) {
            }
        });
    }

    private void onResize() {
        MozillaExecutor.mozAsyncExec(new Runnable(){

            public void run() {
                Rectangle rect = MozillaBrowserMini.this.getBounds();
                nsIBaseWindow baseWindow = XPCOMUtils.qi((nsISupports)MozillaBrowserMini.this.webBrowser, nsIBaseWindow.class);
                baseWindow.setPositionAndSize(rect.x, rect.y, rect.width, rect.height, true);
                if (Platform.usingGTK2Toolkit() && MozillaBrowserMini.this.gtkPtr != null) {
                    Gtk.gtk.gtk_widget_set_usize(MozillaBrowserMini.this.gtkPtr, rect.width, rect.height);
                }
            }
        });
    }

    public void loadURL(final String url) {
        MozillaExecutor.mozSyncExec(new Runnable(){

            public void run() {
                nsIWebNavigation webNavigation = XPCOMUtils.qi((nsISupports)MozillaBrowserMini.this.webBrowser, nsIWebNavigation.class);
                webNavigation.loadURI(url, 0L, null, null, null);
            }
        });
    }

    public nsISupports queryInterface(String aIID) {
        return Mozilla.queryInterface((nsISupports)this, (String)aIID);
    }

    public nsIWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void setWebBrowser(nsIWebBrowser aWebBrowser) {
        this.webBrowser = aWebBrowser;
    }

    public long getChromeFlags() {
        return 1L;
    }

    public void setStatus(long statusType, String status) {
    }

    public void setChromeFlags(long aChromeFlags) {
    }

    public void destroyBrowserWindow() {
    }

    public void sizeBrowserTo(int aCX, int aCY) {
    }

    public void showAsModal() {
    }

    public boolean isWindowModal() {
        return false;
    }

    public void exitModalEventLoop(long aStatus) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame(mt.t("MozillaBrowserMini.8"));
        frame.setDefaultCloseOperation(3);
        frame.setBounds(200, 200, 640, 480);
        frame.setLayout(new BorderLayout());
        MozillaBrowserMini b = new MozillaBrowserMini();
        frame.add((Component)b, "Center");
        frame.setVisible(true);
    }
}

